/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.audit.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.act.mapper.TpmActDetailMapper;
import com.biz.crm.act.mapper.TpmActMapper;
import com.biz.crm.act.model.TpmActDetailEntity;
import com.biz.crm.act.model.TpmActEntity;
import com.biz.crm.act.service.ITpmActDetailService;
import com.biz.crm.act.service.ITpmActService;
import com.biz.crm.act.service.impl.ActOperateFeeBudgetVo;
import com.biz.crm.act.service.impl.ActServiceHelper;
import com.biz.crm.audit.mapper.TpmAuditActMapper;
import com.biz.crm.audit.mapper.TpmAuditDetailMapper;
import com.biz.crm.audit.mapper.TpmAuditFileMapper;
import com.biz.crm.audit.mapper.TpmAuditMapper;
import com.biz.crm.audit.model.TpmAuditActEntity;
import com.biz.crm.audit.model.TpmAuditDetailEntity;
import com.biz.crm.audit.model.TpmAuditEntity;
import com.biz.crm.audit.model.TpmAuditFileEntity;
import com.biz.crm.audit.service.ITpmAuditActService;
import com.biz.crm.audit.service.ITpmAuditDetailService;
import com.biz.crm.audit.service.ITpmAuditFileService;
import com.biz.crm.audit.service.ITpmAuditService;
import com.biz.crm.audit.service.impl.AuditServiceHelper;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.costtypefine.mapper.TpmCostTypeFineMapper;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActSaveTypeEnum;
import com.biz.crm.eunm.tpm.ActTypeEnum;
import com.biz.crm.eunm.tpm.AuditFileTypeEnum;
import com.biz.crm.eunm.tpm.FeeBudgetDetailTypeEnum;
import com.biz.crm.eunm.tpm.FeeBudgetRemarkEnum;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetDetailsMapper;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetDetailsEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.feebudget.service.ITpmFeeBudgetDetailsService;
import com.biz.crm.feebudget.service.ITpmFeeBudgetService;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActReqVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActDetailRespVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActRespVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditDetailReqVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditReqVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditActRespVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditDetailRespVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditFileRespVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditRespVo;
import com.biz.crm.nebular.tpm.feebudget.req.FeeBudgetControlOperateTypeEnum;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PageUtil;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@ConditionalOnMissingBean(name={"TpmAuditServiceExpandImpl"})
public class TpmAuditServiceImpl
extends ServiceImpl<TpmAuditMapper, TpmAuditEntity>
implements ITpmAuditService {
    private static final Logger log = LoggerFactory.getLogger(TpmAuditServiceImpl.class);
    @Resource
    private TpmAuditMapper tpmAuditMapper;
    @Autowired
    private AuditServiceHelper serviceHelper;
    @Resource
    private TpmActDetailMapper tpmActDetailMapper;
    @Autowired
    private ITpmAuditDetailService iTpmAuditDetailService;
    @Autowired
    private ITpmAuditActService iTpmAuditActService;
    @Resource
    private TpmAuditDetailMapper tpmAuditDetailMapper;
    @Resource
    private TpmAuditActMapper tpmAuditActMapper;
    @Autowired
    private ITpmAuditFileService iTpmAuditFileService;
    @Resource
    private TpmAuditFileMapper tpmAuditFileMapper;
    @Resource
    private TpmCostTypeFineMapper tpmCostTypeFineMapper;
    @Resource
    private TpmFeeBudgetDetailsMapper tpmFeeBudgetDetailsMapper;
    @Autowired
    private ITpmActService tpmActService;
    @Autowired
    private ITpmActDetailService actDetailService;
    @Resource
    private TpmActMapper tpmActMapper;
    @Autowired
    private ActServiceHelper actServiceHelper;
    @Resource
    private TpmActDetailMapper actDetailMapper;
    @Autowired
    private ITpmFeeBudgetService feeBudgetService;
    @Autowired
    private ITpmFeeBudgetDetailsService feeBudgetDetailsService;

    @Override
    public PageResult<TpmAuditRespVo> findList(TpmAuditReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<TpmAuditRespVo> list = this.tpmAuditMapper.findList((Page<TpmAuditRespVo>)page, reqVo);
        list.stream().forEach(tpmAuditRespVo -> this.parsingApproveStatusName((TpmAuditRespVo)tpmAuditRespVo, tpmAuditRespVo.getApproveStatus()));
        this.serviceHelper.convertListDate(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    private void parsingApproveStatusName(TpmAuditRespVo tpmAuditRespVo, String approveStatus) {
        if (StringUtils.equals((CharSequence)ActApproveStatusEnum.APPROVED.getCode(), (CharSequence)approveStatus)) {
            tpmAuditRespVo.setApproveStatusName(ActApproveStatusEnum.APPROVED.getDes());
        } else if (StringUtils.equals((CharSequence)ActApproveStatusEnum.CREATE.getCode(), (CharSequence)approveStatus)) {
            tpmAuditRespVo.setApproveStatusName(ActApproveStatusEnum.CREATE.getDes());
        } else if (StringUtils.equals((CharSequence)ActApproveStatusEnum.APPROVING.getCode(), (CharSequence)approveStatus)) {
            tpmAuditRespVo.setApproveStatusName(ActApproveStatusEnum.APPROVING.getDes());
        } else if (StringUtils.equals((CharSequence)ActApproveStatusEnum.REJECTED.getCode(), (CharSequence)approveStatus)) {
            tpmAuditRespVo.setApproveStatusName(ActApproveStatusEnum.REJECTED.getDes());
        } else if (StringUtils.equals((CharSequence)ActApproveStatusEnum.INTERRUPT.getCode(), (CharSequence)approveStatus)) {
            tpmAuditRespVo.setApproveStatusName(ActApproveStatusEnum.INTERRUPT.getDes());
        } else {
            tpmAuditRespVo.setApproveStatusName(ActApproveStatusEnum.CLOSED.getDes());
        }
    }

    @Override
    public TpmAuditRespVo query(TpmAuditReqVo reqVo) {
        List tpmAuditFileEntities;
        TpmAuditEntity tpmAuditEntity = (TpmAuditEntity)((Object)this.tpmAuditMapper.selectById((Serializable)((Object)reqVo.getId())));
        if (ObjectUtils.isEmpty((Object)((Object)tpmAuditEntity))) {
            return new TpmAuditRespVo();
        }
        TpmAuditRespVo tpmAuditRespVo = (TpmAuditRespVo)CrmBeanUtil.copy((Object)((Object)tpmAuditEntity), TpmAuditRespVo.class);
        this.queryAuditDetail(tpmAuditRespVo);
        List auditActEntityList = this.tpmAuditActMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmAuditActEntity::getAuditCode, (Object)tpmAuditRespVo.getAuditCode()));
        if (CollectionUtils.isNotEmpty((Collection)auditActEntityList)) {
            tpmAuditRespVo.setTpmAuditActReqVos(CrmBeanUtil.copyList((List)auditActEntityList, TpmAuditActRespVo.class));
        }
        if (CollectionUtils.isNotEmpty((Collection)(tpmAuditFileEntities = this.tpmAuditFileMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmAuditFileEntity::getAuditCode, (Object)tpmAuditRespVo.getAuditCode()))))) {
            tpmAuditRespVo.setAuditFileRespVos(CrmBeanUtil.copyList((List)tpmAuditFileEntities, TpmAuditFileRespVo.class));
        }
        return tpmAuditRespVo;
    }

    private void queryAuditDetail(TpmAuditRespVo tpmAuditRespVo) {
        List detailEntityList = this.tpmAuditDetailMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmAuditDetailEntity::getAuditCode, (Object)tpmAuditRespVo.getAuditCode()));
        if (CollectionUtils.isNotEmpty((Collection)detailEntityList)) {
            List tpmAuditDetailRespVos = CrmBeanUtil.copyList((List)detailEntityList, TpmAuditDetailRespVo.class);
            List findCodes = tpmAuditDetailRespVos.stream().map(TpmAuditDetailRespVo::getFineCode).collect(Collectors.toList());
            List tpmCostTypeFineEntities = this.tpmCostTypeFineMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(TpmCostTypeFineEntity::getFineCode, findCodes));
            if (CollectionUtil.listNotEmpty((List)tpmCostTypeFineEntities)) {
                Map<String, List<TpmCostTypeFineEntity>> findCodeGroupMap = tpmCostTypeFineEntities.stream().collect(Collectors.groupingBy(TpmCostTypeFineEntity::getFineCode));
                Map<String, String> dictValueMap = this.queryDictValueMap();
                tpmAuditDetailRespVos.forEach(tpmAuditDetailRespVo -> {
                    TpmCostTypeFineEntity typeFineEntity;
                    String fineCode = tpmAuditDetailRespVo.getFineCode();
                    if (StringUtils.isNotBlank((CharSequence)fineCode) && CollectionUtil.mapNotEmpty((Map)findCodeGroupMap) && StringUtils.isNotEmpty((CharSequence)(typeFineEntity = (TpmCostTypeFineEntity)((Object)((Object)((List)findCodeGroupMap.get(fineCode)).get(0)))).getPayTypeList()) && CollectionUtil.mapNotEmpty((Map)dictValueMap)) {
                        List<DictItemVo> payTypes = this.getPayTypes(typeFineEntity.getPayTypeList(), dictValueMap);
                        tpmAuditDetailRespVo.setPayTypesJsonStr(JSON.toJSONString(payTypes));
                        tpmAuditDetailRespVo.setPayTypes(payTypes);
                    }
                });
                tpmAuditRespVo.setDetailVos(tpmAuditDetailRespVos);
            }
        }
    }

    @Override
    public List<DictItemVo> getPayTypes(String payTypeList, Map<String, String> map) {
        List codes = JSON.parseArray((String)payTypeList, String.class);
        ArrayList payTypes = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)codes)) {
            codes.forEach(o -> {
                DictItemVo dictItemVo = new DictItemVo();
                String s = (String)map.get(o);
                dictItemVo.setDictKey(s);
                dictItemVo.setDictValue(o);
                payTypes.add(dictItemVo);
            });
        }
        return payTypes;
    }

    @Override
    public Map<String, String> queryDictValueMap() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("pay_type_d");
        Map dictValueMapsByCodes = DictUtil.getDictValueMapsByCodes((List)dictCodes);
        if (!CollectionUtil.mapNotEmpty((Map)dictValueMapsByCodes)) {
            return Maps.newHashMap();
        }
        Map map = (Map)dictValueMapsByCodes.get("pay_type_d");
        return map;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TpmAuditReqVo reqVo) {
        this.serviceHelper.saveCheck(reqVo);
        TpmAuditEntity entity = (TpmAuditEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmAuditEntity.class));
        entity.setAuditCode(CodeUtil.createOneCode((String)"tpm_audit"));
        this.save((Object)entity);
        this.saveAuditDetailInfo(reqVo, entity);
        this.saveAuditActInfo(reqVo, entity);
        this.saveAuditFileInfo(reqVo, entity);
        if (StringUtils.equals((CharSequence)ActSaveTypeEnum.ADD_AND_APPROVE.getCode(), (CharSequence)reqVo.getSaveType()) && reqVo.getOccupyFeeBudgetFlag().booleanValue()) {
            this.occupyTheBudget(reqVo);
        }
    }

    private void occupyTheBudget(TpmAuditReqVo reqVo) {
        List occupyFeeBudgetDetails = reqVo.getOccupyFeeBudgetDetails();
        List detailEntities = this.actDetailMapper.selectList((Wrapper)new LambdaQueryWrapper().in(TpmActDetailEntity::getActDetailCode, (Collection)occupyFeeBudgetDetails.stream().map(TpmAuditDetailReqVo::getActDetailCode).collect(Collectors.toList())));
        ActOperateFeeBudgetVo operateFeeBudgetVo = this.actServiceHelper.setOperateFeeBudgetVo(detailEntities);
        ArrayList saveFeeBudgetDetails = Lists.newArrayList();
        HashSet saveFeeBudgetCodes = Sets.newHashSet();
        HashSet saveFeeBudgetControlIds = Sets.newHashSet();
        for (TpmAuditDetailReqVo p : occupyFeeBudgetDetails) {
            List<TpmFeeBudgetDetailsEntity> tpmFeeBudgetDetailsEntities = operateFeeBudgetVo.getBudgetDetailsMap().get(p.getActCode() + p.getActDetailCode()).stream().sorted(Comparator.comparing(TpmFeeBudgetDetailsEntity::getReduceOrder)).collect(Collectors.toList());
            AtomicReference<BigDecimal> occupyMoney = new AtomicReference<BigDecimal>(p.getAuditApplyAmount().add(Optional.ofNullable(p.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO)).subtract(p.getActDetailApplyAmount()));
            HashMap ratioCanOccupyMoneyMap = Maps.newHashMap();
            if (operateFeeBudgetVo.getIsRatio().booleanValue()) {
                tpmFeeBudgetDetailsEntities.forEach(t -> {
                    String feeBudgetTypeKey = this.actServiceHelper.getFeebudgetTypeKey(t.getFeeBudgetType(), t.getOrgType());
                    ratioCanOccupyMoneyMap.put(feeBudgetTypeKey, ((BigDecimal)occupyMoney.get()).multiply(t.getReduceRatio()).divide(BigDecimal.valueOf(100L)));
                });
            }
            for (int i = 0; i < tpmFeeBudgetDetailsEntities.size(); ++i) {
                TpmFeeBudgetDetailsEntity feeBudgetDetailsEntity = (TpmFeeBudgetDetailsEntity)((Object)tpmFeeBudgetDetailsEntities.get(i));
                TpmFeeBudgetEntity budgetEntity = operateFeeBudgetVo.getFeeBudgetMap().get(feeBudgetDetailsEntity.getFeeBudgetCode());
                TpmFeeBudgetControlEntity budgetControlEntity = operateFeeBudgetVo.getControlEntityMap().get(budgetEntity.getControlId());
                if (budgetEntity.getCanUseAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal canOccupyMoney = BigDecimal.ZERO;
                BigDecimal maxCanOccupy = BigDecimal.ZERO;
                if (operateFeeBudgetVo.getIsRatio().booleanValue()) {
                    String feebudgetTypeKey = this.actServiceHelper.getFeebudgetTypeKey(feeBudgetDetailsEntity.getFeeBudgetType(), feeBudgetDetailsEntity.getOrgType());
                    maxCanOccupy = (BigDecimal)ratioCanOccupyMoneyMap.get(feebudgetTypeKey);
                    if (maxCanOccupy.compareTo(BigDecimal.ZERO) == 0) continue;
                    if (maxCanOccupy.compareTo(budgetEntity.getCanUseAmount()) == 1) {
                        canOccupyMoney = budgetEntity.getCanUseAmount();
                        occupyMoney.set(occupyMoney.get().subtract(budgetEntity.getCanUseAmount()));
                        ratioCanOccupyMoneyMap.put(feebudgetTypeKey, maxCanOccupy.subtract(budgetEntity.getCanUseAmount()));
                        budgetEntity.setCanUseAmount(BigDecimal.ZERO);
                        budgetControlEntity.setCanUseAmount(budgetControlEntity.getCanUseAmount().subtract(canOccupyMoney));
                    } else {
                        canOccupyMoney = maxCanOccupy;
                        ratioCanOccupyMoneyMap.put(feebudgetTypeKey, BigDecimal.ZERO);
                        budgetEntity.setCanUseAmount(budgetEntity.getCanUseAmount().subtract(maxCanOccupy));
                        budgetControlEntity.setCanUseAmount(budgetControlEntity.getCanUseAmount().subtract(maxCanOccupy));
                    }
                } else {
                    if (occupyMoney.get().compareTo(BigDecimal.ZERO) == 0) break;
                    maxCanOccupy = budgetEntity.getCanUseAmount();
                    if (occupyMoney.get().compareTo(maxCanOccupy) == 1) {
                        canOccupyMoney = maxCanOccupy;
                        occupyMoney.set(occupyMoney.get().subtract(maxCanOccupy));
                        budgetEntity.setCanUseAmount(BigDecimal.ZERO);
                        budgetControlEntity.setCanUseAmount(budgetControlEntity.getCanUseAmount().subtract(canOccupyMoney));
                    } else {
                        canOccupyMoney = occupyMoney.get();
                        occupyMoney.set(BigDecimal.ZERO);
                        budgetEntity.setCanUseAmount(budgetEntity.getCanUseAmount().subtract(canOccupyMoney));
                        budgetControlEntity.setCanUseAmount(budgetControlEntity.getCanUseAmount().subtract(canOccupyMoney));
                    }
                }
                saveFeeBudgetCodes.add(budgetEntity.getFeeBudgetCode());
                saveFeeBudgetControlIds.add(budgetControlEntity.getId());
                TpmFeeBudgetDetailsEntity newBudgetDetailsEntity = new TpmFeeBudgetDetailsEntity();
                CrmBeanUtil.copyProperties((Object)((Object)feeBudgetDetailsEntity), (Object)((Object)newBudgetDetailsEntity));
                newBudgetDetailsEntity.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.USE.getCode());
                newBudgetDetailsEntity.setYear(budgetEntity.getBudgetYear());
                newBudgetDetailsEntity.setMonth(budgetEntity.getBudgetMonth());
                newBudgetDetailsEntity.setFeeBudgetDetailTypeName(FeeBudgetDetailTypeEnum.USE.getDes());
                newBudgetDetailsEntity.setFeeAmount(BigDecimal.ZERO.subtract(canOccupyMoney));
                newBudgetDetailsEntity.setAfterAmount(budgetEntity.getCanUseAmount());
                newBudgetDetailsEntity.setBeforAmount(budgetEntity.getCanUseAmount().add(canOccupyMoney));
                newBudgetDetailsEntity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                newBudgetDetailsEntity.setBusinessCode(p.getAuditCode());
                newBudgetDetailsEntity.setBusinessLineCode(p.getAuditDetailCode());
                newBudgetDetailsEntity.setBusinessRemarks(FeeBudgetRemarkEnum.WRITE_OFF_THE_OCCUPIED_BUDGET.getDes());
                this.actServiceHelper.setPublicParamsNull((CrmBaseEntity)newBudgetDetailsEntity);
                saveFeeBudgetDetails.add(newBudgetDetailsEntity);
            }
            if (MapUtils.isNotEmpty((Map)ratioCanOccupyMoneyMap)) {
                ratioCanOccupyMoneyMap.keySet().forEach(t -> {
                    BigDecimal bigDecimal = (BigDecimal)ratioCanOccupyMoneyMap.get(t);
                    if (bigDecimal.compareTo(BigDecimal.ZERO) == 1) {
                        throw new BusinessException("\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801:" + p.getActDetailCode() + "\u8d85\u989d\u6838\u9500\u5360\u7528\u8d39\u7528\u65f6,\u9884\u7b97\u4e0d\u8db3");
                    }
                });
                continue;
            }
            if (occupyMoney.get().compareTo(BigDecimal.ZERO) != 1) continue;
            throw new BusinessException("\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801:" + p.getActDetailCode() + "\u8d85\u989d\u6838\u9500\u5360\u7528\u8d39\u7528\u65f6,\u9884\u7b97\u4e0d\u8db3");
        }
        operateFeeBudgetVo.setSaveFeeBudgetDetails(saveFeeBudgetDetails);
        operateFeeBudgetVo.setSaveFeeBudgetCodes(saveFeeBudgetCodes);
        operateFeeBudgetVo.setSaveFeeBudgetControlIds(saveFeeBudgetControlIds);
        operateFeeBudgetVo.setTypeEnum(FeeBudgetControlOperateTypeEnum.USE);
        this.actServiceHelper.saveFeeBudgetDataInfos(operateFeeBudgetVo);
    }

    private void saveAuditFileInfo(TpmAuditReqVo reqVo, TpmAuditEntity entity) {
        List typeFineRespVos = reqVo.getAuditFileRespVos();
        if (CollectionUtil.listNotEmpty((List)typeFineRespVos)) {
            List tpmAuditFileEntities = CrmBeanUtil.copyList((List)typeFineRespVos, TpmAuditFileEntity.class);
            tpmAuditFileEntities.forEach(tpmAuditFileEntity -> {
                tpmAuditFileEntity.setAuditCode(entity.getAuditCode());
                tpmAuditFileEntity.setAuditFileType(AuditFileTypeEnum.AUDIT_INFORMATION.getCode());
                tpmAuditFileEntity.setFormInstanceId(entity.getFormInstanceId());
            });
            this.iTpmAuditFileService.saveBatch(tpmAuditFileEntities);
        }
    }

    public void saveAuditDetailInfo(TpmAuditReqVo reqVo, TpmAuditEntity entity) {
        List detailVos = reqVo.getDetailVos();
        detailVos.forEach(o -> {
            o.setAuditDetailCode(CodeUtil.createOneCode((String)"tpm_audit_detail"));
            o.setAuditCode(entity.getAuditCode());
            o.setFormInstanceId(entity.getFormInstanceId());
            if (Objects.isNull(o.getFeeUsed())) {
                o.setFeeUsed(BigDecimal.ZERO);
            }
            if (StringUtils.isBlank((CharSequence)o.getIsAllFeeUsed())) {
                o.setIsAllFeeUsed(GlobalWhetherEnum.NO.getCode());
            }
        });
        List tpmAuditDetailEntities = CrmBeanUtil.copyList((List)detailVos, TpmAuditDetailEntity.class);
        this.iTpmAuditDetailService.saveBatch(tpmAuditDetailEntities);
    }

    public void saveAuditActInfo(TpmAuditReqVo reqVo, TpmAuditEntity entity) {
        List tpmAuditActReqVos = reqVo.getTpmAuditActReqVos();
        tpmAuditActReqVos.forEach(o -> {
            o.setAuditCode(entity.getAuditCode());
            o.setFormInstanceId(entity.getAuditCode());
        });
        List tpmAuditActEntities = CrmBeanUtil.copyList((List)tpmAuditActReqVos, TpmAuditActEntity.class);
        this.iTpmAuditActService.saveBatch(tpmAuditActEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TpmAuditReqVo reqVo) {
        this.serviceHelper.saveCheck(reqVo);
        TpmAuditEntity tpmAuditEntity = (TpmAuditEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmAuditEntity.class));
        this.updateById((Object)tpmAuditEntity);
        this.updateAuditDetail(reqVo, tpmAuditEntity);
        this.updateAct(reqVo, tpmAuditEntity);
        this.updateAuditFile(reqVo, tpmAuditEntity);
        if (ActSaveTypeEnum.UPDATE_AND_APPROVE.getCode().equals(reqVo.getSaveType())) {
            this.occupyTheBudget(reqVo);
        }
    }

    public void updateAct(TpmAuditReqVo reqVo, TpmAuditEntity tpmAuditEntity) {
        List tpmAuditActReqVos = reqVo.getTpmAuditActReqVos();
        tpmAuditActReqVos.stream().forEach(tpmAuditActReqVo -> {
            tpmAuditActReqVo.setFormInstanceId(tpmAuditEntity.getFormInstanceId());
            tpmAuditActReqVo.setAuditCode(tpmAuditEntity.getAuditCode());
        });
        List auditActIds = tpmAuditActReqVos.stream().map(UuidVo::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(auditActIds)) {
            this.tpmAuditActMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmAuditActEntity::getAuditCode, (Object)tpmAuditEntity.getAuditCode())).notIn(BaseIdEntity::getId, auditActIds));
        }
        this.iTpmAuditActService.saveOrUpdateBatch(CrmBeanUtil.copyList((List)tpmAuditActReqVos, TpmAuditActEntity.class));
    }

    public void updateAuditDetail(TpmAuditReqVo reqVo, TpmAuditEntity tpmAuditEntity) {
        List detailVos = reqVo.getDetailVos();
        detailVos.stream().forEach(detailReqVo -> {
            detailReqVo.setFormInstanceId(tpmAuditEntity.getFormInstanceId());
            detailReqVo.setAuditCode(tpmAuditEntity.getAuditCode());
        });
        List auditDetailIds = detailVos.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getId())).map(UuidVo::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(auditDetailIds)) {
            this.tpmAuditDetailMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmAuditDetailEntity::getAuditCode, (Object)tpmAuditEntity.getAuditCode())).notIn(BaseIdEntity::getId, auditDetailIds));
        }
        this.iTpmAuditDetailService.saveOrUpdateBatch(CrmBeanUtil.copyList((List)detailVos, TpmAuditDetailEntity.class));
    }

    public void updateAuditFile(TpmAuditReqVo reqVo, TpmAuditEntity tpmAuditEntity) {
        List auditFileRespVos = reqVo.getAuditFileRespVos();
        if (CollectionUtils.isNotEmpty((Collection)auditFileRespVos)) {
            auditFileRespVos.stream().forEach(tpmAuditFileRespVo -> {
                tpmAuditFileRespVo.setFormInstanceId(tpmAuditEntity.getFormInstanceId());
                tpmAuditFileRespVo.setAuditCode(tpmAuditEntity.getAuditCode());
            });
            List auditFileIds = auditFileRespVos.stream().map(UuidVo::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(auditFileIds)) {
                this.tpmAuditFileMapper.delete((Wrapper)Wrappers.lambdaQuery().eq(TpmAuditFileEntity::getAuditCode, (Object)tpmAuditEntity.getAuditCode()));
            }
            this.iTpmAuditFileService.saveBatch(CrmBeanUtil.copyList((List)auditFileRespVos, TpmAuditFileEntity.class));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        List tpmAuditEntities = this.tpmAuditMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)tpmAuditEntities)) {
            this.serviceHelper.deleteCheck(tpmAuditEntities, ids);
            List auditCodes = tpmAuditEntities.stream().map(TpmAuditEntity::getAuditCode).collect(Collectors.toList());
            this.tpmAuditDetailMapper.delete((Wrapper)Wrappers.lambdaQuery().in(TpmAuditDetailEntity::getAuditCode, auditCodes));
            this.tpmAuditActMapper.delete((Wrapper)Wrappers.lambdaQuery().in(TpmAuditActEntity::getAuditCode, auditCodes));
            this.tpmAuditMapper.deleteBatchIds(ids);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(TpmAuditReqVo reqVo) {
        List tpmAuditEntities = this.tpmAuditMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmAuditEntities)) {
            tpmAuditEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmAuditEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(TpmAuditReqVo reqVo) {
        List tpmAuditEntities = this.tpmAuditMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmAuditEntities)) {
            tpmAuditEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmAuditEntities);
    }

    @Override
    public PageResult<TpmActDetailRespVo> findActDetailList(TpmActDetailReqVo tpmActDetailReqVo) {
        AssertUtils.isNotEmpty((Collection)tpmActDetailReqVo.getActCodes(), (String)"\u6d3b\u52a8\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        Page page = PageUtil.buildPage((Integer)tpmActDetailReqVo.getPageNum(), (Integer)tpmActDetailReqVo.getPageSize());
        ArrayList list = this.tpmActDetailMapper.findActDetailList((Page<TpmActDetailRespVo>)page, tpmActDetailReqVo);
        if (CollectionUtils.isEmpty(list)) {
            list = Lists.newArrayList();
        }
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            Map<String, String> dictValueMap = this.queryDictValueMap();
            list.forEach(tpmActDetailRespVo -> {
                if (StringUtils.isNotEmpty((CharSequence)tpmActDetailRespVo.getPayTypeList()) && CollectionUtil.mapNotEmpty((Map)dictValueMap)) {
                    List<DictItemVo> payTypes = this.getPayTypes(tpmActDetailRespVo.getPayTypeList(), dictValueMap);
                    tpmActDetailRespVo.setPayTypesJsonStr(JSON.toJSONString(payTypes));
                    tpmActDetailRespVo.setPayTypes(payTypes);
                }
                if (Objects.isNull(tpmActDetailRespVo.getAuditAmount())) {
                    tpmActDetailRespVo.setAuditAmount(BigDecimal.ZERO);
                }
            });
        }
        return PageResult.builder().data((List)list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void auditApproved(TpmAuditReqVo tpmAuditReqVo) {
        AssertUtils.isNotEmpty((String)tpmAuditReqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        TpmAuditEntity tpmAuditEntity = (TpmAuditEntity)((Object)this.tpmAuditMapper.selectById((Serializable)((Object)tpmAuditReqVo.getId())));
        tpmAuditEntity.setApproveStatus(ActApproveStatusEnum.APPROVED.getCode());
        this.updateById((Object)tpmAuditEntity);
        List detailEntityList = this.tpmAuditDetailMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmAuditDetailEntity::getAuditCode, (Object)tpmAuditEntity.getAuditCode()));
        HashSet actCodes = Sets.newHashSet();
        detailEntityList.forEach(o -> actCodes.add(o.getActCode()));
        List actEntities = this.tpmActMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmActEntity.class).in(TpmActEntity::getActCode, (Collection)actCodes));
        Map actEntityMap = actEntities.stream().collect(Collectors.toMap(TpmActEntity::getActCode, Function.identity()));
        List actDetailEntities = this.tpmActDetailMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmActDetailEntity.class).in(TpmActDetailEntity::getActCode, (Collection)actCodes));
        HashMap actDetailEntityMap = Maps.newHashMap();
        HashMap groupByActCodeMap = Maps.newHashMap();
        actDetailEntities.stream().forEach(o -> {
            actDetailEntityMap.put(o.getActDetailCode(), o);
            List tpmActDetailEntities = (List)groupByActCodeMap.get(o.getActCode());
            if (CollectionUtils.isEmpty((Collection)tpmActDetailEntities)) {
                tpmActDetailEntities = Lists.newArrayList();
            }
            tpmActDetailEntities.add(o);
            groupByActCodeMap.put(o.getActCode(), tpmActDetailEntities);
        });
        ArrayList needRefundActDetails = Lists.newArrayList();
        ArrayList needSaveActDetails = Lists.newArrayList();
        HashMap actDetailToAuditDetailMap = Maps.newHashMap();
        for (TpmAuditDetailEntity o2 : detailEntityList) {
            TpmActDetailEntity actDetailEntity = (TpmActDetailEntity)((Object)actDetailEntityMap.get(o2.getActDetailCode()));
            TpmActEntity actEntity = (TpmActEntity)((Object)actEntityMap.get(actDetailEntity.getActCode()));
            actDetailEntity.setAuditAmount(Optional.ofNullable(actDetailEntity.getAuditAmount()).orElse(BigDecimal.ZERO).add(o2.getAuditApplyAmount()));
            actDetailEntity.setIsAllAudit(o2.getIsAllAudit());
            actDetailEntity.setIsAudit(GlobalWhetherEnum.YES.getCode());
            actEntity.setAuditTotalAmount(Optional.ofNullable(actEntity.getAuditTotalAmount()).orElse(BigDecimal.ZERO).add(o2.getAuditApplyAmount()));
            needSaveActDetails.add(actDetailEntity);
            if (actDetailEntity.getAuditAmount().compareTo(actDetailEntity.getApplyAmount()) != -1 || !StringUtils.equals((CharSequence)GlobalWhetherEnum.YES.getCode(), (CharSequence)actDetailEntity.getIsAllAudit())) continue;
            needRefundActDetails.add(actDetailEntity);
            actDetailToAuditDetailMap.put(o2.getActDetailCode(), o2);
        }
        this.actDetailService.updateBatchById(needSaveActDetails);
        for (TpmActEntity actEntity : actEntities) {
            List detailEntities = (List)groupByActCodeMap.get(actEntity.getActCode());
            long count = detailEntities.stream().filter(p -> StringUtils.equals((CharSequence)GlobalWhetherEnum.YES.getCode(), (CharSequence)p.getIsAllAudit())).count();
            if (!Objects.nonNull(count) || (long)detailEntities.size() != count) continue;
            actEntity.setIsAllAudit(GlobalWhetherEnum.YES.getCode());
        }
        this.tpmActService.updateBatchById(actEntities);
        if (CollectionUtils.isNotEmpty((Collection)needRefundActDetails)) {
            ActOperateFeeBudgetVo actOperateFeeBudgetVo = this.actServiceHelper.setOperateFeeBudgetVo(needRefundActDetails);
        }
    }

    private void refundActFeeBudgetDetail(List<TpmAuditEntity> tpmAuditEntities) {
        List auditCodeList = tpmAuditEntities.stream().map(TpmAuditEntity::getAuditCode).collect(Collectors.toList());
        List tpmAuditDetailEntities = this.tpmAuditDetailMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(TpmAuditDetailEntity::getAuditCode, auditCodeList));
        Map<String, List<TpmAuditDetailEntity>> tpmAuditListMap = tpmAuditDetailEntities.stream().filter(o -> StringUtils.equals((CharSequence)GlobalWhetherEnum.YES.getCode(), (CharSequence)o.getIsAllAudit())).collect(Collectors.groupingBy(TpmAuditDetailEntity::getActDetailCode));
        for (Map.Entry<String, List<TpmAuditDetailEntity>> tpmAuditMap : tpmAuditListMap.entrySet()) {
            BigDecimal actDetailApplyAmount;
            List<TpmAuditDetailEntity> detailEntityList = tpmAuditMap.getValue();
            List detailReqVos = CrmBeanUtil.copyList(detailEntityList, TpmAuditDetailReqVo.class);
            BigDecimal auditApplyAmountTotal = detailReqVos.stream().map(TpmAuditDetailReqVo::getAuditApplyAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (auditApplyAmountTotal.compareTo(actDetailApplyAmount = ((TpmAuditDetailReqVo)detailReqVos.get(0)).getActDetailApplyAmount()) != -1) continue;
            BigDecimal refundAmount = actDetailApplyAmount.subtract(auditApplyAmountTotal);
            this.addActFeeBudgetDetail(detailReqVos, refundAmount, GlobalWhetherEnum.NO.getCode());
        }
    }

    private void addActFeeBudgetDetail(List<TpmAuditDetailReqVo> detailVo, BigDecimal occupiedOrRefundAmount, String type) {
        List tpmFeeBudgetDetailsEntities = this.tpmFeeBudgetDetailsMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TpmFeeBudgetDetailsEntity::getBusinessLineCode, (Object)detailVo.get(0).getActDetailCode())).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
        if (CollectionUtils.isEmpty((Collection)tpmFeeBudgetDetailsEntities)) {
            return;
        }
        if (StringUtils.equals((CharSequence)GlobalWhetherEnum.YES.getCode(), (CharSequence)type)) {
            if (Objects.isNull(((TpmFeeBudgetDetailsEntity)((Object)tpmFeeBudgetDetailsEntities.get(0))).getReduceRatio())) {
                this.reduceOrderAmount(tpmFeeBudgetDetailsEntities, occupiedOrRefundAmount);
            } else {
                this.reduceRatioAmount(tpmFeeBudgetDetailsEntities, occupiedOrRefundAmount);
            }
        } else if (Objects.isNull(((TpmFeeBudgetDetailsEntity)((Object)tpmFeeBudgetDetailsEntities.get(0))).getReduceRatio())) {
            this.reduceOrderAmountRefund(tpmFeeBudgetDetailsEntities, occupiedOrRefundAmount);
        } else {
            this.reduceRatioAmountRefund(tpmFeeBudgetDetailsEntities, occupiedOrRefundAmount);
        }
    }

    private void reduceOrderAmount(List<TpmFeeBudgetDetailsEntity> tpmFeeBudgetDetailsEntities, BigDecimal occupiedOrRefundAmount) {
        List<TpmFeeBudgetDetailsEntity> detailsEntityList = tpmFeeBudgetDetailsEntities.stream().sorted(Comparator.comparing(TpmFeeBudgetDetailsEntity::getReduceOrder)).collect(Collectors.toList());
        this.sequentialDeduction(detailsEntityList, occupiedOrRefundAmount);
    }

    private void reduceRatioAmount(List<TpmFeeBudgetDetailsEntity> tpmFeeBudgetDetailsEntities, BigDecimal occupiedOrRefundAmount) {
        Map<String, List<TpmFeeBudgetDetailsEntity>> collect = tpmFeeBudgetDetailsEntities.stream().collect(Collectors.groupingBy(o -> this.fetchGroupKey((TpmFeeBudgetDetailsEntity)((Object)o))));
        for (Map.Entry<String, List<TpmFeeBudgetDetailsEntity>> stringListEntry : collect.entrySet()) {
            BigDecimal reduceRatio = stringListEntry.getValue().get(0).getReduceRatio();
            BigDecimal needDeductionAmount = occupiedOrRefundAmount.multiply(reduceRatio);
            List<TpmFeeBudgetDetailsEntity> detailsEntityList = stringListEntry.getValue().stream().sorted(Comparator.comparing(TpmFeeBudgetDetailsEntity::getReduceOrder)).collect(Collectors.toList());
            this.sequentialDeduction(detailsEntityList, needDeductionAmount);
        }
    }

    private String fetchGroupKey(TpmFeeBudgetDetailsEntity detailsEntity) {
        return detailsEntity.getFeeBudgetType() + "_" + detailsEntity.getOrgType();
    }

    private void sequentialDeduction(List<TpmFeeBudgetDetailsEntity> detailsEntityList, BigDecimal occupiedOrRefundAmount) {
        ArrayList newDetails = Lists.newArrayList();
        Iterator<TpmFeeBudgetDetailsEntity> iterator = detailsEntityList.iterator();
        for (TpmFeeBudgetDetailsEntity entity : detailsEntityList) {
            TpmFeeBudgetDetailsEntity newEntity = new TpmFeeBudgetDetailsEntity();
            newDetails.add(newEntity);
            if (occupiedOrRefundAmount.compareTo(BigDecimal.ZERO) != 0) continue;
            break;
        }
        while (iterator.hasNext()) {
            BigDecimal currentAmount;
            TpmFeeBudgetDetailsEntity detailsEntity = iterator.next();
            detailsEntity.setFeeAmount(occupiedOrRefundAmount);
            BigDecimal afterAmount = detailsEntity.getAfterAmount();
            if (!iterator.hasNext()) {
                if (occupiedOrRefundAmount.compareTo(afterAmount) == 1) {
                    throw new BusinessException("\u8d39\u7528\u9884\u7b97" + detailsEntity.getFeeBudgetCode() + "\u4e0d\u8db3");
                }
                currentAmount = occupiedOrRefundAmount;
                occupiedOrRefundAmount = BigDecimal.ZERO;
            } else if (afterAmount.compareTo(occupiedOrRefundAmount) >= 0) {
                currentAmount = occupiedOrRefundAmount;
                occupiedOrRefundAmount = BigDecimal.ZERO;
            } else {
                currentAmount = afterAmount;
                occupiedOrRefundAmount = occupiedOrRefundAmount.subtract(afterAmount);
            }
            detailsEntity.setBeforAmount(afterAmount);
            detailsEntity.setAfterAmount(afterAmount.subtract(currentAmount));
            detailsEntity.setId(null);
            detailsEntity.setBusinessRemarks(FeeBudgetRemarkEnum.WRITE_OFF_THE_OCCUPIED_BUDGET.getDes());
            detailsEntity.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.USE.getCode());
            detailsEntity.setFeeBudgetDetailTypeName(FeeBudgetDetailTypeEnum.USE.getDes());
            this.tpmFeeBudgetDetailsMapper.insert((Object)detailsEntity);
        }
    }

    private void reduceOrderAmountRefund(List<TpmFeeBudgetDetailsEntity> tpmFeeBudgetDetailsEntities, BigDecimal occupiedOrRefundAmount) {
        List<TpmFeeBudgetDetailsEntity> detailsEntityList = tpmFeeBudgetDetailsEntities.stream().sorted(Comparator.comparing(TpmFeeBudgetDetailsEntity::getReduceOrder).reversed()).collect(Collectors.toList());
        this.sequentialRefund(detailsEntityList, occupiedOrRefundAmount);
    }

    private void reduceRatioAmountRefund(List<TpmFeeBudgetDetailsEntity> tpmFeeBudgetDetailsEntities, BigDecimal occupiedOrRefundAmount) {
        Map<String, List<TpmFeeBudgetDetailsEntity>> collect = tpmFeeBudgetDetailsEntities.stream().collect(Collectors.groupingBy(o -> this.fetchGroupKey((TpmFeeBudgetDetailsEntity)((Object)o))));
        for (Map.Entry<String, List<TpmFeeBudgetDetailsEntity>> stringListEntry : collect.entrySet()) {
            BigDecimal reduceRatio = stringListEntry.getValue().get(0).getReduceRatio();
            BigDecimal needDeductionAmount = occupiedOrRefundAmount.multiply(reduceRatio);
            List<TpmFeeBudgetDetailsEntity> detailsEntityList = stringListEntry.getValue().stream().sorted(Comparator.comparing(TpmFeeBudgetDetailsEntity::getReduceOrder).reversed()).collect(Collectors.toList());
            this.sequentialRefund(detailsEntityList, needDeductionAmount);
        }
    }

    private void sequentialRefund(List<TpmFeeBudgetDetailsEntity> detailsEntityList, BigDecimal occupiedOrRefundAmount) {
        Iterator<TpmFeeBudgetDetailsEntity> iterator = detailsEntityList.iterator();
        while (iterator.hasNext()) {
            BigDecimal currentAmount;
            if (occupiedOrRefundAmount.compareTo(BigDecimal.ZERO) == 0) continue;
            TpmFeeBudgetDetailsEntity detailsEntity = iterator.next();
            detailsEntity.setFeeAmount(occupiedOrRefundAmount);
            BigDecimal initAmount = detailsEntity.getInitAmount();
            BigDecimal afterAmount = detailsEntity.getAfterAmount();
            BigDecimal refundAfterAmount = occupiedOrRefundAmount.add(afterAmount);
            if (!iterator.hasNext()) {
                currentAmount = refundAfterAmount.compareTo(initAmount) > -1 ? initAmount : refundAfterAmount;
                occupiedOrRefundAmount = BigDecimal.ZERO;
            } else if (initAmount.compareTo(refundAfterAmount) >= 0) {
                currentAmount = refundAfterAmount;
                occupiedOrRefundAmount = BigDecimal.ZERO;
            } else {
                currentAmount = initAmount;
                occupiedOrRefundAmount = occupiedOrRefundAmount.subtract(initAmount);
            }
            detailsEntity.setBeforAmount(afterAmount);
            detailsEntity.setAfterAmount(currentAmount);
            detailsEntity.setId(null);
            detailsEntity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
            detailsEntity.setBusinessRemarks(FeeBudgetRemarkEnum.WRITE_OFF_AND_RETURN.getDes());
            detailsEntity.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.RETURN_BACK.getCode());
            detailsEntity.setFeeBudgetDetailTypeName(FeeBudgetDetailTypeEnum.RETURN_BACK.getDes());
            this.tpmFeeBudgetDetailsMapper.insert((Object)detailsEntity);
        }
    }

    @Override
    public PageResult<TpmActRespVo> actList(TpmActReqVo tpmActReqVo) {
        tpmActReqVo.setApproveStatus(ActApproveStatusEnum.APPROVED.getCode());
        tpmActReqVo.setIsAllAudit(GlobalWhetherEnum.NO.getCode());
        tpmActReqVo.setActType(ActTypeEnum.PROJECT.getCode());
        return this.tpmActService.findList(tpmActReqVo);
    }
}

