/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.account.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.account.mapper.TpmAccountProductMapper;
import com.biz.crm.account.model.TpmAccountProductEntity;
import com.biz.crm.account.service.ITpmAccountProductService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.tpm.account.req.TpmAccountProductReqVo;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountProductRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmAccountProductServiceExpandImpl"})
public class TpmAccountProductServiceImpl
extends ServiceImpl<TpmAccountProductMapper, TpmAccountProductEntity>
implements ITpmAccountProductService {
    private static final Logger log = LoggerFactory.getLogger(TpmAccountProductServiceImpl.class);
    @Resource
    private TpmAccountProductMapper tpmAccountProductMapper;

    @Override
    public PageResult<TpmAccountProductRespVo> findList(TpmAccountProductReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<TpmAccountProductRespVo> list = this.tpmAccountProductMapper.findList((Page<TpmAccountProductRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmAccountProductRespVo query(TpmAccountProductReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TpmAccountProductReqVo reqVo) {
        TpmAccountProductEntity entity = (TpmAccountProductEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmAccountProductEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TpmAccountProductReqVo reqVo) {
        TpmAccountProductEntity entity = (TpmAccountProductEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(TpmAccountProductReqVo reqVo) {
        List tpmAccountProductEntities = this.tpmAccountProductMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmAccountProductEntities)) {
            tpmAccountProductEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(tpmAccountProductEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(TpmAccountProductReqVo reqVo) {
        List tpmAccountProductEntities = this.tpmAccountProductMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmAccountProductEntities)) {
            tpmAccountProductEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmAccountProductEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(TpmAccountProductReqVo reqVo) {
        List tpmAccountProductEntities = this.tpmAccountProductMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmAccountProductEntities)) {
            tpmAccountProductEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmAccountProductEntities);
    }
}

