/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.audit.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.audit.mapper.TpmAuditFileMapper;
import com.biz.crm.audit.model.TpmAuditFileEntity;
import com.biz.crm.audit.service.ITpmAuditFileService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditFileReqVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditFileRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmAuditFileServiceExpandImpl"})
public class TpmAuditFileServiceImpl
extends ServiceImpl<TpmAuditFileMapper, TpmAuditFileEntity>
implements ITpmAuditFileService {
    private static final Logger log = LoggerFactory.getLogger(TpmAuditFileServiceImpl.class);
    @Resource
    private TpmAuditFileMapper tpmAuditFileMapper;

    @Override
    public PageResult<TpmAuditFileRespVo> findList(TpmAuditFileReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<TpmAuditFileRespVo> list = this.tpmAuditFileMapper.findList((Page<TpmAuditFileRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmAuditFileRespVo query(TpmAuditFileReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TpmAuditFileReqVo reqVo) {
        TpmAuditFileEntity entity = (TpmAuditFileEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmAuditFileEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TpmAuditFileReqVo reqVo) {
        TpmAuditFileEntity entity = (TpmAuditFileEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(TpmAuditFileReqVo reqVo) {
        List tpmAuditFileEntities = this.tpmAuditFileMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmAuditFileEntities)) {
            tpmAuditFileEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(tpmAuditFileEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(TpmAuditFileReqVo reqVo) {
        List tpmAuditFileEntities = this.tpmAuditFileMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmAuditFileEntities)) {
            tpmAuditFileEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmAuditFileEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(TpmAuditFileReqVo reqVo) {
        List tpmAuditFileEntities = this.tpmAuditFileMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmAuditFileEntities)) {
            tpmAuditFileEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmAuditFileEntities);
    }
}

