/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.budgetsubjects.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.budgetsubjects.mapper.TpmBudgetSubjectsMapper;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.budgetsubjects.service.ITpmBudgetSubjectsService;
import com.biz.crm.budgetsubjects.service.impl.BudgetSubjectsServiceHelper;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.SelectAllFlagEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.BudgetSubjectsException;
import com.biz.crm.nebular.tpm.budgetsubjects.req.TpmBudgetSubjectsReqVo;
import com.biz.crm.nebular.tpm.budgetsubjects.resp.TpmBudgetSubjectsRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmBudgetSubjectsServiceExpandImpl"})
public class TpmBudgetSubjectsServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmBudgetSubjectsMapper, TpmBudgetSubjectsEntity>
implements ITpmBudgetSubjectsService {
    private static final Logger log = LoggerFactory.getLogger(TpmBudgetSubjectsServiceImpl.class);
    @Resource
    private TpmBudgetSubjectsMapper tpmBudgetSubjectsMapper;
    @Autowired
    private BudgetSubjectsServiceHelper serviceHelper;

    @Override
    @CrmLog
    public PageResult<TpmBudgetSubjectsRespVo> findList(TpmBudgetSubjectsReqVo tpmBudgetSubjectsReqVo) {
        Page page = PageUtil.buildPage((Integer)tpmBudgetSubjectsReqVo.getPageNum(), (Integer)tpmBudgetSubjectsReqVo.getPageSize());
        List<TpmBudgetSubjectsRespVo> list = this.tpmBudgetSubjectsMapper.findList((Page<TpmBudgetSubjectsRespVo>)page, tpmBudgetSubjectsReqVo);
        this.serviceHelper.convertListDate(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmLog
    public TpmBudgetSubjectsRespVo query(TpmBudgetSubjectsReqVo tpmBudgetSubjectsReqVo) {
        List list = this.findList(tpmBudgetSubjectsReqVo).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new TpmBudgetSubjectsRespVo();
        }
        return (TpmBudgetSubjectsRespVo)list.get(0);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void save(TpmBudgetSubjectsReqVo tpmBudgetSubjectsReqVo) {
        this.serviceHelper.saveCheck(tpmBudgetSubjectsReqVo);
        TpmBudgetSubjectsEntity entity = (TpmBudgetSubjectsEntity)((Object)CrmBeanUtil.copy((Object)tpmBudgetSubjectsReqVo, TpmBudgetSubjectsEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void update(TpmBudgetSubjectsReqVo tpmBudgetSubjectsReqVo) {
        if (StringUtils.isEmpty((CharSequence)tpmBudgetSubjectsReqVo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TpmBudgetSubjectsEntity entity = (TpmBudgetSubjectsEntity)((Object)this.getById((Serializable)((Object)tpmBudgetSubjectsReqVo.getId())));
        if (Objects.isNull((Object)entity)) {
            throw new BusinessException((CrmExceptionType)BudgetSubjectsException.DATA_NOT_EXIST);
        }
        this.serviceHelper.saveCheck(tpmBudgetSubjectsReqVo);
        CrmBeanUtil.copyProperties((Object)tpmBudgetSubjectsReqVo, (Object)((Object)entity));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void deleteBatch(TpmBudgetSubjectsReqVo tpmBudgetSubjectsReqVo) {
        AssertUtils.isNotEmpty((Collection)tpmBudgetSubjectsReqVo.getIds(), (CrmExceptionType)CommonException.IDS_NULL);
        List<TpmBudgetSubjectsRespVo> list = this.tpmBudgetSubjectsMapper.countRelatedNum(tpmBudgetSubjectsReqVo.getIds());
        AssertUtils.isNotEmpty(list, (String)"\u60a8\u9009\u62e9\u7684\u9884\u7b97\u79d1\u76ee\u5df2\u88ab\u5220\u9664");
        list.forEach(o -> AssertUtils.isTrue((o.getNum() == 0 ? 1 : 0) != 0, (String)("\u9884\u7b97\u79d1\u76ee:" + o.getBudgetSubjectsCode() + "\u5df2\u88ab\u8d39\u7528\u9884\u7b97\u5173\u8054,\u4e0d\u80fd\u5220\u9664")));
        this.tpmBudgetSubjectsMapper.deleteProductsByParams(tpmBudgetSubjectsReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void enableBatch(TpmBudgetSubjectsReqVo reqVo) {
        if (StringUtils.equals((CharSequence)SelectAllFlagEnum.ALL.getCode(), (CharSequence)reqVo.getSelectAllFlag())) {
            TpmBudgetSubjectsEntity entity = new TpmBudgetSubjectsEntity();
            entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            this.serviceHelper.updateBySelectAll(reqVo, entity);
        } else {
            AssertUtils.isNotEmpty((Collection)reqVo.getIds(), (CrmExceptionType)CommonException.IDS_NULL);
            List entities = this.tpmBudgetSubjectsMapper.selectBatchIds(reqVo.getIds());
            if (CollectionUtils.isNotEmpty((Collection)entities)) {
                entities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
            }
            this.updateBatchById(entities);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void disableBatch(TpmBudgetSubjectsReqVo reqVo) {
        if (StringUtils.equals((CharSequence)SelectAllFlagEnum.ALL.getCode(), (CharSequence)reqVo.getSelectAllFlag())) {
            TpmBudgetSubjectsEntity entity = new TpmBudgetSubjectsEntity();
            entity.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            this.serviceHelper.updateBySelectAll(reqVo, entity);
        } else {
            AssertUtils.isNotEmpty((Collection)reqVo.getIds(), (CrmExceptionType)CommonException.IDS_NULL);
            List entities = this.tpmBudgetSubjectsMapper.selectBatchIds(reqVo.getIds());
            if (CollectionUtils.isNotEmpty((Collection)entities)) {
                entities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
            }
            this.updateBatchById(entities);
        }
    }
}

