/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.feebudget.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.budgetsubjects.mapper.TpmBudgetSubjectsMapper;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.tpm.BudgetSubjectsControlTypeEnum;
import com.biz.crm.eunm.tpm.FeeBudgetDetailTypeEnum;
import com.biz.crm.eunm.tpm.FeeBudgetTypeEnum;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.FeeBudgetException;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetControlMapper;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetDetailsMapper;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetMapper;
import com.biz.crm.feebudget.model.OperateBudgetControlReqVo;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetDetailsEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.humanarea.EngineOrgFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgReqVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgRespVo;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FeeBudgetServiceHelper
extends BaseServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(FeeBudgetServiceHelper.class);
    @Resource
    private TpmFeeBudgetMapper mapper;
    @Resource
    private TpmFeeBudgetDetailsMapper detailsMapper;
    @Resource
    private TpmBudgetSubjectsMapper budgetSubjectsMapper;
    @Resource
    private MdmCustomerMsgFeign customerFeign;
    @Resource
    private TpmFeeBudgetControlMapper controlMapper;
    @Resource
    private EngineOrgFeign orgFeign;

    public Map<String, Map<String, String>> getDicts() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("fiscal_year");
        dictCodes.add("fiscal_month");
        dictCodes.add("fiscal_quater");
        dictCodes.add("enable_status");
        dictCodes.add("customer_source");
        dictCodes.add("fee_budget_type");
        return DictUtil.getDictValueMapsByCodes((List)dictCodes);
    }

    public void convertListDate(List<TpmFeeBudgetRespVo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Map<String, Map<String, String>> map = this.getDicts();
            list.forEach(o -> {
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)o.getEnableStatus())) {
                    o.setEnableStatusName((String)((Map)Optional.ofNullable(map.get("enable_status")).orElse(Maps.newHashMap())).get(o.getEnableStatus()));
                }
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)o.getBudgetYear())) {
                    o.setBudgetYearName((String)((Map)Optional.ofNullable(map.get("fiscal_year")).orElse(Maps.newHashMap())).get(o.getBudgetYear()));
                }
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)o.getBudgetMonth())) {
                    o.setBudgetMonthName((String)((Map)Optional.ofNullable(map.get("fiscal_month")).orElse(Maps.newHashMap())).get(o.getBudgetMonth()));
                }
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)o.getBudgetQuater())) {
                    o.setBudgetQuaterName((String)((Map)Optional.ofNullable(map.get("fiscal_quater")).orElse(Maps.newHashMap())).get(o.getBudgetQuater()));
                }
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)o.getChannel())) {
                    o.setChannelName((String)((Map)Optional.ofNullable(map.get("customer_source")).orElse(Maps.newHashMap())).get(o.getChannel()));
                }
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)o.getFeeBudgetType())) {
                    o.setFeeBudgetTypeName((String)((Map)Optional.ofNullable(map.get("fee_budget_type")).orElse(Maps.newHashMap())).get(o.getFeeBudgetType()));
                }
            });
        }
    }

    public void updateBySelectAll(TpmFeeBudgetReqVo reqVo, TpmFeeBudgetEntity entity) {
        this.mapper.updateBySelectAll(entity, reqVo);
    }

    public void saveCheck(TpmFeeBudgetReqVo reqVo) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)reqVo.getFeeBudgetCode())) {
            reqVo.setFeeBudgetCode(CodeUtil.createOneCode((String)"tpm_fee_budget"));
        }
        AssertUtils.isNotEmpty((String)reqVo.getFeeBudgetCode(), (String)"\u8d39\u7528\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getFeeBudgetType(), (String)"\u8d39\u7528\u9884\u7b97\u7c7b\u578b");
        AssertUtils.isNotEmpty((String)reqVo.getBudgetYear(), (String)"\u8bf7\u9009\u62e9\u5e74\u4efd");
        AssertUtils.isNotEmpty((String)reqVo.getBudgetMonth(), (String)"\u8bf7\u9009\u62e9\u6708\u4efd");
        AssertUtils.isNotEmpty((String)reqVo.getBudgetQuater(), (String)"\u8bf7\u9009\u62e9\u5b63\u5ea6");
        AssertUtils.isNotNull((Object)reqVo.getInitAmount(), (String)"\u8bf7\u8f93\u5165\u671f\u521d\u91d1\u989d");
        AssertUtils.isNotEmpty((String)reqVo.getBudgetSubjectsCode(), (String)"\u8bf7\u9009\u62e9\u9884\u7b97\u79d1\u76ee");
        EngineOrgRespVo orgRespVo = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reqVo.getOrgCode())) {
            EngineOrgReqVo engineOrgReqVo = new EngineOrgReqVo();
            engineOrgReqVo.setOrgCode(reqVo.getOrgCode());
            orgRespVo = (EngineOrgRespVo)this.orgFeign.query(engineOrgReqVo).getResult();
            AssertUtils.isNotNull((Object)orgRespVo, (String)"\u60a8\u9009\u62e9\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728");
            reqVo.setOrgType(Optional.ofNullable(orgRespVo.getOrgType()).orElse(""));
            reqVo.setOrgName(Optional.ofNullable(orgRespVo.getOrgName()).orElse(""));
            reqVo.setOrgTypeName(Optional.ofNullable(orgRespVo.getOrgTypeName()).orElse(""));
        }
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)FeeBudgetTypeEnum.DEPARTMENT.getCode(), (CharSequence)reqVo.getFeeBudgetType())) {
            AssertUtils.isNotEmpty((String)reqVo.getOrgCode(), (String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7");
        }
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)FeeBudgetTypeEnum.CUSTOMER.getCode(), (CharSequence)reqVo.getFeeBudgetType())) {
            AssertUtils.isNotEmpty((String)reqVo.getCustomerCode(), (String)"\u8bf7\u9009\u62e9\u5ba2\u6237");
            MdmCustomerMsgReqVo customerMsgReqVo = new MdmCustomerMsgReqVo();
            customerMsgReqVo.setCustomerCode(reqVo.getCustomerCode());
            List customerMsgRespVos = ((PageResult)this.customerFeign.list(customerMsgReqVo).getResult()).getData();
            if (CollectionUtils.isNotEmpty((Collection)customerMsgRespVos)) {
                MdmCustomerMsgRespVo customerMsgRespVo = (MdmCustomerMsgRespVo)customerMsgRespVos.get(0);
                AssertUtils.isNotNull((Object)customerMsgRespVo, (String)"\u60a8\u9009\u62e9\u7684\u5ba2\u6237\u4e0d\u5b58\u5728");
                AssertUtils.isTrue((boolean)org.apache.commons.lang3.StringUtils.equals((CharSequence)CrmEnableStatusEnum.ENABLE.getCode(), (CharSequence)customerMsgRespVo.getEnableStatus()), (String)"\u60a8\u9009\u62e9\u7684\u5ba2\u6237\u5df2\u88ab\u7981\u7528");
                AssertUtils.isNotEmpty((String)customerMsgRespVo.getOrgCode(), (String)"\u60a8\u9009\u62e9\u7684\u5ba2\u6237\u7ec4\u7ec7\u6570\u636e\u4e0d\u5b8c\u6574");
                reqVo.setCustomerName(customerMsgRespVo.getCustomerName());
                reqVo.setCustomerOrgCode(customerMsgRespVo.getCustomerOrgCode());
                reqVo.setCustomerOrgName(customerMsgRespVo.getCustomerOrgName());
                reqVo.setOrgCode(customerMsgRespVo.getOrgCode());
                reqVo.setOrgName(customerMsgRespVo.getOrgName());
            }
        }
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)FeeBudgetTypeEnum.CHANNEL.getCode(), (CharSequence)reqVo.getFeeBudgetType())) {
            AssertUtils.isNotEmpty((String)reqVo.getOrgCode(), (String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7");
            AssertUtils.isNotEmpty((String)reqVo.getChannel(), (String)"\u8bf7\u9009\u62e9\u6e20\u9053");
        }
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)FeeBudgetTypeEnum.TERMINAL.getCode(), (CharSequence)reqVo.getFeeBudgetType())) {
            AssertUtils.isNotEmpty((String)reqVo.getCustomerCode(), (String)"\u8bf7\u9009\u62e9\u5ba2\u6237");
            AssertUtils.isNotEmpty((String)reqVo.getTerminalCode(), (String)"\u8bf7\u9009\u62e9\u95e8\u5e97");
        }
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        TpmBudgetSubjectsEntity subjectsEntity = (TpmBudgetSubjectsEntity)((Object)this.budgetSubjectsMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(TpmBudgetSubjectsEntity::getBudgetSubjectsCode, (Object)reqVo.getBudgetSubjectsCode())));
        AssertUtils.isNotNull((Object)((Object)subjectsEntity), (String)"\u9884\u7b97\u79d1\u76ee\u6570\u636e\u4e0d\u5b58\u5728");
        AssertUtils.isTrue((boolean)org.apache.commons.lang3.StringUtils.equals((CharSequence)CrmEnableStatusEnum.ENABLE.getCode(), (CharSequence)subjectsEntity.getEnableStatus()), (String)"\u60a8\u9009\u62e9\u9884\u7b97\u79d1\u76ee\u5df2\u88ab\u7981\u7528");
        reqVo.setBudgetSubjectsControlType(subjectsEntity.getControlType());
        this.checkDataExist(reqVo);
    }

    public String getErrorMsg(TpmFeeBudgetReqVo reqVo) {
        StringBuffer msg = new StringBuffer("\u5df2\u5b58\u5728,");
        msg.append(" \u5e74\u4efd:").append(reqVo.getBudgetYear());
        msg.append(",\u6708\u4efd:").append(reqVo.getBudgetMonth());
        msg.append(",\u5ba2\u6237\u7f16\u7801:").append(reqVo.getCustomerCode());
        msg.append(",\u9884\u7b97\u79d1\u76ee\u7f16\u7801:").append(reqVo.getBudgetSubjectsCode());
        msg.append(",\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801:").append(reqVo.getProductLevelCode());
        msg.append(",\u4ea7\u54c1\u7f16\u7801:").append(reqVo.getProductCode());
        msg.append(",\u7ec4\u7ec7\u7f16\u7801:").append(reqVo.getOrgCode());
        msg.append(",\u6e20\u9053:").append(reqVo.getChannel());
        msg.append(",\u95e8\u5e97\u7f16\u7801:").append(reqVo.getTerminalCode());
        msg.append(",\u7684\u8d39\u7528\u9884\u7b97\u6570\u636e");
        return msg.toString();
    }

    public void checkDataExist(TpmFeeBudgetReqVo reqVo) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmFeeBudgetEntity::getFeeBudgetCode, (Object)reqVo.getFeeBudgetCode());
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            wrapper.ne(BaseIdEntity::getId, (Object)reqVo.getId());
        }
        TpmFeeBudgetEntity entity = (TpmFeeBudgetEntity)((Object)this.mapper.selectOne((Wrapper)wrapper));
        AssertUtils.isTrue((boolean)Objects.isNull((Object)entity), (CrmExceptionType)FeeBudgetException.DATA_CODE_DUPLICATE, (String[])new String[0]);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            queryWrapper.ne(BaseIdEntity::getId, (Object)reqVo.getId());
        }
        queryWrapper.eq(TpmFeeBudgetEntity::getBudgetYear, (Object)reqVo.getBudgetYear());
        queryWrapper.eq(TpmFeeBudgetEntity::getBudgetMonth, (Object)reqVo.getBudgetMonth());
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reqVo.getCustomerCode())) {
            queryWrapper.eq(TpmFeeBudgetEntity::getCustomerCode, (Object)reqVo.getCustomerCode());
        } else {
            queryWrapper.isNull(TpmFeeBudgetEntity::getCustomerCode);
        }
        queryWrapper.eq(TpmFeeBudgetEntity::getBudgetSubjectsCode, (Object)reqVo.getBudgetSubjectsCode());
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reqVo.getProductLevelCode())) {
            queryWrapper.eq(TpmFeeBudgetEntity::getProductLevelCode, (Object)reqVo.getProductLevelCode());
        } else {
            queryWrapper.isNull(TpmFeeBudgetEntity::getProductLevelCode);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reqVo.getProductCode())) {
            queryWrapper.eq(TpmFeeBudgetEntity::getProductCode, (Object)reqVo.getProductCode());
        } else {
            queryWrapper.isNull(TpmFeeBudgetEntity::getProductCode);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reqVo.getOrgCode())) {
            queryWrapper.eq(TpmFeeBudgetEntity::getOrgCode, (Object)reqVo.getOrgCode());
        } else {
            queryWrapper.isNull(TpmFeeBudgetEntity::getOrgCode);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reqVo.getChannel())) {
            queryWrapper.eq(TpmFeeBudgetEntity::getChannel, (Object)reqVo.getChannel());
        } else {
            queryWrapper.isNull(TpmFeeBudgetEntity::getChannel);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reqVo.getTerminalCode())) {
            queryWrapper.eq(TpmFeeBudgetEntity::getTerminalCode, (Object)reqVo.getTerminalCode());
        } else {
            queryWrapper.isNull(TpmFeeBudgetEntity::getTerminalCode);
        }
        List entityList = this.mapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            throw new BusinessException("\u5df2\u5b58\u5728\u76f8\u540c\u7684\u8d39\u7528\u9884\u7b97");
        }
    }

    public TpmFeeBudgetDetailsEntity transformDetail(TpmFeeBudgetEntity entity, TpmFeeBudgetReqVo reqVo) {
        TpmFeeBudgetDetailsEntity detailsEntity = new TpmFeeBudgetDetailsEntity();
        CrmBeanUtil.copyProperties((Object)((Object)entity), (Object)((Object)detailsEntity));
        detailsEntity.setId(null);
        detailsEntity.setBusinessCode(detailsEntity.getFeeBudgetCode());
        FeeBudgetDetailTypeEnum detailTypeEnum = null;
        BigDecimal afterAmount = BigDecimal.ZERO;
        BigDecimal beforAmount = BigDecimal.ZERO;
        BigDecimal feeAmount = BigDecimal.ZERO;
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)FeeBudgetDetailTypeEnum.INIT.getCode(), (CharSequence)reqVo.getFeeBudgetDetailType())) {
            detailTypeEnum = FeeBudgetDetailTypeEnum.INIT;
            beforAmount = entity.getInitAmount();
            afterAmount = entity.getInitAmount();
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)FeeBudgetDetailTypeEnum.ADDITIONAL.getCode(), (CharSequence)reqVo.getFeeBudgetDetailType())) {
            afterAmount = entity.getCanUseAmount();
            feeAmount = reqVo.getChangeAmount();
            detailTypeEnum = FeeBudgetDetailTypeEnum.ADDITIONAL;
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)FeeBudgetDetailTypeEnum.CUT_OUT.getCode(), (CharSequence)reqVo.getFeeBudgetDetailType())) {
            afterAmount = entity.getCanUseAmount();
            feeAmount = BigDecimal.ZERO.subtract(reqVo.getChangeAmount());
            detailTypeEnum = FeeBudgetDetailTypeEnum.CUT_OUT;
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)FeeBudgetDetailTypeEnum.ADJUST_IN.getCode(), (CharSequence)reqVo.getFeeBudgetDetailType())) {
            afterAmount = entity.getCanUseAmount();
            feeAmount = reqVo.getChangeAmount();
            detailTypeEnum = FeeBudgetDetailTypeEnum.ADJUST_IN;
            detailsEntity.setBusinessCode(reqVo.getFeeBudgetCode());
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)FeeBudgetDetailTypeEnum.ADJUST_OUT.getCode(), (CharSequence)reqVo.getFeeBudgetDetailType())) {
            afterAmount = entity.getCanUseAmount();
            feeAmount = BigDecimal.ZERO.subtract(reqVo.getChangeAmount());
            detailTypeEnum = FeeBudgetDetailTypeEnum.ADJUST_OUT;
            detailsEntity.setBusinessCode(reqVo.getAdjustInFeeBudgetCode());
        }
        detailsEntity.setBusinessRemarks(reqVo.getBusinessRemarks());
        detailsEntity.setFeeBudgetDetailType(detailTypeEnum.getCode());
        detailsEntity.setFeeBudgetDetailTypeName(detailTypeEnum.getDes());
        detailsEntity.setMonth(entity.getBudgetMonth());
        detailsEntity.setYear(entity.getBudgetYear());
        detailsEntity.setAfterAmount(afterAmount);
        detailsEntity.setFeeAmount(feeAmount);
        detailsEntity.setBeforAmount(beforAmount);
        return detailsEntity;
    }

    public void createOrUpdateSaveDetail(TpmFeeBudgetEntity entity, TpmFeeBudgetReqVo reqVo) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)entity.getId())) {
            this.detailsMapper.delete((Wrapper)new LambdaQueryWrapper().eq(TpmFeeBudgetDetailsEntity::getFeeBudgetCode, (Object)entity.getFeeBudgetCode()));
        }
        TpmFeeBudgetDetailsEntity detailsEntity = this.transformDetail(entity, reqVo);
        this.detailsMapper.insert((Object)detailsEntity);
    }

    public void changeOrAdjustSaveDetail(TpmFeeBudgetEntity entity, TpmFeeBudgetReqVo reqVo) {
        TpmFeeBudgetDetailsEntity detailsEntity = this.transformDetail(entity, reqVo);
        this.detailsMapper.insert((Object)detailsEntity);
    }

    public void changeCheck(TpmFeeBudgetReqVo reqVo) {
        AssertUtils.isNotNull((Object)reqVo.getChangeAmount(), (String)"\u53d8\u66f4\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((reqVo.getChangeAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u53d8\u66f4\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        AssertUtils.isNotEmpty((String)reqVo.getFeeBudgetDetailType(), (String)"\u53d8\u66f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((org.apache.commons.lang3.StringUtils.equals((CharSequence)FeeBudgetDetailTypeEnum.ADDITIONAL.getCode(), (CharSequence)reqVo.getFeeBudgetDetailType()) || org.apache.commons.lang3.StringUtils.equals((CharSequence)FeeBudgetDetailTypeEnum.CUT_OUT.getCode(), (CharSequence)reqVo.getFeeBudgetDetailType()) ? 1 : 0) != 0, (String)"\u8d39\u7528\u9884\u7b97\u53d8\u66f4\u53ea\u80fd\u9009\u62e9\u8ffd\u52a0\u6216\u8005\u524a\u51cf");
        TpmBudgetSubjectsEntity subjectsEntity = (TpmBudgetSubjectsEntity)((Object)this.budgetSubjectsMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(TpmBudgetSubjectsEntity::getBudgetSubjectsCode, (Object)reqVo.getBudgetSubjectsCode())));
        reqVo.setBudgetSubjectsControlType(subjectsEntity.getControlType());
    }

    public void adjustCheck(TpmFeeBudgetReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getAdjustInFeeBudgetId(), (String)"\u8bf7\u9009\u62e9\u8c03\u5165\u65b9");
        AssertUtils.isNotNull((Object)reqVo.getChangeAmount(), (String)"\u8bf7\u8f93\u5165\u8c03\u51fa\u91d1\u989d");
        AssertUtils.isNotNull((Object)reqVo.getChangeAmount(), (String)"\u8bf7\u8f93\u5165\u8c03\u51fa\u91d1\u989d");
        AssertUtils.isNotEmpty((String)reqVo.getFeeBudgetDetailType(), (String)"\u8bf7\u9009\u62e9\u53d8\u66f4\u7c7b\u578b");
        AssertUtils.isTrue((!org.apache.commons.lang3.StringUtils.equals((CharSequence)reqVo.getId(), (CharSequence)reqVo.getAdjustInFeeBudgetId()) ? 1 : 0) != 0, (String)"\u8c03\u5165\u65b9\u4e0d\u80fd\u4e0e\u8c03\u51fa\u65b9\u4e00\u81f4");
    }

    public void computeAmount(TpmFeeBudgetEntity entity, TpmFeeBudgetReqVo reqVo) {
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)FeeBudgetDetailTypeEnum.CUT_OUT.getCode(), (CharSequence)reqVo.getFeeBudgetDetailType()) || org.apache.commons.lang3.StringUtils.equals((CharSequence)FeeBudgetDetailTypeEnum.ADJUST_OUT.getCode(), (CharSequence)reqVo.getFeeBudgetDetailType())) {
            entity.setAdjustTotalAmount(entity.getAdjustTotalAmount().subtract(reqVo.getChangeAmount()));
            entity.setAfterAdjustAmount(entity.getAfterAdjustAmount().subtract(reqVo.getChangeAmount()));
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)FeeBudgetDetailTypeEnum.ADDITIONAL.getCode(), (CharSequence)reqVo.getFeeBudgetDetailType()) || org.apache.commons.lang3.StringUtils.equals((CharSequence)FeeBudgetDetailTypeEnum.ADJUST_IN.getCode(), (CharSequence)reqVo.getFeeBudgetDetailType())) {
            entity.setAdjustTotalAmount(entity.getAdjustTotalAmount().add(reqVo.getChangeAmount()));
            entity.setAfterAdjustAmount(entity.getAfterAdjustAmount().add(reqVo.getChangeAmount()));
        }
    }

    public void createFeeBudget(OperateBudgetControlReqVo reqVo) {
        TpmFeeBudgetEntity entity = reqVo.getEntity();
        TpmFeeBudgetReqVo budgetReqVo = reqVo.getReqVo();
        String controlType = budgetReqVo.getBudgetSubjectsControlType();
        List<String> feeBudgetControls = this.getFeeBudgetControls(entity.getFeeBudgetType(), controlType);
        Map<String, Object> newQueryMap = this.convertDataToMap(feeBudgetControls, (Object)entity);
        TpmFeeBudgetControlEntity newControl = this.findFeeBudgetControlByParams(newQueryMap);
        if (Objects.isNull((Object)newControl)) {
            newControl = this.saveNewControl(budgetReqVo, entity);
        } else {
            this.updateControl(newControl, BigDecimal.ZERO, budgetReqVo.getInitAmount());
        }
        entity.setControlId(newControl.getId());
    }

    public void updateFeeBudget(OperateBudgetControlReqVo reqVo) {
        TpmFeeBudgetEntity entity = reqVo.getEntity();
        TpmFeeBudgetReqVo budgetReqVo = reqVo.getReqVo();
        String controlType = budgetReqVo.getBudgetSubjectsControlType();
        List<String> feeBudgetControls = this.getFeeBudgetControls(entity.getFeeBudgetType(), controlType);
        AssertUtils.isNotEmpty((String)entity.getControlId(), (String)"\u8d39\u7528\u9884\u7b97\u6570\u636e\u5f02\u5e38,\u63a7\u5236\u7ef4\u5ea6id\u4e3a\u7a7a");
        TpmFeeBudgetControlEntity oldControl = (TpmFeeBudgetControlEntity)((Object)this.controlMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(BaseIdEntity::getId, (Object)entity.getControlId())));
        Map<String, Object> newQueryMap = this.convertDataToMap(feeBudgetControls, (Object)entity);
        TpmFeeBudgetControlEntity newControl = this.findFeeBudgetControlByParams(newQueryMap);
        if (Objects.nonNull((Object)newControl)) {
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)entity.getControlId(), (CharSequence)newControl.getId())) {
                if (budgetReqVo.getInitAmount().compareTo(budgetReqVo.getCanUseAmount()) != 0) {
                    this.updateControl(oldControl, budgetReqVo.getCanUseAmount(), budgetReqVo.getInitAmount());
                }
            } else {
                this.updateControl(newControl, BigDecimal.ZERO, budgetReqVo.getInitAmount());
                this.updateControl(oldControl, budgetReqVo.getCanUseAmount(), BigDecimal.ZERO);
            }
        } else {
            newControl = this.saveNewControl(budgetReqVo, entity);
            this.updateControl(oldControl, budgetReqVo.getCanUseAmount(), BigDecimal.ZERO);
        }
        entity.setControlId(newControl.getId());
    }

    private void deleteFeeBudget(OperateBudgetControlReqVo reqVo) {
        this.updateControl(reqVo.getControlEntity(), reqVo.getControlUpdateAmount(), BigDecimal.ZERO);
    }

    public TpmFeeBudgetControlEntity saveNewControl(TpmFeeBudgetReqVo reqVo, TpmFeeBudgetEntity entity) {
        TpmFeeBudgetControlEntity newControl = new TpmFeeBudgetControlEntity();
        CrmBeanUtil.copyProperties((Object)((Object)entity), (Object)((Object)newControl));
        String selectKey = this.getSelectKey(reqVo);
        newControl.setCanUseAmount(entity.getCanUseAmount());
        newControl.setSelectKey(selectKey);
        super.setPublicParamsNull((CrmBaseEntity)newControl);
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)BudgetSubjectsControlTypeEnum.QUATER.getCode(), (CharSequence)reqVo.getBudgetSubjectsControlType())) {
            newControl.setBudgetMonth(null);
        }
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)BudgetSubjectsControlTypeEnum.YEAR.getCode(), (CharSequence)reqVo.getBudgetSubjectsControlType())) {
            newControl.setBudgetMonth(null);
            newControl.setBudgetQuater(null);
        }
        this.controlMapper.insert((Object)newControl);
        return newControl;
    }

    public void updateControl(TpmFeeBudgetControlEntity controlEntity, BigDecimal oldAmount, BigDecimal newAmount) {
        controlEntity.setCanUseAmount(Optional.ofNullable(controlEntity.getCanUseAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(newAmount).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(oldAmount).orElse(BigDecimal.ZERO)));
        this.controlMapper.updateById((Object)controlEntity);
    }

    public void saveFeeBudgetControlData(OperateBudgetControlReqVo reqVo) {
        AssertUtils.isNotNull((Object)reqVo.getTypeEnum(), (String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        switch (reqVo.getTypeEnum()) {
            case NEW: {
                this.createFeeBudget(reqVo);
                break;
            }
            case UPDATE: {
                this.updateFeeBudget(reqVo);
                break;
            }
            case DELETE: {
                this.deleteFeeBudget(reqVo);
                break;
            }
            case ENABLE: {
                this.enableFeeBudget(reqVo);
                break;
            }
            case DISABLE: {
                this.disableFeeBudget(reqVo);
                break;
            }
            case CHANGE: {
                this.adjustOrChangeFeeBudget(reqVo);
                break;
            }
            case ADJUST_OUT: {
                this.adjustOrChangeFeeBudget(reqVo);
                break;
            }
            case ADJUST_IN: {
                this.adjustOrChangeFeeBudget(reqVo);
                break;
            }
            case USE: {
                this.useOrReturnFeeBudget(reqVo);
                break;
            }
            case RETURN: {
                this.useOrReturnFeeBudget(reqVo);
                break;
            }
            default: {
                throw new BusinessException("\u5c1a\u672a\u5b9a\u4e49\u7684\u8d39\u7528\u7ef4\u5ea6\u64cd\u4f5c\u7c7b\u578b");
            }
        }
    }

    private void useOrReturnFeeBudget(OperateBudgetControlReqVo reqVo) {
        this.updateControl(reqVo.getControlEntity(), BigDecimal.ZERO, BigDecimal.ZERO);
    }

    private void adjustOrChangeFeeBudget(OperateBudgetControlReqVo reqVo) {
        TpmFeeBudgetEntity entity = reqVo.getEntity();
        AssertUtils.isNotEmpty((String)entity.getControlId(), (String)("\u8d39\u7528\u9884\u7b97\u7f16\u7801:" + entity.getFeeBudgetCode() + "\u672a\u5173\u8054\u5230\u63a7\u5236\u7ef4\u5ea6"));
        TpmFeeBudgetControlEntity controlEntity = (TpmFeeBudgetControlEntity)((Object)this.controlMapper.selectById((Serializable)((Object)entity.getControlId())));
        AssertUtils.isNotNull((Object)((Object)controlEntity), (String)("\u8d39\u7528\u9884\u7b97\u7f16\u7801:" + entity.getFeeBudgetCode() + "\u5173\u8054\u7684\u63a7\u5236\u7ef4\u5ea6\u4e0d\u5b58\u5728"));
        this.updateControl(controlEntity, BigDecimal.ZERO, reqVo.getAfterChangeCanUseAmount());
    }

    private void enableFeeBudget(OperateBudgetControlReqVo reqVo) {
        TpmFeeBudgetEntity entity = reqVo.getEntity();
        AssertUtils.isNotEmpty((String)entity.getControlId(), (String)("\u8d39\u7528\u9884\u7b97\u7f16\u7801:" + entity.getFeeBudgetCode() + "\u672a\u5173\u8054\u5230\u63a7\u5236\u7ef4\u5ea6"));
        TpmFeeBudgetControlEntity controlEntity = (TpmFeeBudgetControlEntity)((Object)this.controlMapper.selectById((Serializable)((Object)entity.getControlId())));
        AssertUtils.isNotNull((Object)((Object)controlEntity), (String)("\u8d39\u7528\u9884\u7b97\u7f16\u7801:" + entity.getFeeBudgetCode() + "\u5173\u8054\u7684\u63a7\u5236\u7ef4\u5ea6\u4e0d\u5b58\u5728"));
        this.updateControl(controlEntity, BigDecimal.ZERO, entity.getCanUseAmount());
    }

    private void disableFeeBudget(OperateBudgetControlReqVo reqVo) {
        TpmFeeBudgetEntity entity = reqVo.getEntity();
        AssertUtils.isNotEmpty((String)entity.getControlId(), (String)("\u8d39\u7528\u9884\u7b97\u7f16\u7801:" + entity.getFeeBudgetCode() + "\u672a\u5173\u8054\u5230\u63a7\u5236\u7ef4\u5ea6"));
        TpmFeeBudgetControlEntity controlEntity = (TpmFeeBudgetControlEntity)((Object)this.controlMapper.selectById((Serializable)((Object)entity.getControlId())));
        AssertUtils.isNotNull((Object)((Object)controlEntity), (String)("\u8d39\u7528\u9884\u7b97\u7f16\u7801:" + entity.getFeeBudgetCode() + "\u5173\u8054\u7684\u63a7\u5236\u7ef4\u5ea6\u4e0d\u5b58\u5728"));
        this.updateControl(controlEntity, entity.getCanUseAmount(), BigDecimal.ZERO);
    }

    public String getSelectKey(TpmFeeBudgetReqVo reqVo) {
        String controlType = reqVo.getBudgetSubjectsControlType();
        StringBuffer selectKey = new StringBuffer();
        selectKey.append(reqVo.getBudgetYear());
        if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)BudgetSubjectsControlTypeEnum.YEAR.getCode(), (CharSequence)controlType)) {
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)BudgetSubjectsControlTypeEnum.QUATER.getCode(), (CharSequence)controlType)) {
                selectKey.append("-").append(reqVo.getBudgetQuater());
            } else {
                selectKey.append("-").append(reqVo.getBudgetQuater()).append("-").append(reqVo.getBudgetMonth());
            }
        }
        return selectKey.toString();
    }

    public Map<String, Object> convertDataToMap(List<String> feeBudgetControls, Object obj) {
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)obj));
        HashMap map = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(feeBudgetControls)) {
            feeBudgetControls.stream().forEach(o -> {
                String s = StringUtils.camelCaseName((String)o);
                Object x = jsonObject.get((Object)s);
                if (Objects.isNull(x)) {
                    map.put(o, null);
                } else {
                    map.put(o, x);
                }
            });
        }
        return map;
    }

    public TpmFeeBudgetControlEntity findFeeBudgetControlByParams(Map<String, Object> map) {
        QueryWrapper wrapper = new QueryWrapper();
        AssertUtils.isTrue((boolean)MapUtils.isNotEmpty(map), (String)"\u67e5\u8be2\u8d39\u7528\u9884\u7b97\u63a7\u5236\u7ef4\u5ea6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        for (String s : map.keySet()) {
            Object o = map.get(s);
            if (Objects.isNull(o)) {
                wrapper.isNull((Object)s);
                continue;
            }
            wrapper.eq((Object)s, o);
        }
        List entities = this.controlMapper.selectList((Wrapper)wrapper);
        AssertUtils.isTrue((CollectionUtils.size((Object)entities) <= 1 ? 1 : 0) != 0, (String)"\u5f53\u524d\u63a7\u5236\u7ef4\u5ea6\u7684\u6570\u636e\u5b58\u5728\u591a\u6761,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        return CollectionUtils.isEmpty((Collection)entities) ? null : (TpmFeeBudgetControlEntity)((Object)entities.get(0));
    }

    public List<String> getFeeBudgetControls(String feeBudgetType, String controlType) {
        ArrayList list = Lists.newArrayList();
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)BudgetSubjectsControlTypeEnum.NON.getCode(), (CharSequence)controlType) || org.apache.commons.lang3.StringUtils.equals((CharSequence)BudgetSubjectsControlTypeEnum.MONTH.getCode(), (CharSequence)controlType)) {
            list.add("budget_year");
            list.add("budget_quater");
            list.add("budget_month");
        }
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)BudgetSubjectsControlTypeEnum.QUATER.getCode(), (CharSequence)controlType)) {
            list.add("budget_year");
            list.add("budget_quater");
        }
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)BudgetSubjectsControlTypeEnum.YEAR.getCode(), (CharSequence)controlType)) {
            list.add("budget_year");
        }
        list.add("budget_subjects_code");
        list.add("product_level_code");
        list.add("product_code");
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)FeeBudgetTypeEnum.DEPARTMENT.getCode(), (CharSequence)feeBudgetType)) {
            list.add("org_code");
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)FeeBudgetTypeEnum.TERMINAL.getCode(), (CharSequence)feeBudgetType)) {
            list.add("terminal_code");
            list.add("customer_code");
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)FeeBudgetTypeEnum.CHANNEL.getCode(), (CharSequence)feeBudgetType)) {
            list.add("channel");
            list.add("org_code");
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)FeeBudgetTypeEnum.CUSTOMER.getCode(), (CharSequence)feeBudgetType)) {
            list.add("customer_code");
        }
        list.add("fee_budget_type");
        return list;
    }
}

