/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.act.mapper.TpmActBudgetMapper;
import com.biz.crm.act.mapper.TpmActDetailMapper;
import com.biz.crm.act.mapper.TpmActFeeShareMapper;
import com.biz.crm.act.mapper.TpmActFileMapper;
import com.biz.crm.act.mapper.TpmActMapper;
import com.biz.crm.act.model.TpmActBudgetEntity;
import com.biz.crm.act.model.TpmActEntity;
import com.biz.crm.act.service.ITpmActFileService;
import com.biz.crm.act.service.ITpmActService;
import com.biz.crm.act.service.impl.ActBuilder;
import com.biz.crm.act.service.impl.ActServiceHelper;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesEntity;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetControlMapper;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.feebudget.service.ITpmFeeBudgetControlService;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.humanarea.EngineOrgFeign;
import com.biz.crm.mdm.material.MdmMaterialFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgRespVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmMaterialOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmTerminalOrgSearchReqVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialPriceRespVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmTerminalReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalRespVo;
import com.biz.crm.nebular.tpm.act.req.ActDetailFeeShareVo;
import com.biz.crm.nebular.tpm.act.req.ActGetCustomerCodeByOrgCodeReqVo;
import com.biz.crm.nebular.tpm.act.req.ActGetOrgInfoReqVo;
import com.biz.crm.nebular.tpm.act.req.ActGetTerminalByCustomerCodeReqVo;
import com.biz.crm.nebular.tpm.act.req.TmpActFeeShareReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActFileReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActReqVo;
import com.biz.crm.nebular.tpm.act.resp.TmpActFeeShareRespVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActDetailRespVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActFileRespVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActRespVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetControlReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmActServiceExpandImpl"})
public class TpmActServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmActMapper, TpmActEntity>
implements ITpmActService {
    private static final Logger log = LoggerFactory.getLogger(TpmActServiceImpl.class);
    @Resource
    private TpmActMapper tpmActMapper;
    @Resource
    private ActServiceHelper serviceHelper;
    @Resource
    private ITpmActFileService actFileService;
    @Resource
    private TpmFeeBudgetControlMapper tpmFeeBudgetControlMapper;
    @Resource
    private EngineOrgFeign engineOrgFeign;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private MdmMaterialFeign mdmMaterialFeign;
    @Resource
    private TpmActBudgetMapper budgetMapper;
    @Resource
    private TpmActDetailMapper detailMapper;
    @Resource
    private TpmActFeeShareMapper feeShareMapper;
    @Resource
    private TpmActFileMapper fileMapper;
    @Autowired
    private ITpmFeeBudgetControlService budgetControlService;

    @Override
    public PageResult<TpmActRespVo> findList(TpmActReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<TpmActRespVo> list = this.tpmActMapper.findList((Page<TpmActRespVo>)page, reqVo);
        this.serviceHelper.convertListDate(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmActRespVo query(TpmActReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        PageResult<TpmActRespVo> data = this.findList(reqVo);
        List list = data.getData();
        AssertUtils.isNotEmpty((Collection)list, (String)"\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e0d\u5b58\u5728");
        TpmActRespVo respVo = (TpmActRespVo)list.get(0);
        Map<String, String> payTypesDictMap = this.serviceHelper.getPayTypesDict();
        List budgetEntities = this.budgetMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(TpmActBudgetEntity::getActCode, (Object)respVo.getActCode()));
        if (CollectionUtils.isNotEmpty((Collection)budgetEntities)) {
            HashSet controlIds = Sets.newHashSet();
            HashMap map = Maps.newHashMap();
            budgetEntities.forEach(o -> {
                map.put(o.getFeeBudgetCode(), o);
                controlIds.add(o.getControlId());
            });
            TpmFeeBudgetControlReqVo controlReqVo = new TpmFeeBudgetControlReqVo();
            controlReqVo.setIds((Collection)controlIds);
            List<TpmFeeBudgetControlRespVo> budgetControlRespVos = this.budgetControlService.list(controlReqVo);
            if (CollectionUtils.isNotEmpty(budgetControlRespVos)) {
                budgetControlRespVos.forEach(o -> {
                    List feeBudgetVos = o.getFeeBudgetVos();
                    if (CollectionUtils.isNotEmpty((Collection)feeBudgetVos)) {
                        feeBudgetVos.forEach(p -> {
                            TpmActBudgetEntity budgetEntity = (TpmActBudgetEntity)((Object)((Object)((Object)map.get(p.getFeeBudgetCode()))));
                            p.setReduceRatio(budgetEntity.getReduceRatio());
                            p.setReduceOrder(budgetEntity.getReduceOrder());
                            p.setActCode(budgetEntity.getActCode());
                        });
                    }
                });
            }
            respVo.setEditBudgetVos(budgetControlRespVos);
        }
        TpmActDetailReqVo detailReqVo = new TpmActDetailReqVo();
        detailReqVo.setActCode(respVo.getActCode());
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)-1);
        List<TpmActDetailRespVo> detailRespVos = this.detailMapper.findList((Page<TpmActDetailRespVo>)page, detailReqVo);
        if (CollectionUtils.isNotEmpty(detailRespVos)) {
            HashSet categoriesCodes = Sets.newHashSet();
            HashSet fineCodes = Sets.newHashSet();
            detailRespVos.stream().forEach(o -> {
                categoriesCodes.add(o.getCategoriesCode());
                fineCodes.add(o.getFineCode());
            });
            List<TpmCostTypeCategoriesEntity> categoriesEntitiesByCodes = this.serviceHelper.findCategoriesEntitiesByCodes(categoriesCodes);
            List<TpmCostTypeFineEntity> fineEntitiesByCodes = this.serviceHelper.findFineEntitiesByCodes(fineCodes);
            Map<Object, Object> fineEntityMap = Maps.newHashMap();
            Map<Object, Object> categoriesEntityMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty(fineEntitiesByCodes)) {
                fineEntityMap = fineEntitiesByCodes.stream().collect(Collectors.toMap(TpmCostTypeFineEntity::getFineCode, Function.identity()));
            }
            if (CollectionUtils.isNotEmpty(categoriesEntitiesByCodes)) {
                categoriesEntityMap = categoriesEntitiesByCodes.stream().collect(Collectors.toMap(TpmCostTypeCategoriesEntity::getCategoriesCode, Function.identity()));
            }
            for (TpmActDetailRespVo o2 : detailRespVos) {
                TpmCostTypeFineEntity tpmCostTypeFineEntity;
                TpmCostTypeCategoriesEntity tpmCostTypeCategoriesEntity = (TpmCostTypeCategoriesEntity)((Object)categoriesEntityMap.get(o2.getCategoriesCode()));
                if (Objects.nonNull((Object)tpmCostTypeCategoriesEntity)) {
                    o2.setFormCode(tpmCostTypeCategoriesEntity.getFormCode());
                }
                if (!Objects.nonNull((Object)(tpmCostTypeFineEntity = (TpmCostTypeFineEntity)((Object)fineEntityMap.get(o2.getFineCode()))))) continue;
                List<DictItemVo> dictItemVos = this.serviceHelper.convertDictList(payTypesDictMap, tpmCostTypeFineEntity.getPayTypeList());
                o2.setPayTypes(dictItemVos);
            }
        }
        respVo.setDetailVos(detailRespVos);
        TmpActFeeShareReqVo tmpActFeeShareReqVo = new TmpActFeeShareReqVo();
        tmpActFeeShareReqVo.setActCode(respVo.getActCode());
        Page feeShareRespVoPage = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)-1);
        List<TmpActFeeShareRespVo> list1 = this.feeShareMapper.findList((Page<TmpActFeeShareRespVo>)feeShareRespVoPage, tmpActFeeShareReqVo);
        respVo.setFeeShareVos(list1);
        TpmActFileReqVo fileReqVo = new TpmActFileReqVo();
        fileReqVo.setActCode(respVo.getActCode());
        Page filePage = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)-1);
        List<TpmActFileRespVo> fileRespVos = this.fileMapper.findList((Page<TpmActFileRespVo>)filePage, fileReqVo);
        respVo.setFileList(fileRespVos);
        return respVo;
    }

    @Override
    public List<TpmCostTypeFineRespVo> getCategoryFinesByCategoryCode(TpmActDetailReqVo tpmActDetailReqVo) {
        AssertUtils.isNotEmpty((String)tpmActDetailReqVo.getCategoriesCode(), (String)"\u8bf7\u9009\u62e9\u6d3b\u52a8\u5927\u7c7b");
        List<TpmCostTypeFineRespVo> list = this.tpmActMapper.getCategoryFinesByCategoryCode(tpmActDetailReqVo);
        if (CollectionUtils.isNotEmpty(list)) {
            Map<String, String> map = this.serviceHelper.getPayTypesDict();
            list.forEach(o -> {
                List<DictItemVo> payTypes = this.serviceHelper.convertDictList(map, o.getPayTypeList());
                o.setPayTypes(payTypes);
            });
        }
        return list;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TpmActReqVo reqVo) {
        ActBuilder.builder(this.serviceHelper, reqVo).init().check().convert().save();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TpmActReqVo reqVo) {
        this.serviceHelper.updateCheck(reqVo);
        ActBuilder.builder(this.serviceHelper, reqVo).init().check().convert().update();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        TpmActReqVo tpmActReqVo = new TpmActReqVo().setIds(ids);
        this.serviceHelper.deleteCheck(tpmActReqVo);
        this.tpmActMapper.deleteByParams(tpmActReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void closed(TpmActReqVo reqVo) {
        AssertUtils.isNotEmpty((Collection)reqVo.getIds(), (CrmExceptionType)CommonException.IDS_NULL);
        List<TpmActRespVo> list = this.serviceHelper.closedCheck(reqVo);
        this.serviceHelper.closedBatch(list);
    }

    @Override
    public List<EngineOrgRespVo> getOrgInfoByControlIds(ActGetOrgInfoReqVo tpmActReqVo) {
        AssertUtils.isNotEmpty((Collection)tpmActReqVo.getControlIds(), (String)"\u8bf7\u9009\u62e9\u8d39\u7528\u9884\u7b97");
        Set controlIds = tpmActReqVo.getControlIds().stream().collect(Collectors.toSet());
        List tpmFeeBudgetControlEntities = this.tpmFeeBudgetControlMapper.selectBatchIds(controlIds);
        if (CollectionUtils.isEmpty((Collection)tpmFeeBudgetControlEntities)) {
            return Lists.newArrayList();
        }
        Set orgCodes = tpmFeeBudgetControlEntities.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getOrgCode())).map(TpmFeeBudgetControlEntity::getOrgCode).collect(Collectors.toSet());
        UserRedis user = UserUtils.getUser();
        if (Objects.nonNull(user) && Objects.nonNull(user.getOrgcode())) {
            orgCodes.add(user.getOrgcode());
        }
        EngineOrgSearchReqVo engineOrgSearchReqVo = new EngineOrgSearchReqVo();
        engineOrgSearchReqVo.setOrgCodeList((List)Lists.newArrayList(orgCodes));
        engineOrgSearchReqVo.setPageSize(tpmActReqVo.getPageSize());
        engineOrgSearchReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        engineOrgSearchReqVo.setOrgCodeOrName(tpmActReqVo.getOrgCodeOrName());
        log.info("\u6d3b\u52a8\u65b0\u589e\u6839\u636e\u8d39\u7528\u9884\u7b97\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u7ec4\u7ec7 \u5165\u53c2=\u3010{}\u3011", (Object)JSON.toJSONString((Object)engineOrgSearchReqVo));
        Result currentAndSubOrgCodeList = null;
        try {
            currentAndSubOrgCodeList = this.engineOrgFeign.findCurrentAndSubOrgCodeList(engineOrgSearchReqVo);
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
            throw new BusinessException("\u6d3b\u52a8\u65b0\u589e\u6839\u636e\u8d39\u7528\u9884\u7b97\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u7ec4\u7ec7,\u8c03\u7528mdm\u63a5\u53e3\u5931\u8d25");
        }
        log.info("\u6d3b\u52a8\u65b0\u589e\u6839\u636e\u8d39\u7528\u9884\u7b97\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u7ec4\u7ec7 \u8fd4\u56de\u7ed3\u679c=\u3010{}\u3011", (Object)JSON.toJSONString((Object)currentAndSubOrgCodeList));
        return (List)ApiResultUtil.objResult((Result)currentAndSubOrgCodeList, (boolean)true);
    }

    @Override
    public List<MdmCustomerMsgRespVo> getCustomerMsgByOrgCodes(ActGetCustomerCodeByOrgCodeReqVo tpmActReqVo) {
        AssertUtils.isNotEmpty((String)tpmActReqVo.getOrgCode(), (String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7");
        MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo = new MdmCustomerOrgSearchReqVo();
        mdmCustomerOrgSearchReqVo.setCustomerCodeOrName(tpmActReqVo.getCustomerCodeOrName());
        mdmCustomerOrgSearchReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        mdmCustomerOrgSearchReqVo.setPageSize(tpmActReqVo.getPageSize());
        mdmCustomerOrgSearchReqVo.setOrgCodeList(Collections.singletonList(tpmActReqVo.getOrgCode()));
        Result currentAndSubCustomerList = null;
        try {
            currentAndSubCustomerList = this.mdmCustomerMsgFeign.findCurrentAndSubCustomerList(mdmCustomerOrgSearchReqVo);
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
            throw new BusinessException("\u6d3b\u52a8\u65b0\u589e\u6839\u636e\u7ec4\u7ec7\u83b7\u53d6\u5ba2\u6237\u5217\u8868,\u8c03\u7528mdm\u63a5\u53e3\u5931\u8d25");
        }
        return (List)ApiResultUtil.objResult((Result)currentAndSubCustomerList, (boolean)true);
    }

    @Override
    public List<MdmTerminalRespVo> getTerminalMsgByCustomerCode(ActGetTerminalByCustomerCodeReqVo tpmActReqVo) {
        AssertUtils.isNotEmpty((String)tpmActReqVo.getCustomerCode(), (String)"\u8bf7\u9009\u62e9\u5ba2\u6237");
        MdmTerminalOrgSearchReqVo mdmTerminalOrgSearchReqVo = new MdmTerminalOrgSearchReqVo();
        mdmTerminalOrgSearchReqVo.setPageSize(tpmActReqVo.getPageSize());
        mdmTerminalOrgSearchReqVo.setCustomerCode(tpmActReqVo.getCustomerCode());
        mdmTerminalOrgSearchReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        mdmTerminalOrgSearchReqVo.setTerminalCodeOrName(tpmActReqVo.getTerminalCodeOrName());
        Result list = null;
        try {
            list = this.mdmTerminalFeign.list(new MdmTerminalReqVo());
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
            throw new BusinessException("\u6d3b\u52a8\u65b0\u589e\u6839\u636e\u5ba2\u6237\u83b7\u53d6\u95e8\u5e97\u5217\u8868,\u8c03\u7528mdm\u63a5\u53e3\u5931\u8d25");
        }
        return ((PageResult)list.getResult()).getData();
    }

    @Override
    public List<MdmMaterialPriceRespVo> getMaterialList(ActGetTerminalByCustomerCodeReqVo tpmActReqVo) {
        MdmMaterialOrgSearchReqVo mdmMaterialOrgSearchReqVo = new MdmMaterialOrgSearchReqVo();
        mdmMaterialOrgSearchReqVo.setPageSize(tpmActReqVo.getPageSize());
        mdmMaterialOrgSearchReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        mdmMaterialOrgSearchReqVo.setMaterialCodeOrName(tpmActReqVo.getMaterialCodeOrName());
        Result currentAndSubMaterialList = null;
        try {
            currentAndSubMaterialList = this.mdmMaterialFeign.findCurrentAndSubMaterialList(mdmMaterialOrgSearchReqVo);
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
            throw new BusinessException("\u9886\u7528\u6d3b\u52a8\u65b0\u589e\u9875\u9762\u67e5\u8be2\u7269\u6599\u5217\u8868,\u8c03\u7528mdm\u63a5\u53e3\u5931\u8d25");
        }
        return (List)ApiResultUtil.objResult((Result)currentAndSubMaterialList, (boolean)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        List tpmActEntities = this.tpmActMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)tpmActEntities)) {
            tpmActEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmActEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        List tpmActEntities = this.tpmActMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)tpmActEntities)) {
            tpmActEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmActEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void approve(TpmActReqVo tpmActReqVo) {
        TpmActEntity tpmActEntity = this.serviceHelper.approveCheck(tpmActReqVo);
        tpmActEntity.setApproveStatus(ActApproveStatusEnum.APPROVING.getCode());
        this.update(tpmActReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void rejectAndInterrupt(TpmActReqVo reqVo) {
        this.serviceHelper.rejectAndInterrupt(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void approved(TpmActReqVo reqVo) {
        this.serviceHelper.approved(reqVo);
    }

    @Override
    public List<ActDetailFeeShareVo> actDetailFeeShare(ActDetailFeeShareVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getExecuteBeginDate(), (String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.isNotEmpty((String)reqVo.getExecuteEndDate(), (String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.isNotNull((Object)reqVo.getFeeShareAmount(), (String)"\u5206\u644a\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.isTrue((boolean)StringUtils.isEmpty((CharSequence)reqVo.getFeeShareGroupId()), (String)"\u5f53\u524d\u6d3b\u52a8\u660e\u7ec6\u4e0d\u80fd\u518d\u6b21\u8fdb\u884c\u5206\u644a\uff01");
        List months = DateUtil.getMonthBetween((String)reqVo.getExecuteBeginDate(), (String)reqVo.getExecuteEndDate());
        BigDecimal average = reqVo.getFeeShareAmount().divide(new BigDecimal(months.size()), 2, 3);
        ArrayList<ActDetailFeeShareVo> actDetailFeeShareVos = new ArrayList<ActDetailFeeShareVo>();
        String freeId = UUID.randomUUID().toString().replaceAll("-", "");
        for (String month : months) {
            actDetailFeeShareVos.add(ActDetailFeeShareVo.builder().executeBeginDate(reqVo.getExecuteBeginDate()).executeEndDate(reqVo.getExecuteEndDate()).executeBeginDateSecond(reqVo.getExecuteBeginDateSecond()).executeEndDateSecond(reqVo.getExecuteEndDateSecond()).feeDateStr(month).feeShareAmount(average).feeShareGroupId(freeId).build());
        }
        BigDecimal remainder = reqVo.getFeeShareAmount().subtract(average.multiply(new BigDecimal(months.size())));
        ((ActDetailFeeShareVo)actDetailFeeShareVos.get(actDetailFeeShareVos.size() - 1)).setFeeShareAmount(average.add(remainder));
        return actDetailFeeShareVos;
    }
}

