/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.audit.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.audit.service.ITpmAuditService;
import com.biz.crm.common.PageResult;
import com.biz.crm.costtypefine.service.ITpmCostTypeFineService;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActReqVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActDetailRespVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActRespVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditReqVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditRespVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tpmAuditController"})
@Api(tags={"\u6838\u9500\u7533\u8bf7\u4e3b\u8868 "})
public class TpmAuditController {
    private static final Logger log = LoggerFactory.getLogger(TpmAuditController.class);
    @Autowired
    private ITpmAuditService tpmAuditService;
    @Autowired
    private ITpmCostTypeFineService tpmCostTypeFineService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<TpmAuditRespVo>> list(@RequestBody TpmAuditReqVo tpmAuditReqVo) {
        PageResult<TpmAuditRespVo> result = this.tpmAuditService.findList(tpmAuditReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @PostMapping(value={"/query"})
    @CrmLog
    public Result<TpmAuditRespVo> query(@RequestBody TpmAuditReqVo tpmAuditReqVo) {
        TpmAuditRespVo respVo = this.tpmAuditService.query(tpmAuditReqVo);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody TpmAuditReqVo tpmAuditReqVo) {
        this.tpmAuditService.save(tpmAuditReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody TpmAuditReqVo tpmAuditReqVo) {
        this.tpmAuditService.update(tpmAuditReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        AssertUtils.isNotEmpty(ids, (String)"\u7f16\u7801\u96c6\u5408\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        this.tpmAuditService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        this.tpmAuditService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        this.tpmAuditService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u6838\u9500\u7533\u8bf7\u65b0\u589e\u7684\u6d3b\u52a8\u660e\u7ec6\u5217\u8868")
    @PostMapping(value={"/actDetailList"})
    @CrmLog
    public Result<PageResult<TpmActDetailRespVo>> actDetailList(@RequestBody TpmActDetailReqVo tpmActReqVo) {
        PageResult<TpmActDetailRespVo> result = this.tpmAuditService.findActDetailList(tpmActReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u6838\u9500\u7533\u8bf7\u65b0\u589e\u65f6\u67e5\u8be2\u6d3b\u52a8\u5217\u8868")
    @PostMapping(value={"/actList"})
    @CrmLog
    public Result<PageResult<TpmActRespVo>> actList(@RequestBody TpmActReqVo tpmActReqVo) {
        PageResult<TpmActRespVo> result = this.tpmAuditService.actList(tpmActReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u5ba1\u6279\u901a\u8fc7")
    @PostMapping(value={"/auditApproved"})
    @CrmLog
    public Result auditApproved(@RequestBody TpmAuditReqVo tpmAuditReqVo) {
        this.tpmAuditService.auditApproved(tpmAuditReqVo);
        return Result.ok((String)"\u5ba1\u6279\u901a\u8fc7");
    }

    @ApiOperation(value="\u5ba1\u6279\u9a73\u56de")
    @PostMapping(value={"/reject"})
    @CrmLog
    public Result reject(@RequestBody TpmAuditReqVo tpmAuditReqVo) {
        this.tpmAuditService.rejectAndInterrupt(tpmAuditReqVo);
        return Result.ok((String)"\u5ba1\u6279\u9a73\u56de\u6210\u529f");
    }

    @ApiOperation(value="\u6d41\u7a0b\u8ffd\u56de")
    @PostMapping(value={"/interrupt"})
    @CrmLog
    public Result interrupt(@RequestBody TpmAuditReqVo tpmAuditReqVo) {
        this.tpmAuditService.rejectAndInterrupt(tpmAuditReqVo);
        return Result.ok((String)"\u6d41\u7a0b\u8ffd\u56de\u6210\u529f");
    }

    @ApiOperation(value="\u6838\u9500\u7533\u8bf7\u4e2d\u6838\u9500\u8d44\u6599")
    @PostMapping(value={"/costTypeFineListByFineCode"})
    @CrmLog
    public Result<List<TpmCostTypeFineRespVo>> costTypeFineListByFineCode(@RequestBody List<String> fineCodes) {
        List<TpmCostTypeFineRespVo> respVo = this.tpmCostTypeFineService.costTypeFineListByFineCode(fineCodes);
        return Result.ok(respVo);
    }
}

