/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.account.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.account.mapper.TpmAccountDetailMapper;
import com.biz.crm.account.mapper.TpmAccountInvoiceMapper;
import com.biz.crm.account.mapper.TpmAccountProductMapper;
import com.biz.crm.account.model.TpmAccountDetailEntity;
import com.biz.crm.account.model.TpmAccountInvoiceEntity;
import com.biz.crm.account.model.TpmAccountProductEntity;
import com.biz.crm.account.service.ITpmAccountDetailService;
import com.biz.crm.account.service.impl.AccountServiceHelper;
import com.biz.crm.audit.service.ITpmAuditService;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.costtypefine.mapper.TpmCostTypeFineMapper;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.tpm.AccountStatusEnum;
import com.biz.crm.eunm.tpm.ActPayTypeEnum;
import com.biz.crm.eunm.tpm.ActPayTypeTypeEnum;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.AccountException;
import com.biz.crm.nebular.tpm.account.req.TpmAccountDetailMainReqVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountDetailReqVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountInvoiceReqVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountProductReqVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountUpdatePayTypeReqVo;
import com.biz.crm.nebular.tpm.account.req.TpmPayTypeByTypeAndFineVo;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountDetailMainRespVo;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountDetailRespVo;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountInvoiceRespVo;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountProductRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.UUIDGenerator;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmAccountDetailServiceExpandImpl"})
public class TpmAccountDetailServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmAccountDetailMapper, TpmAccountDetailEntity>
implements ITpmAccountDetailService {
    private static final Logger log = LoggerFactory.getLogger(TpmAccountDetailServiceImpl.class);
    @Resource
    private TpmAccountDetailMapper tpmAccountDetailMapper;
    @Autowired
    private AccountServiceHelper accountServiceHelper;
    @Resource
    private TpmAccountProductMapper tpmAccountProductMapper;
    @Resource
    private TpmAccountInvoiceMapper tpmAccountInvoiceMapper;
    @Resource
    private TpmCostTypeFineMapper tpmCostTypeFineMapper;
    @Autowired
    private ITpmAuditService iTpmAuditService;

    @Override
    public PageResult<TpmAccountDetailRespVo> findList(TpmAccountDetailReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<TpmAccountDetailRespVo> list = this.tpmAccountDetailMapper.findList((Page<TpmAccountDetailRespVo>)page, reqVo);
        list.forEach(tpmAccountDetailRespVo -> {
            if (StringUtils.equals((CharSequence)AccountStatusEnum.CREATE.getCode(), (CharSequence)tpmAccountDetailRespVo.getApproveStatus())) {
                tpmAccountDetailRespVo.setApproveStatusName(AccountStatusEnum.CREATE.getDes());
            } else if (StringUtils.equals((CharSequence)AccountStatusEnum.SUBMITTED.getCode(), (CharSequence)tpmAccountDetailRespVo.getApproveStatus())) {
                tpmAccountDetailRespVo.setApproveStatusName(AccountStatusEnum.SUBMITTED.getDes());
            }
            if (StringUtils.equals((CharSequence)ActPayTypeTypeEnum.DEFAULT_FEE_POOL.getCode(), (CharSequence)tpmAccountDetailRespVo.getPayTypeType())) {
                tpmAccountDetailRespVo.setPayTypeTypeName(ActPayTypeTypeEnum.DEFAULT_FEE_POOL.getDes());
            } else if (StringUtils.equals((CharSequence)ActPayTypeTypeEnum.NEED_INVOICE.getCode(), (CharSequence)tpmAccountDetailRespVo.getPayTypeType())) {
                tpmAccountDetailRespVo.setPayTypeTypeName(ActPayTypeTypeEnum.NEED_INVOICE.getDes());
            }
        });
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmAccountDetailMainRespVo queryView(String id) {
        TpmAccountDetailMainRespVo resultVo = new TpmAccountDetailMainRespVo();
        AssertUtils.isNotEmpty((String)id, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
        TpmAccountDetailEntity accountDetailEntity = (TpmAccountDetailEntity)((Object)this.tpmAccountDetailMapper.selectById((Serializable)((Object)id)));
        AssertUtils.isNotNull((Object)((Object)accountDetailEntity), (CrmExceptionType)AccountException.DATA_NOT_EXIST, (String[])new String[0]);
        List accountDetailEntities = this.tpmAccountDetailMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmAccountDetailEntity::getGroupId, (Object)accountDetailEntity.getGroupId()));
        AssertUtils.isNotEmpty((Collection)accountDetailEntities, (CrmExceptionType)AccountException.DATA_NOT_EXIST);
        if (StringUtils.equals((CharSequence)ActPayTypeTypeEnum.DEFAULT_FEE_POOL.getCode(), (CharSequence)accountDetailEntity.getPayTypeType())) {
            if (StringUtils.equals((CharSequence)ActPayTypeEnum.REPLENISHMENT.getCode(), (CharSequence)accountDetailEntity.getPayType())) {
                this.setProductInfo(resultVo, accountDetailEntity, accountDetailEntities);
            } else {
                List accountDetailRespVos = CrmBeanUtil.copyList((List)accountDetailEntities, TpmAccountDetailRespVo.class);
                resultVo.setAccountDetailRespVos(accountDetailRespVos);
            }
        } else if (StringUtils.equals((CharSequence)ActPayTypeTypeEnum.NEED_INVOICE.getCode(), (CharSequence)accountDetailEntity.getPayTypeType())) {
            this.setInvoiceInfo(resultVo, accountDetailEntity, accountDetailEntities);
        }
        resultVo.setGroupId(accountDetailEntity.getGroupId());
        return resultVo;
    }

    private void setInvoiceInfo(TpmAccountDetailMainRespVo resultVo, TpmAccountDetailEntity accountDetailEntity, List<TpmAccountDetailEntity> accountDetailEntities) {
        List tpmAccountInvoiceEntities = this.tpmAccountInvoiceMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmAccountInvoiceEntity::getGroupId, (Object)accountDetailEntity.getGroupId()));
        if (CollectionUtils.isNotEmpty((Collection)tpmAccountInvoiceEntities)) {
            Map<String, List<TpmAccountInvoiceEntity>> accountInvoiceMap = tpmAccountInvoiceEntities.stream().collect(Collectors.groupingBy(TpmAccountInvoiceEntity::getInvoiceCode));
            ArrayList<Object> tpmAccountInvoiceRespVos = new ArrayList<Object>();
            for (Map.Entry<String, List<TpmAccountInvoiceEntity>> accountInvoiceMapList : accountInvoiceMap.entrySet()) {
                List<TpmAccountInvoiceEntity> invoiceMapListValue = accountInvoiceMapList.getValue();
                String accountCode = invoiceMapListValue.stream().map(TpmAccountInvoiceEntity::getAccountCode).collect(Collectors.joining(","));
                TpmAccountInvoiceEntity tpmAccountInvoiceEntity = invoiceMapListValue.get(0);
                tpmAccountInvoiceEntity.setAccountCode(accountCode);
                tpmAccountInvoiceRespVos.add(CrmBeanUtil.copy((Object)((Object)tpmAccountInvoiceEntity), TpmAccountInvoiceRespVo.class));
            }
            List accountDetailRespVos = CrmBeanUtil.copyList(accountDetailEntities, TpmAccountDetailRespVo.class);
            resultVo.setAccountDetailRespVos(accountDetailRespVos);
            resultVo.setAccountInvoiceRespVos(tpmAccountInvoiceRespVos);
        }
    }

    private void setProductInfo(TpmAccountDetailMainRespVo resultVo, TpmAccountDetailEntity accountDetailEntity, List<TpmAccountDetailEntity> accountDetailEntities) {
        ArrayList<TpmAccountDetailRespVo> detailRespVos = new ArrayList<TpmAccountDetailRespVo>();
        List productEntities = this.tpmAccountProductMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmAccountProductEntity::getGroupId, (Object)accountDetailEntity.getGroupId()));
        if (CollectionUtils.isNotEmpty((Collection)productEntities)) {
            Map<String, List<TpmAccountProductEntity>> accountProductMap = productEntities.stream().collect(Collectors.groupingBy(TpmAccountProductEntity::getAccountCode));
            for (Map.Entry<String, List<TpmAccountProductEntity>> accountProductMapList : accountProductMap.entrySet()) {
                for (TpmAccountDetailEntity detailEntity : accountDetailEntities) {
                    if (!StringUtils.equals((CharSequence)detailEntity.getAccountCode(), (CharSequence)accountProductMapList.getKey())) continue;
                    TpmAccountDetailRespVo tpmAccountDetailRespVo = (TpmAccountDetailRespVo)CrmBeanUtil.copy((Object)((Object)detailEntity), TpmAccountDetailRespVo.class);
                    List tpmAccountProductRespVos = CrmBeanUtil.copyList(accountProductMapList.getValue(), TpmAccountProductRespVo.class);
                    tpmAccountDetailRespVo.setAccountProductRespVos(tpmAccountProductRespVos);
                    detailRespVos.add(tpmAccountDetailRespVo);
                }
            }
            resultVo.setAccountDetailRespVos(detailRespVos);
        } else {
            resultVo.setAccountDetailRespVos(CrmBeanUtil.copyList(accountDetailEntities, TpmAccountDetailRespVo.class));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TpmAccountDetailMainReqVo accountDetailMainReqVo) {
        this.accountServiceHelper.saveCheck(accountDetailMainReqVo);
        List accountDetailReqVos = accountDetailMainReqVo.getAccountDetailReqVos();
        String groupId = UUIDGenerator.generate();
        accountDetailReqVos.forEach(tpmAccountDetailReqVo -> {
            List tpmProductInfoReqVos = tpmAccountDetailReqVo.getTpmProductInfoReqVos();
            if (CollectionUtils.isNotEmpty((Collection)tpmProductInfoReqVos)) {
                String productNames = tpmProductInfoReqVos.stream().map(TpmAccountProductReqVo::getProductName).collect(Collectors.joining(","));
                tpmAccountDetailReqVo.setProductNames(productNames);
            }
            tpmAccountDetailReqVo.setGroupId(groupId);
        });
        List accountInvoiceReqVos = accountDetailMainReqVo.getAccountInvoiceReqVos();
        String formInstanceId = accountDetailMainReqVo.getFormInstanceId();
        List accountDetailEntities = CrmBeanUtil.copyList((List)accountDetailReqVos, TpmAccountDetailEntity.class);
        accountDetailEntities.forEach(tpmAccountDetailEntity -> tpmAccountDetailEntity.setFormInstanceId(formInstanceId));
        this.saveBatch(accountDetailEntities);
        if (StringUtils.equals((CharSequence)ActPayTypeTypeEnum.DEFAULT_FEE_POOL.getCode(), (CharSequence)((TpmAccountDetailReqVo)accountDetailReqVos.get(0)).getPayTypeType())) {
            for (TpmAccountDetailReqVo tpmAccountDetailReqVo2 : accountDetailReqVos) {
                if (!StringUtils.equals((CharSequence)ActPayTypeEnum.REPLENISHMENT.getCode(), (CharSequence)tpmAccountDetailReqVo2.getPayType())) continue;
                this.saveProductInfo(accountDetailReqVos, groupId, formInstanceId);
            }
        } else if (StringUtils.equals((CharSequence)ActPayTypeTypeEnum.NEED_INVOICE.getCode(), (CharSequence)((TpmAccountDetailReqVo)accountDetailReqVos.get(0)).getPayTypeType())) {
            this.saveInvoice(accountInvoiceReqVos, groupId, formInstanceId);
        }
    }

    private void saveProductInfo(List<TpmAccountDetailReqVo> accountDetailReqVos, String groupId, String formInstanceId) {
        accountDetailReqVos.forEach(tpmAccountDetailReqVo -> {
            List productInfoReqVos = tpmAccountDetailReqVo.getTpmProductInfoReqVos();
            if (CollectionUtils.isNotEmpty((Collection)productInfoReqVos)) {
                productInfoReqVos.forEach(productInfoReqVo -> {
                    TpmAccountProductEntity tpmAccountProductEntity = new TpmAccountProductEntity();
                    tpmAccountProductEntity.setProductCode(productInfoReqVo.getProductCode());
                    tpmAccountProductEntity.setProductName(productInfoReqVo.getProductName());
                    tpmAccountProductEntity.setAccountCode(tpmAccountDetailReqVo.getAccountCode());
                    tpmAccountProductEntity.setFormInstanceId(formInstanceId);
                    tpmAccountProductEntity.setRemarks(tpmAccountDetailReqVo.getRemarks());
                    if (StringUtils.isNotBlank((CharSequence)groupId)) {
                        tpmAccountProductEntity.setGroupId(groupId);
                    }
                    this.tpmAccountProductMapper.insert((Object)tpmAccountProductEntity);
                });
            }
        });
    }

    private void saveInvoice(List<TpmAccountInvoiceReqVo> accountInvoiceReqVos, String groupId, String formInstanceId) {
        accountInvoiceReqVos.forEach(tpmAccountInvoiceReqVo -> {
            List accountCodes = tpmAccountInvoiceReqVo.getAccountCodes();
            accountCodes.forEach(accountCode -> {
                TpmAccountInvoiceEntity tpmAccountInvoiceEntity = (TpmAccountInvoiceEntity)((Object)((Object)((Object)CrmBeanUtil.copy((Object)tpmAccountInvoiceReqVo, TpmAccountInvoiceEntity.class))));
                tpmAccountInvoiceEntity.setAccountCode((String)accountCode);
                tpmAccountInvoiceEntity.setFormInstanceId(formInstanceId);
                if (StringUtils.isNotBlank((CharSequence)groupId)) {
                    tpmAccountInvoiceEntity.setGroupId(groupId);
                }
                this.tpmAccountInvoiceMapper.insert((Object)tpmAccountInvoiceEntity);
            });
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TpmAccountDetailMainReqVo accountDetailMainReqVo) {
        List accountInvoiceEntities;
        String groupId = accountDetailMainReqVo.getGroupId();
        AssertUtils.isNotEmpty((String)groupId, (String)"\u5206\u7ec4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.accountServiceHelper.saveCheck(accountDetailMainReqVo);
        List accountDetailReqVos = accountDetailMainReqVo.getAccountDetailReqVos();
        List accountInvoiceReqVos = accountDetailMainReqVo.getAccountInvoiceReqVos();
        List accountDetailIds = accountDetailReqVos.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getId())).map(UuidVo::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(accountDetailIds)) {
            this.tpmAccountDetailMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmAccountDetailEntity::getGroupId, (Object)groupId)).notIn(BaseIdEntity::getId, accountDetailIds));
        }
        this.saveOrUpdateBatch(CrmBeanUtil.copyList((List)accountDetailReqVos, TpmAccountDetailEntity.class));
        if (StringUtils.equals((CharSequence)ActPayTypeTypeEnum.DEFAULT_FEE_POOL.getCode(), (CharSequence)((TpmAccountDetailReqVo)accountDetailReqVos.get(0)).getPayTypeType())) {
            for (TpmAccountDetailReqVo tpmAccountDetailReqVo : accountDetailReqVos) {
                if (!StringUtils.equals((CharSequence)ActPayTypeEnum.REPLENISHMENT.getCode(), (CharSequence)tpmAccountDetailReqVo.getPayType())) continue;
                List productEntities = this.tpmAccountProductMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(TpmAccountProductEntity::getGroupId, new Object[]{groupId}));
                if (CollectionUtils.isNotEmpty((Collection)productEntities)) {
                    List productIds = productEntities.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
                    this.tpmAccountProductMapper.delete((Wrapper)Wrappers.lambdaQuery().in(BaseIdEntity::getId, productIds));
                }
                this.saveProductInfo(accountDetailReqVos, groupId, accountDetailMainReqVo.getFormInstanceId());
            }
        } else if (StringUtils.equals((CharSequence)ActPayTypeTypeEnum.NEED_INVOICE.getCode(), (CharSequence)((TpmAccountDetailReqVo)accountDetailReqVos.get(0)).getPayTypeType()) && CollectionUtils.isNotEmpty((Collection)(accountInvoiceEntities = this.tpmAccountInvoiceMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(TpmAccountInvoiceEntity::getGroupId, new Object[]{groupId}))))) {
            List invoiceIds = accountInvoiceEntities.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
            this.tpmAccountInvoiceMapper.delete((Wrapper)Wrappers.lambdaQuery().in(BaseIdEntity::getId, invoiceIds));
            this.saveInvoice(accountInvoiceReqVos, groupId, accountDetailMainReqVo.getFormInstanceId());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List accountDetailEntities = this.tpmAccountDetailMapper.selectBatchIds(ids);
        if (CollectionUtils.isEmpty((Collection)accountDetailEntities)) {
            return;
        }
        accountDetailEntities.forEach(o -> AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)o.getApproveStatus(), (CharSequence)AccountStatusEnum.CREATE.getCode()), (String)"\u53ea\u6709\u6682\u5b58\u72b6\u6001\u7684\u6570\u636e\u5141\u8bb8\u5220\u9664"));
        this.tpmAccountDetailMapper.deleteBatchByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        List tpmAccountDetailEntities = this.tpmAccountDetailMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)tpmAccountDetailEntities)) {
            tpmAccountDetailEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmAccountDetailEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        List tpmAccountDetailEntities = this.tpmAccountDetailMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)tpmAccountDetailEntities)) {
            tpmAccountDetailEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmAccountDetailEntities);
    }

    @Override
    public void batchUpdatePayType(TpmAccountUpdatePayTypeReqVo updatePayTypeReqVo) {
        this.accountServiceHelper.batchUpdatePayTypeCheck(updatePayTypeReqVo);
        List ids = updatePayTypeReqVo.getIds();
        ids.forEach(id -> {
            TpmAccountDetailEntity tpmAccountDetailEntity = new TpmAccountDetailEntity();
            tpmAccountDetailEntity.setPayType(updatePayTypeReqVo.getPayType());
            tpmAccountDetailEntity.setPayTypeName(updatePayTypeReqVo.getPayTypeName());
            tpmAccountDetailEntity.setId((String)id);
            this.tpmAccountDetailMapper.updateById((Object)tpmAccountDetailEntity);
        });
    }

    @Override
    public List<DictItemVo> payTypeByTypeAndFine(TpmPayTypeByTypeAndFineVo typeAndFineVo) {
        AssertUtils.isNotEmpty((String)typeAndFineVo.getPayTypeType(), (String)"\u652f\u4ed8\u65b9\u5f0f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((Collection)typeAndFineVo.getFineCodes(), (String)"\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        Set collect = typeAndFineVo.getFineCodes().stream().collect(Collectors.toSet());
        List tpmCostTypeFineEntities = this.tpmCostTypeFineMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(TpmCostTypeFineEntity::getFineCode, collect));
        Set payTypeSet = Sets.newConcurrentHashSet();
        if (CollectionUtil.listNotEmpty((List)tpmCostTypeFineEntities)) {
            Map<String, String> map = this.iTpmAuditService.queryDictValueMap();
            List payTypeCodes = JSON.parseArray((String)((TpmCostTypeFineEntity)((Object)tpmCostTypeFineEntities.get(0))).getPayTypeList(), String.class);
            for (TpmCostTypeFineEntity tpmCostTypeFineEntity : tpmCostTypeFineEntities) {
                String payTypeList = tpmCostTypeFineEntity.getPayTypeList();
                List strings = JSON.parseArray((String)payTypeList, String.class);
                payTypeCodes.retainAll(strings);
            }
            List<DictItemVo> payTypes = this.iTpmAuditService.getPayTypes(JSON.toJSONString((Object)payTypeCodes), map);
            payTypeSet.addAll(payTypes);
        }
        if (CollectionUtils.isEmpty((Collection)payTypeSet)) {
            return Lists.newArrayList();
        }
        return this.payTypeByType(typeAndFineVo.getPayTypeType(), payTypeSet);
    }

    public List<DictItemVo> payTypeByType(String payTypeType, Set<DictItemVo> payTypeSet) {
        List<Object> resultList;
        if (StringUtils.equals((CharSequence)ActPayTypeTypeEnum.NEED_INVOICE.getCode(), (CharSequence)payTypeType)) {
            resultList = payTypeSet.stream().filter(o -> StringUtils.equals((CharSequence)o.getDictValue(), (CharSequence)ActPayTypeEnum.CASH.getCode()) || StringUtils.equals((CharSequence)o.getDictValue(), (CharSequence)ActPayTypeEnum.FORWARD_PAYMENT.getCode()) || StringUtils.equals((CharSequence)o.getDictValue(), (CharSequence)ActPayTypeEnum.ACCOUNT_DEDUCTION.getCode())).collect(Collectors.toList());
        } else if (StringUtils.equals((CharSequence)ActPayTypeTypeEnum.DEFAULT_FEE_POOL.getCode(), (CharSequence)payTypeType)) {
            resultList = payTypeSet.stream().filter(o -> StringUtils.equals((CharSequence)o.getDictValue(), (CharSequence)ActPayTypeEnum.REPLENISHMENT.getCode()) || StringUtils.equals((CharSequence)o.getDictValue(), (CharSequence)ActPayTypeEnum.DISCOUNT.getCode()) || StringUtils.equals((CharSequence)o.getDictValue(), (CharSequence)ActPayTypeEnum.TICKET_DISCOUNT.getCode())).collect(Collectors.toList());
        } else {
            throw new BusinessException("\u652f\u4ed8\u65b9\u5f0f\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        return resultList;
    }
}

