/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.account.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.account.mapper.TpmAccountDetailMapper;
import com.biz.crm.account.model.TpmAccountDetailEntity;
import com.biz.crm.audit.mapper.TpmAuditDetailMapper;
import com.biz.crm.audit.mapper.TpmAuditMapper;
import com.biz.crm.audit.model.TpmAuditDetailEntity;
import com.biz.crm.audit.model.TpmAuditEntity;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.ActAdvancePayApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActPayTypeEnum;
import com.biz.crm.eunm.tpm.ActPayTypeTypeEnum;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.AccountException;
import com.biz.crm.exception.tpm.AuditException;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountDetailMainReqVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountDetailReqVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountInvoiceReqVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountProductReqVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountUpdatePayTypeReqVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AccountServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(AccountServiceHelper.class);
    @Resource
    private TpmAuditDetailMapper tpmAuditDetailMapper;
    @Resource
    private TpmAuditMapper tpmAuditMapper;
    @Resource
    private TpmAccountDetailMapper tpmAccountDetailMapper;
    @Resource
    private MdmProductFeign mdmProductFeign;

    public void saveCheck(TpmAccountDetailMainReqVo accountDetailMainReqVo) {
        List accountDetailReqVos = accountDetailMainReqVo.getAccountDetailReqVos();
        AssertUtils.isNotEmpty((Collection)accountDetailReqVos, (String)"\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        List deduplicationList = accountDetailReqVos.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<TpmAccountDetailReqVo>(Comparator.comparing(TpmAccountDetailReqVo::getAccountCode))), ArrayList::new));
        accountDetailMainReqVo.setAccountDetailReqVos(deduplicationList);
        AssertUtils.isTrue((accountDetailReqVos.size() == deduplicationList.size() ? 1 : 0) != 0, (String)"\u8d39\u7528\u4e0a\u8d26\u6570\u636e\u91cd\u590d");
        if (StringUtils.isNotBlank((CharSequence)accountDetailMainReqVo.getGroupId())) {
            List accountCodes = deduplicationList.stream().map(TpmAccountDetailReqVo::getAccountCode).collect(Collectors.toList());
            List detailEntityList = this.tpmAccountDetailMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(TpmAccountDetailEntity::getAccountCode, accountCodes));
            AssertUtils.isTrue((CollectionUtils.size((Object)detailEntityList) == accountDetailReqVos.size() ? 1 : 0) != 0, (String)"\u8d39\u7528\u4e0a\u8d26\u6570\u636e\u5f02\u5e38");
        }
        this.checkAuditInfo(deduplicationList);
        if (StringUtils.equals((CharSequence)ActPayTypeTypeEnum.DEFAULT_FEE_POOL.getCode(), (CharSequence)((TpmAccountDetailReqVo)deduplicationList.get(0)).getPayTypeType())) {
            for (TpmAccountDetailReqVo tpmAccountDetailReqVo : deduplicationList) {
                if (!StringUtils.equals((CharSequence)ActPayTypeEnum.REPLENISHMENT.getCode(), (CharSequence)tpmAccountDetailReqVo.getPayType())) continue;
                this.checkProductInfo(deduplicationList);
            }
        } else if (StringUtils.equals((CharSequence)ActPayTypeTypeEnum.NEED_INVOICE.getCode(), (CharSequence)((TpmAccountDetailReqVo)deduplicationList.get(0)).getPayTypeType())) {
            this.checkInvoice(accountDetailMainReqVo);
        }
        this.checkDataExist(accountDetailMainReqVo);
    }

    private void checkAuditInfo(List<TpmAccountDetailReqVo> reqVos) {
        Map<String, List<TpmAccountDetailReqVo>> accountDetailMap = reqVos.stream().collect(Collectors.groupingBy(TpmAccountDetailReqVo::getPayTypeType));
        Set<String> payTypes = accountDetailMap.keySet();
        AssertUtils.isTrue((payTypes.size() == 1 ? 1 : 0) != 0, (String)"\u53ea\u80fd\u9009\u62e9\u540c\u4e00\u652f\u4ed8\u65b9\u5f0f\u7c7b\u578b\u7684\u6838\u9500\u660e\u7ec6");
        reqVos.forEach(tpmAccountDetailReqVo -> {
            TpmAuditEntity tpmAuditEntity = (TpmAuditEntity)((Object)((Object)this.tpmAuditMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(TpmAuditEntity::getAuditCode, (Object)tpmAccountDetailReqVo.getAuditCode()))));
            AssertUtils.isNotNull((Object)((Object)tpmAuditEntity), (CrmExceptionType)AuditException.DATA_NOT_EXIST, (String[])new String[0]);
            AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)ActAdvancePayApproveStatusEnum.APPROVED.getCode(), (CharSequence)tpmAuditEntity.getApproveStatus()), (String)"\u5ba1\u6279\u901a\u8fc7\u6838\u9500\u624d\u80fd\u4e0a\u8d26");
            TpmAuditDetailEntity auditDetailEntity = (TpmAuditDetailEntity)((Object)((Object)this.tpmAuditDetailMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(TpmAuditDetailEntity::getAuditDetailCode, (Object)tpmAccountDetailReqVo.getAuditDetailCode()))));
            AssertUtils.isNotNull((Object)((Object)auditDetailEntity), (CrmExceptionType)AuditException.DATA_NOT_EXIST, (String[])new String[0]);
            AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)GlobalWhetherEnum.NO.getCode(), (CharSequence)auditDetailEntity.getIsAllFeeUsed()), (String)"\u5b8c\u5168\u4e0a\u8d26\u7684\u6838\u9500\u4e0d\u80fd\u4e0a\u8d26");
            AssertUtils.isNotNull((Object)tpmAccountDetailReqVo.getAccountAmount(), (String)"\u672c\u6b21\u4e0a\u8d26\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotNull((Object)tpmAccountDetailReqVo.getCurrentAllowAmount(), (String)"\u53ef\u4e0a\u8d26\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isTrue((tpmAccountDetailReqVo.getAccountAmount().compareTo(tpmAccountDetailReqVo.getCurrentAllowAmount()) < 1 ? 1 : 0) != 0, (String)"\u672c\u6b21\u4e0a\u8d26\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u53ef\u4e0a\u8d26\u91d1\u989d");
        });
    }

    private void checkProductInfo(List<TpmAccountDetailReqVo> reqVos) {
        reqVos.forEach(tpmAccountDetailReqVo -> {
            List tpmProductInfoReqVos = tpmAccountDetailReqVo.getTpmProductInfoReqVos();
            if (CollectionUtils.isNotEmpty((Collection)tpmProductInfoReqVos)) {
                List deduplicationList = tpmProductInfoReqVos.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<TpmAccountProductReqVo>(Comparator.comparing(TpmAccountProductReqVo::getProductCode))), ArrayList::new));
                AssertUtils.isTrue((tpmProductInfoReqVos.size() == deduplicationList.size() ? 1 : 0) != 0, (String)"\u4ea7\u54c1\u7f16\u7801\u91cd\u590d");
                tpmProductInfoReqVos.forEach(tpmAccountProductReqVo -> {
                    Result mdmProductRespVoResult = this.mdmProductFeign.detail(null, tpmAccountProductReqVo.getProductCode());
                    AssertUtils.isTrue((boolean)ApiResultUtil.checkResult((Result)mdmProductRespVoResult), (String)"\u4ea7\u54c1\u4e0d\u5b58\u5728");
                    AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)((MdmProductRespVo)mdmProductRespVoResult.getResult()).getEnableStatus(), (CharSequence)CrmEnableStatusEnum.ENABLE.getCode()), (String)"\u4ea7\u54c1\u4e0d\u751f\u6548");
                });
            }
        });
    }

    private void checkInvoice(TpmAccountDetailMainReqVo accountDetailMainReqVo) {
        List accountDetailReqVos = accountDetailMainReqVo.getAccountDetailReqVos();
        List accountInvoiceReqVos = accountDetailMainReqVo.getAccountInvoiceReqVos();
        List deduplicationList = accountInvoiceReqVos.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<TpmAccountInvoiceReqVo>(Comparator.comparing(TpmAccountInvoiceReqVo::getInvoiceCode))), ArrayList::new));
        AssertUtils.isTrue((accountInvoiceReqVos.size() == deduplicationList.size() ? 1 : 0) != 0, (String)"\u4ea7\u54c1\u7f16\u7801\u91cd\u590d");
        accountDetailReqVos.forEach(tpmAccountDetailReqVo -> {
            AssertUtils.isNotEmpty((String)tpmAccountDetailReqVo.getCustomerName(), (String)"\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)tpmAccountDetailReqVo.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isTrue((CollectionUtils.size((Object)tpmAccountDetailReqVo.getTpmProductInfoReqVos()) == 0 ? 1 : 0) != 0, (String)"\u652f\u4ed8\u65b9\u5f0f\u4e3a\u9700\u8981\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u9009\u62e9\u8d27\u8865\u4ea7\u54c1");
        });
        AssertUtils.isNotEmpty((Collection)accountInvoiceReqVos, (String)"\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        accountInvoiceReqVos.forEach(tpmAccountInvoiceReqVo -> {
            AssertUtils.isNotEmpty((String)tpmAccountInvoiceReqVo.getInvoiceCode(), (String)"\u53d1\u7968\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotNull((Object)tpmAccountInvoiceReqVo.getInvoiceAmount(), (String)"\u53d1\u7968\u91d1\u989d(\u4e0d\u542b\u7a0e)\u4e0d\u80fd\u4e3a\u7a7a");
            List accountCodes = tpmAccountInvoiceReqVo.getAccountCodes();
            long count = accountDetailReqVos.stream().filter(o -> accountCodes.contains(o.getAccountCode())).map(TpmAccountDetailReqVo::getCustomerCode).distinct().count();
            AssertUtils.isTrue((count == 1L ? 1 : 0) != 0, (String)("\u53d1\u7968\uff1a" + tpmAccountInvoiceReqVo.getInvoiceCode() + "\u5bf9\u5e94\u7684\u5ba2\u6237\u7f16\u7801\u5fc5\u987b\u76f8\u540c"));
        });
    }

    private void checkDataExist(TpmAccountDetailMainReqVo accountDetailMainReqVo) {
        List accountDetailReqVos = accountDetailMainReqVo.getAccountDetailReqVos();
        for (TpmAccountDetailReqVo accountDetailReqVo : accountDetailReqVos) {
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmAccountDetailEntity::getAuditCode, (Object)accountDetailReqVo.getAccountCode());
            if (StringUtils.isNotEmpty((CharSequence)accountDetailReqVo.getId())) {
                wrapper.ne(BaseIdEntity::getId, (Object)accountDetailReqVo.getId());
            }
            TpmAccountDetailEntity entity = (TpmAccountDetailEntity)((Object)this.tpmAccountDetailMapper.selectOne((Wrapper)wrapper));
            AssertUtils.isTrue((boolean)Objects.isNull((Object)entity), (CrmExceptionType)AccountException.DATA_CODE_DUPLICATE, (String[])new String[0]);
        }
    }

    public void batchUpdatePayTypeCheck(TpmAccountUpdatePayTypeReqVo accountDetailMainReqVo) {
        AssertUtils.isNotEmpty((Collection)accountDetailMainReqVo.getIds(), (String)"\u7f16\u7801\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)accountDetailMainReqVo.getPayType(), (String)"\u652f\u4ed8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

