/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.act.mapper.TpmActBudgetMapper;
import com.biz.crm.act.mapper.TpmActDetailMapper;
import com.biz.crm.act.mapper.TpmActFeeShareMapper;
import com.biz.crm.act.mapper.TpmActFileMapper;
import com.biz.crm.act.mapper.TpmActMapper;
import com.biz.crm.act.model.TmpActFeeShareEntity;
import com.biz.crm.act.model.TpmActBudgetEntity;
import com.biz.crm.act.model.TpmActDetailEntity;
import com.biz.crm.act.model.TpmActEntity;
import com.biz.crm.act.model.TpmActFileEntity;
import com.biz.crm.act.service.ITpmActDetailService;
import com.biz.crm.act.service.impl.ActOperateFeeBudgetVo;
import com.biz.crm.audit.mapper.TpmAuditActMapper;
import com.biz.crm.audit.mapper.TpmAuditMapper;
import com.biz.crm.audit.model.TpmAuditActEntity;
import com.biz.crm.audit.model.TpmAuditDetailEntity;
import com.biz.crm.audit.model.TpmAuditEntity;
import com.biz.crm.audit.service.ITpmAuditDetailService;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesFineMapper;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesMapper;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesEntity;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesFineEntity;
import com.biz.crm.costtypefine.mapper.TpmCostTypeFineMapper;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActSaveTypeEnum;
import com.biz.crm.eunm.tpm.ActTypeEnum;
import com.biz.crm.eunm.tpm.ActivityReleaseNeedEnum;
import com.biz.crm.eunm.tpm.FeeBudgetDetailTypeEnum;
import com.biz.crm.eunm.tpm.FeeBudgetRemarkEnum;
import com.biz.crm.eunm.tpm.FeeBudgetTypeEnum;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.ActException;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetControlMapper;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetDetailsMapper;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetMapper;
import com.biz.crm.feebudget.model.OperateBudgetControlReqVo;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetDetailsEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.feebudget.service.ITpmFeeBudgetControlService;
import com.biz.crm.feebudget.service.ITpmFeeBudgetDetailsService;
import com.biz.crm.feebudget.service.ITpmFeeBudgetService;
import com.biz.crm.feebudget.service.impl.FeeBudgetServiceHelper;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.dict.resp.DictDataVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.tpm.act.req.TpmActReqVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActRespVo;
import com.biz.crm.nebular.tpm.feebudget.req.FeeBudgetControlOperateTypeEnum;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PageUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActServiceHelper
extends BaseServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(ActServiceHelper.class);
    @Resource
    private TpmActMapper actMapper;
    @Resource
    private TpmActBudgetMapper tpmActBudgetMapper;
    @Resource
    private TpmFeeBudgetControlMapper feeBudgetControlMapper;
    @Autowired
    private ITpmFeeBudgetControlService feeBudgetControlService;
    @Resource
    private TpmActDetailMapper actDetailMapper;
    @Resource
    private TpmActFeeShareMapper actFeeShareMapper;
    @Resource
    private TpmActFileMapper actFileMapper;
    @Resource
    private TpmFeeBudgetDetailsMapper feeBudgetDetailsMapper;
    @Resource
    private TpmFeeBudgetMapper feeBudgetMapper;
    @Autowired
    private ITpmFeeBudgetService feeBudgetService;
    @Autowired
    private ITpmFeeBudgetDetailsService feeBudgetDetailsService;
    @Resource
    private TpmCostTypeCategoriesMapper categoriesMapper;
    @Resource
    private TpmCostTypeFineMapper fineMapper;
    @Resource
    private TpmCostTypeCategoriesFineMapper categoriesFineMapper;
    @Resource
    private MdmOrgFeign orgFeign;
    @Autowired
    private FeeBudgetServiceHelper budgetServiceHelper;
    @Resource
    private MdmCustomerMsgFeign customerFeign;
    @Resource
    private TpmAuditMapper auditMapper;
    @Resource
    private TpmAuditActMapper auditActMapper;
    @Resource
    private ITpmAuditDetailService auditDetailService;
    @Autowired
    private ITpmActDetailService actDetailService;

    public Map<String, Map<String, String>> getDicts() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("enable_status");
        dictCodes.add("act_type");
        dictCodes.add("act_approve_status");
        return DictUtil.getDictValueMapsByCodes((List)dictCodes);
    }

    public void convertListDate(List<TpmActRespVo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Map<String, Map<String, String>> map = this.getDicts();
            list.forEach(o -> {
                if (StringUtils.isNotEmpty((CharSequence)o.getEnableStatus())) {
                    o.setEnableStatusName((String)((Map)Optional.ofNullable(map.get("enable_status")).orElse(Maps.newHashMap())).get(o.getEnableStatus()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getActType())) {
                    o.setActTypeName((String)((Map)Optional.ofNullable(map.get("act_type")).orElse(Maps.newHashMap())).get(o.getActType()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getApproveStatus())) {
                    o.setApproveStatusName((String)((Map)Optional.ofNullable(map.get("act_approve_status")).orElse(Maps.newHashMap())).get(o.getApproveStatus()));
                }
            });
        }
    }

    public LambdaQueryWrapper<TpmActEntity> getQueryWrapper(TpmActReqVo reqVo) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(StringUtils.isNotEmpty((CharSequence)reqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)reqVo.getEnableStatus());
        return wrapper;
    }

    public void updateBySelectAll(TpmActReqVo reqVo, TpmActEntity entity) {
        LambdaQueryWrapper<TpmActEntity> queryWrapper = this.getQueryWrapper(reqVo);
        this.actMapper.update((Object)entity, (Wrapper)queryWrapper);
    }

    public void saveCheck(TpmActReqVo reqVo) {
        this.checkDataExist(reqVo);
    }

    public void checkDataExist(TpmActReqVo reqVo) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
    }

    public void deleteCheck(TpmActReqVo reqVo) {
        reqVo.setPageSize(Integer.valueOf(-1));
        List<TpmActRespVo> list = this.actMapper.findList((Page<TpmActRespVo>)PageUtil.buildPage((Integer)1, (Integer)-1), reqVo);
        AssertUtils.isNotNull(list, (String)"\u8bf7\u9009\u62e9\u60a8\u9700\u8981\u5220\u9664\u7684\u6570\u636e");
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append("\u6d3b\u52a8\u7f16\u7801:[");
        if (CollectionUtils.isNotEmpty(list)) {
            StringBuffer msg = new StringBuffer();
            list.forEach(o -> {
                if (!StringUtils.equals((CharSequence)ActApproveStatusEnum.CREATE.getCode(), (CharSequence)o.getApproveStatus())) {
                    msg.append(o.getActCode()).append(",");
                }
            });
            if (StringUtils.isNotEmpty((CharSequence)msg.toString())) {
                throw new BusinessException(errorMsg.append(msg.toString()).append("],\u7684\u6d3b\u52a8\u72b6\u6001\u4e0d\u4e3a\u5f85\u63d0\u4ea4,\u4e0d\u80fd\u5220\u9664").toString());
            }
        }
    }

    public List<TpmActRespVo> closedCheck(TpmActReqVo reqVo) {
        reqVo.setPageSize(Integer.valueOf(-1));
        List<TpmActRespVo> list = this.actMapper.findList((Page<TpmActRespVo>)PageUtil.buildPage((Integer)1, (Integer)-1), reqVo);
        AssertUtils.isNotNull(list, (String)"\u8bf7\u9009\u62e9\u60a8\u9700\u8981\u5173\u95ed\u7684\u6570\u636e");
        StringBuffer errorMsg2 = new StringBuffer();
        StringBuffer errorMsg1 = new StringBuffer();
        errorMsg2.append("\u6d3b\u52a8\u7f16\u7801:[");
        errorMsg1.append("\u6d3b\u52a8\u7f16\u7801:[");
        if (CollectionUtils.isNotEmpty(list)) {
            StringBuffer msg = new StringBuffer();
            StringBuffer msg1 = new StringBuffer();
            list.forEach(o -> {
                if (!StringUtils.equals((CharSequence)ActApproveStatusEnum.APPROVED.getCode(), (CharSequence)o.getApproveStatus())) {
                    msg.append(o.getActCode()).append(",");
                }
                if (StringUtils.equals((CharSequence)GlobalWhetherEnum.YES.getCode(), (CharSequence)o.getIsAllAudit())) {
                    msg1.append(o.getActCode()).append(",");
                }
            });
            if (StringUtils.isNotEmpty((CharSequence)msg.toString())) {
                throw new BusinessException(errorMsg2.append(msg.toString()).append("],\u7684\u6d3b\u52a8\u72b6\u6001\u4e0d\u4e3a\u5ba1\u6279\u901a\u8fc7,\u4e0d\u80fd\u5173\u95ed").toString());
            }
            if (StringUtils.isNotEmpty((CharSequence)msg1.toString())) {
                throw new BusinessException(errorMsg1.append(msg1.toString()).append("],\u7684\u6d3b\u52a8\u5df2\u5b8c\u5168\u6838\u9500\uff0c\u65e0\u9700\u5173\u95ed\u201d").toString());
            }
        }
        return list;
    }

    public ActOperateFeeBudgetVo setOperateFeeBudgetVo(List<TpmActDetailEntity> detailEntities) {
        ArrayList actDetailCodes = Lists.newArrayList();
        HashSet actCodes = Sets.newHashSet();
        detailEntities.stream().forEach(o -> {
            actDetailCodes.add(o.getActDetailCode());
            actCodes.add(o.getActCode());
        });
        List budgetDetailsEntities = this.feeBudgetDetailsMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TpmFeeBudgetDetailsEntity::getBusinessCode, (Collection)actCodes)).in(TpmFeeBudgetDetailsEntity::getBusinessLineCode, (Collection)actDetailCodes)).eq(TpmFeeBudgetDetailsEntity::getFeeBudgetDetailType, (Object)FeeBudgetDetailTypeEnum.USE.getCode())).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
        Boolean isRatio = Objects.nonNull(((TpmFeeBudgetDetailsEntity)((Object)budgetDetailsEntities.get(0))).getReduceRatio());
        HashMap budgetDetailsMap = Maps.newHashMap();
        Set<String> feeBudgetCodes = budgetDetailsEntities.stream().map(TpmFeeBudgetDetailsEntity::getFeeBudgetCode).collect(Collectors.toSet());
        for (TpmFeeBudgetDetailsEntity o2 : budgetDetailsEntities) {
            feeBudgetCodes.add(o2.getFeeBudgetCode());
            List list1 = (List)budgetDetailsMap.get(o2.getBusinessCode() + o2.getBusinessLineCode());
            if (CollectionUtils.isEmpty((Collection)list1)) {
                list1 = Lists.newArrayList();
            }
            list1.add(o2);
            budgetDetailsMap.put(o2.getBusinessCode() + o2.getBusinessLineCode(), list1);
        }
        List<TpmFeeBudgetEntity> feeBudgetEntities = this.findFeeBudgetByCodes(feeBudgetCodes);
        HashSet controlIds = Sets.newHashSet();
        HashMap feeBudgetMap = Maps.newHashMap();
        for (TpmFeeBudgetEntity o3 : feeBudgetEntities) {
            controlIds.add(o3.getControlId());
            feeBudgetMap.put(o3.getFeeBudgetCode(), o3);
        }
        List<TpmFeeBudgetControlEntity> feeBudgetControls = this.findFeeBudgetControls(controlIds);
        Map<String, TpmFeeBudgetControlEntity> controlEntityMap = feeBudgetControls.stream().collect(Collectors.toMap(BaseIdEntity::getId, Function.identity()));
        return ActOperateFeeBudgetVo.builder().budgetDetailsMap(budgetDetailsMap).controlEntityMap(controlEntityMap).feeBudgetControls(feeBudgetControls).feeBudgetEntities(feeBudgetEntities).isRatio(isRatio).feeBudgetMap(feeBudgetMap).saveFeeBudgetCodes(Sets.newHashSet()).saveFeeBudgetControlIds(Sets.newHashSet()).saveFeeBudgetDetails(Lists.newArrayList()).build();
    }

    public void closedBatch(List<TpmActRespVo> list) {
        List<String> actCodes = list.stream().map(TpmActRespVo::getActCode).collect(Collectors.toList());
        List detailEntities = this.actDetailMapper.selectList((Wrapper)new LambdaQueryWrapper().in(TpmActDetailEntity::getActCode, actCodes));
        Map<String, List<TpmActDetailEntity>> actDetailMap = detailEntities.stream().collect(Collectors.groupingBy(TpmActDetailEntity::getActCode));
        ActOperateFeeBudgetVo operateFeeBudgetVo = this.setOperateFeeBudgetVo(detailEntities);
        operateFeeBudgetVo.setBusinessRemark(FeeBudgetRemarkEnum.ACT_RETURN_BUDGET.getDes());
        for (TpmActRespVo o : list) {
            if (!StringUtils.equals((CharSequence)GlobalWhetherEnum.NO.getCode(), (CharSequence)o.getIsAllAudit())) continue;
            List<TpmActDetailEntity> tpmActDetailEntities = actDetailMap.get(o.getActCode());
            operateFeeBudgetVo.setNeedRefundActDetails(tpmActDetailEntities);
            this.calculateRefundBudget(operateFeeBudgetVo);
        }
        operateFeeBudgetVo.setTypeEnum(FeeBudgetControlOperateTypeEnum.RETURN);
        this.actMapper.updateApprovedStatusByCodes(actCodes, ActApproveStatusEnum.CLOSED.getCode());
        this.saveFeeBudgetDataInfos(operateFeeBudgetVo);
    }

    private Boolean judgeIsNeedRefundBudget(Boolean isAuditRefund, TpmActDetailEntity entity) {
        if (Objects.nonNull(isAuditRefund) && isAuditRefund != false ? StringUtils.equals((CharSequence)GlobalWhetherEnum.YES.getCode(), (CharSequence)entity.getIsAllAudit()) && entity.getApplyAmount().compareTo(Optional.ofNullable(entity.getAuditAmount()).orElse(BigDecimal.ZERO)) == 1 : StringUtils.equals((CharSequence)GlobalWhetherEnum.NO.getCode(), (CharSequence)entity.getIsAllAudit()) && entity.getApplyAmount().compareTo(Optional.ofNullable(entity.getAuditAmount()).orElse(BigDecimal.ZERO)) == 1) {
            return true;
        }
        return false;
    }

    public ActOperateFeeBudgetVo calculateRefundBudget(ActOperateFeeBudgetVo operateFeeBudgetVo) {
        block0: for (TpmActDetailEntity p : operateFeeBudgetVo.getNeedRefundActDetails()) {
            if (!this.judgeIsNeedRefundBudget(operateFeeBudgetVo.getIsAuditRefund(), p).booleanValue()) continue;
            List<TpmFeeBudgetDetailsEntity> tpmFeeBudgetDetailsEntities = operateFeeBudgetVo.getBudgetDetailsMap().get(p.getActCode() + p.getActDetailCode()).stream().filter(o -> o.getFeeAmount().compareTo(BigDecimal.ZERO) != 0).sorted(Comparator.comparing(TpmFeeBudgetDetailsEntity::getReduceOrder).reversed()).collect(Collectors.toList());
            AtomicReference<BigDecimal> refundMoney = new AtomicReference<BigDecimal>(p.getApplyAmount().subtract(Optional.ofNullable(p.getAuditAmount()).orElse(BigDecimal.ZERO)));
            HashMap ratioCanRefundMoneyMap = Maps.newHashMap();
            if (operateFeeBudgetVo.getIsRatio().booleanValue()) {
                tpmFeeBudgetDetailsEntities.forEach(t -> {
                    String feebudgetTypeKey = this.getFeebudgetTypeKey(t.getFeeBudgetType(), t.getOrgType());
                    ratioCanRefundMoneyMap.put(feebudgetTypeKey, ((BigDecimal)refundMoney.get()).multiply(t.getReduceRatio()).divide(BigDecimal.valueOf(100L)));
                });
            }
            for (TpmFeeBudgetDetailsEntity r : tpmFeeBudgetDetailsEntities) {
                BigDecimal canRefundMoney = BigDecimal.ZERO;
                BigDecimal maxCanRefund = BigDecimal.ZERO;
                if (operateFeeBudgetVo.getIsRatio().booleanValue()) {
                    String feebudgetTypeKey = this.getFeebudgetTypeKey(r.getFeeBudgetType(), r.getOrgType());
                    maxCanRefund = (BigDecimal)ratioCanRefundMoneyMap.get(feebudgetTypeKey);
                    if (maxCanRefund.compareTo(BigDecimal.ZERO) == 0) continue;
                    if (maxCanRefund.compareTo(r.getFeeAmount().abs()) == 1) {
                        canRefundMoney = r.getFeeAmount().abs();
                        refundMoney.set(refundMoney.get().subtract(maxCanRefund));
                        ratioCanRefundMoneyMap.put(feebudgetTypeKey, maxCanRefund.subtract(r.getFeeAmount().abs()));
                    } else {
                        canRefundMoney = maxCanRefund;
                        ratioCanRefundMoneyMap.put(feebudgetTypeKey, BigDecimal.ZERO);
                    }
                } else {
                    if (refundMoney.get().compareTo(BigDecimal.ZERO) == 0) continue block0;
                    maxCanRefund = r.getFeeAmount().abs();
                    if (refundMoney.get().compareTo(maxCanRefund) == 1) {
                        canRefundMoney = maxCanRefund;
                        refundMoney.set(refundMoney.get().subtract(maxCanRefund));
                    } else {
                        canRefundMoney = refundMoney.get();
                        refundMoney.set(BigDecimal.ZERO);
                    }
                }
                TpmFeeBudgetEntity budgetEntity = operateFeeBudgetVo.getFeeBudgetMap().get(r.getFeeBudgetCode());
                operateFeeBudgetVo.getSaveFeeBudgetCodes().add(budgetEntity.getFeeBudgetCode());
                TpmFeeBudgetControlEntity budgetControlEntity = operateFeeBudgetVo.getControlEntityMap().get(budgetEntity.getControlId());
                operateFeeBudgetVo.getSaveFeeBudgetControlIds().add(budgetControlEntity.getId());
                budgetEntity.setCanUseAmount(budgetEntity.getCanUseAmount().add(canRefundMoney));
                budgetEntity.setUsedAmount(budgetEntity.getUsedAmount().subtract(canRefundMoney));
                budgetControlEntity.setCanUseAmount(budgetControlEntity.getCanUseAmount().add(canRefundMoney));
                TpmFeeBudgetDetailsEntity newBudgetDetailsEntity = new TpmFeeBudgetDetailsEntity();
                CrmBeanUtil.copyProperties((Object)((Object)r), (Object)((Object)newBudgetDetailsEntity));
                if (Objects.nonNull(operateFeeBudgetVo.getIsAuditRefund()) && operateFeeBudgetVo.getIsAuditRefund().booleanValue()) {
                    TpmAuditDetailEntity auditDetailEntity = operateFeeBudgetVo.getActDetailToAuditDetailMap().get(p.getActDetailCode());
                    newBudgetDetailsEntity.setBusinessCode(auditDetailEntity.getAuditCode());
                    newBudgetDetailsEntity.setBusinessLineCode(auditDetailEntity.getAuditDetailCode());
                }
                newBudgetDetailsEntity.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.RETURN_BACK.getCode());
                newBudgetDetailsEntity.setYear(budgetEntity.getBudgetYear());
                newBudgetDetailsEntity.setMonth(budgetEntity.getBudgetMonth());
                newBudgetDetailsEntity.setFeeBudgetDetailTypeName(FeeBudgetDetailTypeEnum.RETURN_BACK.getDes());
                newBudgetDetailsEntity.setFeeAmount(canRefundMoney);
                newBudgetDetailsEntity.setAfterAmount(budgetEntity.getCanUseAmount());
                newBudgetDetailsEntity.setBeforAmount(budgetEntity.getCanUseAmount().subtract(canRefundMoney));
                newBudgetDetailsEntity.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
                newBudgetDetailsEntity.setBusinessRemarks(operateFeeBudgetVo.getBusinessRemark());
                super.setPublicParamsNull((CrmBaseEntity)newBudgetDetailsEntity);
                operateFeeBudgetVo.getSaveFeeBudgetDetails().add(newBudgetDetailsEntity);
            }
        }
        return operateFeeBudgetVo;
    }

    public void saveFeeBudgetDataInfos(ActOperateFeeBudgetVo vo) {
        List needSaveBudgets = vo.getFeeBudgetEntities().stream().filter(o -> vo.getSaveFeeBudgetCodes().contains(o.getFeeBudgetCode())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(needSaveBudgets)) {
            this.feeBudgetService.updateBatchById(needSaveBudgets);
        }
        this.feeBudgetDetailsService.saveBatch(vo.getSaveFeeBudgetDetails());
        List<TpmFeeBudgetControlEntity> saveBudgetControls = vo.getFeeBudgetControls().stream().filter(o -> vo.getSaveFeeBudgetControlIds().contains(o.getId())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(saveBudgetControls)) {
            saveBudgetControls.forEach(o -> {
                OperateBudgetControlReqVo controlReqVo = OperateBudgetControlReqVo.builder().controlEntity((TpmFeeBudgetControlEntity)((Object)o)).typeEnum(vo.getTypeEnum()).build();
                this.budgetServiceHelper.saveFeeBudgetControlData(controlReqVo);
            });
        }
    }

    public List<TpmFeeBudgetEntity> findFeeBudgetByControlIds(Collection<String> controlIds) {
        List feeBudgetEntities = this.feeBudgetMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TpmFeeBudgetEntity::getControlId, controlIds)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode()));
        return feeBudgetEntities;
    }

    public TpmActEntity approveCheck(TpmActReqVo tpmActReqVo) {
        AssertUtils.isNotEmpty((String)tpmActReqVo.getId(), (String)"\u8bf7\u9009\u62e9\u60a8\u9700\u8981\u5173\u95ed\u7684\u6570\u636e");
        TpmActEntity tpmActEntity = (TpmActEntity)((Object)this.actMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(BaseIdEntity::getId, (Object)tpmActReqVo.getId())));
        Set canApproveStatus = ActApproveStatusEnum.getCanApproveStatus();
        AssertUtils.isTrue((boolean)canApproveStatus.contains(tpmActEntity.getApproveStatus()), (String)"\u4ec5\u72b6\u6001\u4e3a\u201c\u5f85\u63d0\u4ea4\u3001\u5ba1\u6279\u9a73\u56de\u3001\u6d41\u7a0b\u8ffd\u56de\u201d\u7684\u5355\u636e\u53ef\u63d0\u4ea4\u5ba1\u6279");
        return tpmActEntity;
    }

    public List<TpmCostTypeCategoriesEntity> findCategoriesEntitiesByCodes(Collection<String> categoriesCodes) {
        List tpmCostTypeCategoriesEntities = this.categoriesMapper.selectList((Wrapper)new LambdaQueryWrapper().in(TpmCostTypeCategoriesEntity::getCategoriesCode, categoriesCodes));
        if (CollectionUtils.isEmpty((Collection)tpmCostTypeCategoriesEntities) || CollectionUtils.size((Object)tpmCostTypeCategoriesEntities) != categoriesCodes.size()) {
            throw new BusinessException("\u6d3b\u52a8\u5927\u7c7b\u6570\u636e\u53d1\u751f\u53d8\u66f4,\u8bf7\u91cd\u65b0\u65b0\u5efa\u6d3b\u52a8");
        }
        return tpmCostTypeCategoriesEntities;
    }

    public List<TpmCostTypeFineEntity> findFineEntitiesByCodes(Collection<String> fineCodes) {
        List tpmCostTypeFineEntities = this.fineMapper.selectList((Wrapper)new LambdaQueryWrapper().in(TpmCostTypeFineEntity::getFineCode, fineCodes));
        if (CollectionUtils.isEmpty((Collection)tpmCostTypeFineEntities) || CollectionUtils.size((Object)tpmCostTypeFineEntities) != fineCodes.size()) {
            throw new BusinessException("\u7ec6\u7c7b\u6570\u636e\u53d1\u751f\u53d8\u66f4,\u8bf7\u91cd\u65b0\u65b0\u5efa\u6d3b\u52a8");
        }
        return tpmCostTypeFineEntities;
    }

    public List<TpmCostTypeCategoriesFineEntity> findCategoriesFineEntities(Collection<String> categoriesCodes, Collection<String> fineCodes) {
        List tpmCostTypeCategoriesFineEntities = this.categoriesFineMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TpmCostTypeCategoriesFineEntity::getCategoriesCode, categoriesCodes)).in(TpmCostTypeCategoriesFineEntity::getFineCode, fineCodes));
        return tpmCostTypeCategoriesFineEntities;
    }

    public void saveOrUpdateAct(TpmActEntity actEntity, TpmActReqVo reqVo) {
        if (ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())) {
            actEntity.setApproveStatus(ActApproveStatusEnum.APPROVING.getCode());
        } else {
            actEntity.setApproveStatus(ActApproveStatusEnum.CREATE.getCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)actEntity.getId())) {
            this.actMapper.updateById((Object)actEntity);
        } else {
            this.actMapper.insert((Object)actEntity);
        }
    }

    public void saveActBudgets(List<TpmActBudgetEntity> actBudgetEntities, TpmActReqVo reqVo) {
        if (ActSaveTypeEnum.getUpdateTypes().contains(reqVo.getSaveType())) {
            List list = actBudgetEntities.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getId())).map(BaseIdEntity::getId).collect(Collectors.toList());
            this.tpmActBudgetMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().notIn(CollectionUtils.isNotEmpty(list), BaseIdEntity::getId, list)).eq(TpmActBudgetEntity::getActCode, (Object)reqVo.getActCode()));
        }
        actBudgetEntities.forEach(o -> {
            if (StringUtils.isEmpty((CharSequence)o.getId())) {
                this.tpmActBudgetMapper.insert(o);
            } else {
                this.tpmActBudgetMapper.updateById(o);
            }
        });
    }

    public void saveActDetails(List<TpmActDetailEntity> actDetailEntities, TpmActReqVo reqVo) {
        if (ActSaveTypeEnum.getUpdateTypes().contains(reqVo.getSaveType())) {
            List list = actDetailEntities.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getId())).map(BaseIdEntity::getId).collect(Collectors.toList());
            this.actDetailMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().notIn(CollectionUtils.isNotEmpty(list), BaseIdEntity::getId, list)).eq(TpmActDetailEntity::getActCode, (Object)reqVo.getActCode()));
        }
        actDetailEntities.forEach(o -> {
            if (StringUtils.isEmpty((CharSequence)o.getId())) {
                this.actDetailMapper.insert(o);
            } else {
                this.actDetailMapper.updateById(o);
            }
        });
    }

    public void saveActShares(List<TmpActFeeShareEntity> shareEntities, TpmActReqVo reqVo) {
        if (CollectionUtils.isNotEmpty(shareEntities)) {
            if (ActSaveTypeEnum.getUpdateTypes().contains(reqVo.getSaveType())) {
                List list = shareEntities.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getId())).map(BaseIdEntity::getId).collect(Collectors.toList());
                this.actFeeShareMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().notIn(CollectionUtils.isNotEmpty(list), BaseIdEntity::getId, list)).eq(TmpActFeeShareEntity::getActCode, (Object)reqVo.getActCode()));
            }
            shareEntities.stream().forEach(o -> {
                if (StringUtils.isEmpty((CharSequence)o.getId())) {
                    this.actFeeShareMapper.insert(o);
                } else {
                    this.actFeeShareMapper.updateById(o);
                }
            });
        }
    }

    public void saveActFiles(List<TpmActFileEntity> fileEntities, TpmActReqVo reqVo) {
        if (ActSaveTypeEnum.getUpdateTypes().contains(reqVo.getSaveType())) {
            List list = fileEntities.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getId())).map(BaseIdEntity::getId).collect(Collectors.toList());
            this.actFileMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().notIn(CollectionUtils.isNotEmpty(list), BaseIdEntity::getId, list)).eq(TpmActFileEntity::getActCode, (Object)reqVo.getActCode()));
        }
        fileEntities.forEach(o -> {
            if (StringUtils.isEmpty((CharSequence)o.getId())) {
                this.actFileMapper.insert(o);
            } else {
                this.actFileMapper.updateById(o);
            }
        });
    }

    public void saveFeeBudgetDetails(List<TpmFeeBudgetDetailsEntity> feeBudgetDetailsEntities, TpmActReqVo reqVo) {
        if (!ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())) {
            return;
        }
        this.feeBudgetDetailsService.saveBatch(feeBudgetDetailsEntities);
    }

    public void saveFeeBudgets(List<TpmFeeBudgetEntity> feeBudgetEntities, TpmActReqVo reqVo) {
        if (!ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())) {
            return;
        }
        this.feeBudgetService.updateBatchById(feeBudgetEntities);
    }

    public void saveFeeBudgetControls(List<TpmFeeBudgetControlEntity> controlEntities, TpmActReqVo reqVo) {
        if (!ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())) {
            return;
        }
        for (TpmFeeBudgetControlEntity o : controlEntities) {
            OperateBudgetControlReqVo controlReqVo = OperateBudgetControlReqVo.builder().controlEntity(o).typeEnum(FeeBudgetControlOperateTypeEnum.USE).build();
            this.budgetServiceHelper.saveFeeBudgetControlData(controlReqVo);
        }
    }

    public Map<String, MdmOrgRespVo> findOrgByCodes(Set<String> orgCodes) {
        HashMap map = Maps.newHashMap();
        MdmOrgReqVo mdmOrgReqVo = new MdmOrgReqVo();
        mdmOrgReqVo.setOrgCodeList((Collection)Lists.newArrayList(orgCodes));
        List listResult = (List)this.orgFeign.listCondition(mdmOrgReqVo).getResult();
        if (CollectionUtils.isNotEmpty((Collection)listResult)) {
            listResult.forEach(o -> map.put(o.getOrgCode(), o));
        }
        return MapUtils.isNotEmpty((Map)map) ? map : Maps.newHashMap();
    }

    public Map<String, MdmCustomerMsgRespVo> findCustomerByCodes(Set<String> customerCodes) {
        HashMap map = Maps.newHashMap();
        MdmCustomerMsgReqVo mdmCustomerMsgReqVo = new MdmCustomerMsgReqVo();
        mdmCustomerMsgReqVo.setCustomerCodeList((List)Lists.newArrayList(customerCodes));
        List list = (List)this.customerFeign.findCustomerSelectList(mdmCustomerMsgReqVo).getResult();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(o -> map.put(o.getCustomerCode(), o));
        }
        return MapUtils.isNotEmpty((Map)map) ? map : Maps.newHashMap();
    }

    public List<TpmFeeBudgetControlEntity> findFeeBudgetControls(Set<String> controlIds) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(BaseIdEntity::getId, controlIds);
        List tpmFeeBudgetControlEntities = this.feeBudgetControlMapper.selectList((Wrapper)queryWrapper);
        return CollectionUtils.isEmpty((Collection)tpmFeeBudgetControlEntities) ? Lists.newArrayList() : tpmFeeBudgetControlEntities;
    }

    public void updateCheck(TpmActReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        TpmActEntity entity = (TpmActEntity)((Object)this.actMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(BaseIdEntity::getId, (Object)reqVo.getId())));
        AssertUtils.isNotNull((Object)((Object)entity), (CrmExceptionType)ActException.DATA_NOT_EXIST, (String[])new String[0]);
        if (!ActApproveStatusEnum.getCanUpdateStatus().contains(entity.getApproveStatus())) {
            throw new BusinessException("\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u4e0d\u5141\u8bb8\u4fee\u6539\u64cd\u4f5c");
        }
    }

    public Map<String, String> getPayTypesDict() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("pay_type_d");
        Map dictValueMapsByCodes = DictUtil.getDictValueMapsByCodes((List)dictCodes);
        Map map = Optional.ofNullable(dictValueMapsByCodes.get("pay_type_d")).orElse(Maps.newHashMap());
        return map;
    }

    public Map<String, String> getPayTypeTypeMap() {
        List dataList = DictUtil.list((String)"pay_type_d");
        return dataList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, v -> v.getExtendMap().get("pay_type_type") == null ? "" : (String)v.getExtendMap().get("pay_type_type")));
    }

    public TpmActEntity approvedCheck(TpmActReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        TpmActEntity entity = (TpmActEntity)((Object)this.actMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(BaseIdEntity::getId, (Object)reqVo.getId())));
        AssertUtils.isNotNull((Object)((Object)entity), (String)"\u5f53\u524d\u6d3b\u52a8\u6570\u636e\u4e0d\u5b58\u5728");
        if (!StringUtils.equals((CharSequence)ActApproveStatusEnum.APPROVING.getCode(), (CharSequence)entity.getApproveStatus())) {
            return null;
        }
        return entity;
    }

    public TpmActEntity rejectAndInterruptCheck(TpmActReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        TpmActEntity entity = (TpmActEntity)((Object)this.actMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(BaseIdEntity::getId, (Object)reqVo.getId())));
        if (!StringUtils.equals((CharSequence)ActApproveStatusEnum.APPROVING.getCode(), (CharSequence)entity.getApproveStatus())) {
            return null;
        }
        if (StringUtils.equals((CharSequence)ActSaveTypeEnum.REJECT.getCode(), (CharSequence)reqVo.getSaveType())) {
            entity.setApproveStatus(ActApproveStatusEnum.REJECTED.getCode());
        }
        if (StringUtils.equals((CharSequence)ActSaveTypeEnum.INTERRUPT.getCode(), (CharSequence)reqVo.getSaveType())) {
            entity.setApproveStatus(ActApproveStatusEnum.INTERRUPT.getCode());
        }
        return entity;
    }

    public List<TpmActDetailEntity> findDetailsByActCode(String actCode) {
        List tpmActDetailEntities = this.actDetailMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(TpmActDetailEntity::getActCode, (Object)actCode));
        return tpmActDetailEntities;
    }

    public Map<String, TpmCostTypeFineEntity> findFineMapByActDetails(Collection<String> fineCodes) {
        List<TpmCostTypeFineEntity> fineEntitiesByCodes = this.findFineEntitiesByCodes(fineCodes);
        if (CollectionUtils.isNotEmpty(fineEntitiesByCodes)) {
            Map<String, TpmCostTypeFineEntity> map = fineEntitiesByCodes.stream().collect(Collectors.toMap(TpmCostTypeFineEntity::getFineCode, Function.identity()));
            return map;
        }
        return Maps.newHashMap();
    }

    public void approved(TpmActReqVo reqVo) {
        TpmActEntity entity = this.approvedCheck(reqVo);
        if (Objects.isNull((Object)entity)) {
            return;
        }
        List<TpmActDetailEntity> details = this.findDetailsByActCode(entity.getActCode());
        HashSet fineCodes = Sets.newHashSet();
        for (TpmActDetailEntity o : details) {
            fineCodes.add(o.getFineCode());
        }
        Map<String, TpmCostTypeFineEntity> fineMap = this.findFineMapByActDetails(fineCodes);
        HashSet needAuditDetailCodes = Sets.newHashSet();
        for (TpmActDetailEntity o : details) {
            TpmCostTypeFineEntity fineEntity = fineMap.get(o.getFineCode());
            if (!Objects.nonNull(fineEntity.getAuditValidity())) continue;
            String date = "";
            try {
                date = DateUtil.formatAddMonth((String)entity.getEndDate(), (String)"yyyy-MM-dd", (int)fineEntity.getAuditValidity());
            }
            catch (ParseException e) {
                log.error("{}", (Throwable)e);
                throw new BusinessException("\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
            }
            o.setAllowAuditEndDate(date);
            o.setAllowAuditEndDateSecond("23:59:59");
            if (!StringUtils.equals((CharSequence)GlobalWhetherEnum.YES.getCode(), (CharSequence)fineEntity.getIsAudit()) || !StringUtils.equals((CharSequence)GlobalWhetherEnum.YES.getCode(), (CharSequence)fineEntity.getIsAutoAudit())) continue;
            needAuditDetailCodes.add(o.getActDetailCode());
            o.setIsAllAudit(GlobalWhetherEnum.YES.getCode());
            o.setAuditAmount(o.getApplyAmount());
        }
        entity.setApproveStatus(ActApproveStatusEnum.APPROVED.getCode());
        this.createAuditData(entity, details, needAuditDetailCodes);
        this.actMapper.updateById((Object)entity);
    }

    public void createAuditData(TpmActEntity entity, List<TpmActDetailEntity> needAuditList, Set<String> needAuditDetailCodes) {
        if (CollectionUtils.isNotEmpty(needAuditDetailCodes)) {
            entity.setIsAudit(GlobalWhetherEnum.YES.getCode());
            AtomicReference<BigDecimal> auditTotalAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            TpmAuditEntity auditEntity = new TpmAuditEntity();
            auditEntity.setAuditCode(CodeUtil.createOneCode((String)"tpm_audit"));
            auditEntity.setApproveStatus(ActApproveStatusEnum.APPROVED.getCode());
            auditEntity.setAuditName(entity.getActName() + "-\u81ea\u52a8\u6838\u9500");
            TpmAuditActEntity auditActEntity = new TpmAuditActEntity();
            CrmBeanUtil.copyProperties((Object)((Object)entity), (Object)((Object)auditActEntity));
            super.setPublicParamsNull((CrmBaseEntity)auditActEntity);
            auditActEntity.setAuditCode(auditEntity.getAuditCode());
            List auditDetails = needAuditList.stream().filter(o -> needAuditDetailCodes.contains(o.getActDetailCode())).map(o -> {
                auditTotalAmount.set(((BigDecimal)auditTotalAmount.get()).add(o.getApplyAmount()));
                TpmAuditDetailEntity detailEntity = new TpmAuditDetailEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)detailEntity));
                super.setPublicParamsNull((CrmBaseEntity)detailEntity);
                detailEntity.setAuditCode(auditEntity.getAuditCode());
                detailEntity.setActName(entity.getActName());
                detailEntity.setActDetailApplyAmount(o.getApplyAmount());
                detailEntity.setAlreadyAuditAmount(o.getApplyAmount());
                detailEntity.setIsAllAudit(GlobalWhetherEnum.YES.getCode());
                detailEntity.setAuditApplyAmount(o.getApplyAmount());
                detailEntity.setFeeUsed(BigDecimal.ZERO);
                detailEntity.setIsAllFeeUsed(GlobalWhetherEnum.NO.getCode());
                return detailEntity;
            }).collect(Collectors.toList());
            entity.setAuditTotalAmount(auditTotalAmount.get());
            if (entity.getTotalAmount().compareTo(auditTotalAmount.get()) == 0) {
                entity.setIsAllAudit(GlobalWhetherEnum.YES.getCode());
            } else {
                entity.setIsAllAudit(GlobalWhetherEnum.NO.getCode());
            }
            this.auditMapper.insert((Object)auditEntity);
            this.auditActMapper.insert((Object)auditActEntity);
            this.auditDetailService.saveBatch(auditDetails);
        }
        this.actDetailService.updateBatchById(needAuditList);
    }

    public void rejectAndInterrupt(TpmActReqVo reqVo) {
        TpmActEntity entity = this.rejectAndInterruptCheck(reqVo);
        if (Objects.isNull((Object)entity)) {
            return;
        }
        List<TpmActDetailEntity> details = this.findDetailsByActCode(entity.getActCode());
        HashSet detailCodes = Sets.newHashSet();
        for (TpmActDetailEntity o2 : details) {
            detailCodes.add(o2.getActDetailCode());
        }
        List budgetDetailsEntities = this.feeBudgetDetailsMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TpmFeeBudgetDetailsEntity.class).eq(TpmFeeBudgetDetailsEntity::getBusinessCode, (Object)entity.getActCode())).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
        HashSet feeBudgetCodes = Sets.newHashSet();
        for (TpmFeeBudgetDetailsEntity o3 : budgetDetailsEntities) {
            feeBudgetCodes.add(o3.getFeeBudgetCode());
        }
        List<TpmFeeBudgetEntity> feeBudgetEntities = this.findFeeBudgetByCodes(feeBudgetCodes);
        HashSet controlIds = Sets.newHashSet();
        HashMap budgetEntityMap = Maps.newHashMap();
        for (TpmFeeBudgetEntity o4 : feeBudgetEntities) {
            controlIds.add(o4.getControlId());
            budgetEntityMap.put(o4.getFeeBudgetCode(), o4);
        }
        List<TpmFeeBudgetControlEntity> feeBudgetControls = this.findFeeBudgetControls(controlIds);
        Map controlEntityMap = feeBudgetControls.stream().collect(Collectors.toMap(BaseIdEntity::getId, Function.identity()));
        ArrayList newBudgetDetailsEntities = Lists.newArrayList();
        for (TpmFeeBudgetDetailsEntity o5 : budgetDetailsEntities) {
            o5.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            if (o5.getFeeAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            TpmFeeBudgetEntity budgetEntity = (TpmFeeBudgetEntity)((Object)budgetEntityMap.get(o5.getFeeBudgetCode()));
            TpmFeeBudgetControlEntity controlEntity = (TpmFeeBudgetControlEntity)((Object)controlEntityMap.get(budgetEntity.getControlId()));
            TpmFeeBudgetDetailsEntity newDetail = new TpmFeeBudgetDetailsEntity();
            CrmBeanUtil.copyProperties((Object)((Object)o5), (Object)((Object)newDetail));
            super.setPublicParamsNull((CrmBaseEntity)newDetail);
            newDetail.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.RETURN_BACK.getCode());
            newDetail.setFeeBudgetDetailTypeName(FeeBudgetDetailTypeEnum.RETURN_BACK.getDes());
            newDetail.setFeeAmount(BigDecimal.ZERO.subtract(newDetail.getFeeAmount()));
            newDetail.setAfterAmount(budgetEntity.getCanUseAmount().add(newDetail.getFeeAmount()));
            newDetail.setBeforAmount(budgetEntity.getCanUseAmount());
            newDetail.setBusinessRemarks(FeeBudgetRemarkEnum.ACT_RETURN_BUDGET.getDes());
            budgetEntity.setCanUseAmount(budgetEntity.getCanUseAmount().add(newDetail.getFeeAmount()));
            budgetEntity.setUsedAmount(budgetEntity.getUsedAmount().subtract(newDetail.getFeeAmount()));
            controlEntity.setCanUseAmount(controlEntity.getCanUseAmount().add(newDetail.getFeeAmount()));
            newDetail.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            newBudgetDetailsEntities.add(newDetail);
        }
        feeBudgetControls.forEach(o -> {
            OperateBudgetControlReqVo controlReqVo = OperateBudgetControlReqVo.builder().controlEntity((TpmFeeBudgetControlEntity)((Object)o)).typeEnum(FeeBudgetControlOperateTypeEnum.RETURN).build();
            this.budgetServiceHelper.saveFeeBudgetControlData(controlReqVo);
        });
        this.feeBudgetDetailsService.saveBatch(newBudgetDetailsEntities);
        this.feeBudgetDetailsService.updateBatchById(budgetDetailsEntities);
        this.feeBudgetService.updateBatchById(feeBudgetEntities);
        this.actMapper.updateById((Object)entity);
    }

    public List<TpmFeeBudgetEntity> findFeeBudgetByCodes(Collection<String> feeBudgetCodes) {
        List feeBudgetEntities = this.feeBudgetMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TpmFeeBudgetEntity.class).in(TpmFeeBudgetEntity::getFeeBudgetCode, feeBudgetCodes)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode()));
        return feeBudgetEntities;
    }

    public String getFeebudgetTypeKey(String feeBudgetType, String orgType) {
        String mapKey = StringUtils.equals((CharSequence)FeeBudgetTypeEnum.DEPARTMENT.getCode(), (CharSequence)feeBudgetType) ? feeBudgetType + orgType : feeBudgetType;
        return mapKey;
    }

    public List<String> getActivityReleaseNeedsByActType(String actType) {
        ArrayList list = Lists.newArrayList();
        if (StringUtils.equals((CharSequence)actType, (CharSequence)ActTypeEnum.STABLE_CHARGE.getCode())) {
            list.add(ActivityReleaseNeedEnum.CUSTOMER.getCode());
            list.add(ActivityReleaseNeedEnum.TERMINAL.getCode());
        }
        if (StringUtils.equals((CharSequence)actType, (CharSequence)ActTypeEnum.DEPARTMENT_CHARGE.getCode())) {
            list.add(ActivityReleaseNeedEnum.DEPARTMENT.getCode());
        }
        if (StringUtils.equals((CharSequence)actType, (CharSequence)ActTypeEnum.PROJECT.getCode())) {
            // empty if block
        }
        if (StringUtils.equals((CharSequence)actType, (CharSequence)ActTypeEnum.DEPARTMENT_RECEIVE.getCode())) {
            list.add(ActivityReleaseNeedEnum.DEPARTMENT.getCode());
        }
        if (StringUtils.equals((CharSequence)actType, (CharSequence)ActTypeEnum.PRACTICALITY_CHARGE.getCode())) {
            list.add(ActivityReleaseNeedEnum.CUSTOMER.getCode());
            list.add(ActivityReleaseNeedEnum.TERMINAL.getCode());
        }
        return list;
    }
}

