/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.account.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.account.mapper.TpmAccountDetailMapper;
import com.biz.crm.account.mapper.TpmAccountInvoiceMapper;
import com.biz.crm.account.mapper.TpmAccountProductMapper;
import com.biz.crm.account.model.TpmAccountDetailEntity;
import com.biz.crm.account.model.TpmAccountInvoiceEntity;
import com.biz.crm.account.model.TpmAccountProductEntity;
import com.biz.crm.account.service.ITpmAccountDetailService;
import com.biz.crm.account.service.ITpmAccountInvoiceService;
import com.biz.crm.account.service.ITpmAccountProductService;
import com.biz.crm.account.service.impl.AccountServiceHelper;
import com.biz.crm.audit.mapper.TpmAuditDetailMapper;
import com.biz.crm.audit.model.TpmAuditDetailEntity;
import com.biz.crm.audit.service.ITpmAuditDetailService;
import com.biz.crm.audit.service.ITpmAuditService;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.costtypefine.mapper.TpmCostTypeFineMapper;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.AccountStatusEnum;
import com.biz.crm.eunm.tpm.ActPayTypeEnum;
import com.biz.crm.eunm.tpm.ActPayTypeTypeEnum;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.AccountException;
import com.biz.crm.nebular.tpm.account.req.TpmAccountDetailMainReqVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountDetailReqVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountInvoiceReqVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountProductReqVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountUpdatePayTypeReqVo;
import com.biz.crm.nebular.tpm.account.req.TpmPayTypeByTypeAndFineVo;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountDetailMainRespVo;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountDetailRespVo;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountInvoiceRespVo;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountProductRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.UUIDGenerator;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmAccountDetailServiceExpandImpl"})
public class TpmAccountDetailServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmAccountDetailMapper, TpmAccountDetailEntity>
implements ITpmAccountDetailService {
    private static final Logger log = LoggerFactory.getLogger(TpmAccountDetailServiceImpl.class);
    @Resource
    private TpmAccountDetailMapper tpmAccountDetailMapper;
    @Autowired
    private AccountServiceHelper accountServiceHelper;
    @Resource
    private TpmAccountProductMapper tpmAccountProductMapper;
    @Resource
    private TpmAccountInvoiceMapper tpmAccountInvoiceMapper;
    @Resource
    private TpmCostTypeFineMapper tpmCostTypeFineMapper;
    @Autowired
    private ITpmAuditService iTpmAuditService;
    @Autowired
    private ITpmAccountProductService accountProductService;
    @Autowired
    private ITpmAccountInvoiceService accountInvoiceService;
    @Resource
    private TpmAuditDetailMapper auditDetailMapper;
    @Autowired
    private ITpmAuditDetailService auditDetailService;

    @Override
    public PageResult<TpmAccountDetailRespVo> findList(TpmAccountDetailReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<TpmAccountDetailRespVo> list = this.tpmAccountDetailMapper.findList((Page<TpmAccountDetailRespVo>)page, reqVo);
        this.accountServiceHelper.convertListDate(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmAccountDetailMainRespVo queryView(String id) {
        TpmAccountDetailMainRespVo resultVo = new TpmAccountDetailMainRespVo();
        AssertUtils.isNotEmpty((String)id, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
        TpmAccountDetailEntity accountDetailEntity = (TpmAccountDetailEntity)((Object)this.tpmAccountDetailMapper.selectById((Serializable)((Object)id)));
        AssertUtils.isNotNull((Object)((Object)accountDetailEntity), (CrmExceptionType)AccountException.DATA_NOT_EXIST, (String[])new String[0]);
        TpmAccountDetailReqVo reqVo = new TpmAccountDetailReqVo();
        reqVo.setGroupId(accountDetailEntity.getGroupId());
        reqVo.setPageSize(Integer.valueOf(-1));
        List detailRespVos = this.findList(reqVo).getData();
        resultVo.setAccountDetailRespVos(detailRespVos);
        this.setProductInfo(resultVo);
        this.setInvoiceInfo(resultVo);
        return resultVo;
    }

    private void setInvoiceInfo(TpmAccountDetailMainRespVo resultVo) {
        List tpmAccountInvoiceEntities = this.tpmAccountInvoiceMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmAccountInvoiceEntity::getGroupId, (Object)((TpmAccountDetailRespVo)resultVo.getAccountDetailRespVos().get(0)).getGroupId()));
        if (CollectionUtils.isNotEmpty((Collection)tpmAccountInvoiceEntities)) {
            List invoiceRespVos = tpmAccountInvoiceEntities.stream().map(o -> {
                TpmAccountInvoiceRespVo vo = (TpmAccountInvoiceRespVo)CrmBeanUtil.copy((Object)o, TpmAccountInvoiceRespVo.class);
                vo.setAccountCodeList(JSON.parseArray((String)o.getAccountCodes(), String.class));
                vo.setAccountCodes(StringUtils.join((Object[])new String[]{vo.getAccountCodes(), ","}));
                return vo;
            }).collect(Collectors.toList());
            resultVo.setAccountInvoiceRespVos(invoiceRespVos);
        }
    }

    private void setProductInfo(TpmAccountDetailMainRespVo resultVo) {
        List productEntities = this.tpmAccountProductMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmAccountProductEntity::getGroupId, (Object)resultVo.getGroupId()));
        if (CollectionUtils.isNotEmpty((Collection)productEntities)) {
            Map<String, List<TpmAccountProductEntity>> accountProductMap = productEntities.stream().collect(Collectors.groupingBy(TpmAccountProductEntity::getAccountCode));
            for (TpmAccountDetailRespVo detailRespVo : resultVo.getAccountDetailRespVos()) {
                List<TpmAccountProductEntity> entities = accountProductMap.get(detailRespVo.getAccountCode());
                List tpmAccountProductRespVos = CrmBeanUtil.copyList(entities, TpmAccountProductRespVo.class);
                detailRespVo.setAccountProductRespVos(tpmAccountProductRespVos);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TpmAccountDetailMainReqVo accountDetailMainReqVo) {
        this.accountServiceHelper.saveCheck(accountDetailMainReqVo);
        List accountDetailReqVos = accountDetailMainReqVo.getAccountDetailReqVos();
        String groupId = UUIDGenerator.generate();
        accountDetailReqVos.forEach(tpmAccountDetailReqVo -> {
            List tpmProductInfoReqVos = tpmAccountDetailReqVo.getTpmProductInfoReqVos();
            if (CollectionUtils.isNotEmpty((Collection)tpmProductInfoReqVos)) {
                String productNames = tpmProductInfoReqVos.stream().map(TpmAccountProductReqVo::getProductName).collect(Collectors.joining(","));
                tpmAccountDetailReqVo.setProductNames(productNames);
            }
            tpmAccountDetailReqVo.setGroupId(groupId);
        });
        List accountInvoiceReqVos = accountDetailMainReqVo.getAccountInvoiceReqVos();
        List accountDetailEntities = CrmBeanUtil.copyList((List)accountDetailReqVos, TpmAccountDetailEntity.class);
        this.saveBatch(accountDetailEntities);
        this.saveProductInfo(accountDetailMainReqVo.getNeedSaveProductList(), groupId);
        this.saveInvoice(accountInvoiceReqVos, groupId);
        this.updateAuditDetails(accountDetailMainReqVo.getSaveType(), accountDetailEntities);
    }

    public void updateAuditDetails(String saveType, List<TpmAccountDetailEntity> accountDetailEntities) {
        if (StringUtils.equals((CharSequence)AccountStatusEnum.SUBMIT.getCode(), (CharSequence)saveType)) {
            HashMap map = Maps.newHashMap();
            ArrayList auditDetailCodes = Lists.newArrayList();
            accountDetailEntities.stream().forEach(o -> {
                map.put(o.getAuditDetailCode(), o);
                auditDetailCodes.add(o.getAuditDetailCode());
            });
            List tpmAuditDetailEntities = this.auditDetailMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmAuditDetailEntity.class).in(TpmAuditDetailEntity::getAuditDetailCode, (Collection)auditDetailCodes));
            tpmAuditDetailEntities.forEach(o -> {
                TpmAccountDetailEntity tpmAccountDetailEntity = (TpmAccountDetailEntity)((Object)((Object)map.get(o.getAuditDetailCode())));
                BigDecimal add = tpmAccountDetailEntity.getAccountAmount().add(Optional.ofNullable(o.getFeeUsed()).orElse(BigDecimal.ZERO));
                if (o.getAuditApplyAmount().compareTo(add) == 1) {
                    o.setIsAllFeeUsed(GlobalWhetherEnum.NO.getCode());
                } else {
                    o.setIsAllFeeUsed(GlobalWhetherEnum.YES.getCode());
                }
                o.setFeeUsed(add);
            });
            this.auditDetailService.updateBatchById(tpmAuditDetailEntities);
        }
    }

    private void saveProductInfo(List<TpmAccountProductReqVo> needSaveProductList, String groupId) {
        if (CollectionUtils.isNotEmpty(needSaveProductList)) {
            List ids = needSaveProductList.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getId())).map(UuidVo::getId).collect(Collectors.toList());
            this.tpmAccountProductMapper.delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TpmAccountProductEntity.class).eq(TpmAccountProductEntity::getGroupId, (Object)groupId)).notIn(CollectionUtils.isNotEmpty(ids), BaseIdEntity::getId, ids));
            List productEntities = needSaveProductList.stream().map(o -> {
                TpmAccountProductEntity productEntity = (TpmAccountProductEntity)((Object)((Object)CrmBeanUtil.copy((Object)o, TpmAccountProductEntity.class)));
                productEntity.setGroupId(groupId);
                return productEntity;
            }).collect(Collectors.toList());
            this.accountProductService.saveOrUpdateBatch(productEntities);
        } else {
            this.tpmAccountProductMapper.delete((Wrapper)Wrappers.lambdaQuery(TpmAccountProductEntity.class).eq(TpmAccountProductEntity::getGroupId, (Object)groupId));
        }
    }

    private void saveInvoice(List<TpmAccountInvoiceReqVo> accountInvoiceReqVos, String groupId) {
        if (CollectionUtils.isNotEmpty(accountInvoiceReqVos)) {
            List ids = accountInvoiceReqVos.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getId())).map(UuidVo::getId).collect(Collectors.toList());
            this.tpmAccountInvoiceMapper.delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TpmAccountInvoiceEntity.class).eq(TpmAccountInvoiceEntity::getGroupId, (Object)groupId)).notIn(CollectionUtils.isNotEmpty(ids), BaseIdEntity::getId, ids));
            List entities = accountInvoiceReqVos.stream().map(o -> {
                TpmAccountInvoiceEntity entity = (TpmAccountInvoiceEntity)((Object)((Object)CrmBeanUtil.copy((Object)o, TpmAccountInvoiceEntity.class)));
                entity.setGroupId(groupId);
                return entity;
            }).collect(Collectors.toList());
            this.accountInvoiceService.saveOrUpdateBatch(entities);
        } else {
            this.tpmAccountInvoiceMapper.delete((Wrapper)Wrappers.lambdaQuery(TpmAccountInvoiceEntity.class).eq(TpmAccountInvoiceEntity::getGroupId, (Object)groupId));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TpmAccountDetailMainReqVo accountDetailMainReqVo) {
        String groupId = accountDetailMainReqVo.getGroupId();
        AssertUtils.isNotEmpty((String)groupId, (String)"\u5206\u7ec4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.accountServiceHelper.saveCheck(accountDetailMainReqVo);
        List accountDetailReqVos = accountDetailMainReqVo.getAccountDetailReqVos();
        List accountInvoiceReqVos = accountDetailMainReqVo.getAccountInvoiceReqVos();
        List accountDetailIds = accountDetailReqVos.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getId())).map(UuidVo::getId).collect(Collectors.toList());
        this.tpmAccountDetailMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmAccountDetailEntity::getGroupId, (Object)groupId)).notIn(CollectionUtils.isNotEmpty(accountDetailIds), BaseIdEntity::getId, accountDetailIds));
        List accountDetailEntities = CrmBeanUtil.copyList((List)accountDetailReqVos, TpmAccountDetailEntity.class);
        this.saveOrUpdateBatch(accountDetailEntities);
        this.saveProductInfo(accountDetailMainReqVo.getNeedSaveProductList(), groupId);
        this.saveInvoice(accountInvoiceReqVos, groupId);
        this.updateAuditDetails(accountDetailMainReqVo.getSaveType(), accountDetailEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List accountDetailEntities = this.tpmAccountDetailMapper.selectBatchIds(ids);
        if (CollectionUtils.isEmpty((Collection)accountDetailEntities)) {
            return;
        }
        ArrayList accountCodes = Lists.newArrayList();
        HashSet groupIds = Sets.newHashSet();
        accountDetailEntities.forEach(o -> {
            AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)o.getApproveStatus(), (CharSequence)AccountStatusEnum.TEMP.getCode()), (String)"\u53ea\u6709\u6682\u5b58\u72b6\u6001\u7684\u6570\u636e\u5141\u8bb8\u5220\u9664");
            accountCodes.add(o.getAccountCode());
            groupIds.add(o.getGroupId());
        });
        this.tpmAccountDetailMapper.deleteBatchByIds(ids);
        this.tpmAccountProductMapper.delete((Wrapper)Wrappers.lambdaQuery(TpmAccountProductEntity.class).in(TpmAccountProductEntity::getAccountCode, (Collection)accountCodes));
        List invoiceEntities = this.tpmAccountInvoiceMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmAccountInvoiceEntity.class).in(TpmAccountInvoiceEntity::getGroupId, (Collection)groupIds));
        if (CollectionUtils.isNotEmpty((Collection)invoiceEntities)) {
            ArrayList needDeleteInvoiceIds = Lists.newArrayList();
            ArrayList needUpdateInvoices = Lists.newArrayList();
            invoiceEntities.stream().forEach(o -> {
                List codes = JSON.parseArray((String)o.getAccountCodes(), String.class);
                codes.removeAll(accountCodes);
                if (CollectionUtils.isEmpty((Collection)codes)) {
                    needDeleteInvoiceIds.add(o.getId());
                } else if (codes.size() != JSON.parseArray((String)o.getAccountCodes(), String.class).size()) {
                    o.setAccountCodes(JSON.toJSONString((Object)codes));
                    needUpdateInvoices.add(o);
                }
            });
            if (CollectionUtils.isNotEmpty((Collection)needDeleteInvoiceIds)) {
                this.tpmAccountInvoiceMapper.delete((Wrapper)Wrappers.lambdaQuery(TpmAccountInvoiceEntity.class).in(BaseIdEntity::getId, (Collection)needDeleteInvoiceIds));
            }
            if (CollectionUtils.isNotEmpty((Collection)needUpdateInvoices)) {
                this.accountInvoiceService.updateBatchById(needUpdateInvoices);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        List tpmAccountDetailEntities = this.tpmAccountDetailMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)tpmAccountDetailEntities)) {
            tpmAccountDetailEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmAccountDetailEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        List tpmAccountDetailEntities = this.tpmAccountDetailMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)tpmAccountDetailEntities)) {
            tpmAccountDetailEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmAccountDetailEntities);
    }

    @Override
    public void batchUpdatePayType(TpmAccountUpdatePayTypeReqVo updatePayTypeReqVo) {
        this.accountServiceHelper.batchUpdatePayTypeCheck(updatePayTypeReqVo);
        List ids = updatePayTypeReqVo.getIds();
        ids.forEach(id -> {
            TpmAccountDetailEntity tpmAccountDetailEntity = new TpmAccountDetailEntity();
            tpmAccountDetailEntity.setPayType(updatePayTypeReqVo.getPayType());
            tpmAccountDetailEntity.setPayTypeName(updatePayTypeReqVo.getPayTypeName());
            tpmAccountDetailEntity.setId((String)id);
            this.tpmAccountDetailMapper.updateById((Object)tpmAccountDetailEntity);
        });
    }

    @Override
    public List<DictItemVo> payTypeByTypeAndFine(TpmPayTypeByTypeAndFineVo typeAndFineVo) {
        AssertUtils.isNotEmpty((String)typeAndFineVo.getPayTypeType(), (String)"\u652f\u4ed8\u65b9\u5f0f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((Collection)typeAndFineVo.getFineCodes(), (String)"\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        Set collect = typeAndFineVo.getFineCodes().stream().collect(Collectors.toSet());
        List tpmCostTypeFineEntities = this.tpmCostTypeFineMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(TpmCostTypeFineEntity::getFineCode, collect));
        Set payTypeSet = Sets.newConcurrentHashSet();
        if (CollectionUtil.listNotEmpty((List)tpmCostTypeFineEntities)) {
            Map<String, String> map = this.iTpmAuditService.queryDictValueMap();
            List payTypeCodes = JSON.parseArray((String)((TpmCostTypeFineEntity)((Object)tpmCostTypeFineEntities.get(0))).getPayTypeList(), String.class);
            for (TpmCostTypeFineEntity tpmCostTypeFineEntity : tpmCostTypeFineEntities) {
                String payTypeList = tpmCostTypeFineEntity.getPayTypeList();
                List strings = JSON.parseArray((String)payTypeList, String.class);
                payTypeCodes.retainAll(strings);
            }
            List<DictItemVo> payTypes = this.iTpmAuditService.getPayTypes(JSON.toJSONString((Object)payTypeCodes), map);
            payTypeSet.addAll(payTypes);
        }
        if (CollectionUtils.isEmpty((Collection)payTypeSet)) {
            return Lists.newArrayList();
        }
        return this.payTypeByType(typeAndFineVo.getPayTypeType(), payTypeSet);
    }

    public List<DictItemVo> payTypeByType(String payTypeType, Set<DictItemVo> payTypeSet) {
        List<Object> resultList;
        if (StringUtils.equals((CharSequence)ActPayTypeTypeEnum.NEED_INVOICE.getCode(), (CharSequence)payTypeType)) {
            resultList = payTypeSet.stream().filter(o -> StringUtils.equals((CharSequence)o.getDictValue(), (CharSequence)ActPayTypeEnum.CASH.getCode()) || StringUtils.equals((CharSequence)o.getDictValue(), (CharSequence)ActPayTypeEnum.FORWARD_PAYMENT.getCode()) || StringUtils.equals((CharSequence)o.getDictValue(), (CharSequence)ActPayTypeEnum.ACCOUNT_DEDUCTION.getCode())).collect(Collectors.toList());
        } else if (StringUtils.equals((CharSequence)ActPayTypeTypeEnum.DEFAULT_FEE_POOL.getCode(), (CharSequence)payTypeType)) {
            resultList = payTypeSet.stream().filter(o -> StringUtils.equals((CharSequence)o.getDictValue(), (CharSequence)ActPayTypeEnum.REPLENISHMENT.getCode()) || StringUtils.equals((CharSequence)o.getDictValue(), (CharSequence)ActPayTypeEnum.DISCOUNT.getCode()) || StringUtils.equals((CharSequence)o.getDictValue(), (CharSequence)ActPayTypeEnum.TICKET_DISCOUNT.getCode())).collect(Collectors.toList());
        } else {
            throw new BusinessException("\u652f\u4ed8\u65b9\u5f0f\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        return resultList;
    }
}

