/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.fiscalyear.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.fiscalyear.mapper.TpmFiscalYearSettingMapper;
import com.biz.crm.fiscalyear.model.TpmFiscalYearSettingEntity;
import com.biz.crm.nebular.tpm.fiscalyear.req.TpmFiscalYearSettingReqVo;
import com.biz.crm.nebular.tpm.fiscalyear.resp.TpmFiscalYearSettingRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.DictUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FiscalYearSettingServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(FiscalYearSettingServiceHelper.class);
    @Resource
    private TpmFiscalYearSettingMapper mapper;

    public Map<String, Map<String, String>> getDicts() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("enable_status");
        dictCodes.add("fiscal_month");
        dictCodes.add("fiscal_quater");
        dictCodes.add("fiscal_year");
        return DictUtil.getDictValueMapsByCodes((List)dictCodes);
    }

    public void convertListDate(List<TpmFiscalYearSettingRespVo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Map<String, Map<String, String>> map = this.getDicts();
            list.forEach(o -> {
                if (StringUtils.isNotEmpty((CharSequence)o.getEnableStatus())) {
                    o.setEnableStatusName((String)((Map)Optional.ofNullable(map.get("enable_status")).orElse(Maps.newHashMap())).get(o.getEnableStatus()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getYear())) {
                    o.setYearName((String)((Map)Optional.ofNullable(map.get("fiscal_year")).orElse(Maps.newHashMap())).get(o.getYear()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getMonth())) {
                    o.setMonthName((String)((Map)Optional.ofNullable(map.get("fiscal_month")).orElse(Maps.newHashMap())).get(o.getMonth()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getQuater())) {
                    o.setQuaterName((String)((Map)Optional.ofNullable(map.get("fiscal_quater")).orElse(Maps.newHashMap())).get(o.getQuater()));
                }
            });
        }
    }

    public LambdaQueryWrapper<TpmFiscalYearSettingEntity> getQueryWrapper(TpmFiscalYearSettingReqVo reqVo) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(StringUtils.isNotEmpty((CharSequence)reqVo.getYear()), TpmFiscalYearSettingEntity::getYear, (Object)reqVo.getYear());
        wrapper.eq(StringUtils.isNotEmpty((CharSequence)reqVo.getQuater()), TpmFiscalYearSettingEntity::getQuater, (Object)reqVo.getQuater());
        wrapper.eq(StringUtils.isNotEmpty((CharSequence)reqVo.getMonth()), TpmFiscalYearSettingEntity::getMonth, (Object)reqVo.getMonth());
        wrapper.eq(StringUtils.isNotEmpty((CharSequence)reqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)reqVo.getEnableStatus());
        return wrapper;
    }

    public void updateBySelectAll(TpmFiscalYearSettingReqVo reqVo, TpmFiscalYearSettingEntity entity) {
        LambdaQueryWrapper<TpmFiscalYearSettingEntity> productQueryWrapper = this.getQueryWrapper(reqVo);
        this.mapper.update((Object)entity, (Wrapper)productQueryWrapper);
    }

    public void saveCheck(TpmFiscalYearSettingReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getMonth(), (String)"\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getYear(), (String)"\u9884\u7b97\u8d22\u5e74\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getQuater(), (String)"\u5b63\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getBeginDate(), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getEndDate(), (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isEmpty((CharSequence)reqVo.getEndDateSecond())) {
            reqVo.setEndDateSecond("23:59:59");
        }
        if (StringUtils.isEmpty((CharSequence)reqVo.getBeginDateSecond())) {
            reqVo.setBeginDateSecond("00:00:00");
        }
        AssertUtils.isTrue((StringUtils.compare((String)(reqVo.getBeginDate() + reqVo.getBeginDateSecond()), (String)(reqVo.getEndDate() + reqVo.getEndDateSecond())) < 0 ? 1 : 0) != 0, (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
        this.checkDataExist(reqVo);
    }

    public void checkDataExist(TpmFiscalYearSettingReqVo reqVo) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmFiscalYearSettingEntity::getYear, (Object)reqVo.getYear())).eq(TpmFiscalYearSettingEntity::getQuater, (Object)reqVo.getQuater())).eq(TpmFiscalYearSettingEntity::getMonth, (Object)reqVo.getMonth());
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            wrapper.ne(BaseIdEntity::getId, (Object)reqVo.getId());
        }
        List list = this.mapper.selectList((Wrapper)wrapper);
        AssertUtils.isTrue((boolean)CollectionUtils.isEmpty((Collection)list), (String)"\u9884\u7b97\u8d22\u5e74+\u6708\u5ea6\u6570\u636e\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u586b\u5199");
        List allList = this.mapper.selectList((Wrapper)new LambdaQueryWrapper().ne(StringUtils.isNotEmpty((CharSequence)reqVo.getId()), BaseIdEntity::getId, (Object)reqVo.getId()));
        if (CollectionUtils.isNotEmpty((Collection)allList)) {
            String nowBeginDateStr = reqVo.getBeginDate() + reqVo.getBeginDateSecond();
            String nowEndDateStr = reqVo.getEndDate() + reqVo.getEndDateSecond();
            for (TpmFiscalYearSettingEntity o : allList) {
                String oldBeginDateStr = o.getBeginDate() + o.getBeginDateSecond();
                String oldEndDateStr = o.getEndDate() + o.getEndDateSecond();
                Boolean flag = false;
                if (StringUtils.compare((String)nowBeginDateStr, (String)oldBeginDateStr) >= 0 && StringUtils.compare((String)nowBeginDateStr, (String)oldEndDateStr) <= 0) {
                    flag = true;
                }
                if (StringUtils.compare((String)nowEndDateStr, (String)oldBeginDateStr) >= 0 && StringUtils.compare((String)nowEndDateStr, (String)oldEndDateStr) <= 0) {
                    flag = true;
                }
                if (StringUtils.compare((String)nowBeginDateStr, (String)oldBeginDateStr) < 0 && StringUtils.compare((String)nowEndDateStr, (String)oldEndDateStr) > 0) {
                    flag = true;
                }
                if (!flag.booleanValue()) continue;
                throw new BusinessException("\u5f00\u59cb\u65f6\u95f4+\u7ed3\u675f\u65f6\u95f4\u5df2\u5b58\u5728\u9884\u7b97\u8d22\u5e74\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u586b\u5199");
            }
        }
    }
}

