/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.advancepay.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.advancepay.mapper.TpmActAdvancePayDetailMapper;
import com.biz.crm.advancepay.mapper.TpmActAdvancePayMapper;
import com.biz.crm.advancepay.model.TpmActAdvancePayDetailEntity;
import com.biz.crm.advancepay.model.TpmActAdvancePayEntity;
import com.biz.crm.advancepay.service.ITpmActAdvancePayDetailService;
import com.biz.crm.advancepay.service.ITpmActAdvancePayService;
import com.biz.crm.advancepay.service.impl.ActAdvancePayServiceHelper;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.tpm.ActAdvancePayApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActSaveTypeEnum;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.ActAdvancePayException;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.common.ProcessCommonVo;
import com.biz.crm.nebular.tpm.advancepay.req.TpmActAdvancePayDetailReqVo;
import com.biz.crm.nebular.tpm.advancepay.req.TpmActAdvancePayReqVo;
import com.biz.crm.nebular.tpm.advancepay.resp.TpmActAdvancePayRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.Result;
import com.bizunited.platform.common.vo.UuidVo;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmActAdvancePayServiceExpandImpl"})
public class TpmActAdvancePayServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmActAdvancePayMapper, TpmActAdvancePayEntity>
implements ITpmActAdvancePayService {
    private static final Logger log = LoggerFactory.getLogger(TpmActAdvancePayServiceImpl.class);
    @Resource
    private TpmActAdvancePayMapper tpmActAdvancePayMapper;
    @Autowired
    private ActAdvancePayServiceHelper serviceHelper;
    @Resource
    private TpmActAdvancePayDetailMapper detailMapper;
    @Autowired
    private ITpmActAdvancePayDetailService detailService;
    @Autowired
    private TaActBaseFeign activityFeign;

    @Override
    public PageResult<TpmActAdvancePayRespVo> findList(TpmActAdvancePayReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<TpmActAdvancePayRespVo> list = this.tpmActAdvancePayMapper.findList((Page<TpmActAdvancePayRespVo>)page, reqVo);
        this.serviceHelper.convertListDate(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmActAdvancePayRespVo query(String id) {
        TpmActAdvancePayReqVo tpmActAdvancePayReqVo = new TpmActAdvancePayReqVo();
        tpmActAdvancePayReqVo.setId(id);
        List data = this.findList(tpmActAdvancePayReqVo).getData();
        if (CollectionUtils.isEmpty((Collection)data)) {
            return new TpmActAdvancePayRespVo();
        }
        TpmActAdvancePayRespVo respVo = (TpmActAdvancePayRespVo)data.get(0);
        TpmActAdvancePayDetailReqVo detailReqVo = new TpmActAdvancePayDetailReqVo();
        detailReqVo.setPageSize(Integer.valueOf(-1));
        detailReqVo.setAdvanceCode(respVo.getAdvanceCode());
        List detailRespVos = this.detailService.findList(detailReqVo).getData();
        respVo.setDetailVos(detailRespVos);
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TpmActAdvancePayReqVo reqVo) {
        this.serviceHelper.saveCheck(reqVo);
        AssertUtils.isTrue((boolean)ActSaveTypeEnum.getCreateTypes().contains(reqVo.getSaveType()), (String)"\u4fdd\u5b58\u7c7b\u578b\u503c\u9519\u8bef");
        TpmActAdvancePayEntity entity = (TpmActAdvancePayEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmActAdvancePayEntity.class));
        this.save((Object)entity);
        List detailVos = reqVo.getDetailVos();
        List<TpmActAdvancePayDetailEntity> payDetailEntities = this.convertDetails(detailVos);
        this.detailService.saveBatch(payDetailEntities);
        this.sendToActivity(entity, reqVo);
    }

    public void sendToActivity(TpmActAdvancePayEntity entity, TpmActAdvancePayReqVo reqVo) {
        if (StringUtils.equals((CharSequence)ActApproveStatusEnum.APPROVING.getCode(), (CharSequence)entity.getApproveStatus())) {
            StartProcessReqVo processReqVo = this.serviceHelper.buildStartProcessData(entity, reqVo);
            Result processCommonVoResult = this.activityFeign.startProcess(processReqVo);
            if (!Objects.equals(CommonConstant.SC_OK_200, processCommonVoResult.getCode())) {
                throw new BusinessException(processCommonVoResult.getMessage());
            }
            entity.setProcessCode(((ProcessCommonVo)processCommonVoResult.getResult()).getProcessNo());
            this.saveOrUpdate((Object)entity);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TpmActAdvancePayReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        TpmActAdvancePayEntity entity = (TpmActAdvancePayEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        AssertUtils.isNotNull((Object)((Object)entity), (CrmExceptionType)ActAdvancePayException.DATA_NOT_EXIST, (String[])new String[0]);
        AssertUtils.isTrue((boolean)ActAdvancePayApproveStatusEnum.getCanUpdateStatus().contains(entity.getApproveStatus()), (String)"\u5f53\u524d\u6570\u636e\u4e0d\u5141\u8bb8\u4fee\u6539");
        this.serviceHelper.saveCheck(reqVo);
        AssertUtils.isTrue((boolean)ActSaveTypeEnum.getUpdateTypes().contains(reqVo.getSaveType()), (String)"\u4fdd\u5b58\u7c7b\u578b\u503c\u9519\u8bef");
        TpmActAdvancePayEntity updateEntity = (TpmActAdvancePayEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmActAdvancePayEntity.class));
        this.updateById((Object)updateEntity);
        List detailVos = reqVo.getDetailVos();
        List detailIds = detailVos.stream().map(UuidVo::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(detailIds)) {
            this.detailMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmActAdvancePayDetailEntity::getAdvanceCode, (Object)entity.getAdvanceCode())).notIn(BaseIdEntity::getId, detailIds));
        }
        List<TpmActAdvancePayDetailEntity> payDetailEntities = this.convertDetails(detailVos);
        this.detailService.saveOrUpdateBatch(payDetailEntities);
        this.sendToActivity(entity, reqVo);
    }

    public List<TpmActAdvancePayDetailEntity> convertDetails(List<TpmActAdvancePayDetailReqVo> detailVos) {
        List<TpmActAdvancePayDetailEntity> payDetailEntities = detailVos.stream().map(o -> {
            TpmActAdvancePayDetailEntity detailEntity = new TpmActAdvancePayDetailEntity();
            CrmBeanUtil.copyProperties((Object)o, (Object)((Object)detailEntity));
            return detailEntity;
        }).collect(Collectors.toList());
        return payDetailEntities;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (String)"\u8bf7\u9009\u60a8\u9700\u8981\u5220\u9664\u7684\u6570\u636e");
        List entities = this.tpmActAdvancePayMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            entities.stream().forEach(o -> AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)ActAdvancePayApproveStatusEnum.CREATE.getCode(), (CharSequence)o.getApproveStatus()), (String)"\u53ea\u6709\u5f85\u63d0\u4ea4\u7684\u6570\u636e\u53ef\u4ee5\u5220\u9664"));
            this.tpmActAdvancePayMapper.deleteBatchIds(ids);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        List tpmActAdvancePayEntities = this.tpmActAdvancePayMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)tpmActAdvancePayEntities)) {
            tpmActAdvancePayEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmActAdvancePayEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        List tpmActAdvancePayEntities = this.tpmActAdvancePayMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)tpmActAdvancePayEntities)) {
            tpmActAdvancePayEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmActAdvancePayEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void approve(TpmActAdvancePayReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getWorkFlowKey(), (String)"\u8bf7\u9009\u62e9\u6d41\u7a0b");
        TpmActAdvancePayEntity entity = (TpmActAdvancePayEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        AssertUtils.isNotNull((Object)((Object)entity), (CrmExceptionType)ActAdvancePayException.DATA_NOT_EXIST, (String[])new String[0]);
        reqVo.setSaveType(ActSaveTypeEnum.APPROVE.getCode());
        Set canApproveStatus = ActAdvancePayApproveStatusEnum.getCanApproveStatus();
        AssertUtils.isTrue((boolean)canApproveStatus.contains(entity.getApproveStatus()), (String)"\u4ec5\u72b6\u6001\u4e3a\u201c\u5f85\u63d0\u4ea4\u3001\u5ba1\u6279\u9a73\u56de\u3001\u6d41\u7a0b\u8ffd\u56de\u201d\u7684\u5355\u636e\u53ef\u63d0\u4ea4\u5ba1\u6279");
        this.serviceHelper.saveCheck(reqVo);
        TpmActAdvancePayEntity updateEntity = (TpmActAdvancePayEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmActAdvancePayEntity.class));
        this.updateById((Object)updateEntity);
        List detailVos = reqVo.getDetailVos();
        List<TpmActAdvancePayDetailEntity> payDetailEntities = this.convertDetails(detailVos);
        this.detailService.saveOrUpdateBatch(payDetailEntities);
        this.sendToActivity(entity, reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void activityCallBack(ActivitiCallBackVo activitiCallBackVo) {
        String formNo = activitiCallBackVo.getFormNo();
        AssertUtils.isNotEmpty((String)formNo, (String)"\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        TpmActAdvancePayEntity entity = (TpmActAdvancePayEntity)((Object)this.tpmActAdvancePayMapper.selectOne((Wrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)formNo)));
        if (Indicator.CON_BPM_DOING.getCode() == activitiCallBackVo.getProcessState().intValue()) {
            entity.setApproveStatus(ActAdvancePayApproveStatusEnum.APPROVED.getCode());
        }
        if (Indicator.CON_BPM_PASS.getCode() == activitiCallBackVo.getProcessState().intValue()) {
            entity.setApproveStatus(ActAdvancePayApproveStatusEnum.REJECTED.getCode());
        }
        this.updateById((Object)entity);
    }
}

