/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.audit.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.act.mapper.TpmActDetailMapper;
import com.biz.crm.act.mapper.TpmActMapper;
import com.biz.crm.act.model.TpmActDetailEntity;
import com.biz.crm.act.model.TpmActEntity;
import com.biz.crm.act.service.ITpmActDetailService;
import com.biz.crm.act.service.ITpmActService;
import com.biz.crm.act.service.impl.ActOperateFeeBudgetVo;
import com.biz.crm.act.service.impl.ActServiceHelper;
import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.audit.mapper.TpmAuditActMapper;
import com.biz.crm.audit.mapper.TpmAuditDetailMapper;
import com.biz.crm.audit.mapper.TpmAuditFileMapper;
import com.biz.crm.audit.mapper.TpmAuditMapper;
import com.biz.crm.audit.model.TpmAuditActEntity;
import com.biz.crm.audit.model.TpmAuditDetailEntity;
import com.biz.crm.audit.model.TpmAuditEntity;
import com.biz.crm.audit.model.TpmAuditFileEntity;
import com.biz.crm.audit.service.ITpmAuditActService;
import com.biz.crm.audit.service.ITpmAuditDetailService;
import com.biz.crm.audit.service.ITpmAuditFileService;
import com.biz.crm.audit.service.ITpmAuditService;
import com.biz.crm.audit.service.impl.AuditServiceHelper;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.costtypefine.mapper.TpmCostTypeFineMapper;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActSaveTypeEnum;
import com.biz.crm.eunm.tpm.ActSendMessageTypeEnum;
import com.biz.crm.eunm.tpm.ActTypeEnum;
import com.biz.crm.eunm.tpm.BudgetSubjectsControlTypeEnum;
import com.biz.crm.eunm.tpm.FeeBudgetDetailTypeEnum;
import com.biz.crm.eunm.tpm.FeeBudgetRemarkEnum;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetDetailsMapper;
import com.biz.crm.feebudget.model.OperateBudgetControlReqVo;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetDetailsEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.feebudget.service.ITpmFeeBudgetDetailsService;
import com.biz.crm.feebudget.service.ITpmFeeBudgetService;
import com.biz.crm.feebudget.service.impl.FeeBudgetServiceHelper;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.common.ProcessCommonVo;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActSendMessageVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActDetailRespVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActRespVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditDetailReqVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditReqVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditActRespVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditDetailRespVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditFileRespVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditRespVo;
import com.biz.crm.nebular.tpm.feebudget.req.FeeBudgetControlOperateTypeEnum;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.Result;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@ConditionalOnMissingBean(name={"TpmAuditServiceExpandImpl"})
public class TpmAuditServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmAuditMapper, TpmAuditEntity>
implements ITpmAuditService {
    private static final Logger log = LoggerFactory.getLogger(TpmAuditServiceImpl.class);
    @Resource
    private TpmAuditMapper tpmAuditMapper;
    @Autowired
    private AuditServiceHelper serviceHelper;
    @Resource
    private TpmActDetailMapper tpmActDetailMapper;
    @Autowired
    private ITpmAuditDetailService iTpmAuditDetailService;
    @Autowired
    private ITpmAuditActService iTpmAuditActService;
    @Autowired
    private FeeBudgetServiceHelper budgetServiceHelper;
    @Resource
    private TpmAuditDetailMapper tpmAuditDetailMapper;
    @Resource
    private TpmAuditActMapper tpmAuditActMapper;
    @Autowired
    private ITpmAuditFileService iTpmAuditFileService;
    @Resource
    private TpmAuditFileMapper tpmAuditFileMapper;
    @Resource
    private TpmCostTypeFineMapper tpmCostTypeFineMapper;
    @Resource
    private TpmFeeBudgetDetailsMapper tpmFeeBudgetDetailsMapper;
    @Autowired
    private ITpmActService tpmActService;
    @Autowired
    private ITpmActDetailService actDetailService;
    @Resource
    private TpmActMapper tpmActMapper;
    @Autowired
    private ActServiceHelper actServiceHelper;
    @Resource
    private TpmActDetailMapper actDetailMapper;
    @Autowired
    private ITpmFeeBudgetService feeBudgetService;
    @Autowired
    private ITpmFeeBudgetDetailsService feeBudgetDetailsService;
    @Autowired
    private TaActBaseFeign activityFeign;
    @Value(value="${rocketmq.topic}${rocketmq.environment-variable}")
    private String topic;
    @Resource
    private RocketMQProducer rocketMQProducer;

    @Override
    public PageResult<TpmAuditRespVo> findList(TpmAuditReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<TpmAuditRespVo> list = this.tpmAuditMapper.findList((Page<TpmAuditRespVo>)page, reqVo);
        this.serviceHelper.convertListDate(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmAuditRespVo query(String id) {
        List tpmAuditFileEntities;
        TpmAuditEntity tpmAuditEntity = (TpmAuditEntity)((Object)this.tpmAuditMapper.selectById((Serializable)((Object)id)));
        if (ObjectUtils.isEmpty((Object)((Object)tpmAuditEntity))) {
            return new TpmAuditRespVo();
        }
        TpmAuditRespVo tpmAuditRespVo = (TpmAuditRespVo)CrmBeanUtil.copy((Object)((Object)tpmAuditEntity), TpmAuditRespVo.class);
        this.queryAuditDetail(tpmAuditRespVo);
        List auditActEntityList = this.tpmAuditActMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmAuditActEntity::getAuditCode, (Object)tpmAuditRespVo.getAuditCode()));
        if (CollectionUtils.isNotEmpty((Collection)auditActEntityList)) {
            tpmAuditRespVo.setTpmAuditActReqVos(CrmBeanUtil.copyList((List)auditActEntityList, TpmAuditActRespVo.class));
        }
        if (CollectionUtils.isNotEmpty((Collection)(tpmAuditFileEntities = this.tpmAuditFileMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmAuditFileEntity::getAuditCode, (Object)tpmAuditRespVo.getAuditCode()))))) {
            tpmAuditRespVo.setAuditFileRespVos(CrmBeanUtil.copyList((List)tpmAuditFileEntities, TpmAuditFileRespVo.class));
        }
        return tpmAuditRespVo;
    }

    private void queryAuditDetail(TpmAuditRespVo tpmAuditRespVo) {
        List detailEntityList = this.tpmAuditDetailMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmAuditDetailEntity::getAuditCode, (Object)tpmAuditRespVo.getAuditCode()));
        if (CollectionUtils.isNotEmpty((Collection)detailEntityList)) {
            List tpmAuditDetailRespVos = CrmBeanUtil.copyList((List)detailEntityList, TpmAuditDetailRespVo.class);
            HashSet findCodes = Sets.newHashSet();
            HashSet actDetailCodes = Sets.newHashSet();
            tpmAuditDetailRespVos.forEach(o -> {
                findCodes.add(o.getFineCode());
                actDetailCodes.add(o.getActDetailCode());
            });
            List tpmCostTypeFineEntities = this.tpmCostTypeFineMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(TpmCostTypeFineEntity::getFineCode, (Collection)findCodes));
            List actDetailEntities = this.tpmActDetailMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmActDetailEntity.class).in(TpmActDetailEntity::getActDetailCode, (Collection)actDetailCodes));
            HashMap alreadyAuditMoneyMap = Maps.newHashMap();
            Optional.ofNullable(actDetailEntities).orElse(Lists.newArrayList()).stream().forEach(o -> alreadyAuditMoneyMap.put(o.getActDetailCode(), Optional.ofNullable(o.getAuditAmount()).orElse(BigDecimal.ZERO)));
            Map<String, List<TpmCostTypeFineEntity>> findCodeGroupMap = Optional.ofNullable(tpmCostTypeFineEntities).orElse(Lists.newArrayList()).stream().collect(Collectors.groupingBy(TpmCostTypeFineEntity::getFineCode));
            Map<String, String> dictValueMap = this.queryDictValueMap();
            tpmAuditDetailRespVos.forEach(tpmAuditDetailRespVo -> {
                TpmCostTypeFineEntity typeFineEntity;
                String fineCode = tpmAuditDetailRespVo.getFineCode();
                if (StringUtils.isNotBlank((CharSequence)fineCode) && CollectionUtil.mapNotEmpty((Map)findCodeGroupMap) && Objects.nonNull((Object)(typeFineEntity = (TpmCostTypeFineEntity)((Object)((Object)((List)findCodeGroupMap.get(fineCode)).get(0))))) && StringUtils.isNotEmpty((CharSequence)typeFineEntity.getPayTypeList()) && CollectionUtil.mapNotEmpty((Map)dictValueMap)) {
                    List<DictItemVo> payTypes = this.getPayTypes(typeFineEntity.getPayTypeList(), dictValueMap);
                    tpmAuditDetailRespVo.setPayTypesJsonStr(JSON.toJSONString(payTypes));
                    tpmAuditDetailRespVo.setPayTypes(payTypes);
                }
                if (MapUtils.isNotEmpty((Map)alreadyAuditMoneyMap)) {
                    tpmAuditDetailRespVo.setAlreadyAuditAmount(Optional.ofNullable(alreadyAuditMoneyMap.get(tpmAuditDetailRespVo.getActDetailCode())).orElse(BigDecimal.ZERO));
                }
            });
            tpmAuditRespVo.setDetailVos(tpmAuditDetailRespVos);
        }
    }

    @Override
    public List<DictItemVo> getPayTypes(String payTypeList, Map<String, String> map) {
        List codes = JSON.parseArray((String)payTypeList, String.class);
        ArrayList payTypes = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)codes)) {
            codes.forEach(o -> {
                DictItemVo dictItemVo = new DictItemVo();
                String s = (String)map.get(o);
                dictItemVo.setDictKey(s);
                dictItemVo.setDictValue(o);
                payTypes.add(dictItemVo);
            });
        }
        return payTypes;
    }

    @Override
    public Map<String, String> queryDictValueMap() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("pay_type_d");
        Map dictValueMapsByCodes = DictUtil.getDictValueMapsByCodes((List)dictCodes);
        if (!CollectionUtil.mapNotEmpty((Map)dictValueMapsByCodes)) {
            return Maps.newHashMap();
        }
        Map map = (Map)dictValueMapsByCodes.get("pay_type_d");
        return map;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TpmAuditReqVo reqVo) {
        this.serviceHelper.saveCheck(reqVo);
        AssertUtils.isTrue((boolean)ActSaveTypeEnum.getCreateTypes().contains(reqVo.getSaveType()), (String)"\u4fdd\u5b58\u7c7b\u578b\u503c\u9519\u8bef");
        TpmAuditEntity entity = (TpmAuditEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmAuditEntity.class));
        entity.setAuditCode(CodeUtil.createOneCode((String)"tpm_audit"));
        this.save((Object)entity);
        this.saveAuditDetailInfo(reqVo, entity);
        this.saveAuditActInfo(reqVo, entity);
        this.saveAuditFileInfo(reqVo, entity);
        if (StringUtils.equals((CharSequence)ActSaveTypeEnum.ADD_AND_APPROVE.getCode(), (CharSequence)reqVo.getSaveType()) && reqVo.getOccupyFeeBudgetFlag().booleanValue()) {
            this.occupyTheBudget(reqVo);
            this.sendToActivity(entity, reqVo);
        }
    }

    private void occupyTheBudget(TpmAuditReqVo reqVo) {
        List occupyFeeBudgetDetails = reqVo.getOccupyFeeBudgetDetails();
        if (CollectionUtils.isEmpty((Collection)occupyFeeBudgetDetails)) {
            return;
        }
        List detailEntities = this.actDetailMapper.selectList((Wrapper)new LambdaQueryWrapper().in(TpmActDetailEntity::getActDetailCode, (Collection)occupyFeeBudgetDetails.stream().map(TpmAuditDetailReqVo::getActDetailCode).collect(Collectors.toSet())));
        ActOperateFeeBudgetVo operateFeeBudgetVo = this.actServiceHelper.setOperateFeeBudgetVo(detailEntities);
        ArrayList saveFeeBudgetDetails = Lists.newArrayList();
        HashSet saveFeeBudgetCodes = Sets.newHashSet();
        HashSet saveFeeBudgetControlIds = Sets.newHashSet();
        for (TpmAuditDetailReqVo p : occupyFeeBudgetDetails) {
            List<TpmFeeBudgetDetailsEntity> tpmFeeBudgetDetailsEntities = operateFeeBudgetVo.getBudgetDetailsMap().get(p.getActCode() + p.getActDetailCode()).stream().sorted(Comparator.comparing(TpmFeeBudgetDetailsEntity::getReduceOrder)).collect(Collectors.toList());
            AtomicReference<BigDecimal> occupyMoney = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            if (Optional.ofNullable(p.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO).compareTo(p.getActDetailApplyAmount()) == 1) {
                occupyMoney.set(p.getAuditApplyAmount());
            } else {
                occupyMoney.set(p.getAuditApplyAmount().add(Optional.ofNullable(p.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO)).subtract(p.getActDetailApplyAmount()));
            }
            HashMap ratioCanOccupyMoneyMap = Maps.newHashMap();
            if (operateFeeBudgetVo.getIsRatio().booleanValue()) {
                tpmFeeBudgetDetailsEntities.forEach(t -> {
                    String feeBudgetTypeKey = this.actServiceHelper.getFeebudgetTypeKey(t.getFeeBudgetType(), t.getOrgType());
                    ratioCanOccupyMoneyMap.put(feeBudgetTypeKey, ((BigDecimal)occupyMoney.get()).multiply(t.getReduceRatio()).divide(BigDecimal.valueOf(100L)));
                });
            }
            for (int i = 0; i < tpmFeeBudgetDetailsEntities.size(); ++i) {
                TpmFeeBudgetDetailsEntity feeBudgetDetailsEntity = (TpmFeeBudgetDetailsEntity)((Object)tpmFeeBudgetDetailsEntities.get(i));
                TpmFeeBudgetEntity budgetEntity = operateFeeBudgetVo.getFeeBudgetMap().get(feeBudgetDetailsEntity.getFeeBudgetCode());
                TpmFeeBudgetControlEntity budgetControlEntity = operateFeeBudgetVo.getControlEntityMap().get(budgetEntity.getControlId());
                TpmBudgetSubjectsEntity subjectsEntity = operateFeeBudgetVo.getSubjectsEntityMap().get(budgetEntity.getBudgetSubjectsCode());
                AssertUtils.isNotNull((Object)((Object)subjectsEntity), (String)("\u8d39\u7528\u9884\u7b97:" + budgetEntity.getFeeBudgetCode() + "\u5bf9\u5e94\u7684\u9884\u7b97\u79d1\u76ee:" + budgetEntity.getBudgetSubjectsCode() + "\u4e0d\u5b58\u5728"));
                if (!StringUtils.equals((CharSequence)BudgetSubjectsControlTypeEnum.NON.getCode(), (CharSequence)subjectsEntity.getControlType()) && budgetEntity.getCanUseAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal canOccupyMoney = BigDecimal.ZERO;
                BigDecimal maxCanOccupy = BigDecimal.ZERO;
                if (operateFeeBudgetVo.getIsRatio().booleanValue()) {
                    String feebudgetTypeKey = this.actServiceHelper.getFeebudgetTypeKey(feeBudgetDetailsEntity.getFeeBudgetType(), feeBudgetDetailsEntity.getOrgType());
                    maxCanOccupy = (BigDecimal)ratioCanOccupyMoneyMap.get(feebudgetTypeKey);
                    if (maxCanOccupy.compareTo(BigDecimal.ZERO) == 0) continue;
                    if (!StringUtils.equals((CharSequence)BudgetSubjectsControlTypeEnum.NON.getCode(), (CharSequence)subjectsEntity.getControlType())) {
                        canOccupyMoney = maxCanOccupy;
                        ratioCanOccupyMoneyMap.put(feebudgetTypeKey, BigDecimal.ZERO);
                        budgetEntity.setCanUseAmount(budgetEntity.getCanUseAmount().subtract(maxCanOccupy));
                        budgetControlEntity.setCanUseAmount(budgetControlEntity.getCanUseAmount().subtract(maxCanOccupy));
                    } else if (maxCanOccupy.compareTo(budgetEntity.getCanUseAmount()) == 1) {
                        canOccupyMoney = budgetEntity.getCanUseAmount();
                        occupyMoney.set(occupyMoney.get().subtract(budgetEntity.getCanUseAmount()));
                        ratioCanOccupyMoneyMap.put(feebudgetTypeKey, maxCanOccupy.subtract(budgetEntity.getCanUseAmount()));
                        budgetEntity.setCanUseAmount(BigDecimal.ZERO);
                        budgetControlEntity.setCanUseAmount(budgetControlEntity.getCanUseAmount().subtract(canOccupyMoney));
                    } else {
                        canOccupyMoney = maxCanOccupy;
                        ratioCanOccupyMoneyMap.put(feebudgetTypeKey, BigDecimal.ZERO);
                        budgetEntity.setCanUseAmount(budgetEntity.getCanUseAmount().subtract(maxCanOccupy));
                        budgetControlEntity.setCanUseAmount(budgetControlEntity.getCanUseAmount().subtract(maxCanOccupy));
                    }
                } else {
                    if (occupyMoney.get().compareTo(BigDecimal.ZERO) == 0) break;
                    if (!StringUtils.equals((CharSequence)BudgetSubjectsControlTypeEnum.NON.getCode(), (CharSequence)subjectsEntity.getControlType())) {
                        canOccupyMoney = occupyMoney.get();
                        occupyMoney.set(BigDecimal.ZERO);
                        budgetEntity.setCanUseAmount(budgetEntity.getCanUseAmount().subtract(canOccupyMoney));
                        budgetControlEntity.setCanUseAmount(budgetControlEntity.getCanUseAmount().subtract(canOccupyMoney));
                    } else {
                        maxCanOccupy = budgetEntity.getCanUseAmount();
                        if (occupyMoney.get().compareTo(maxCanOccupy) == 1) {
                            canOccupyMoney = maxCanOccupy;
                            occupyMoney.set(occupyMoney.get().subtract(maxCanOccupy));
                            budgetEntity.setCanUseAmount(BigDecimal.ZERO);
                            budgetControlEntity.setCanUseAmount(budgetControlEntity.getCanUseAmount().subtract(canOccupyMoney));
                        } else {
                            canOccupyMoney = occupyMoney.get();
                            occupyMoney.set(BigDecimal.ZERO);
                            budgetEntity.setCanUseAmount(budgetEntity.getCanUseAmount().subtract(canOccupyMoney));
                            budgetControlEntity.setCanUseAmount(budgetControlEntity.getCanUseAmount().subtract(canOccupyMoney));
                        }
                    }
                }
                saveFeeBudgetCodes.add(budgetEntity.getFeeBudgetCode());
                saveFeeBudgetControlIds.add(budgetControlEntity.getId());
                TpmFeeBudgetDetailsEntity newBudgetDetailsEntity = new TpmFeeBudgetDetailsEntity();
                CrmBeanUtil.copyProperties((Object)((Object)feeBudgetDetailsEntity), (Object)((Object)newBudgetDetailsEntity));
                newBudgetDetailsEntity.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.USE.getCode());
                newBudgetDetailsEntity.setYear(budgetEntity.getBudgetYear());
                newBudgetDetailsEntity.setMonth(budgetEntity.getBudgetMonth());
                newBudgetDetailsEntity.setFeeBudgetDetailTypeName(FeeBudgetDetailTypeEnum.USE.getDes());
                newBudgetDetailsEntity.setFeeAmount(BigDecimal.ZERO.subtract(canOccupyMoney));
                newBudgetDetailsEntity.setAfterAmount(budgetEntity.getCanUseAmount());
                newBudgetDetailsEntity.setBeforAmount(budgetEntity.getCanUseAmount().add(canOccupyMoney));
                newBudgetDetailsEntity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                newBudgetDetailsEntity.setBusinessCode(p.getAuditCode());
                newBudgetDetailsEntity.setBusinessLineCode(p.getAuditDetailCode());
                newBudgetDetailsEntity.setBusinessRemarks(FeeBudgetRemarkEnum.WRITE_OFF_THE_OCCUPIED_BUDGET.getDes());
                this.actServiceHelper.setPublicParamsNull((CrmBaseEntity)newBudgetDetailsEntity);
                saveFeeBudgetDetails.add(newBudgetDetailsEntity);
            }
            if (MapUtils.isNotEmpty((Map)ratioCanOccupyMoneyMap)) {
                ratioCanOccupyMoneyMap.keySet().forEach(t -> {
                    BigDecimal bigDecimal = (BigDecimal)ratioCanOccupyMoneyMap.get(t);
                    if (bigDecimal.compareTo(BigDecimal.ZERO) == 1) {
                        throw new BusinessException("\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801:" + p.getActDetailCode() + "\u8d85\u989d\u6838\u9500\u5360\u7528\u8d39\u7528\u65f6,\u9884\u7b97\u4e0d\u8db3");
                    }
                });
                continue;
            }
            if (occupyMoney.get().compareTo(BigDecimal.ZERO) != 1) continue;
            throw new BusinessException("\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801:" + p.getActDetailCode() + "\u8d85\u989d\u6838\u9500\u5360\u7528\u8d39\u7528\u65f6,\u9884\u7b97\u4e0d\u8db3");
        }
        operateFeeBudgetVo.setSaveFeeBudgetDetails(saveFeeBudgetDetails);
        operateFeeBudgetVo.setSaveFeeBudgetCodes(saveFeeBudgetCodes);
        operateFeeBudgetVo.setSaveFeeBudgetControlIds(saveFeeBudgetControlIds);
        operateFeeBudgetVo.setTypeEnum(FeeBudgetControlOperateTypeEnum.USE);
        this.actServiceHelper.saveFeeBudgetDataInfos(operateFeeBudgetVo);
    }

    private void saveAuditFileInfo(TpmAuditReqVo reqVo, TpmAuditEntity entity) {
        List typeFineRespVos = reqVo.getAuditFileRespVos();
        if (CollectionUtil.listNotEmpty((List)typeFineRespVos)) {
            List tpmAuditFileEntities = CrmBeanUtil.copyList((List)typeFineRespVos, TpmAuditFileEntity.class);
            tpmAuditFileEntities.forEach(tpmAuditFileEntity -> {
                AssertUtils.isNotNull((Object)tpmAuditFileEntity.getAuditFileType(), (String)"\u6838\u9500\u8d44\u6599\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                tpmAuditFileEntity.setAuditCode(entity.getAuditCode());
            });
            this.iTpmAuditFileService.saveBatch(tpmAuditFileEntities);
        }
    }

    public void saveAuditDetailInfo(TpmAuditReqVo reqVo, TpmAuditEntity entity) {
        List detailVos = reqVo.getDetailVos();
        detailVos.forEach(o -> {
            if (StringUtils.isEmpty((CharSequence)o.getAuditDetailCode())) {
                o.setAuditDetailCode(CodeUtil.createOneCode((String)"tpm_audit_detail"));
            }
            o.setAuditCode(entity.getAuditCode());
            if (Objects.isNull(o.getFeeUsed())) {
                o.setFeeUsed(BigDecimal.ZERO);
            }
            if (StringUtils.isBlank((CharSequence)o.getIsAllFeeUsed())) {
                o.setIsAllFeeUsed(GlobalWhetherEnum.NO.getCode());
            }
        });
        List tpmAuditDetailEntities = CrmBeanUtil.copyList((List)detailVos, TpmAuditDetailEntity.class);
        this.iTpmAuditDetailService.saveBatch(tpmAuditDetailEntities);
    }

    public void saveAuditActInfo(TpmAuditReqVo reqVo, TpmAuditEntity entity) {
        List tpmAuditActReqVos = reqVo.getTpmAuditActReqVos();
        tpmAuditActReqVos.forEach(o -> o.setAuditCode(entity.getAuditCode()));
        List tpmAuditActEntities = CrmBeanUtil.copyList((List)tpmAuditActReqVos, TpmAuditActEntity.class);
        this.iTpmAuditActService.saveBatch(tpmAuditActEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TpmAuditReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        this.serviceHelper.saveCheck(reqVo);
        AssertUtils.isTrue((boolean)ActSaveTypeEnum.getUpdateTypes().contains(reqVo.getSaveType()), (String)"\u4fdd\u5b58\u7c7b\u578b\u503c\u9519\u8bef");
        TpmAuditEntity tpmAuditEntity = (TpmAuditEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmAuditEntity.class));
        this.updateById((Object)tpmAuditEntity);
        this.updateAuditDetail(reqVo, tpmAuditEntity);
        this.updateAct(reqVo, tpmAuditEntity);
        this.updateAuditFile(reqVo, tpmAuditEntity);
        if (ActSaveTypeEnum.UPDATE_AND_APPROVE.getCode().equals(reqVo.getSaveType())) {
            this.occupyTheBudget(reqVo);
            this.sendToActivity(tpmAuditEntity, reqVo);
        }
    }

    public void updateAct(TpmAuditReqVo reqVo, TpmAuditEntity tpmAuditEntity) {
        List tpmAuditActReqVos = reqVo.getTpmAuditActReqVos();
        tpmAuditActReqVos.stream().forEach(tpmAuditActReqVo -> tpmAuditActReqVo.setAuditCode(tpmAuditEntity.getAuditCode()));
        List auditActIds = tpmAuditActReqVos.stream().map(UuidVo::getId).collect(Collectors.toList());
        this.tpmAuditActMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmAuditActEntity::getAuditCode, (Object)tpmAuditEntity.getAuditCode())).notIn(CollectionUtils.isNotEmpty(auditActIds), BaseIdEntity::getId, auditActIds));
        this.iTpmAuditActService.saveOrUpdateBatch(CrmBeanUtil.copyList((List)tpmAuditActReqVos, TpmAuditActEntity.class));
    }

    public void updateAuditDetail(TpmAuditReqVo reqVo, TpmAuditEntity tpmAuditEntity) {
        List detailVos = reqVo.getDetailVos();
        detailVos.stream().forEach(detailReqVo -> {
            detailReqVo.setAuditCode(tpmAuditEntity.getAuditCode());
            if (StringUtils.isEmpty((CharSequence)detailReqVo.getAuditDetailCode())) {
                detailReqVo.setAuditDetailCode(CodeUtil.createOneCode((String)"tpm_audit_detail"));
            }
            if (Objects.isNull(detailReqVo.getFeeUsed())) {
                detailReqVo.setFeeUsed(BigDecimal.ZERO);
            }
            if (StringUtils.isBlank((CharSequence)detailReqVo.getIsAllFeeUsed())) {
                detailReqVo.setIsAllFeeUsed(GlobalWhetherEnum.NO.getCode());
            }
        });
        List auditDetailIds = detailVos.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getId())).map(UuidVo::getId).collect(Collectors.toList());
        this.tpmAuditDetailMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmAuditDetailEntity::getAuditCode, (Object)tpmAuditEntity.getAuditCode())).notIn(CollectionUtils.isNotEmpty(auditDetailIds), BaseIdEntity::getId, auditDetailIds));
        this.iTpmAuditDetailService.saveOrUpdateBatch(CrmBeanUtil.copyList((List)detailVos, TpmAuditDetailEntity.class));
    }

    public void updateAuditFile(TpmAuditReqVo reqVo, TpmAuditEntity tpmAuditEntity) {
        List auditFileRespVos = reqVo.getAuditFileRespVos();
        if (CollectionUtils.isNotEmpty((Collection)auditFileRespVos)) {
            auditFileRespVos.stream().forEach(tpmAuditFileRespVo -> {
                AssertUtils.isNotNull((Object)tpmAuditFileRespVo.getAuditFileType(), (String)"\u6838\u9500\u8d44\u6599\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                tpmAuditFileRespVo.setAuditCode(tpmAuditEntity.getAuditCode());
            });
            List auditFileIds = auditFileRespVos.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getId())).map(UuidVo::getId).collect(Collectors.toList());
            this.tpmAuditFileMapper.delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TpmAuditFileEntity::getAuditCode, (Object)tpmAuditEntity.getAuditCode())).notIn(CollectionUtils.isNotEmpty(auditFileIds), BaseIdEntity::getId, auditFileIds));
            this.iTpmAuditFileService.saveOrUpdateBatch(CrmBeanUtil.copyList((List)auditFileRespVos, TpmAuditFileEntity.class));
        } else {
            this.tpmAuditFileMapper.delete((Wrapper)Wrappers.lambdaQuery().eq(TpmAuditFileEntity::getAuditCode, (Object)tpmAuditEntity.getAuditCode()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        List tpmAuditEntities = this.tpmAuditMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)tpmAuditEntities)) {
            this.serviceHelper.deleteCheck(tpmAuditEntities, ids);
            List auditCodes = tpmAuditEntities.stream().map(TpmAuditEntity::getAuditCode).collect(Collectors.toList());
            this.tpmAuditDetailMapper.delete((Wrapper)Wrappers.lambdaQuery().in(TpmAuditDetailEntity::getAuditCode, auditCodes));
            this.tpmAuditActMapper.delete((Wrapper)Wrappers.lambdaQuery().in(TpmAuditActEntity::getAuditCode, auditCodes));
            this.tpmAuditMapper.deleteBatchIds(ids);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        List tpmAuditEntities = this.tpmAuditMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)tpmAuditEntities)) {
            tpmAuditEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmAuditEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        List tpmAuditEntities = this.tpmAuditMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)tpmAuditEntities)) {
            tpmAuditEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmAuditEntities);
    }

    @Override
    public PageResult<TpmActDetailRespVo> findActDetailList(TpmActDetailReqVo tpmActDetailReqVo) {
        AssertUtils.isNotEmpty((Collection)tpmActDetailReqVo.getActCodes(), (String)"\u6d3b\u52a8\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        Page page = PageUtil.buildPage((Integer)tpmActDetailReqVo.getPageNum(), (Integer)tpmActDetailReqVo.getPageSize());
        ArrayList list = this.tpmActDetailMapper.findActDetailList((Page<TpmActDetailRespVo>)page, tpmActDetailReqVo);
        if (CollectionUtils.isEmpty(list)) {
            list = Lists.newArrayList();
        }
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            Map<String, String> dictValueMap = this.queryDictValueMap();
            list.forEach(tpmActDetailRespVo -> {
                if (StringUtils.isNotEmpty((CharSequence)tpmActDetailRespVo.getPayTypeList()) && CollectionUtil.mapNotEmpty((Map)dictValueMap)) {
                    List<DictItemVo> payTypes = this.getPayTypes(tpmActDetailRespVo.getPayTypeList(), dictValueMap);
                    tpmActDetailRespVo.setPayTypesJsonStr(JSON.toJSONString(payTypes));
                    tpmActDetailRespVo.setPayTypes(payTypes);
                }
                if (Objects.isNull(tpmActDetailRespVo.getAuditAmount())) {
                    tpmActDetailRespVo.setAuditAmount(BigDecimal.ZERO);
                }
            });
        }
        return PageResult.builder().data((List)list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Set<String> auditApproved(TpmAuditReqVo tpmAuditReqVo) {
        AssertUtils.isNotEmpty((String)tpmAuditReqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        TpmAuditEntity tpmAuditEntity = (TpmAuditEntity)((Object)this.tpmAuditMapper.selectById((Serializable)((Object)tpmAuditReqVo.getId())));
        tpmAuditEntity.setApproveStatus(ActApproveStatusEnum.APPROVED.getCode());
        this.updateById((Object)tpmAuditEntity);
        List detailEntityList = this.tpmAuditDetailMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmAuditDetailEntity::getAuditCode, (Object)tpmAuditEntity.getAuditCode()));
        HashSet actCodes = Sets.newHashSet();
        detailEntityList.forEach(o -> actCodes.add(o.getActCode()));
        List actEntities = this.tpmActMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmActEntity.class).in(TpmActEntity::getActCode, (Collection)actCodes));
        Map actEntityMap = actEntities.stream().collect(Collectors.toMap(TpmActEntity::getActCode, Function.identity()));
        List actDetailEntities = this.tpmActDetailMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmActDetailEntity.class).in(TpmActDetailEntity::getActCode, (Collection)actCodes));
        HashMap actDetailEntityMap = Maps.newHashMap();
        HashMap groupByActCodeMap = Maps.newHashMap();
        actDetailEntities.stream().forEach(o -> {
            actDetailEntityMap.put(o.getActDetailCode(), o);
            List tpmActDetailEntities = (List)groupByActCodeMap.get(o.getActCode());
            if (CollectionUtils.isEmpty((Collection)tpmActDetailEntities)) {
                tpmActDetailEntities = Lists.newArrayList();
            }
            tpmActDetailEntities.add(o);
            groupByActCodeMap.put(o.getActCode(), tpmActDetailEntities);
        });
        ArrayList needRefundActDetails = Lists.newArrayList();
        ArrayList needSaveActDetails = Lists.newArrayList();
        HashMap actDetailToAuditDetailMap = Maps.newHashMap();
        HashSet allAuditActIds = Sets.newHashSet();
        for (TpmAuditDetailEntity o2 : detailEntityList) {
            TpmActDetailEntity actDetailEntity = (TpmActDetailEntity)((Object)actDetailEntityMap.get(o2.getActDetailCode()));
            TpmActEntity actEntity = (TpmActEntity)((Object)actEntityMap.get(actDetailEntity.getActCode()));
            actDetailEntity.setAuditAmount(Optional.ofNullable(actDetailEntity.getAuditAmount()).orElse(BigDecimal.ZERO).add(o2.getAuditApplyAmount()));
            actDetailEntity.setIsAllAudit(o2.getIsAllAudit());
            actDetailEntity.setIsAudit(GlobalWhetherEnum.YES.getCode());
            actEntity.setAuditTotalAmount(Optional.ofNullable(actEntity.getAuditTotalAmount()).orElse(BigDecimal.ZERO).add(o2.getAuditApplyAmount()));
            needSaveActDetails.add(actDetailEntity);
            if (!StringUtils.equals((CharSequence)GlobalWhetherEnum.YES.getCode(), (CharSequence)actDetailEntity.getIsAllAudit())) continue;
            if (actDetailEntity.getAuditAmount().compareTo(actDetailEntity.getApplyAmount()) == -1) {
                needRefundActDetails.add(actDetailEntity);
                actDetailToAuditDetailMap.put(o2.getActDetailCode(), o2);
            }
            allAuditActIds.add(actEntity.getId());
        }
        this.actDetailService.updateBatchById(needSaveActDetails);
        for (TpmActEntity actEntity : actEntities) {
            List detailEntities = (List)groupByActCodeMap.get(actEntity.getActCode());
            actEntity.setIsAudit(GlobalWhetherEnum.YES.getCode());
            long count = detailEntities.stream().filter(p -> StringUtils.equals((CharSequence)GlobalWhetherEnum.YES.getCode(), (CharSequence)p.getIsAllAudit())).count();
            if (!Objects.nonNull(count) || (long)detailEntities.size() != count) continue;
            actEntity.setIsAllAudit(GlobalWhetherEnum.YES.getCode());
        }
        this.tpmActService.updateBatchById(actEntities);
        if (CollectionUtils.isNotEmpty((Collection)needRefundActDetails)) {
            ActOperateFeeBudgetVo operateFeeBudgetVo = this.actServiceHelper.setOperateFeeBudgetVo(needRefundActDetails);
            operateFeeBudgetVo.setActDetailToAuditDetailMap(actDetailToAuditDetailMap);
            operateFeeBudgetVo.setNeedRefundActDetails(needRefundActDetails);
            this.refundActFeeBudgetDetail(operateFeeBudgetVo);
        }
        return allAuditActIds;
    }

    private void refundActFeeBudgetDetail(ActOperateFeeBudgetVo operateFeeBudgetVo) {
        operateFeeBudgetVo.setIsAuditRefund(true);
        operateFeeBudgetVo.setBusinessRemark(FeeBudgetRemarkEnum.WRITE_OFF_AND_RETURN.getDes());
        this.actServiceHelper.calculateRefundBudget(operateFeeBudgetVo);
        operateFeeBudgetVo.setTypeEnum(FeeBudgetControlOperateTypeEnum.RETURN);
        this.actServiceHelper.saveFeeBudgetDataInfos(operateFeeBudgetVo);
    }

    @Override
    public PageResult<TpmActRespVo> actList(TpmActReqVo tpmActReqVo) {
        tpmActReqVo.setApproveStatus(ActApproveStatusEnum.APPROVED.getCode());
        tpmActReqVo.setIsAllAudit(GlobalWhetherEnum.NO.getCode());
        ArrayList actTypes = Lists.newArrayList();
        actTypes.add(ActTypeEnum.STABLE_CHARGE.getCode());
        actTypes.add(ActTypeEnum.PROJECT.getCode());
        actTypes.add(ActTypeEnum.DEPARTMENT_CHARGE.getCode());
        return this.tpmActService.findList(tpmActReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void approve(TpmAuditReqVo tpmAuditReqVo) {
        this.serviceHelper.approveCheck(tpmAuditReqVo);
        this.update(tpmAuditReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void rejectAndInterrupt(TpmAuditReqVo reqVo) {
        TpmAuditEntity auditEntity = this.serviceHelper.rejectAndInterruptCheck(reqVo);
        List budgetDetailsEntities = this.tpmFeeBudgetDetailsMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmFeeBudgetDetailsEntity::getBusinessCode, (Object)auditEntity.getAuditCode())).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
        if (CollectionUtils.isNotEmpty((Collection)budgetDetailsEntities)) {
            HashSet feeBudgetCodes = Sets.newHashSet();
            for (TpmFeeBudgetDetailsEntity o2 : budgetDetailsEntities) {
                feeBudgetCodes.add(o2.getFeeBudgetCode());
            }
            List<TpmFeeBudgetEntity> feeBudgetEntities = this.actServiceHelper.findFeeBudgetByCodes(feeBudgetCodes);
            HashSet controlIds = Sets.newHashSet();
            HashMap budgetEntityMap = Maps.newHashMap();
            for (TpmFeeBudgetEntity o3 : feeBudgetEntities) {
                controlIds.add(o3.getControlId());
                budgetEntityMap.put(o3.getFeeBudgetCode(), o3);
            }
            List<TpmFeeBudgetControlEntity> feeBudgetControls = this.actServiceHelper.findFeeBudgetControls(controlIds);
            Map controlEntityMap = feeBudgetControls.stream().collect(Collectors.toMap(BaseIdEntity::getId, Function.identity()));
            ArrayList newBudgetDetailsEntities = Lists.newArrayList();
            for (TpmFeeBudgetDetailsEntity o4 : budgetDetailsEntities) {
                o4.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
                if (o4.getFeeAmount().compareTo(BigDecimal.ZERO) == 0) continue;
                TpmFeeBudgetEntity budgetEntity = (TpmFeeBudgetEntity)((Object)budgetEntityMap.get(o4.getFeeBudgetCode()));
                TpmFeeBudgetControlEntity controlEntity = (TpmFeeBudgetControlEntity)((Object)controlEntityMap.get(budgetEntity.getControlId()));
                TpmFeeBudgetDetailsEntity newDetail = new TpmFeeBudgetDetailsEntity();
                CrmBeanUtil.copyProperties((Object)((Object)o4), (Object)((Object)newDetail));
                this.actServiceHelper.setPublicParamsNull((CrmBaseEntity)newDetail);
                newDetail.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.RETURN_BACK.getCode());
                newDetail.setFeeBudgetDetailTypeName(FeeBudgetDetailTypeEnum.RETURN_BACK.getDes());
                newDetail.setFeeAmount(BigDecimal.ZERO.subtract(newDetail.getFeeAmount()));
                newDetail.setAfterAmount(budgetEntity.getCanUseAmount().add(newDetail.getFeeAmount()));
                newDetail.setBeforAmount(budgetEntity.getCanUseAmount());
                newDetail.setBusinessRemarks(FeeBudgetRemarkEnum.REJECT_AND_INTERRUPT_RETURN_BUDGET.getDes());
                budgetEntity.setCanUseAmount(budgetEntity.getCanUseAmount().add(newDetail.getFeeAmount()));
                budgetEntity.setUsedAmount(budgetEntity.getUsedAmount().subtract(newDetail.getFeeAmount()));
                controlEntity.setCanUseAmount(controlEntity.getCanUseAmount().add(newDetail.getFeeAmount()));
                newDetail.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
                newBudgetDetailsEntities.add(newDetail);
            }
            feeBudgetControls.forEach(o -> {
                OperateBudgetControlReqVo controlReqVo = OperateBudgetControlReqVo.builder().controlEntity((TpmFeeBudgetControlEntity)((Object)o)).typeEnum(FeeBudgetControlOperateTypeEnum.RETURN).build();
                this.budgetServiceHelper.saveFeeBudgetControlData(controlReqVo);
            });
            this.feeBudgetDetailsService.saveBatch(newBudgetDetailsEntities);
            this.feeBudgetDetailsService.updateBatchById(budgetDetailsEntities);
            this.feeBudgetService.updateBatchById(feeBudgetEntities);
        }
        this.updateById((Object)auditEntity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void activityCallBack(ActivitiCallBackVo activitiCallBackVo) {
        TpmAuditReqVo reqVo = new TpmAuditReqVo();
        reqVo.setId(activitiCallBackVo.getFormNo());
        if (Indicator.CON_BPM_DOING.getCode() == activitiCallBackVo.getProcessState().intValue()) {
            Set<String> actIds = this.auditApproved(reqVo);
            actIds.stream().filter(Objects::nonNull).forEach(o -> {
                TpmActSendMessageVo actSendMessageVo = TpmActSendMessageVo.builder().actId(o).type(ActSendMessageTypeEnum.ALL_AUDIT.getCode()).build();
                RocketMQMessageBody rocketMQMessageBody = RocketMQMessageBody.builder().topic(this.topic).tag("TPM_ACT_APPROVED_AND_CLOSED").bizKey("tpm").msgBody(JSON.toJSONString((Object)actSendMessageVo)).build();
                log.info("\u5b8c\u5168\u6838\u9500,\u53d1\u9001MQ\u6d88\u606f,messageBody={}", (Object)rocketMQMessageBody.getMsgBody());
                this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
            });
        }
        if (Indicator.CON_BPM_PASS.getCode() == activitiCallBackVo.getProcessState().intValue()) {
            reqVo.setApproveStatus(ActApproveStatusEnum.REJECTED.getCode());
            this.rejectAndInterrupt(reqVo);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void sendToActivity(TpmAuditEntity entity, TpmAuditReqVo reqVo) {
        if (StringUtils.equals((CharSequence)ActApproveStatusEnum.APPROVING.getCode(), (CharSequence)entity.getApproveStatus())) {
            StartProcessReqVo processReqVo = this.serviceHelper.buildStartProcessData(entity, reqVo);
            Result processCommonVoResult = this.activityFeign.startProcess(processReqVo);
            if (!Objects.equals(CommonConstant.SC_OK_200, processCommonVoResult.getCode())) {
                throw new BusinessException(processCommonVoResult.getMessage());
            }
            entity.setProcessCode(((ProcessCommonVo)processCommonVoResult.getResult()).getProcessNo());
            this.saveOrUpdate((Object)entity);
        }
    }
}

