/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.budgetsubjects.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.budgetsubjects.mapper.TpmBudgetSubjectsMapper;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.BudgetSubjectsException;
import com.biz.crm.nebular.tpm.budgetsubjects.req.TpmBudgetSubjectsReqVo;
import com.biz.crm.nebular.tpm.budgetsubjects.resp.TpmBudgetSubjectsRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.DictUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BudgetSubjectsServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(BudgetSubjectsServiceHelper.class);
    @Resource
    private TpmBudgetSubjectsMapper mapper;

    public Map<String, Map<String, String>> getDicts() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("enable_status");
        dictCodes.add("control_type");
        dictCodes.add("subjects_type");
        dictCodes.add("subjects_group");
        dictCodes.add("is_roll");
        return DictUtil.getDictValueMapsByCodes((List)dictCodes);
    }

    public void convertListDate(List<TpmBudgetSubjectsRespVo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Map<String, Map<String, String>> map = this.getDicts();
            list.forEach(o -> {
                if (StringUtils.isNotEmpty((CharSequence)o.getEnableStatus())) {
                    o.setEnableStatusName((String)((Map)Optional.ofNullable(map.get("enable_status")).orElse(Maps.newHashMap())).get(o.getEnableStatus()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getSubjectsGroupCode())) {
                    o.setSubjectsGroupName((String)((Map)Optional.ofNullable(map.get("subjects_group")).orElse(Maps.newHashMap())).get(o.getSubjectsGroupCode()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getSubjectsTypeCode())) {
                    o.setSubjectsTypeName((String)((Map)Optional.ofNullable(map.get("subjects_type")).orElse(Maps.newHashMap())).get(o.getSubjectsTypeCode()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getIsRoll())) {
                    o.setIsRollName((String)((Map)Optional.ofNullable(map.get("is_roll")).orElse(Maps.newHashMap())).get(o.getIsRoll()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getControlType())) {
                    o.setControlTypeName((String)((Map)Optional.ofNullable(map.get("control_type")).orElse(Maps.newHashMap())).get(o.getControlType()));
                }
            });
        }
    }

    public LambdaQueryWrapper<TpmBudgetSubjectsEntity> getQueryWrapper(TpmBudgetSubjectsReqVo reqVo) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.like(StringUtils.isNotEmpty((CharSequence)reqVo.getBudgetSubjectsName()), TpmBudgetSubjectsEntity::getBudgetSubjectsName, (Object)reqVo.getBudgetSubjectsName());
        wrapper.like(StringUtils.isNotEmpty((CharSequence)reqVo.getBudgetSubjectsCode()), TpmBudgetSubjectsEntity::getBudgetSubjectsCode, (Object)reqVo.getBudgetSubjectsCode());
        wrapper.eq(StringUtils.isNotEmpty((CharSequence)reqVo.getSubjectsTypeCode()), TpmBudgetSubjectsEntity::getSubjectsTypeCode, (Object)reqVo.getSubjectsTypeCode());
        wrapper.eq(StringUtils.isNotEmpty((CharSequence)reqVo.getSubjectsGroupCode()), TpmBudgetSubjectsEntity::getSubjectsGroupCode, (Object)reqVo.getSubjectsGroupCode());
        wrapper.eq(StringUtils.isNotEmpty((CharSequence)reqVo.getControlType()), TpmBudgetSubjectsEntity::getControlType, (Object)reqVo.getControlType());
        wrapper.eq(StringUtils.isNotEmpty((CharSequence)reqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)reqVo.getEnableStatus());
        return wrapper;
    }

    public void updateBySelectAll(TpmBudgetSubjectsReqVo reqVo, TpmBudgetSubjectsEntity entity) {
        LambdaQueryWrapper<TpmBudgetSubjectsEntity> queryWrapper = this.getQueryWrapper(reqVo);
        this.mapper.update((Object)entity, (Wrapper)queryWrapper);
    }

    public void saveCheck(TpmBudgetSubjectsReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getControlType(), (String)"\u8bf7\u9009\u62e9\u63a7\u5236\u7c7b\u578b");
        if (StringUtils.isEmpty((CharSequence)reqVo.getBudgetSubjectsCode())) {
            reqVo.setBudgetSubjectsCode(CodeUtil.createOneCode((String)"tpm_budget_subjects"));
        }
        if (StringUtils.isEmpty((CharSequence)reqVo.getEnableStatus())) {
            reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        }
        AssertUtils.isNotEmpty((String)reqVo.getBudgetSubjectsName(), (String)"\u8bf7\u8f93\u5165\u9884\u7b97\u79d1\u76ee\u540d\u79f0");
        this.checkDataExist(reqVo);
    }

    public void checkDataExist(TpmBudgetSubjectsReqVo reqVo) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmBudgetSubjectsEntity::getBudgetSubjectsCode, (Object)reqVo.getBudgetSubjectsCode());
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            wrapper.ne(BaseIdEntity::getId, (Object)reqVo.getId());
        }
        TpmBudgetSubjectsEntity entity = (TpmBudgetSubjectsEntity)((Object)this.mapper.selectOne((Wrapper)wrapper));
        AssertUtils.isTrue((boolean)Objects.isNull((Object)entity), (CrmExceptionType)BudgetSubjectsException.DATA_DUPLICATE, (String[])new String[0]);
    }
}

