/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.costtypefine.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.biz.crm.auditcollectexample.mapper.TpmAuditCollectExampleMapper;
import com.biz.crm.auditcollectexample.model.TpmAuditCollectExampleEntity;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.costtypefine.mapper.TpmCostTypeFineMapper;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.CostTypeFineException;
import com.biz.crm.nebular.tpm.auditcollectexample.resp.TpmAuditCollectExampleRespVo;
import com.biz.crm.nebular.tpm.costtypefine.req.TpmCostTypeFineReqVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.DictUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CostTypeFineServiceHelper
extends BaseServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(CostTypeFineServiceHelper.class);
    @Resource
    private TpmCostTypeFineMapper mapper;
    @Resource
    private TpmAuditCollectExampleMapper exampleMapper;

    public Map<String, Map<String, String>> getDicts() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("enable_status");
        dictCodes.add("activity_release_need");
        dictCodes.add("activity_type");
        return DictUtil.getDictValueMapsByCodes((List)dictCodes);
    }

    public void convertListDate(List<TpmCostTypeFineRespVo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Map<String, Map<String, String>> map = this.getDicts();
            list.forEach(o -> {
                if (StringUtils.isNotEmpty((CharSequence)o.getEnableStatus())) {
                    o.setEnableStatusName((String)((Map)Optional.ofNullable(map.get("enable_status")).orElse(Maps.newHashMap())).get(o.getEnableStatus()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getActivityReleaseNeed())) {
                    o.setActivityReleaseNeedName((String)((Map)Optional.ofNullable(map.get("activity_release_need")).orElse(Maps.newHashMap())).get(o.getActivityReleaseNeed()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getActivityType())) {
                    o.setActivityTypeName((String)((Map)Optional.ofNullable(map.get("activity_type")).orElse(Maps.newHashMap())).get(o.getActivityType()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getPayTypeList())) {
                    o.setPayTypeName((String)((Map)Optional.ofNullable(map.get("pay_type_d")).orElse(Maps.newHashMap())).get(o.getPayTypeList()));
                }
            });
        }
    }

    public LambdaQueryWrapper<TpmCostTypeFineEntity> getQueryWrapper(TpmCostTypeFineReqVo reqVo) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.like(StringUtils.isNotEmpty((CharSequence)reqVo.getFineCode()), TpmCostTypeFineEntity::getFineCode, (Object)reqVo.getFineCode());
        wrapper.like(StringUtils.isNotEmpty((CharSequence)reqVo.getFineName()), TpmCostTypeFineEntity::getFineName, (Object)reqVo.getFineName());
        wrapper.eq(StringUtils.isNotEmpty((CharSequence)reqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)reqVo.getEnableStatus());
        return wrapper;
    }

    public void updateBySelectAll(TpmCostTypeFineReqVo reqVo, TpmCostTypeFineEntity entity) {
        LambdaQueryWrapper<TpmCostTypeFineEntity> queryWrapper = this.getQueryWrapper(reqVo);
        this.mapper.update((Object)entity, (Wrapper)queryWrapper);
    }

    public void saveCheck(TpmCostTypeFineReqVo reqVo) {
        if (StringUtils.isEmpty((CharSequence)reqVo.getFineCode())) {
            reqVo.setFineCode(CodeUtil.createOneCode((String)"tpm_cost_type_fine"));
        }
        AssertUtils.isNotEmpty((String)reqVo.getFineCode(), (String)"\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getFineName(), (String)"\u8bf7\u8f93\u5165\u6d3b\u52a8\u7ec6\u7c7b\u540d\u79f0");
        super.isJsonArray(reqVo.getPayTypeList(), "\u652f\u4ed8\u65b9\u5f0f\u5fc5\u987b\u662f\u6570\u7ec4\u683c\u5f0f\u7684json\u5b57\u7b26\u4e32");
        super.isJsonArray(reqVo.getCollectRequireList(), "\u91c7\u96c6\u8981\u6c42\u5fc5\u987b\u662f\u6570\u7ec4\u683c\u5f0f\u7684json\u5b57\u7b26\u4e32");
        super.isJsonArray(reqVo.getAuditRequireList(), "\u6838\u9500\u8d44\u6599\u8981\u6c42\u5fc5\u987b\u662f\u6570\u7ec4\u683c\u5f0f\u7684json\u5b57\u7b26\u4e32");
        if (StringUtils.isEmpty((CharSequence)reqVo.getIsAudit())) {
            reqVo.setIsAudit(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.equals((CharSequence)GlobalWhetherEnum.YES.getCode(), (CharSequence)reqVo.getIsAudit())) {
            if (StringUtils.isEmpty((CharSequence)reqVo.getIsAutoAudit())) {
                reqVo.setIsAutoAudit(GlobalWhetherEnum.NO.getCode());
            }
            if (StringUtils.isEmpty((CharSequence)reqVo.getIsAllowRepeatAudit())) {
                reqVo.setIsAllowRepeatAudit(GlobalWhetherEnum.NO.getCode());
            }
        }
        if (StringUtils.isEmpty((CharSequence)reqVo.getEnableStatus())) {
            reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        }
        if (StringUtils.isEmpty((CharSequence)reqVo.getIsSendSfa())) {
            reqVo.setIsSendSfa(GlobalWhetherEnum.NO.getCode());
        }
        if (StringUtils.isEmpty((CharSequence)reqVo.getIsShareToProduct())) {
            reqVo.setIsShareToProduct(GlobalWhetherEnum.NO.getCode());
        }
        this.checkDataExist(reqVo);
    }

    public void checkDataExist(TpmCostTypeFineReqVo reqVo) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmCostTypeFineEntity::getFineCode, (Object)reqVo.getFineCode());
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            wrapper.ne(BaseIdEntity::getId, (Object)reqVo.getId());
        }
        TpmCostTypeFineEntity entity = (TpmCostTypeFineEntity)((Object)this.mapper.selectOne((Wrapper)wrapper));
        AssertUtils.isTrue((boolean)Objects.isNull((Object)entity), (CrmExceptionType)CostTypeFineException.DATA_DUPLICATE, (String[])new String[0]);
    }

    public List<TpmAuditCollectExampleRespVo> getExamples(String listJson) {
        List codes = JSON.parseArray((String)listJson, String.class);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(TpmAuditCollectExampleEntity::getExampleCode, (Collection)codes);
        return this.exampleMapper.selectList((Wrapper)queryWrapper).stream().filter(Objects::nonNull).map(o -> {
            TpmAuditCollectExampleRespVo vo = new TpmAuditCollectExampleRespVo();
            vo.setExampleCode(o.getExampleCode());
            vo.setExampleName(o.getExampleName());
            return vo;
        }).collect(Collectors.toList());
    }

    public List<DictItemVo> getPayTypes(String payTypeList) {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("pay_type_d");
        Map dictValueMapsByCodes = DictUtil.getDictValueMapsByCodes((List)dictCodes);
        Map map = Optional.ofNullable(dictValueMapsByCodes.get("pay_type_d")).orElse(Maps.newHashMap());
        List codes = JSON.parseArray((String)payTypeList, String.class);
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)codes)) {
            codes.forEach(o -> {
                DictItemVo dictItemVo = new DictItemVo();
                String s = (String)map.get(o);
                dictItemVo.setDictKey(s);
                dictItemVo.setDictValue(o);
                list.add(dictItemVo);
            });
        }
        return list;
    }
}

