/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.advancepay.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.biz.crm.act.mapper.TpmActDetailMapper;
import com.biz.crm.act.mapper.TpmActMapper;
import com.biz.crm.act.model.TpmActDetailEntity;
import com.biz.crm.act.model.TpmActEntity;
import com.biz.crm.advancepay.mapper.TpmActAdvancePayDetailMapper;
import com.biz.crm.advancepay.mapper.TpmActAdvancePayMapper;
import com.biz.crm.advancepay.model.TpmActAdvancePayDetailEntity;
import com.biz.crm.advancepay.model.TpmActAdvancePayEntity;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.ActAdvancePayApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActAdvancePayTypeEnum;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.eunm.tpm.TpmSaveTypeEnum;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.ActAdvancePayException;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.act.req.TaActFileReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.tpm.advancepay.req.TpmActAdvancePayReqVo;
import com.biz.crm.nebular.tpm.advancepay.resp.TpmActAdvancePayRespVo;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetReqVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ActAdvancePayServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(ActAdvancePayServiceHelper.class);
    @Resource
    private TpmActAdvancePayMapper mapper;
    @Resource
    private TpmActAdvancePayDetailMapper detailsMapper;
    @Resource
    private TpmActMapper actMapper;
    @Resource
    private TpmActDetailMapper actDetailMapper;
    @Resource
    private MdmCustomerMsgFeign customerMsgFeign;

    public void convertListDate(List<TpmActAdvancePayRespVo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(o -> {
                if (StringUtils.isNotEmpty((CharSequence)o.getApproveStatus())) {
                    o.setApproveStatusName(ActAdvancePayApproveStatusEnum.getStatusName((String)o.getApproveStatus()));
                }
            });
        }
    }

    public void updateBySelectAll(TpmFeeBudgetReqVo reqVo, TpmActAdvancePayEntity entity) {
    }

    public void saveCheck(TpmActAdvancePayReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getSaveType(), (String)"\u4fdd\u5b58\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isEmpty((CharSequence)reqVo.getAdvanceCode())) {
            String advanceCode = CodeUtil.createOneCode((String)"tpm_act_advance_pay");
            AssertUtils.isNotEmpty((String)advanceCode, (String)"\u6d3b\u52a8\u9884\u4ed8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u8bbe\u7f6e\u7f16\u7801\u89c4\u5219");
            reqVo.setAdvanceCode(advanceCode);
        }
        AssertUtils.isNotEmpty((String)reqVo.getAdvanceType(), (String)"\u6d3b\u52a8\u9884\u4ed8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.equals((CharSequence)ActAdvancePayTypeEnum.CUSTOMER.getCode(), (CharSequence)reqVo.getAdvanceType())) {
            AssertUtils.isNotEmpty((String)reqVo.getCustomerCode(), (String)"\u8bf7\u9009\u62e9\u5ba2\u6237");
            MdmCustomerMsgReqVo customerMsgReqVo = new MdmCustomerMsgReqVo();
            customerMsgReqVo.setCustomerCode(reqVo.getCustomerCode());
            List customers = ((PageResult)this.customerMsgFeign.list(customerMsgReqVo).getResult()).getData();
            if (CollectionUtils.isEmpty((Collection)customers)) {
                MdmCustomerMsgRespVo customerMsgRespVo = (MdmCustomerMsgRespVo)customers.get(0);
                AssertUtils.isNotNull((Object)customerMsgRespVo, (String)"\u60a8\u9009\u62e9\u7684\u5ba2\u6237\u4e0d\u5b58\u5728");
                AssertUtils.isNotEmpty((String)customerMsgRespVo.getCustomerOrgCode(), (String)"\u60a8\u9009\u62e9\u7684\u5ba2\u6237\u6240\u5c5e\u7ec4\u7ec7\u6570\u636e\u4e0d\u5b8c\u6574");
                AssertUtils.isNotEmpty((String)customerMsgRespVo.getOrgCode(), (String)"\u60a8\u9009\u62e9\u7684\u5ba2\u6237\u7ec4\u7ec7\u6570\u636e\u4e0d\u5b8c\u6574");
                reqVo.setCustomerName(customerMsgRespVo.getCustomerName());
                reqVo.setCustomerOrgCode(customerMsgRespVo.getCustomerOrgCode());
                reqVo.setCustomerOrgName(customerMsgRespVo.getCustomerOrgName());
            }
        } else if (StringUtils.equals((CharSequence)ActAdvancePayTypeEnum.ACT.getCode(), (CharSequence)reqVo.getAdvanceType())) {
            AssertUtils.isNotEmpty((String)reqVo.getActCode(), (String)"\u8bf7\u9009\u62e9\u6d3b\u52a8");
            TpmActEntity actEntity = (TpmActEntity)((Object)this.actMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(TpmActEntity::getActCode, (Object)reqVo.getActCode())));
            AssertUtils.isNotNull((Object)((Object)actEntity), (String)("\u6d3b\u52a8\u6570\u636e\u4e0d\u5b58\u5728,\u7f16\u7801:" + reqVo.getActCode()));
            AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)ActApproveStatusEnum.APPROVED.getCode(), (CharSequence)actEntity.getApproveStatus()), (String)"\u5ba1\u6279\u672a\u901a\u8fc7\u7684\u6d3b\u52a8\u4e0d\u80fd\u8fdb\u884c\u9884\u4ed8");
            AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)GlobalWhetherEnum.NO.getCode(), (CharSequence)actEntity.getIsAudit()), (String)"\u5df2\u7ecf\u6838\u9500\u7684\u6d3b\u52a8\u4e0d\u80fd\u8fdb\u884c\u9884\u4ed8");
            reqVo.setActName(actEntity.getActName());
            reqVo.setBeginDate(actEntity.getBeginDate());
            reqVo.setBeginDateSecond(actEntity.getBeginDateSecond());
            reqVo.setEndDate(actEntity.getEndDate());
            reqVo.setEndDateSecond(actEntity.getEndDateSecond());
        } else {
            throw new BusinessException("\u9884\u4ed8\u7c7b\u578b\u503c\u9519\u8bef");
        }
        this.saveCheckDetails(reqVo);
        this.checkDataExist(reqVo);
    }

    public void saveCheckDetails(TpmActAdvancePayReqVo reqVo) {
        List detailVos = reqVo.getDetailVos();
        AssertUtils.isNotEmpty((Collection)detailVos, (String)"\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        HashSet actDetailCodes = Sets.newHashSet();
        HashSet actCodes = Sets.newHashSet();
        AtomicReference<BigDecimal> applyAdvanceTotalAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        detailVos.forEach(o -> {
            AssertUtils.isNotNull((Object)o.getApplyAdvanceAmount(), (String)"\u8bf7\u586b\u5199\u672c\u6b21\u9884\u4ed8\u91d1\u989d");
            reqVo.setApplyAdvanceTotalAmount(Optional.ofNullable(reqVo.getApplyAdvanceTotalAmount()).orElse(BigDecimal.ZERO).add(o.getApplyAdvanceAmount()));
            AssertUtils.isNotEmpty((String)o.getActCode(), (String)"\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)o.getActDetailCode(), (String)"\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            applyAdvanceTotalAmount.set(((BigDecimal)applyAdvanceTotalAmount.get()).add(o.getApplyAdvanceAmount()));
            actDetailCodes.add(o.getActDetailCode());
            actCodes.add(o.getActCode());
        });
        AssertUtils.isTrue((actDetailCodes.size() == detailVos.size() ? 1 : 0) != 0, (String)"\u4e0d\u80fd\u9009\u62e9\u91cd\u590d\u7684\u660e\u7ec6\u6570\u636e");
        List tpmActDetailEntities = this.actDetailMapper.selectList((Wrapper)new LambdaQueryWrapper().in(TpmActDetailEntity::getActDetailCode, (Collection)actDetailCodes));
        AssertUtils.isTrue((tpmActDetailEntities.size() == actDetailCodes.size() ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u660e\u7ec6\u6570\u636e\u5f02\u5e38");
        Map actDetailEntityMap = tpmActDetailEntities.stream().collect(Collectors.toMap(TpmActDetailEntity::getActDetailCode, Function.identity()));
        Map<String, BigDecimal> map = this.getActDetailsAdvanceAmount(actDetailCodes);
        if (StringUtils.equals((CharSequence)ActAdvancePayTypeEnum.ACT.getCode(), (CharSequence)reqVo.getAdvanceType())) {
            AssertUtils.isTrue((actCodes.size() == 1 ? 1 : 0) != 0, (String)"\u5f53\u524d\u7c7b\u578b\u7684\u6d3b\u52a8\u9884\u4ed8\u53ea\u80fd\u9009\u62e9\u540c\u4e00\u4e2a\u6d3b\u52a8\u7684\u660e\u7ec6\u6570\u636e");
            AssertUtils.isTrue((boolean)actCodes.contains(reqVo.getActCode()), (String)("\u5f53\u524d\u7c7b\u578b\u7684\u6d3b\u52a8\u9884\u4ed8\u660e\u7ec6\u6570\u636e\u4e0d\u5c5e\u4e8e\u6d3b\u52a8\u7f16\u7801:" + reqVo.getActCode()));
        }
        reqVo.getDetailVos().forEach(o -> {
            TpmActDetailEntity actDetailEntity = (TpmActDetailEntity)((Object)((Object)actDetailEntityMap.get(o.getActDetailCode())));
            if (StringUtils.equals((CharSequence)ActAdvancePayTypeEnum.CUSTOMER.getCode(), (CharSequence)reqVo.getAdvanceType())) {
                AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)reqVo.getCustomerCode(), (CharSequence)actDetailEntity.getCustomerCode()), (String)("\u6d3b\u52a8\u660e\u7ec6:" + actDetailEntity.getActDetailCode() + "\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5ba2\u6237"));
            }
            AssertUtils.isTrue((Optional.ofNullable(actDetailEntity.getAuditAmount()).orElse(BigDecimal.ZERO).compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)("\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801:" + o.getActDetailCode() + "\u5df2\u7ecf\u4ea7\u751f\u6838\u9500\u6570\u636e,\u4e0d\u80fd\u8fdb\u884c\u9884\u4ed8\u64cd\u4f5c"));
            BigDecimal decimal = Optional.ofNullable(map.get(o.getActDetailCode())).orElse(BigDecimal.ZERO);
            BigDecimal subtract = actDetailEntity.getApplyAmount().subtract(decimal);
            if (o.getApplyAdvanceAmount().compareTo(subtract) > 0) {
                throw new BusinessException("\u6d3b\u52a8\u660e\u7ec6:" + o.getActDetailCode() + "\u5269\u4f59\u53ef\u4ee5\u9884\u4ed8\u7684\u91d1\u989d\u4e3a" + subtract + ",\u8bf7\u91cd\u65b0\u786e\u8ba4");
            }
            if (StringUtils.isEmpty((CharSequence)o.getAdvanceDetailCode())) {
                o.setAdvanceDetailCode(CodeUtil.createOneCode((String)"tpm_act_advance_pay_detail"));
            }
            o.setAlreadyApplyAdvanceTotalAmount(decimal);
            o.setAdvanceCode(reqVo.getAdvanceCode());
            o.setAlreadyApplyAdvanceTotalAmount(decimal);
            o.setActCode(actDetailEntity.getActCode());
            o.setActDetailCode(actDetailEntity.getActDetailCode());
            o.setFineCode(actDetailEntity.getFineCode());
            o.setFineName(actDetailEntity.getFineName());
            o.setCustomerCode(actDetailEntity.getCustomerCode());
            o.setCustomerName(actDetailEntity.getCustomerName());
            o.setPayType(actDetailEntity.getPayType());
            o.setPayTypeName(actDetailEntity.getPayTypeName());
            o.setApplyAmount(actDetailEntity.getApplyAmount());
            o.setActualAdvancePayMount(BigDecimal.ZERO);
            reqVo.setApplyAdvanceTotalAmount((BigDecimal)applyAdvanceTotalAmount.get());
            reqVo.setActualAdvancePayTotalAmount(BigDecimal.ZERO);
        });
    }

    public Map<String, BigDecimal> getActDetailsAdvanceAmount(Collection<String> codes) {
        ArrayList statuses = Lists.newArrayList();
        statuses.add(ActAdvancePayApproveStatusEnum.APPROVING.getCode());
        statuses.add(ActAdvancePayApproveStatusEnum.APPROVED.getCode());
        List<TpmActAdvancePayDetailEntity> payDetailEntities = this.detailsMapper.getActDetailsAdvanceAmount(codes, statuses);
        HashMap map = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(payDetailEntities)) {
            payDetailEntities.forEach(o -> {
                BigDecimal decimal = (BigDecimal)map.get(o.getActDetailCode());
                if (Objects.isNull(decimal)) {
                    map.put(o.getActDetailCode(), o.getApplyAdvanceAmount());
                } else {
                    map.put(o.getActDetailCode(), decimal.add(o.getApplyAdvanceAmount()));
                }
            });
        }
        return map;
    }

    public String getErrorMsg(TpmActAdvancePayReqVo reqVo) {
        StringBuffer msg = new StringBuffer("\u5df2\u5b58\u5728,");
        return msg.toString();
    }

    public void checkDataExist(TpmActAdvancePayReqVo reqVo) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmActAdvancePayEntity::getAdvanceCode, (Object)reqVo.getAdvanceCode());
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            wrapper.ne(BaseIdEntity::getId, (Object)reqVo.getId());
        }
        TpmActAdvancePayEntity entity = (TpmActAdvancePayEntity)((Object)this.mapper.selectOne((Wrapper)wrapper));
        AssertUtils.isTrue((boolean)Objects.isNull((Object)entity), (CrmExceptionType)ActAdvancePayException.DATA_CODE_DUPLICATE, (String[])new String[0]);
        this.setApproveStatus(reqVo);
    }

    public void setApproveStatus(TpmActAdvancePayReqVo reqVo) {
        if (TpmSaveTypeEnum.getCreateTypes().contains(reqVo.getSaveType())) {
            if (StringUtils.isEmpty((CharSequence)reqVo.getApproveStatus())) {
                reqVo.setApproveStatus(ActAdvancePayApproveStatusEnum.CREATE.getCode());
            }
        } else if (TpmSaveTypeEnum.getApprovingTypes().contains(reqVo.getSaveType())) {
            reqVo.setApproveStatus(ActAdvancePayApproveStatusEnum.APPROVING.getCode());
        }
    }

    public StartProcessReqVo buildStartProcessData(TpmActAdvancePayEntity entity, TpmActAdvancePayReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        StartProcessReqVo startProcessReqVo = new StartProcessReqVo();
        startProcessReqVo.setCallBackFeign("TpmAdvanceCallBackFeign");
        startProcessReqVo.setProcessKey(reqVo.getWorkFlowKey());
        startProcessReqVo.setUserCode(user.getUsername());
        startProcessReqVo.setPosCode(user.getPoscode());
        startProcessReqVo.setTitle(reqVo.getTitle());
        startProcessReqVo.setFormNo(entity.getId());
        startProcessReqVo.setRemark(reqVo.getApproveRemarks());
        startProcessReqVo.setSignTicket(System.currentTimeMillis() + "");
        startProcessReqVo.setBusinessCode(entity.getAdvanceCode());
        List taActFileReqVos = Optional.ofNullable(reqVo.getActivityFileList()).orElse(Lists.newArrayList()).stream().map(o -> {
            TaActFileReqVo taActFileReqVo = new TaActFileReqVo();
            taActFileReqVo.setObjectName(o.getObjectName());
            taActFileReqVo.setFileAddress(o.getFileAddress());
            return taActFileReqVo;
        }).collect(Collectors.toList());
        startProcessReqVo.setFileList(taActFileReqVos);
        return startProcessReqVo;
    }
}

