/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.income.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.income.service.ITpmIncomeBudgetService;
import com.biz.crm.nebular.tpm.income.req.TpmIncomeBudgetReqVo;
import com.biz.crm.nebular.tpm.income.resp.TpmIncomeBudgetRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tpmincomebudget"})
@Api(tags={"\u6536\u5165\u9884\u7b97;"})
public class TpmIncomeBudgetController {
    private static final Logger log = LoggerFactory.getLogger(TpmIncomeBudgetController.class);
    @Autowired
    private ITpmIncomeBudgetService tpmIncomeBudgetService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<TpmIncomeBudgetRespVo>> list(@RequestBody TpmIncomeBudgetReqVo tpmIncomeBudgetReqVo) {
        PageResult<TpmIncomeBudgetRespVo> result = this.tpmIncomeBudgetService.findList(tpmIncomeBudgetReqVo);
        return Result.ok(result);
    }

    @CrmLog
    @ApiOperation(value="query")
    @GetMapping(value={"query"})
    public Result<TpmIncomeBudgetRespVo> query(@RequestParam(value="id", required=true) String id, @RequestParam(value="budgetCode", required=true) String budgetCode) {
        TpmIncomeBudgetRespVo tpmIncomeBudgetRespVo = this.tpmIncomeBudgetService.queryView(id, budgetCode);
        return Result.ok((Object)tpmIncomeBudgetRespVo);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @PostMapping(value={"/query"})
    @CrmLog
    public Result<TpmIncomeBudgetRespVo> query(@RequestBody TpmIncomeBudgetReqVo tpmIncomeBudgetReqVo) {
        TpmIncomeBudgetRespVo respVo = this.tpmIncomeBudgetService.query(tpmIncomeBudgetReqVo);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody TpmIncomeBudgetReqVo tpmIncomeBudgetReqVo) {
        this.tpmIncomeBudgetService.save(tpmIncomeBudgetReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody TpmIncomeBudgetReqVo tpmIncomeBudgetReqVo) {
        this.tpmIncomeBudgetService.update(tpmIncomeBudgetReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody TpmIncomeBudgetReqVo tpmIncomeBudgetReqVo) {
        this.tpmIncomeBudgetService.deleteBatch(tpmIncomeBudgetReqVo);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody TpmIncomeBudgetReqVo tpmIncomeBudgetReqVo) {
        this.tpmIncomeBudgetService.enableBatch(tpmIncomeBudgetReqVo);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody TpmIncomeBudgetReqVo tpmIncomeBudgetReqVo) {
        this.tpmIncomeBudgetService.disableBatch(tpmIncomeBudgetReqVo);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }
}

