/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.income.service.impl;

import com.biz.crm.eunm.tpm.IncomeGroupEnum;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.tpm.income.req.TpmIncomeBudgetReqVo;
import com.biz.crm.util.AssertUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InComeHelpService {
    private Map<String, MdmOrgRespVo> mdmOrgRespVoMap;
    private Map<String, MdmTerminalVo> terminalVoMap;
    private Map<String, MdmCustomerMsgRespVo> customerMsgRespVoMap;
    @Autowired
    private MdmOrgFeign mdmOrgFeign;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Autowired
    private MdmTerminalFeign terminalFeign;

    public void checkData(TpmIncomeBudgetReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getIncomeGroupName(), (String)"\u8bf7\u9009\u62e9\u5206\u7ec4");
        HashMap groupMap = Maps.newHashMap();
        groupMap.put(IncomeGroupEnum.ORG.getDes(), IncomeGroupEnum.ORG.getCode());
        groupMap.put(IncomeGroupEnum.CUSTOMER.getDes(), IncomeGroupEnum.CUSTOMER.getCode());
        groupMap.put(IncomeGroupEnum.TERMINAL.getDes(), IncomeGroupEnum.CUSTOMER.getCode());
        if (groupMap.containsKey(reqVo.getIncomeGroupCode())) {
            reqVo.setIncomeGroupCode((String)groupMap.get(reqVo.getIncomeGroupName()));
        }
        AssertUtils.isNotEmpty((String)reqVo.getOrgCode(), (String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.equals((CharSequence)reqVo.getIncomeGroupCode(), (CharSequence)IncomeGroupEnum.CUSTOMER.getCode())) {
            AssertUtils.isNotEmpty((String)reqVo.getCustomerCode(), (String)"\u5206\u7ec4\u4e3a\u5ba2\u6237\u65f6\uff0c\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.equals((CharSequence)reqVo.getIncomeGroupCode(), (CharSequence)IncomeGroupEnum.TERMINAL.getCode())) {
            AssertUtils.isNotEmpty((String)reqVo.getTerminalCode(), (String)"\u5206\u7ec4\u4e3a\u95e8\u5e97\u65f6\uff0c\u95e8\u5e97\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

