/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.tpm.IncomeGroupEnum;
import com.biz.crm.income.mapper.TpmIncomeBudgetMapper;
import com.biz.crm.income.model.TpmIncomeBudgetEntity;
import com.biz.crm.mdm.cusorg.MdmCusOrgFeign;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.mdm.cusorg.CusOrgVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.tpm.income.req.TpmIncomeBudgetReqVo;
import com.biz.crm.nebular.tpm.income.resp.TpmIncomeBudgetRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.DictUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InComeServiceHelp {
    @Autowired
    private MdmCusOrgFeign mdmCusOrgFeign;
    @Autowired
    private MdmOrgFeign mdmOrgFeign;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Autowired
    private MdmTerminalFeign terminalFeign;
    @Resource
    private TpmIncomeBudgetMapper incomeBudgetMapper;
    @Autowired
    private MdmProductFeign productFeign;

    public Map<String, Map<String, String>> getDicts() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("income_group");
        dictCodes.add("fiscal_month");
        dictCodes.add("budget_year");
        dictCodes.add("income_type");
        dictCodes.add("enable_status");
        return DictUtil.getDictValueMapsByCodes((List)dictCodes);
    }

    public void checkData(TpmIncomeBudgetReqVo reqVo) {
        if (StringUtils.isEmpty((CharSequence)reqVo.getIncomeCode())) {
            reqVo.setIncomeCode(CodeUtil.createOneCode((String)"tpm_income_budget"));
        }
        AssertUtils.isNotEmpty((String)reqVo.getIncomeGroupCode(), (String)"\u8bf7\u9009\u62e9\u5206\u7ec4");
        Map<String, String> groupMap = this.getDicts().get("income_group");
        if (!groupMap.containsKey(reqVo.getIncomeGroupCode())) {
            throw new BusinessException("\u6240\u9009\u5206\u7ec4\u4e0d\u5b58\u5728");
        }
        reqVo.setIncomeGroupName(groupMap.get(reqVo.getIncomeGroupCode()));
        if (StringUtils.equals((CharSequence)reqVo.getIncomeGroupCode(), (CharSequence)IncomeGroupEnum.PRODUCT.getCode())) {
            AssertUtils.isNotEmpty((String)reqVo.getProductCode(), (String)"\u5206\u7ec4\u4e3a\u4ea7\u54c1\u65f6\uff0c\u4ea7\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
            MdmProductRespVo mdmProductRespVo = (MdmProductRespVo)this.productFeign.detail("", reqVo.getProductCode()).getResult();
            if (mdmProductRespVo == null) {
                throw new BusinessException("\u8be5\u4ea7\u54c1\u4e0d\u5b58\u5728");
            }
            reqVo.setProductName(mdmProductRespVo.getProductName());
            reqVo.setProductLevelCode(mdmProductRespVo.getProductLevelCode());
            reqVo.setProductLevelName(mdmProductRespVo.getProductLevelName());
        } else {
            AssertUtils.isNotEmpty((String)reqVo.getOrgCode(), (String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
            MdmOrgRespVo mdmOrgRespVo = (MdmOrgRespVo)this.mdmOrgFeign.detail(reqVo.getOrgCode()).getResult();
            if (mdmOrgRespVo == null) {
                throw new BusinessException("\u7ec4\u7ec7\u4e0d\u5b58\u5728");
            }
            reqVo.setOrgName(mdmOrgRespVo.getOrgName());
            List<String> orgCodes = Collections.singletonList(reqVo.getOrgCode());
            if (StringUtils.equals((CharSequence)reqVo.getIncomeGroupCode(), (CharSequence)IncomeGroupEnum.CUSTOMER.getCode())) {
                this.setCustomerData(reqVo, orgCodes);
            }
            if (StringUtils.equals((CharSequence)reqVo.getIncomeGroupCode(), (CharSequence)IncomeGroupEnum.TERMINAL.getCode())) {
                this.setCustomerData(reqVo, orgCodes);
                AssertUtils.isNotEmpty((String)reqVo.getTerminalCode(), (String)"\u5206\u7ec4\u4e3a\u95e8\u5e97\u65f6\uff0c\u95e8\u5e97\u4e0d\u80fd\u4e3a\u7a7a");
                Map terminalVoMap = ((List)this.terminalFeign.findCurrentAndSubTerminalList(orgCodes).getResult()).stream().collect(Collectors.toMap(MdmTerminalVo::getTerminalCode, Function.identity()));
                if (!terminalVoMap.containsKey(reqVo.getTerminalCode())) {
                    throw new BusinessException("\u95e8\u5e97\u4e0d\u5c5e\u4e8e\u6240\u9009\u7ec4\u7ec7");
                }
                reqVo.setTerminalName(((MdmTerminalVo)terminalVoMap.get(reqVo.getTerminalCode())).getTerminalName());
            }
        }
        AssertUtils.isNotEmpty((String)reqVo.getInitAmount().toString(), (String)"\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getIncomeTypeName(), (String)"\u6536\u5165\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Map<String, String> incomeTypeMap = this.getDicts().get("income_type");
        if (StringUtils.isEmpty((CharSequence)reqVo.getIncomeType())) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u9884\u7b97\u7c7b\u578b");
        }
        if (!incomeTypeMap.containsKey(reqVo.getIncomeType())) {
            throw new BusinessException("\u6240\u9009\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        this.checkIsExist(reqVo);
    }

    private void checkIsExist(TpmIncomeBudgetReqVo reqVo) {
        LambdaQueryWrapper wrappers = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TpmIncomeBudgetEntity::getIncomeCode, (Object)reqVo.getIncomeCode());
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            wrappers.ne(BaseIdEntity::getId, (Object)reqVo.getId());
        }
        AssertUtils.isTrue((boolean)Objects.isNull(this.incomeBudgetMapper.selectOne((Wrapper)wrappers)), (String)"\u8be5\u7f16\u7801\u5df2\u5b58\u5728");
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            queryWrapper.ne(BaseIdEntity::getId, (Object)reqVo.getId());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getBudgetMonth()) && StringUtils.isNotEmpty((CharSequence)reqVo.getBudgetYear())) {
            queryWrapper.eq(TpmIncomeBudgetEntity::getBudgetMonth, (Object)reqVo.getBudgetMonth());
            queryWrapper.eq(TpmIncomeBudgetEntity::getBudgetYear, (Object)reqVo.getBudgetYear());
            AssertUtils.isTrue((boolean)Objects.isNull(this.incomeBudgetMapper.selectOne((Wrapper)queryWrapper)), (String)"\u5f53\u524d\u5e74\u6708\u5df2\u6709\u9884\u7b97");
            reqVo.setBudgetYearMonth(reqVo.getBudgetYear() + "-" + reqVo.getBudgetMonth());
        }
    }

    private void setCustomerData(TpmIncomeBudgetReqVo reqVo, List<String> orgCodes) {
        CusOrgVo cusOrgVo;
        AssertUtils.isNotEmpty((String)reqVo.getCustomerCode(), (String)"\u5206\u7ec4\u4e3a\u5ba2\u6237/\u95e8\u5e97\u65f6\uff0c\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo = new MdmCustomerOrgSearchReqVo();
        mdmCustomerOrgSearchReqVo.setOrgCodeList(orgCodes);
        Map customerMsgRespVoMap = ((List)this.mdmCustomerMsgFeign.findCurrentAndSubCustomerList(mdmCustomerOrgSearchReqVo).getResult()).stream().collect(Collectors.toMap(MdmCustomerMsgRespVo::getCustomerCode, Function.identity()));
        if (!customerMsgRespVoMap.containsKey(reqVo.getCustomerCode())) {
            throw new BusinessException("\u7528\u6237\u4e0d\u5c5e\u4e8e\u6240\u9009\u7ec4\u7ec7");
        }
        MdmCustomerMsgRespVo mdmCustomerMsgRespVo = (MdmCustomerMsgRespVo)customerMsgRespVoMap.get(reqVo.getCustomerCode());
        reqVo.setCustomerName(mdmCustomerMsgRespVo.getCustomerName());
        reqVo.setCustomerOrgCode(mdmCustomerMsgRespVo.getCustomerOrgCode());
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getCustomerOrgCode()) && (cusOrgVo = (CusOrgVo)this.mdmCusOrgFeign.query("", reqVo.getCustomerOrgCode()).getResult()) != null && StringUtils.isNotEmpty((CharSequence)cusOrgVo.getCustomerOrgName())) {
            reqVo.setCustomerOrgName(cusOrgVo.getCustomerOrgName());
        }
    }

    public void setRespVoData(TpmIncomeBudgetRespVo respVo) {
        Map<String, String> monthMap = this.getDicts().get("fiscal_month");
        Map<String, String> yearMap = this.getDicts().get("budget_year");
        Map<String, String> enableStatusMap = this.getDicts().get("enable_status");
        Map<String, String> incomeTypeMap = this.getDicts().get("income_type");
        if (StringUtils.isNotEmpty((CharSequence)respVo.getBudgetMonth())) {
            respVo.setBudgetMonthDesc(monthMap.get(respVo.getBudgetMonth()));
        }
        if (StringUtils.isNotEmpty((CharSequence)respVo.getBudgetYear())) {
            respVo.setBudgetYearDesc(yearMap.get(respVo.getBudgetYear()));
            if (StringUtils.isNotEmpty((CharSequence)respVo.getEnableStatus())) {
                respVo.setEnableStatusName(enableStatusMap.get(respVo.getEnableStatus()));
            }
            if (StringUtils.isNotEmpty((CharSequence)respVo.getIncomeType())) {
                respVo.setIncomeTypeName(incomeTypeMap.get(respVo.getIncomeType()));
            }
            if (StringUtils.isNotEmpty((CharSequence)respVo.getBudgetYearMonth())) {
                respVo.setBudgetYearMonthDesc(respVo.getBudgetYearDesc() + respVo.getBudgetMonthDesc());
            }
        }
    }

    public void updateCheck(TpmIncomeBudgetReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u6536\u5165\u9884\u7b97id\u4e0d\u80fd\u4e3a\u7a7a");
        TpmIncomeBudgetEntity entity = (TpmIncomeBudgetEntity)((Object)this.incomeBudgetMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(BaseIdEntity::getId, (Object)reqVo.getId())));
        AssertUtils.isNotNull((Object)((Object)entity), (String)"\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728");
    }
}

