/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.income.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.income.mapper.TpmIncomeBudgetMapper;
import com.biz.crm.income.model.TpmIncomeBudgetEntity;
import com.biz.crm.income.service.ITpmIncomeBudgetService;
import com.biz.crm.income.service.impl.InComeServiceHelp;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.tpm.income.req.TpmIncomeBudgetReqVo;
import com.biz.crm.nebular.tpm.income.resp.TpmIncomeBudgetRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmIncomeBudgetServiceExpandImpl"})
public class TpmIncomeBudgetServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmIncomeBudgetMapper, TpmIncomeBudgetEntity>
implements ITpmIncomeBudgetService {
    private static final Logger log = LoggerFactory.getLogger(TpmIncomeBudgetServiceImpl.class);
    @Resource
    private TpmIncomeBudgetMapper tpmIncomeBudgetMapper;
    @Autowired
    private InComeServiceHelp inComeHelpService;
    @Autowired
    private MdmOrgFeign mdmOrgFeign;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Autowired
    private MdmTerminalFeign terminalFeign;
    @Autowired
    private MdmProductFeign mdmProductFeign;

    @Override
    public PageResult<TpmIncomeBudgetRespVo> findList(TpmIncomeBudgetReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<TpmIncomeBudgetRespVo> list = this.tpmIncomeBudgetMapper.findList((Page<TpmIncomeBudgetRespVo>)page, reqVo);
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(o -> this.inComeHelpService.setRespVoData((TpmIncomeBudgetRespVo)o));
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmIncomeBudgetRespVo query(String id) {
        AssertUtils.isNotEmpty((String)id, (CrmExceptionType)CommonException.IDS_NULL);
        TpmIncomeBudgetEntity tpmIncomeBudgetEntity = (TpmIncomeBudgetEntity)((Object)this.tpmIncomeBudgetMapper.selectById((Serializable)((Object)id)));
        AssertUtils.isNotNull((Object)((Object)tpmIncomeBudgetEntity), (String)"\u67e5\u8be2\u6570\u636e\u53d1\u751f\u53d8\u5316,\u6570\u636e\u4e0d\u5b58\u5728");
        TpmIncomeBudgetRespVo tpmIncomeBudgetRespVo = (TpmIncomeBudgetRespVo)CrmBeanUtil.copy((Object)((Object)tpmIncomeBudgetEntity), TpmIncomeBudgetRespVo.class);
        this.inComeHelpService.setRespVoData(tpmIncomeBudgetRespVo);
        return tpmIncomeBudgetRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TpmIncomeBudgetReqVo reqVo) {
        this.inComeHelpService.checkData(reqVo);
        TpmIncomeBudgetEntity entity = (TpmIncomeBudgetEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmIncomeBudgetEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TpmIncomeBudgetReqVo reqVo) {
        this.inComeHelpService.updateCheck(reqVo);
        this.inComeHelpService.checkData(reqVo);
        TpmIncomeBudgetEntity entity = (TpmIncomeBudgetEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmIncomeBudgetEntity.class));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List tpmIncomeBudgetEntities = this.tpmIncomeBudgetMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)tpmIncomeBudgetEntities)) {
            tpmIncomeBudgetEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmIncomeBudgetEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List tpmIncomeBudgetEntities = this.tpmIncomeBudgetMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)tpmIncomeBudgetEntities)) {
            tpmIncomeBudgetEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmIncomeBudgetEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchDelete(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List entities = this.tpmIncomeBudgetMapper.selectBatchIds(ids);
        ArrayList removeIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            entities.forEach(o -> removeIds.add(o.getId()));
            this.removeByIds(removeIds);
        }
    }

    @Override
    public List<MdmOrgRespVo> findAllOrgCodes(MdmOrgReqVo mdmOrgReqVo) {
        Result orgRespVos;
        mdmOrgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        try {
            orgRespVos = this.mdmOrgFeign.findOrgList(mdmOrgReqVo);
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
            throw new BusinessException("\u6536\u5165\u9884\u7b97\u65b0\u589e\u83b7\u53d6\u6240\u6709\u7ec4\u7ec7,\u8c03\u7528mdm\u63a5\u53e3\u5931\u8d25");
        }
        return (List)ApiResultUtil.objResult((Result)orgRespVos, (boolean)true);
    }

    @Override
    public List<MdmCustomerMsgRespVo> findCustomerByOrgCode(List<String> codes) {
        Result customerOrgRespVos;
        MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo = new MdmCustomerOrgSearchReqVo();
        mdmCustomerOrgSearchReqVo.setOrgCodeList(codes);
        try {
            customerOrgRespVos = this.mdmCustomerMsgFeign.findCurrentAndSubCustomerList(mdmCustomerOrgSearchReqVo);
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
            throw new BusinessException("\u6536\u5165\u9884\u7b97\u65b0\u589e\u83b7\u53d6\u5bf9\u5e94\u5ba2\u6237,\u8c03\u7528mdm\u63a5\u53e3\u5931\u8d25");
        }
        return (List)ApiResultUtil.objResult((Result)customerOrgRespVos, (boolean)true);
    }

    @Override
    public List<MdmTerminalVo> findTerminalByOrgCode(List<String> codes) {
        Result terminalRespVos;
        try {
            terminalRespVos = this.terminalFeign.findCurrentAndSubTerminalList(codes);
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
            throw new BusinessException("\u6536\u5165\u9884\u7b97\u65b0\u589e\u83b7\u53d6\u5bf9\u5e94\u95e8\u5e97,\u8c03\u7528mdm\u63a5\u53e3\u5931\u8d25");
        }
        return (List)ApiResultUtil.objResult((Result)terminalRespVos, (boolean)true);
    }

    @Override
    public List<MdmProductRespVo> findAllProduct(MdmProductReqVo mdmProductReqVo) {
        Result productRespVos;
        try {
            mdmProductReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            productRespVos = this.mdmProductFeign.listCondition(mdmProductReqVo);
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
            throw new BusinessException("\u6536\u5165\u9884\u7b97\u83b7\u53d6\u5546\u54c1\uff0c\u8c03\u7528mdm\u63a5\u53e3\u5931\u8d25");
        }
        return (List)ApiResultUtil.objResult((Result)productRespVos, (boolean)true);
    }
}

