/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.tpm.IncomeGroupEnum;
import com.biz.crm.income.mapper.TpmIncomeBudgetMapper;
import com.biz.crm.income.model.TpmIncomeBudgetEntity;
import com.biz.crm.mdm.cusorg.MdmCusOrgFeign;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.mdm.productlevel.MdmProductLevelFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.mdm.cusorg.CusOrgVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelSelectReqVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelSelectRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmCustomerTerminalVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.tpm.income.req.TpmIncomeBudgetReqVo;
import com.biz.crm.nebular.tpm.income.resp.TpmIncomeBudgetRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InComeServiceHelp {
    @Autowired
    private MdmCusOrgFeign mdmCusOrgFeign;
    @Autowired
    private MdmOrgFeign mdmOrgFeign;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Autowired
    private MdmTerminalFeign terminalFeign;
    @Resource
    private TpmIncomeBudgetMapper incomeBudgetMapper;
    @Autowired
    private MdmProductFeign productFeign;
    @Autowired
    private MdmProductLevelFeign mdmProductLevelFeign;

    public Map<String, Map<String, String>> getDicts() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("income_group");
        dictCodes.add("fiscal_month");
        dictCodes.add("budget_year");
        dictCodes.add("income_type");
        dictCodes.add("enable_status");
        return DictUtil.getDictValueMapsByCodes((List)dictCodes);
    }

    public void checkData(TpmIncomeBudgetReqVo reqVo) {
        Map<String, Map<String, String>> globalMaps = this.getDicts();
        if (StringUtils.isEmpty((CharSequence)reqVo.getIncomeCode())) {
            reqVo.setIncomeCode(CodeUtil.createOneCode((String)"tpm_income_budget"));
        }
        AssertUtils.isNotEmpty((String)reqVo.getIncomeGroupCode(), (String)"\u8bf7\u9009\u62e9\u5206\u7ec4");
        if (!Optional.ofNullable(globalMaps.get("income_group")).orElse(Maps.newHashMap()).containsKey(reqVo.getIncomeGroupCode())) {
            throw new BusinessException("\u6240\u9009\u5206\u7ec4\u4e0d\u5b58\u5728");
        }
        reqVo.setIncomeGroupName(globalMaps.get("income_group").get(reqVo.getIncomeGroupCode()));
        if (StringUtils.equals((CharSequence)reqVo.getIncomeGroupCode(), (CharSequence)IncomeGroupEnum.PRODUCT.getCode())) {
            AssertUtils.isNotEmpty((String)reqVo.getProductLevelCode(), (String)"\u5206\u7ec4\u4e3a\u4ea7\u54c1\u65f6\uff0c\u4ea7\u54c1\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a");
            MdmProductLevelRespVo productLevelRespVo = (MdmProductLevelRespVo)ApiResultUtil.objResult((Result)this.mdmProductLevelFeign.detail("", reqVo.getProductLevelCode()));
            AssertUtils.isNotNull((Object)productLevelRespVo, (String)"\u4e0d\u5b58\u5728\u8be5\u4ea7\u54c1\u5c42\u7ea7");
            List productLevelSelectRespVos = (List)ApiResultUtil.objResult((Result)this.mdmProductLevelFeign.productLevelSelectList(new MdmProductLevelSelectReqVo()));
            Map<Object, Object> productLevelSelectRespVoMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty((Collection)productLevelSelectRespVos)) {
                productLevelSelectRespVoMap = productLevelSelectRespVos.stream().collect(Collectors.toMap(MdmProductLevelSelectRespVo::getProductLevelCode, Function.identity()));
            }
            if (!productLevelSelectRespVoMap.containsKey(reqVo.getProductLevelCode())) {
                throw new BusinessException("\u6240\u9009\u5c42\u7ea7\u4e0d\u5728\u53ef\u9009\u8303\u56f4");
            }
            reqVo.setProductLevelName(productLevelRespVo.getProductLevelName());
            List<String> productLevelCodeList = Collections.singletonList(reqVo.getProductLevelCode());
            List productRespVos = (List)ApiResultUtil.objResult((Result)this.productFeign.queryBatchByProductLevelCodeList(productLevelCodeList));
            AssertUtils.isNotEmpty((String)reqVo.getProductCode(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            Map productRespVoMap = productRespVos.stream().collect(Collectors.toMap(MdmProductRespVo::getProductCode, Function.identity()));
            if (!productRespVoMap.containsKey(reqVo.getProductCode())) {
                throw new BusinessException("\u4ea7\u54c1\u4e0d\u5c5e\u4e8e\u6240\u9009\u5c42\u7ea7");
            }
            reqVo.setProductName(((MdmProductRespVo)productRespVoMap.get(reqVo.getProductCode())).getProductName());
        } else {
            AssertUtils.isNotEmpty((String)reqVo.getOrgCode(), (String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
            MdmOrgRespVo mdmOrgRespVo = (MdmOrgRespVo)ApiResultUtil.objResult((Result)this.mdmOrgFeign.detail(reqVo.getOrgCode()));
            AssertUtils.isNotNull((Object)mdmOrgRespVo, (String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728");
            MdmOrgReqVo mdmOrgReqVo = new MdmOrgReqVo();
            mdmOrgReqVo.setOrgCode(UserUtils.getUser().getOrgcode());
            List orgRespVos = (List)ApiResultUtil.objResult((Result)this.mdmOrgFeign.findAllChildrenOrgList(mdmOrgReqVo));
            Map orgRespVoMap = orgRespVos.stream().collect(Collectors.toMap(MdmOrgRespVo::getOrgCode, Function.identity()));
            if (!orgRespVoMap.containsKey(reqVo.getOrgCode())) {
                throw new BusinessException("\u53ea\u80fd\u9009\u62e9\u81ea\u5df1\u7684\u7ec4\u7ec7\u6216\u4e0b\u7ea7\u7ec4\u7ec7");
            }
            reqVo.setOrgName(((MdmOrgRespVo)orgRespVoMap.get(reqVo.getOrgCode())).getOrgName());
            List<String> orgCodes = Collections.singletonList(reqVo.getOrgCode());
            if (StringUtils.equals((CharSequence)reqVo.getIncomeGroupCode(), (CharSequence)IncomeGroupEnum.CUSTOMER.getCode())) {
                this.setCustomerData(reqVo, orgCodes);
            }
            if (StringUtils.equals((CharSequence)reqVo.getIncomeGroupCode(), (CharSequence)IncomeGroupEnum.TERMINAL.getCode())) {
                this.setCustomerData(reqVo, orgCodes);
                AssertUtils.isNotEmpty((String)reqVo.getTerminalCode(), (String)"\u5206\u7ec4\u4e3a\u95e8\u5e97\u65f6\uff0c\u95e8\u5e97\u4e0d\u80fd\u4e3a\u7a7a");
                MdmCustomerTerminalVo mdmCustomerTerminalVo = new MdmCustomerTerminalVo();
                List<String> customerList = Collections.singletonList(reqVo.getCustomerCode());
                mdmCustomerTerminalVo.setCustomerCodeList(customerList);
                List mdmTerminalVos = (List)ApiResultUtil.objResult((Result)this.terminalFeign.customerTerminalList(mdmCustomerTerminalVo));
                MdmTerminalVo mdmTerminalVo = (MdmTerminalVo)ApiResultUtil.objResult((Result)this.terminalFeign.query("", reqVo.getTerminalCode()));
                AssertUtils.isNotNull((Object)mdmTerminalVo, (String)"\u95e8\u5e97\u4e0d\u5b58\u5728");
                Map mdmTerminalVoMap = mdmTerminalVos.stream().collect(Collectors.toMap(MdmTerminalVo::getTerminalCode, Function.identity()));
                if (!mdmTerminalVoMap.containsKey(reqVo.getTerminalCode())) {
                    throw new BusinessException("\u95e8\u5e97\u4e0d\u5c5e\u4e8e\u6240\u9009\u7ec4\u7ec7");
                }
                reqVo.setTerminalName(((MdmTerminalVo)mdmTerminalVoMap.get(reqVo.getTerminalCode())).getTerminalName());
            }
        }
        AssertUtils.isNotEmpty((String)reqVo.getInitAmount().toString(), (String)"\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getIncomeType(), (String)"\u6536\u5165\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getBudgetYear(), (String)"\u9884\u7b97\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getBudgetMonth(), (String)"\u9884\u7b97\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        reqVo.setBudgetYearMonth(reqVo.getBudgetYear() + "-" + reqVo.getBudgetMonth());
        AssertUtils.isNotEmpty((String)reqVo.getIncomeType(), (String)"\u9884\u7b97\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (!Optional.ofNullable(globalMaps.get("income_type")).orElse(Maps.newHashMap()).containsKey(reqVo.getIncomeType())) {
            throw new BusinessException("\u6536\u5165\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        reqVo.setIncomeTypeName(globalMaps.get("income_type").get(reqVo.getIncomeType()));
        this.checkIsExist(reqVo);
    }

    private void checkIsExist(TpmIncomeBudgetReqVo reqVo) {
        int countSize;
        int count;
        LambdaQueryWrapper wrappers = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TpmIncomeBudgetEntity::getIncomeCode, (Object)reqVo.getIncomeCode());
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            wrappers.ne(BaseIdEntity::getId, (Object)reqVo.getId());
        }
        if ((count = CollectionUtils.size((Object)this.incomeBudgetMapper.selectList((Wrapper)wrappers))) > 0) {
            if (count == 1) {
                throw new BusinessException("\u8be5\u7f16\u7801\u5b58\u5728");
            }
            throw new BusinessException("\u6570\u636e\u5e93\u5f02\u5e38");
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(TpmIncomeBudgetEntity::getBudgetMonth, (Object)reqVo.getBudgetMonth());
        queryWrapper.eq(TpmIncomeBudgetEntity::getBudgetYear, (Object)reqVo.getBudgetYear());
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            queryWrapper.ne(BaseIdEntity::getId, (Object)reqVo.getId());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getProductCode())) {
            queryWrapper.eq(TpmIncomeBudgetEntity::getProductLevelCode, (Object)reqVo.getProductLevelCode());
            queryWrapper.eq(TpmIncomeBudgetEntity::getProductCode, (Object)reqVo.getProductCode());
            countSize = this.incomeBudgetMapper.selectList((Wrapper)queryWrapper).size();
            if (countSize > 0) {
                if (countSize == 1) {
                    throw new BusinessException("\u8be5\u9884\u7b97\u5b58\u5728\u76f8\u540c\u5e74\u6708");
                }
                throw new BusinessException("\u6570\u636e\u5e93\u5f02\u5e38");
            }
        }
        queryWrapper.eq(TpmIncomeBudgetEntity::getOrgCode, (Object)reqVo.getOrgCode());
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getOrgCode()) && StringUtils.isEmpty((CharSequence)reqVo.getCustomerCode()) && (countSize = this.incomeBudgetMapper.selectList((Wrapper)queryWrapper).size()) > 0) {
            if (countSize == 1) {
                throw new BusinessException("\u8be5\u9884\u7b97\u5b58\u5728\u76f8\u540c\u5e74\u6708");
            }
            throw new BusinessException("\u6570\u636e\u5e93\u5f02\u5e38");
        }
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getCustomerCode()) && StringUtils.isEmpty((CharSequence)reqVo.getTerminalCode())) {
            queryWrapper.eq(TpmIncomeBudgetEntity::getCustomerCode, (Object)reqVo.getCustomerCode());
            countSize = this.incomeBudgetMapper.selectList((Wrapper)queryWrapper).size();
            if (countSize > 0) {
                if (countSize == 1) {
                    throw new BusinessException("\u8be5\u9884\u7b97\u5b58\u5728\u76f8\u540c\u5e74\u6708");
                }
                throw new BusinessException("\u6570\u636e\u5e93\u5f02\u5e38");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getTerminalCode())) {
            queryWrapper.eq(TpmIncomeBudgetEntity::getCustomerCode, (Object)reqVo.getCustomerCode());
            queryWrapper.eq(TpmIncomeBudgetEntity::getTerminalCode, (Object)reqVo.getTerminalCode());
            countSize = this.incomeBudgetMapper.selectList((Wrapper)queryWrapper).size();
            if (countSize > 0) {
                if (countSize == 1) {
                    throw new BusinessException("\u8be5\u9884\u7b97\u5b58\u5728\u76f8\u540c\u5e74\u6708");
                }
                throw new BusinessException("\u6570\u636e\u5e93\u5f02\u5e38");
            }
        }
    }

    private void setCustomerData(TpmIncomeBudgetReqVo reqVo, List<String> orgCodes) {
        CusOrgVo cusOrgVo;
        AssertUtils.isNotEmpty((String)reqVo.getCustomerCode(), (String)"\u5206\u7ec4\u4e3a\u5ba2\u6237/\u95e8\u5e97\u65f6\uff0c\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo = new MdmCustomerOrgSearchReqVo();
        mdmCustomerOrgSearchReqVo.setOrgCodeList(orgCodes);
        Map customerMsgRespVoMap = ((List)ApiResultUtil.objResult((Result)this.mdmCustomerMsgFeign.findCurrentAndSubCustomerList(mdmCustomerOrgSearchReqVo))).stream().collect(Collectors.toMap(MdmCustomerMsgRespVo::getCustomerCode, Function.identity()));
        if (!customerMsgRespVoMap.containsKey(reqVo.getCustomerCode())) {
            throw new BusinessException("\u5ba2\u6237\u4e0d\u5c5e\u4e8e\u6240\u9009\u7ec4\u7ec7");
        }
        MdmCustomerMsgRespVo customerMsgRespVo = (MdmCustomerMsgRespVo)ApiResultUtil.objResult((Result)this.mdmCustomerMsgFeign.query("", reqVo.getCustomerCode()));
        AssertUtils.isNotNull((Object)customerMsgRespVo, (String)"\u5ba2\u6237\u4e0d\u5b58\u5728");
        MdmCustomerMsgRespVo mdmCustomerMsgRespVo = (MdmCustomerMsgRespVo)customerMsgRespVoMap.get(reqVo.getCustomerCode());
        reqVo.setCustomerName(mdmCustomerMsgRespVo.getCustomerName());
        reqVo.setCustomerOrgCode(mdmCustomerMsgRespVo.getCustomerOrgCode());
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getCustomerOrgCode()) && StringUtils.isNotEmpty((CharSequence)(cusOrgVo = (CusOrgVo)ApiResultUtil.objResult((Result)this.mdmCusOrgFeign.query("", reqVo.getCustomerOrgCode()))).getCustomerOrgName())) {
            reqVo.setCustomerOrgName(cusOrgVo.getCustomerOrgName());
        }
    }

    public void setRespVoData(TpmIncomeBudgetRespVo respVo) {
        Map<String, Map<String, String>> globalMaps = this.getDicts();
        if (StringUtils.isNotEmpty((CharSequence)respVo.getBudgetMonth())) {
            respVo.setBudgetMonthDesc(Optional.ofNullable(globalMaps.get("budget_mouth")).orElse(Maps.newHashMap()).get(respVo.getBudgetMonth()));
        }
        if (StringUtils.isNotEmpty((CharSequence)respVo.getBudgetYear())) {
            respVo.setBudgetYearDesc(Optional.ofNullable(globalMaps.get("budget_year")).orElse(Maps.newHashMap()).get(respVo.getBudgetYear()));
            if (StringUtils.isNotEmpty((CharSequence)respVo.getEnableStatus())) {
                respVo.setEnableStatusName(Optional.ofNullable(globalMaps.get("enable_status")).orElse(Maps.newHashMap()).get(respVo.getEnableStatus()));
            }
            if (StringUtils.isNotEmpty((CharSequence)respVo.getIncomeType())) {
                respVo.setIncomeTypeName(Optional.ofNullable(globalMaps.get("income_type")).orElse(Maps.newHashMap()).get(respVo.getIncomeType()));
            }
            if (StringUtils.isNotEmpty((CharSequence)respVo.getBudgetYearMonth())) {
                respVo.setBudgetYearMonthDesc(respVo.getBudgetYearDesc() + respVo.getBudgetMonthDesc());
            }
        }
    }

    public void updateCheck(TpmIncomeBudgetReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u6536\u5165\u9884\u7b97id\u4e0d\u80fd\u4e3a\u7a7a");
        List listEntity = this.incomeBudgetMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(BaseIdEntity::getId, (Object)reqVo.getId()));
        if (CollectionUtils.size((Object)listEntity) > 1) {
            throw new BusinessException("\u6570\u636e\u5f02\u5e38");
        }
        if (CollectionUtils.size((Object)listEntity) < 1) {
            throw new BusinessException("\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728");
        }
    }
}

