/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.financesubject.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.financesubject.mapper.TpmFinanceSubjectMapper;
import com.biz.crm.financesubject.model.TpmFinanceSubjectEntity;
import com.biz.crm.financesubject.service.TpmFinanceSubjectService;
import com.biz.crm.financesubject.service.impl.FinanceSubjectHelp;
import com.biz.crm.nebular.tpm.financesubject.req.TpmFinanceSubjectReqVo;
import com.biz.crm.nebular.tpm.financesubject.resp.TpmFinanceSubjectRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmFinanceSubjectServiceImpl"})
public class TpmFinanceSubjectServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmFinanceSubjectMapper, TpmFinanceSubjectEntity>
implements TpmFinanceSubjectService {
    private static final Logger log = LoggerFactory.getLogger(TpmFinanceSubjectServiceImpl.class);
    @Resource
    private TpmFinanceSubjectMapper financeSubjectMapper;
    @Autowired
    private FinanceSubjectHelp financeSubjectHelp;

    @Override
    public PageResult<TpmFinanceSubjectRespVo> findList(TpmFinanceSubjectReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<TpmFinanceSubjectRespVo> list = this.financeSubjectMapper.findList((Page<TpmFinanceSubjectRespVo>)page, reqVo);
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(o -> this.financeSubjectHelp.setRespVoData((TpmFinanceSubjectRespVo)o));
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmFinanceSubjectRespVo queryView(String id) {
        AssertUtils.isNotEmpty((String)id, (CrmExceptionType)CommonException.IDS_NULL);
        List financeSubjectEntities = this.financeSubjectMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(BaseIdEntity::getId, (Object)id));
        if (CollectionUtils.size((Object)financeSubjectEntities) > 1) {
            throw new BusinessException("\u67e5\u8be2\u7ed3\u679c\u5927\u4e8e1\u6761");
        }
        if (CollectionUtils.isEmpty((Collection)financeSubjectEntities)) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        TpmFinanceSubjectRespVo respVo = (TpmFinanceSubjectRespVo)CrmBeanUtil.copy(financeSubjectEntities.get(0), TpmFinanceSubjectRespVo.class);
        this.financeSubjectHelp.setRespVoData(respVo);
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TpmFinanceSubjectReqVo reqVo) {
        this.financeSubjectHelp.checkData(reqVo);
        TpmFinanceSubjectEntity tpmFinanceSubjectEntity = (TpmFinanceSubjectEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmFinanceSubjectEntity.class));
        this.save((Object)tpmFinanceSubjectEntity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TpmFinanceSubjectReqVo reqVo) {
        this.financeSubjectHelp.updateCheck(reqVo);
        this.financeSubjectHelp.checkData(reqVo);
        TpmFinanceSubjectEntity tpmFinanceSubjectEntity = (TpmFinanceSubjectEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmFinanceSubjectEntity.class));
        this.updateById((Object)tpmFinanceSubjectEntity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchDelete(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List entities = this.financeSubjectMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            ArrayList removeIds = Lists.newArrayList();
            entities.forEach(o -> removeIds.add(o.getId()));
            this.removeByIds(removeIds);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchDisable(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List entities = this.financeSubjectMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            entities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
            this.updateBatchById(entities);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchEnable(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List entities = this.financeSubjectMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            entities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
            this.updateBatchById(entities);
        }
    }
}

