/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.jiuleiact.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.jiuleiact.mapper.TpmJiuActMapper;
import com.biz.crm.jiuleiact.model.TpmJiuActEntity;
import com.biz.crm.jiuleiact.service.TpmJiuActService;
import com.biz.crm.jiuleiact.service.impl.TpmJiuServiceHelper;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.tpm.act.req.ActGetCustomerCodeByOrgCodeReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.nebular.tpm.jiuact.req.TpmJiuActReqVo;
import com.biz.crm.nebular.tpm.jiuact.resp.TpmActJiuRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"TpmJiuActServiceImpl"})
public class TpmJiuActServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmJiuActMapper, TpmJiuActEntity>
implements TpmJiuActService {
    @Resource
    private TpmJiuActMapper tpmJiuActMapper;
    @Autowired
    private TpmJiuServiceHelper helper;
    @Resource
    private MdmCustomerMsgFeign customerMsgFeign;
    @Resource
    private MdmOrgFeign orgFeign;

    @Override
    public PageResult<TpmActJiuRespVo> findList(TpmJiuActReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<TpmActJiuRespVo> list = this.tpmJiuActMapper.findList((Page<TpmActJiuRespVo>)page, reqVo);
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(o -> this.helper.setRespVoData((TpmActJiuRespVo)o));
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmActJiuRespVo queryOne(String id) {
        AssertUtils.isNotEmpty((String)id, (CrmExceptionType)CommonException.IDS_NULL);
        List entities = this.tpmJiuActMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(BaseIdEntity::getId, (Object)id));
        return new TpmActJiuRespVo();
    }

    @Override
    public void add(TpmJiuActReqVo tpmJiuActReqVo) {
        this.helper.checkData(tpmJiuActReqVo);
    }

    @Override
    public Map<String, MdmOrgRespVo> getOrgMap(String isCrossOrg) {
        UserRedis userRedis = UserUtils.getUser();
        Map<Object, Object> map = Maps.newHashMap();
        MdmOrgReqVo mdmOrgReqVo = new MdmOrgReqVo();
        mdmOrgReqVo.setOrgCode(userRedis.getOrgcode());
        if (StringUtils.equals((CharSequence)isCrossOrg, (CharSequence)GlobalWhetherEnum.YES.getCode())) {
            List respVos = null;
            try {
                respVos = (List)ApiResultUtil.objResult((Result)this.orgFeign.findAllChildrenOrgList(mdmOrgReqVo), (boolean)true);
            }
            catch (Exception e) {
                this.log.error("{}", (Throwable)e);
                throw new BusinessException("\u8c03\u7528mdm\u63a5\u53e3\u5931\u8d25");
            }
            map = respVos.stream().collect(Collectors.toMap(MdmOrgRespVo::getOrgCode, Function.identity()));
            return map;
        }
        List respVos = null;
        MdmOrgRespVo vo = null;
        try {
            respVos = (List)ApiResultUtil.objResult((Result)this.orgFeign.findSingleChildrenOrgList(mdmOrgReqVo), (boolean)true);
            vo = (MdmOrgRespVo)ApiResultUtil.objResult((Result)this.orgFeign.detail(userRedis.getOrgcode()), (boolean)true);
        }
        catch (Exception e) {
            this.log.error("{}", (Throwable)e);
            throw new BusinessException("\u6d3b\u52a8\u65b0\u589e,\u8c03\u7528mdm\u63a5\u53e3\u5931\u8d25");
        }
        map = respVos.stream().collect(Collectors.toMap(MdmOrgRespVo::getOrgCode, Function.identity()));
        map.put(userRedis.getOrgcode(), vo);
        return map;
    }

    @Override
    public Map<String, MdmCustomerMsgRespVo> getCustomerMsgByOrgCodes(ActGetCustomerCodeByOrgCodeReqVo tpmActReqVo) {
        AssertUtils.isNotEmpty((String)tpmActReqVo.getOrgCode(), (String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7");
        MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo = new MdmCustomerOrgSearchReqVo();
        mdmCustomerOrgSearchReqVo.setCustomerCodeOrName(tpmActReqVo.getCustomerCodeOrName());
        mdmCustomerOrgSearchReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        mdmCustomerOrgSearchReqVo.setLockState(CrmEnableStatusEnum.ENABLE.getCode());
        mdmCustomerOrgSearchReqVo.setPageSize(tpmActReqVo.getPageSize());
        mdmCustomerOrgSearchReqVo.setOrgCodeList(Collections.singletonList(tpmActReqVo.getOrgCode()));
        Result currentAndSubCustomerList = null;
        try {
            currentAndSubCustomerList = this.customerMsgFeign.findCurrentAndSubCustomerList(mdmCustomerOrgSearchReqVo);
        }
        catch (Exception e) {
            this.log.error("{}", (Throwable)e);
            throw new BusinessException("\u6d3b\u52a8\u65b0\u589e\u6839\u636e\u7ec4\u7ec7\u83b7\u53d6\u5ba2\u6237\u5217\u8868,\u8c03\u7528mdm\u63a5\u53e3\u5931\u8d25");
        }
        List respVos = (List)ApiResultUtil.objResult((Result)currentAndSubCustomerList, (boolean)true);
        return respVos.stream().collect(Collectors.toMap(MdmCustomerMsgRespVo::getCustomerCode, Function.identity()));
    }

    @Override
    public List<TpmFeeBudgetControlRespVo> findBudgetController(TpmJiuActReqVo reqVo) {
        ArrayList<TpmFeeBudgetControlRespVo> list = new ArrayList<TpmFeeBudgetControlRespVo>();
        AssertUtils.isNotEmpty((String)reqVo.getBeginDate(), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getEndDate(), (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        System.out.println(DateUtil.getMonthBetween((String)reqVo.getBeginDate(), (String)reqVo.getEndDate()));
        return list;
    }
}

