/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.jiuleiact.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.budgetsubjects.mapper.TpmBudgetSubjectsMapper;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesFineMapper;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesMapper;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesEntity;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesFineEntity;
import com.biz.crm.costtypefine.mapper.TpmCostTypeFineMapper;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.BudgetSubjectsControlTypeEnum;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetMapper;
import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.tpm.jiuact.req.TpmJiuActBudgetReqVo;
import com.biz.crm.nebular.tpm.jiuact.req.TpmJiuActReqVo;
import com.biz.crm.nebular.tpm.jiuact.resp.TpmActJiuRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TpmJiuServiceHelper
extends BaseServiceHelper {
    @Resource
    private TpmCostTypeCategoriesFineMapper categoriesFineMapper;
    @Autowired
    private MdmOrgFeign orgFeign;
    @Resource
    private TpmCostTypeCategoriesMapper tpmCostTypeCategoriesMapper;
    @Resource
    private TpmBudgetSubjectsMapper subjectsMapper;
    @Resource
    private TpmFeeBudgetMapper feeBudgetMapper;
    @Resource
    private MdmCustomerMsgFeign customerMsgFeign;
    @Resource
    private TpmCostTypeFineMapper tpmCostTypeFineMapper;

    public Map<String, Map<String, String>> getDictMaps() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("act_approve_status");
        dictCodes.add("enable_status");
        return DictUtil.getDictValueMapsByCodes((List)dictCodes);
    }

    public void setRespVoData(TpmActJiuRespVo respVo) {
        Map<String, Map<String, String>> dataMaps = this.getDictMaps();
        if (StringUtils.isNotEmpty((CharSequence)respVo.getApproveStatus())) {
            respVo.setApproveStatusName(Optional.ofNullable(dataMaps.get("act_approve_status")).orElse(Maps.newHashMap()).get(respVo.getApproveStatus()));
        }
        if (StringUtils.isNotEmpty((CharSequence)respVo.getEnableStatus())) {
            respVo.setEnableStatusName(Optional.ofNullable(dataMaps.get("enable_status")).orElse(Maps.newHashMap()).get(respVo.getEnableStatus()));
        }
    }

    public void checkData(TpmJiuActReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getActName(), (String)"\u8bf7\u8f93\u5165\u6d3b\u52a8\u540d\u79f0");
        AssertUtils.isNotEmpty((String)reqVo.getBeginDate(), (String)"\u8bf7\u9009\u62e9\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4");
        if (StringUtils.isEmpty((CharSequence)reqVo.getBeginDateSecond())) {
            reqVo.setBeginDateSecond("00:00:00");
        }
        AssertUtils.isNotEmpty((String)reqVo.getEndDate(), (String)"\u8bf7\u9009\u62e9\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4");
        if (StringUtils.isEmpty((CharSequence)reqVo.getEndDateSecond())) {
            reqVo.setBeginDateSecond("23:59:59");
        }
        AssertUtils.isTrue((StringUtils.compare((String)(reqVo.getBeginDate() + reqVo.getBeginDateSecond()), (String)(reqVo.getEndDate() + reqVo.getEndDateSecond())) > 0 ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4");
        AssertUtils.isNotEmpty((String)reqVo.getActType(), (String)"\u8bf7\u9009\u62e9\u6d3b\u52a8\u7c7b\u578b");
        List fineEntities = this.tpmCostTypeFineMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode()));
        if (CollectionUtils.isEmpty((Collection)fineEntities)) {
            throw new BusinessException("\u6d3b\u52a8\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        Set fineCodes = fineEntities.stream().map(TpmCostTypeFineEntity::getFineCode).collect(Collectors.toSet());
        if (!fineCodes.contains(reqVo.getActType())) {
            throw new BusinessException("\u6d3b\u52a8\u7c7b\u578b\u4e0d\u53ef\u9009");
        }
        this.checkOrgAndCus(reqVo);
        this.checkBudgets(reqVo);
    }

    private void checkBudgets(TpmJiuActReqVo reqVo) {
        List fineEntities = this.tpmCostTypeFineMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmCostTypeFineEntity::getFineCode, (Object)reqVo.getActType()));
        if (CollectionUtils.size((Object)fineEntities) != 1) {
            throw new BusinessException("\u6d3b\u52a8\u7c7b\u578b\u5f02\u5e38");
        }
        List categoriesFineEntities = this.categoriesFineMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmCostTypeCategoriesFineEntity::getFineCode, (Object)reqVo.getActType()));
        if (CollectionUtils.isEmpty((Collection)categoriesFineEntities)) {
            throw new BusinessException(reqVo.getActType() + "\u6d3b\u52a8\u7c7b\u578b\u6ca1\u6709\u5173\u8054\u6295\u5165\u7c7b\u578b\uff0c\u65e0\u6cd5\u9009\u62e9\u9884\u7b97");
        }
        Set<Object> categoriesSets = Sets.newHashSet();
        categoriesSets = categoriesFineEntities.stream().map(TpmCostTypeCategoriesFineEntity::getCategoriesCode).collect(Collectors.toSet());
        List categoriesEntities = this.tpmCostTypeCategoriesMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(TpmCostTypeCategoriesEntity::getCategoriesCode, (Collection)categoriesSets));
        if (CollectionUtils.isEmpty((Collection)categoriesEntities)) {
            throw new BusinessException("\u5173\u8054\u6295\u5165\u7c7b\u578b\u4e0d\u5b58\u5728,\u65e0\u6cd5\u83b7\u53d6\u9884\u7b97");
        }
        Set budgetSubjectSetByCate = categoriesEntities.stream().map(TpmCostTypeCategoriesEntity::getBudgetSubjectsCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(budgetSubjectSetByCate)) {
            throw new BusinessException("\u6295\u5165\u7c7b\u578b\u6570\u636e\u5f02\u5e38");
        }
        AssertUtils.isNotEmpty((Collection)reqVo.getBudgetControlVos(), (String)"\u8bf7\u9009\u62e9\u9884\u7b97");
        HashSet controllerIds = Sets.newHashSet();
        HashSet applyAmountSets = Sets.newHashSet();
        HashSet budgetSubjectSets = Sets.newHashSet();
        reqVo.getBudgetControlVos().forEach(o -> {
            if (StringUtils.isNotEmpty((CharSequence)o.getId())) {
                controllerIds.add(o.getId());
            }
            if (StringUtils.isNotEmpty((CharSequence)o.getBudgetSubjectsCode())) {
                budgetSubjectSets.add(o.getBudgetSubjectsCode());
            }
            if (o.getApplyAmount() != null) {
                List subjectsRespVoList = this.subjectsMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmBudgetSubjectsEntity::getBudgetSubjectsCode, (Object)o.getBudgetSubjectsCode()));
                if (subjectsRespVoList.size() > 1) {
                    throw new BusinessException("\u9884\u7b97\u79d1\u76ee\u5f02\u5e38");
                }
                if (StringUtils.equals((CharSequence)((TpmBudgetSubjectsEntity)((Object)((Object)subjectsRespVoList.get(0)))).getControlType(), (CharSequence)BudgetSubjectsControlTypeEnum.NON.getCode())) {
                    applyAmountSets.add(o.getApplyAmount());
                } else {
                    if (Optional.ofNullable(o.getApplyAmount()).orElse(BigDecimal.ZERO).compareTo(o.getCanUseAmount()) > 0) {
                        throw new BusinessException("\u7533\u8bf7\u91d1\u989d\u4e0d\u53ef\u5927\u4e8e\u53ef\u7528\u91d1\u989d");
                    }
                    applyAmountSets.add(o.getApplyAmount());
                }
            }
            ArrayList actBudgetReqVoList = Lists.newArrayList();
            o.getFeeBudgetVos().forEach(x -> {
                TpmJiuActBudgetReqVo tpmJiuActBudgetReqVo = new TpmJiuActBudgetReqVo();
            });
        });
        AssertUtils.isTrue((applyAmountSets.size() > 0 ? 1 : 0) != 0, (String)"\u81f3\u5c11\u4e00\u6761\u9884\u7b97\u7533\u8bf7\u4e86\u91d1\u989d");
        List entities = this.feeBudgetMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(TpmFeeBudgetEntity::getControlId, (Collection)controllerIds));
        if (CollectionUtils.size((Object)entities) < CollectionUtils.size((Object)controllerIds)) {
            throw new BusinessException("\u9884\u7b97\u6570\u636e\u5f02\u5e38");
        }
    }

    private void checkFeeBudget(Set<String> controllerIds) {
    }

    private void checkOrgAndCus(TpmJiuActReqVo reqVo) {
        UserRedis userRedis = UserUtils.getUser();
        if (StringUtils.isNotEmpty((CharSequence)userRedis.getOrgcode()) && StringUtils.isNotEmpty((CharSequence)reqVo.getOrgCode())) {
            MdmOrgRespVo orgRespVo = (MdmOrgRespVo)ApiResultUtil.objResult((Result)this.orgFeign.detail(reqVo.getOrgCode()));
            if (StringUtils.equals((CharSequence)reqVo.getIsCrossOrg(), (CharSequence)GlobalWhetherEnum.YES.getCode())) {
                MdmOrgRespVo orgRespVoByRedis = (MdmOrgRespVo)ApiResultUtil.objResult((Result)this.orgFeign.detail(userRedis.getOrgcode()));
                if (!StringUtils.startsWith((CharSequence)orgRespVo.getRuleCode(), (CharSequence)orgRespVoByRedis.getRuleCode())) {
                    throw new BusinessException("\u7ec4\u7ec7\u4e0d\u5728\u7ef4\u62a4\u8303\u56f4\u5185");
                }
            } else if (!StringUtils.equals((CharSequence)reqVo.getOrgCode(), (CharSequence)userRedis.getOrgcode()) && !StringUtils.equals((CharSequence)orgRespVo.getParentCode(), (CharSequence)userRedis.getOrgcode())) {
                throw new BusinessException("\u7ec4\u7ec7\u4e0d\u5728\u7ef4\u62a4\u8303\u56f4\u5185");
            }
            if (StringUtils.isNotEmpty((CharSequence)reqVo.getCustomerCode())) {
                super.isJsonArray(reqVo.getCustomerCode(), "\u8bf7\u8f93\u5165 \u6570\u7ec4\u7684json\u5b57\u7b26\u4e32");
                List cusCodeList = JsonPropertyUtil.toArray((String)reqVo.getCustomerCode(), String.class);
                MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo = new MdmCustomerOrgSearchReqVo();
                mdmCustomerOrgSearchReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                mdmCustomerOrgSearchReqVo.setLockState(CrmEnableStatusEnum.ENABLE.getCode());
                mdmCustomerOrgSearchReqVo.setOrgCodeList(Collections.singletonList(reqVo.getOrgCode()));
                List customerMsgRespVos = (List)ApiResultUtil.objResult((Result)this.customerMsgFeign.findCurrentAndSubCustomerList(mdmCustomerOrgSearchReqVo), (boolean)true);
                Set codeSets = customerMsgRespVos.stream().map(MdmCustomerMsgRespVo::getCustomerCode).collect(Collectors.toSet());
                if (CollectionUtils.isNotEmpty((Collection)cusCodeList) && !codeSets.containsAll(cusCodeList)) {
                    throw new BusinessException("\u5ba2\u6237\u4e0d\u53ef\u9009");
                }
            }
        }
    }
}

