/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.jiuleiact.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.jiuleiact.service.TpmJiuActService;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.tpm.act.req.ActGetCustomerCodeByOrgCodeReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.nebular.tpm.jiuact.req.TpmJiuActReqVo;
import com.biz.crm.nebular.tpm.jiuact.resp.TpmActJiuRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tpmJiuActController"})
@Api(tags={"\u9152\u7c7btpm \u6d3b\u52a8\u4e3b\u8868"})
public class TpmJiuActController {
    private static final Logger log = LoggerFactory.getLogger(TpmJiuActController.class);
    @Autowired
    private TpmJiuActService tpmJiuActService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<TpmActJiuRespVo>> list(@RequestBody TpmJiuActReqVo tpmJiuActReqVo) {
        PageResult<TpmActJiuRespVo> result = this.tpmJiuActService.findList(tpmJiuActReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a")
    @GetMapping(value={"/query"})
    @CrmLog
    public Result<TpmActJiuRespVo> queryOne(@RequestParam(value="id", required=false) String id) {
        TpmActJiuRespVo tpmActJiuRespVo = this.tpmJiuActService.queryOne(id);
        return Result.ok((Object)tpmActJiuRespVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/add"})
    @CrmLog
    public Result add(@RequestBody TpmJiuActReqVo tpmJiuActReqVo) {
        this.tpmJiuActService.add(tpmJiuActReqVo);
        return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @ApiOperation(value="\u636e \u767b\u5f55 \u4eba \u548c\u662f\u5426\u9009\u62e9 \u8de8\u7ec4\u7ec7 \u6765 \u83b7\u53d6\u7ec4\u7ec7Map")
    @GetMapping(value={"/findOrgMapByCodeAndIsCross"})
    @CrmLog
    public Result<Map<String, MdmOrgRespVo>> findOrgMapByCodeAndIsCross(@RequestParam(value="isCross", required=false) String isCross) {
        Map<String, MdmOrgRespVo> map = this.tpmJiuActService.getOrgMap(isCross);
        return Result.ok(map);
    }

    @ApiOperation(value="\u636e\u7ec4\u7ec7 \u6765 \u83b7\u53d6\u5ba2\u6237Map")
    @PostMapping(value={"/findCusMapByOrgCode"})
    @CrmLog
    public Result<Map<String, MdmCustomerMsgRespVo>> findCusMapByOrgCode(@RequestBody ActGetCustomerCodeByOrgCodeReqVo reqVo) {
        Map<String, MdmCustomerMsgRespVo> map = this.tpmJiuActService.getCustomerMsgByOrgCodes(reqVo);
        return Result.ok(map);
    }

    @ApiOperation(value="\u6d3b\u52a8\u65b0\u589e\u53ef\u9009\u9884\u7b97\u63a7\u5236\u7ef4\u5ea6")
    @PostMapping(value={"/findBudgetController"})
    @CrmLog
    public Result<List<TpmFeeBudgetControlRespVo>> findBudgetController(@RequestBody TpmJiuActReqVo reqVo) {
        List<TpmFeeBudgetControlRespVo> controlRespVos = this.tpmJiuActService.findBudgetController(reqVo);
        return Result.ok(controlRespVos);
    }
}

