/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.costtypefine.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.account.mapper.TpmAccountDetailMapper;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.auditcollectexample.mapper.TpmAuditCollectExampleMapper;
import com.biz.crm.auditcollectexample.mapper.TpmAuditCollectExamplePictureMapper;
import com.biz.crm.auditcollectexample.model.TpmAuditCollectExampleEntity;
import com.biz.crm.auditcollectexample.model.TpmAuditCollectExamplePictureEntity;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.common.TpmGlobalDictConstants;
import com.biz.crm.costtypecategories.service.ITpmCostTypeCategoriesFineService;
import com.biz.crm.costtypecategories.service.ITpmCostTypeCategoriesRangeService;
import com.biz.crm.costtypefine.mapper.TpmActCollectFieldFineMapper;
import com.biz.crm.costtypefine.mapper.TpmCostTypeFineMapper;
import com.biz.crm.costtypefine.model.TpmActCollectFieldFineEntity;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.costtypefine.service.ITpmActCollectFieldFineService;
import com.biz.crm.costtypefine.service.ITpmCostTypeFineService;
import com.biz.crm.costtypefine.service.impl.CostTypeFineServiceHelper;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.CostTypeFineException;
import com.biz.crm.nebular.tpm.account.req.TpmAccountInvoiceReqVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditFileConvertReqVo;
import com.biz.crm.nebular.tpm.auditcollectexample.resp.TpmAuditCollectExamplePictureRespVo;
import com.biz.crm.nebular.tpm.auditcollectexample.resp.TpmAuditCollectExampleRespVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesFineReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesRangeReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRangeRespVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRespVo;
import com.biz.crm.nebular.tpm.costtypefine.req.TpmCostTypeFineReqVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmActCollectFieldFineRespVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmCostTypeFineServiceExpandImpl"})
public class TpmCostTypeFineServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmCostTypeFineMapper, TpmCostTypeFineEntity>
implements ITpmCostTypeFineService {
    private static final Logger log = LoggerFactory.getLogger(TpmCostTypeFineServiceImpl.class);
    @Resource
    private TpmCostTypeFineMapper tpmCostTypeFineMapper;
    @Autowired
    private CostTypeFineServiceHelper serviceHelper;
    @Resource
    private TpmAuditCollectExampleMapper tpmAuditCollectExampleMapper;
    @Resource
    private TpmAuditCollectExamplePictureMapper tpmAuditCollectExamplePictureMapper;
    @Resource
    private ITpmActCollectFieldFineService iTpmActCollectFieldFineService;
    @Resource
    private TpmAccountDetailMapper accountDetailMapper;
    @Resource
    private TpmActCollectFieldFineMapper fieldFineMapper;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;
    @Autowired
    private ITpmCostTypeCategoriesRangeService rangeService;
    @Autowired
    private ITpmCostTypeCategoriesFineService fineService;

    @Override
    @CrmLog
    public PageResult<TpmCostTypeFineRespVo> findList(TpmCostTypeFineReqVo tpmCostTypeFineReqVo) {
        Page page = PageUtil.buildPage((Integer)tpmCostTypeFineReqVo.getPageNum(), (Integer)tpmCostTypeFineReqVo.getPageSize());
        List<TpmCostTypeFineRespVo> list = this.tpmCostTypeFineMapper.findList((Page<TpmCostTypeFineRespVo>)page, tpmCostTypeFineReqVo);
        this.serviceHelper.convertListDate(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmLog
    public TpmCostTypeFineRespVo query(String id) {
        List fieldFineEntities;
        TpmCostTypeFineReqVo tpmCostTypeFineReqVo = new TpmCostTypeFineReqVo();
        tpmCostTypeFineReqVo.setId(id);
        List list = this.findList(tpmCostTypeFineReqVo).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new TpmCostTypeFineRespVo();
        }
        TpmCostTypeFineRespVo respVo = (TpmCostTypeFineRespVo)list.get(0);
        TpmCostTypeCategoriesRangeReqVo rangeReqVo = new TpmCostTypeCategoriesRangeReqVo();
        rangeReqVo.setPageSize(Integer.valueOf(-1));
        rangeReqVo.setCategoriesCode(respVo.getFineCode());
        List rangeVos = this.rangeService.findList(rangeReqVo).getData();
        Map<String, List<TpmCostTypeCategoriesRangeRespVo>> map = rangeVos.stream().collect(Collectors.groupingBy(o -> o.getRangeType() + o.getIsContain()));
        map.keySet().forEach(o -> {
            List vos = (List)map.get(o);
            if (StringUtils.equals((CharSequence)(TpmGlobalDictConstants.RANGE_ORG + "Y"), (CharSequence)o)) {
                respVo.setContainOrgRangeVos(vos);
            } else if (StringUtils.equals((CharSequence)(TpmGlobalDictConstants.RANGE_ORG + "N"), (CharSequence)o)) {
                respVo.setNonContainOrgRangeVos(vos);
            } else if (StringUtils.equals((CharSequence)(TpmGlobalDictConstants.RANGE_ORG_TYPE + "Y"), (CharSequence)o)) {
                respVo.setContainOrgTypeRangeVos(vos);
            } else if (StringUtils.equals((CharSequence)(TpmGlobalDictConstants.RANGE_ORG_TYPE + "N"), (CharSequence)o)) {
                respVo.setNonContainOrgTypeRangeVos(vos);
            } else {
                throw new BusinessException("\u6d3b\u52a8\u7ec6\u7c7b" + respVo.getFineCode() + "\u8303\u56f4\u4fe1\u606f\u6570\u636e\u5f02\u5e38");
            }
        });
        TpmCostTypeCategoriesFineReqVo categoriesReqVo = new TpmCostTypeCategoriesFineReqVo();
        categoriesReqVo.setPageSize(Integer.valueOf(-1));
        categoriesReqVo.setFineCode(respVo.getFineCode());
        List categoriesVos = this.fineService.findList(categoriesReqVo).getData();
        respVo.setTpmCostTypeCategoriesFineRespVo(categoriesVos);
        if (StringUtils.isNotEmpty((CharSequence)respVo.getCollectRequireList())) {
            List<TpmAuditCollectExampleRespVo> collectRequires = this.serviceHelper.getExamples(respVo.getCollectRequireList());
            respVo.setCollectRequires(collectRequires);
        }
        if (StringUtils.isNotEmpty((CharSequence)respVo.getAuditRequireList())) {
            List<TpmAuditCollectExampleRespVo> auditRequires = this.serviceHelper.getExamples(respVo.getAuditRequireList());
            respVo.setAuditRequires(auditRequires);
        }
        if (StringUtils.isNotEmpty((CharSequence)respVo.getPayTypeList())) {
            List<DictItemVo> payTypes = this.serviceHelper.getPayTypes(respVo.getPayTypeList());
            respVo.setPayTypes(payTypes);
        }
        if (CollectionUtils.isNotEmpty((Collection)(fieldFineEntities = ((LambdaQueryChainWrapper)this.iTpmActCollectFieldFineService.lambdaQuery().eq(TpmActCollectFieldFineEntity::getFineCode, (Object)respVo.getFineCode())).select(new SFunction[]{TpmActCollectFieldFineEntity::getFieldCode, TpmActCollectFieldFineEntity::getFieldName}).list()))) {
            respVo.setCollectFieldList(CrmBeanUtil.copyList((List)fieldFineEntities, TpmActCollectFieldFineRespVo.class));
        }
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void save(TpmCostTypeFineReqVo reqVo) {
        this.serviceHelper.saveCheck(reqVo);
        TpmCostTypeFineEntity entity = (TpmCostTypeFineEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmCostTypeFineEntity.class));
        this.save((Object)entity);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        TpmCostTypeFineRespVo newData = (TpmCostTypeFineRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmCostTypeFineRespVo.class);
        this.crmLogSendUtil.sendForAdd(menuCodeObj.toString(), newData.getId(), newData.getFineCode(), (Object)newData);
        if (CollectionUtils.isNotEmpty((Collection)reqVo.getCollectFieldList())) {
            List fieldFineEntities = reqVo.getCollectFieldList().stream().map(o -> {
                TpmActCollectFieldFineEntity fieldFineEntity = new TpmActCollectFieldFineEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)fieldFineEntity));
                fieldFineEntity.setFineCode(entity.getFineCode());
                return fieldFineEntity;
            }).collect(Collectors.toList());
            this.iTpmActCollectFieldFineService.saveOrUpdateBatch(fieldFineEntities);
        }
        reqVo.setFineCode(entity.getFineCode());
        this.serviceHelper.saveFines(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void update(TpmCostTypeFineReqVo reqVo) {
        if (StringUtils.isEmpty((CharSequence)reqVo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TpmCostTypeFineEntity entity = (TpmCostTypeFineEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        if (Objects.isNull((Object)entity)) {
            throw new BusinessException((CrmExceptionType)CostTypeFineException.DATA_NOT_EXIST);
        }
        this.serviceHelper.saveCheck(reqVo);
        TpmCostTypeFineRespVo oldData = (TpmCostTypeFineRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmCostTypeFineRespVo.class);
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)((Object)entity));
        this.updateById((Object)entity);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        TpmCostTypeFineRespVo newData = (TpmCostTypeFineRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmCostTypeFineRespVo.class);
        this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), newData.getId(), newData.getFineCode(), (Object)oldData, (Object)newData);
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TpmActCollectFieldFineEntity::getFineCode, (Object)entity.getFineCode());
        List collectFieldList = reqVo.getCollectFieldList();
        if (CollectionUtils.isNotEmpty((Collection)collectFieldList)) {
            List ids = collectFieldList.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getId())).map(UuidVo::getId).collect(Collectors.toList());
            wrapper.notIn(CollectionUtils.isNotEmpty(ids), BaseIdEntity::getId, ids);
            List fieldFineEntities = collectFieldList.stream().map(o -> {
                TpmActCollectFieldFineEntity fieldFineEntity = new TpmActCollectFieldFineEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)fieldFineEntity));
                fieldFineEntity.setFineCode(entity.getFineCode());
                return fieldFineEntity;
            }).collect(Collectors.toList());
            this.iTpmActCollectFieldFineService.saveOrUpdateBatch(fieldFineEntities);
        }
        this.fieldFineMapper.delete((Wrapper)wrapper);
        this.serviceHelper.saveFines(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void deleteBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        PageResult<TpmCostTypeFineRespVo> oldDataList = this.findList(new TpmCostTypeFineReqVo().setIds(ids));
        this.tpmCostTypeFineMapper.deleteProductsByParams(new TpmCostTypeFineReqVo().setIds(ids));
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        oldDataList.getData().stream().forEach(o -> this.crmLogSendUtil.sendForDel(menuCodeObj.toString(), o.getId(), o.getFineCode(), o));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void enableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List entities = this.tpmCostTypeFineMapper.selectBatchIds(ids);
        List oldDataList = CrmBeanUtil.copyList((List)entities, TpmCostTypeFineRespVo.class);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            entities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(entities);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        List newDataList = CrmBeanUtil.copyList((List)entities, TpmCostTypeFineRespVo.class);
        for (int i = 0; i < newDataList.size(); ++i) {
            this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), ((TpmCostTypeFineRespVo)newDataList.get(i)).getId(), ((TpmCostTypeFineRespVo)newDataList.get(i)).getFineCode(), oldDataList.get(i), newDataList.get(i));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void disableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List entities = this.tpmCostTypeFineMapper.selectBatchIds(ids);
        List oldDataList = CrmBeanUtil.copyList((List)entities, TpmCostTypeFineRespVo.class);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            entities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(entities);
        List newDataList = CrmBeanUtil.copyList((List)entities, TpmCostTypeFineRespVo.class);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        for (int i = 0; i < newDataList.size(); ++i) {
            this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), ((TpmCostTypeFineRespVo)newDataList.get(i)).getId(), ((TpmCostTypeFineRespVo)newDataList.get(i)).getFineCode(), oldDataList.get(i), newDataList.get(i));
        }
    }

    @Override
    public List<TpmCostTypeFineRespVo> costTypeFineListByFineCode(TpmAuditFileConvertReqVo reqVo) {
        AssertUtils.isNotEmpty((Collection)reqVo.getFineCodeList(), (String)"\u7ec6\u7c7b\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"fine_code", (Collection)reqVo.getFineCodeList());
        List tpmCostTypeFineEntities = this.tpmCostTypeFineMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)tpmCostTypeFineEntities)) {
            return Lists.newArrayList();
        }
        List tpmCostTypeFineRespVos = CrmBeanUtil.copyList((List)tpmCostTypeFineEntities, TpmCostTypeFineRespVo.class);
        List<String> auditRequireList = tpmCostTypeFineRespVos.stream().map(TpmCostTypeFineRespVo::getAuditRequireList).collect(Collectors.toList());
        ArrayList codes = new ArrayList();
        auditRequireList.forEach(listJson -> {
            if (StringUtils.isNotEmpty((CharSequence)listJson)) {
                codes.addAll(JSON.parseArray((String)listJson, String.class));
            }
        });
        List<String> auditRequireCodes = codes.stream().distinct().collect(Collectors.toList());
        Map<String, TpmAuditCollectExampleRespVo> exampleMap = this.getExampleMap(auditRequireCodes);
        Map<Object, Object> fileMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)reqVo.getAuditFileReqVos())) {
            fileMap = reqVo.getAuditFileReqVos().stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getFineCode()) && StringUtils.isNotEmpty((CharSequence)o.getExampleCode())).collect(Collectors.groupingBy(o -> o.getFineCode() + o.getExampleCode()));
        }
        for (TpmCostTypeFineRespVo tpmCostTypeFineRespVo : tpmCostTypeFineRespVos) {
            if (!StringUtils.isNotEmpty((CharSequence)tpmCostTypeFineRespVo.getAuditRequireList())) continue;
            List auditRequires = JSON.parseArray((String)tpmCostTypeFineRespVo.getAuditRequireList(), String.class);
            ArrayList<TpmAuditCollectExampleRespVo> collectExampleRespVos = new ArrayList<TpmAuditCollectExampleRespVo>();
            for (String exampleCode : auditRequires) {
                TpmAuditCollectExampleRespVo exampleRespVo = exampleMap.get(exampleCode);
                if (!Objects.nonNull(exampleRespVo)) continue;
                if (MapUtils.isNotEmpty((Map)fileMap)) {
                    List tpmAuditFileReqVos = (List)fileMap.get(tpmCostTypeFineRespVo.getFineCode() + exampleRespVo.getExampleCode());
                    exampleRespVo.setAuditFileReqVos(tpmAuditFileReqVos);
                }
                collectExampleRespVos.add(exampleRespVo);
            }
            tpmCostTypeFineRespVo.setAuditRequires(collectExampleRespVos);
        }
        return tpmCostTypeFineRespVos;
    }

    private Map<String, TpmAuditCollectExampleRespVo> getExampleMap(List<String> auditRequireCodes) {
        if (CollectionUtils.isNotEmpty(auditRequireCodes)) {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(TpmAuditCollectExampleEntity::getExampleCode, auditRequireCodes);
            LambdaQueryWrapper pictureQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(TpmAuditCollectExamplePictureEntity::getExampleCode, auditRequireCodes);
            List exampleEntities = this.tpmAuditCollectExampleMapper.selectList((Wrapper)queryWrapper);
            List examplePictureEntities = this.tpmAuditCollectExamplePictureMapper.selectList((Wrapper)pictureQueryWrapper);
            HashMap<String, TpmAuditCollectExampleRespVo> nameMap = new HashMap<String, TpmAuditCollectExampleRespVo>();
            if (CollectionUtils.isNotEmpty((Collection)exampleEntities)) {
                Map<String, List<TpmAuditCollectExampleEntity>> collect = exampleEntities.stream().collect(Collectors.groupingBy(TpmAuditCollectExampleEntity::getExampleCode));
                for (Map.Entry<String, List<TpmAuditCollectExampleEntity>> stringListEntry : collect.entrySet()) {
                    TpmAuditCollectExampleEntity tpmAuditCollectExampleEntity = stringListEntry.getValue().get(0);
                    TpmAuditCollectExampleRespVo collectExampleRespVo = (TpmAuditCollectExampleRespVo)CrmBeanUtil.copy((Object)((Object)tpmAuditCollectExampleEntity), TpmAuditCollectExampleRespVo.class);
                    if (CollectionUtils.isNotEmpty((Collection)examplePictureEntities)) {
                        Map<String, List<TpmAuditCollectExamplePictureEntity>> pictureMap = examplePictureEntities.stream().collect(Collectors.groupingBy(TpmAuditCollectExamplePictureEntity::getExampleCode));
                        for (Map.Entry<String, List<TpmAuditCollectExamplePictureEntity>> listEntry : pictureMap.entrySet()) {
                            if (!StringUtils.equals((CharSequence)stringListEntry.getKey(), (CharSequence)listEntry.getKey())) continue;
                            collectExampleRespVo.setPictureRespVos(CrmBeanUtil.copyList(listEntry.getValue(), TpmAuditCollectExamplePictureRespVo.class));
                        }
                    }
                    nameMap.put(stringListEntry.getKey(), collectExampleRespVo);
                }
            }
            return nameMap;
        }
        return Maps.newHashMap();
    }

    @Override
    public PageResult<TpmCostTypeCategoriesRespVo> findCategoriesByFineCode(TpmCostTypeFineReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getFineCode(), (String)"\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<TpmCostTypeCategoriesRespVo> list = this.tpmCostTypeFineMapper.findCategoriesByFineCode((Page<TpmCostTypeCategoriesRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<TpmCostTypeFineRespVo> financeSubjectsErpCodeByFindCode(TpmAccountInvoiceReqVo reqVo) {
        List fineCodeList = reqVo.getFineCodeList();
        if (CollectionUtils.isEmpty((Collection)fineCodeList)) {
            return Lists.newArrayList();
        }
        Set collect = fineCodeList.stream().collect(Collectors.toSet());
        List tpmCostTypeFineEntities = this.tpmCostTypeFineMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(TpmCostTypeFineEntity::getFineCode, collect));
        if (CollectionUtils.isNotEmpty((Collection)tpmCostTypeFineEntities)) {
            List collect1 = tpmCostTypeFineEntities.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getFinanceSubjectsErpCode()) && StringUtils.isNotEmpty((CharSequence)o.getFinanceSubjectsErpName())).map(o -> {
                TpmCostTypeFineRespVo vo = new TpmCostTypeFineRespVo();
                vo.setFinanceSubjectsErpCode(o.getFinanceSubjectsErpCode());
                vo.setFinanceSubjectsErpName(o.getFinanceSubjectsErpName());
                vo.setFineName(o.getFinanceSubjectsErpCode() + o.getFinanceSubjectsErpName());
                return vo;
            }).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<TpmCostTypeFineRespVo>(Comparator.comparing(TpmCostTypeFineRespVo::getFineName))), ArrayList::new));
            return collect1;
        }
        return Lists.newArrayList();
    }
}

