/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.liqueuract.service.impl.actbuilder;

import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActSaveTypeEnum;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActFileEntity;
import com.biz.crm.liqueuract.service.impl.TpmLiqueurServiceHelper;
import com.biz.crm.liqueuract.service.impl.actbuilder.ActBaseBuilder;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetRespVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActBudgetReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActReqVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class LiqueurActBuilder
extends BaseServiceHelper
implements ActBaseBuilder {
    private TpmLiqueurServiceHelper helper;
    private TpmLiqueurActReqVo reqVo;
    private List<TpmLiqueurActBudgetReqVo> liqueurActBudgetReqVos;
    private List<TpmFeeBudgetRespVo> feeBudgetRespVos;
    private List<TpmFeeBudgetControlRespVo> feeBudgetControlRespVos;
    private TpmLiqueurActEntity liqueurActEntity;
    private List<TpmLiqueurActBudgetEntity> liqueurActBudgetEntities = Lists.newArrayList();
    private List<TpmLiqueurActFileEntity> liqueurActFileEntities = Lists.newArrayList();
    private List<TpmFeeBudgetEntity> feeBudgetEntities = Lists.newArrayList();
    private List<TpmFeeBudgetControlEntity> feeBudgetControlEntities = Lists.newArrayList();

    public LiqueurActBuilder(TpmLiqueurServiceHelper helper, TpmLiqueurActReqVo reqVo) {
        this.helper = helper;
        this.reqVo = reqVo;
    }

    public static LiqueurActBuilder builder(TpmLiqueurServiceHelper helper, TpmLiqueurActReqVo reqVo) {
        return new LiqueurActBuilder(helper, reqVo);
    }

    @Override
    public ActBaseBuilder init() {
        if (!CollectionUtils.isNotEmpty((Collection)this.reqVo.getBudgetControlVos())) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u6d3b\u52a8\u9884\u7b97");
        }
        this.helper.setLiqueurActBudget(this.reqVo);
        this.liqueurActBudgetReqVos = this.reqVo.getLiqueurActBudgetReqVos();
        return this;
    }

    @Override
    public ActBaseBuilder check() {
        this.checkActData();
        this.helper.checkOrgAndCus(this.reqVo);
        this.helper.checkBudgets(this.reqVo);
        this.helper.checkBudgetData(this.reqVo);
        this.checkAmount();
        return this;
    }

    private void checkAmount() {
        if (!ActSaveTypeEnum.getCheckBudgetTypes().contains(this.reqVo.getSaveType())) {
            return;
        }
        Map actBudgetReqVoMap = this.liqueurActBudgetReqVos.stream().collect(Collectors.toMap(TpmLiqueurActBudgetReqVo::getFeeBudgetCode, Function.identity()));
        HashSet feeBudgetIds = Sets.newHashSet();
        ArrayList feeBudgetRespVos = Lists.newArrayList();
        this.reqVo.getBudgetControlVos().forEach(o -> {
            AtomicReference<BigDecimal> bigDecimal = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            o.getFeeBudgetVos().forEach(x -> {
                TpmFeeBudgetRespVo feeBudgetRespVo = new TpmFeeBudgetRespVo();
                Set actBudgetCodes = actBudgetReqVoMap.keySet();
                TpmLiqueurActBudgetReqVo actBudgetReqVo = (TpmLiqueurActBudgetReqVo)actBudgetReqVoMap.get(x.getFeeBudgetCode());
                if (actBudgetCodes.contains(x.getFeeBudgetCode())) {
                    if (x.getCanUseAmount().compareTo(actBudgetReqVo.getApplyAmount()) < 1) {
                        throw new BusinessException("\u9884\u7b97\u53ef\u7528\u4f59\u989d\u4e0d\u8db3");
                    }
                    feeBudgetRespVo.setCanUseAmount(x.getCanUseAmount().subtract(actBudgetReqVo.getApplyAmount()));
                    feeBudgetRespVo.setUsedAmount(x.getUsedAmount().add(actBudgetReqVo.getApplyAmount()));
                    feeBudgetRespVos.add(feeBudgetRespVo);
                }
                feeBudgetIds.add(x.getId());
                bigDecimal.set(((BigDecimal)bigDecimal.get()).add(x.getCanUseAmount()));
            });
            o.setCanUseAmount(bigDecimal.get());
        });
        AssertUtils.isTrue((feeBudgetIds.size() == this.liqueurActBudgetReqVos.size() ? 1 : 0) != 0, (String)"\u9884\u7b97\u6570\u636e\u5f02\u5e38");
        this.feeBudgetRespVos = feeBudgetRespVos;
    }

    private void checkActData() {
        AssertUtils.isNotEmpty((String)this.reqVo.getActName(), (String)"\u8bf7\u8f93\u5165\u6d3b\u52a8\u540d\u79f0");
        AssertUtils.isNotEmpty((String)this.reqVo.getBeginDate(), (String)"\u8bf7\u9009\u62e9\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4");
        if (StringUtils.isEmpty((CharSequence)this.reqVo.getBeginDateSecond())) {
            this.reqVo.setBeginDateSecond("00:00:00");
        }
        AssertUtils.isNotEmpty((String)this.reqVo.getEndDate(), (String)"\u8bf7\u9009\u62e9\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4");
        if (StringUtils.isEmpty((CharSequence)this.reqVo.getEndDateSecond())) {
            this.reqVo.setBeginDateSecond("23:59:59");
        }
        AssertUtils.isTrue((StringUtils.compare((String)(this.reqVo.getBeginDate() + this.reqVo.getBeginDateSecond()), (String)(this.reqVo.getEndDate() + this.reqVo.getEndDateSecond())) < 0 ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4");
        AssertUtils.isNotEmpty((String)this.reqVo.getFineCode(), (String)"\u8bf7\u9009\u62e9\u6d3b\u52a8\u7c7b\u578b");
        if (StringUtils.isEmpty((CharSequence)this.reqVo.getApproveStatus())) {
            this.reqVo.setApproveStatus(ActApproveStatusEnum.CREATE.getCode());
        }
        if (StringUtils.isEmpty((CharSequence)this.reqVo.getSaveType())) {
            this.reqVo.setSaveType(ActSaveTypeEnum.ADD.getCode());
        }
    }

    @Override
    public ActBaseBuilder convert() {
        this.liqueurActEntity = (TpmLiqueurActEntity)((Object)CrmBeanUtil.copy((Object)this.reqVo, TpmLiqueurActEntity.class));
        this.liqueurActEntity.setActCode(CodeUtil.createOneCode((String)"tpm_act"));
        this.liqueurActEntity.setIsAllAudit(GlobalWhetherEnum.NO.getCode());
        this.liqueurActEntity.setIsAudit(GlobalWhetherEnum.NO.getCode());
        BigDecimal amount = this.liqueurActBudgetReqVos.stream().map(TpmLiqueurActBudgetReqVo::getApplyAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.liqueurActEntity.setTotalAmount(amount);
        this.liqueurActBudgetReqVos.forEach(x -> {
            x.setActCode(this.liqueurActEntity.getActCode());
            TpmLiqueurActBudgetEntity entity = (TpmLiqueurActBudgetEntity)((Object)((Object)CrmBeanUtil.copy((Object)x, TpmLiqueurActBudgetEntity.class)));
            this.liqueurActBudgetEntities.add(entity);
        });
        this.liqueurActBudgetEntities = CrmBeanUtil.copyList(this.liqueurActBudgetReqVos, TpmLiqueurActBudgetEntity.class);
        this.feeBudgetEntities = CrmBeanUtil.copyList(this.feeBudgetRespVos, TpmFeeBudgetEntity.class);
        if (CollectionUtils.isNotEmpty((Collection)this.reqVo.getFileReqVos())) {
            this.reqVo.getFileReqVos().forEach(x -> {
                x.setActCode(this.liqueurActEntity.getActCode());
                TpmLiqueurActFileEntity entity = (TpmLiqueurActFileEntity)((Object)((Object)CrmBeanUtil.copy((Object)x, TpmLiqueurActFileEntity.class)));
                this.liqueurActFileEntities.add(entity);
            });
            this.feeBudgetControlEntities = CrmBeanUtil.copyList((List)this.reqVo.getBudgetControlVos(), TpmFeeBudgetControlEntity.class);
        }
        return this;
    }

    @Override
    public TpmLiqueurActEntity save() {
        this.helper.saveOrUpdateAct(this.liqueurActEntity, this.reqVo);
        this.helper.saveActBudgets(this.liqueurActBudgetEntities, this.reqVo);
        this.helper.saveActFiles(this.liqueurActFileEntities, this.reqVo);
        this.helper.saveFeeBudgets(this.feeBudgetEntities, this.reqVo);
        this.helper.saveBudgetController(this.feeBudgetControlEntities, this.reqVo);
        return this.liqueurActEntity;
    }

    @Override
    public TpmLiqueurActEntity update() {
        this.helper.saveOrUpdateAct(this.liqueurActEntity, this.reqVo);
        this.helper.saveActBudgets(this.liqueurActBudgetEntities, this.reqVo);
        this.helper.saveActFiles(this.liqueurActFileEntities, this.reqVo);
        this.helper.saveFeeBudgets(this.feeBudgetEntities, this.reqVo);
        this.helper.saveBudgetController(this.feeBudgetControlEntities, this.reqVo);
        return this.liqueurActEntity;
    }
}

