/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.liqueuract.service.impl.actbuilder;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.BusinessException;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActBudgetMapper;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterDetailBudgetEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterEntity;
import com.biz.crm.liqueuract.service.impl.TpmLiqueurServiceHelper;
import com.biz.crm.liqueuract.service.impl.actbuilder.DetailBaseBuilder;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterReqVo;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;

public class LiqueurDetailBuilder
implements DetailBaseBuilder {
    private TpmLiqueurServiceHelper helper;
    private TpmLiqueurActRegisterReqVo reqVo;
    private TpmLiqueurActEntity actEntity;
    private Set<String> controllerIds;
    private List<TpmLiqueurActRegisterDetailBudgetEntity> registerDetailBudgetEntities;
    private Map<String, List<TpmLiqueurActBudgetEntity>> actBudgetEntitiesMap;
    @Resource
    private TpmLiqueurActBudgetMapper actBudgetMapper;

    public LiqueurDetailBuilder(TpmLiqueurServiceHelper helper, TpmLiqueurActRegisterReqVo reqVo) {
        this.helper = helper;
        this.reqVo = reqVo;
    }

    public static LiqueurDetailBuilder builder(TpmLiqueurServiceHelper helper, TpmLiqueurActRegisterReqVo reqVo) {
        return new LiqueurDetailBuilder(helper, reqVo);
    }

    @Override
    public DetailBaseBuilder init() {
        this.buildUpData();
        return this;
    }

    private void buildUpData() {
        this.actEntity = this.helper.saveCheckActStatus(this.reqVo);
        ArrayList usedDetailEntities = Lists.newArrayList();
        List actBudgetEntities = this.actBudgetMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmLiqueurActBudgetEntity::getActCode, (Object)this.reqVo.getActCode()));
        HashMap actBudgetEntityMap = Maps.newHashMap();
        HashSet controllerIds = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty((Collection)actBudgetEntities)) {
            actBudgetEntities.forEach(x -> {
                ArrayList entities = Lists.newArrayList();
                controllerIds.add(x.getControlId());
                if (actBudgetEntityMap.containsKey(x.getControlId())) {
                    ((List)actBudgetEntityMap.get(x.getControlId())).add(x);
                } else {
                    entities.add(x);
                    actBudgetEntityMap.put(x.getControlId(), entities);
                }
            });
        }
        if (CollectionUtils.isEmpty((Collection)this.reqVo.getControlRespVos())) {
            throw new BusinessException("\u6ca1\u6709\u53ef\u7528\u9884\u7b97\uff0c\u660e\u7ec6\u65e0\u6cd5\u767b\u8bb0");
        }
        this.reqVo.getControlRespVos().forEach(x -> {
            if (actBudgetEntityMap.containsKey(x.getId())) {
                List entities = (List)actBudgetEntityMap.get(x.getId());
                BigDecimal approveAmount = entities.stream().map(TpmLiqueurActBudgetEntity::getApproveAmount).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal canUseAmountByAct = entities.stream().map(TpmLiqueurActBudgetEntity::getCanUseAmount).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                x.setApproveAmount(approveAmount);
                x.setCanUseAmountByAct(canUseAmountByAct);
            }
        });
        if (CollectionUtils.isEmpty((Collection)this.reqVo.getActDetailReqVos())) {
            throw new BusinessException("\u81f3\u5c11\u767b\u8bb0\u4e00\u6761\u660e\u7ec6");
        }
        this.reqVo.getActDetailReqVos().forEach(x -> {
            if (StringUtils.isEmpty((String)x.getActDetailCode())) {
                x.setActDetailCode(CodeUtil.createOneCode((String)"tpm_act_detail"));
            }
            if (CollectionUtils.isEmpty((Collection)x.getControlList())) {
                throw new BusinessException("\u660e\u7ec6\u767b\u8bb0\u9700\u8981\u5173\u8054\u6d3b\u52a8\u9884\u7b97");
            }
            x.getControlList().forEach(o -> {
                if (actBudgetEntityMap.containsKey(o.getId())) {
                    List entities = (List)actBudgetEntityMap.get(o.getId());
                    entities.forEach(y -> {
                        TpmLiqueurActRegisterDetailBudgetEntity entity = new TpmLiqueurActRegisterDetailBudgetEntity();
                        entity.setActBudgetCode(y.getActBudgetCode());
                        entity.setActDetailCode(x.getActDetailCode());
                        usedDetailEntities.add(entity);
                    });
                }
            });
        });
        this.controllerIds = controllerIds;
        this.actBudgetEntitiesMap = actBudgetEntityMap;
        this.registerDetailBudgetEntities = usedDetailEntities;
    }

    @Override
    public DetailBaseBuilder check() {
        this.checkActRegisterDetails();
        return this;
    }

    private void checkActRegisterDetails() {
        this.reqVo.getActDetailReqVos().forEach(x -> {});
    }

    @Override
    public DetailBaseBuilder convert() {
        return null;
    }

    @Override
    public TpmLiqueurActRegisterEntity save() {
        return null;
    }

    @Override
    public TpmLiqueurActRegisterEntity update() {
        return null;
    }
}

