/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.liqueuract.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActRegisterMapper;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterEntity;
import com.biz.crm.liqueuract.service.ITpmLiqueurActRegisterService;
import com.biz.crm.liqueuract.service.impl.TpmLiqueurActRegisterServiceHelper;
import com.biz.crm.liqueuract.service.impl.actbuilder.ActRegisterBuilder;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.common.ProcessCommonVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.Result;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmLiqueurDetailServiceExpandImpl"})
public class TpmLiqueurActRegisterServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmLiqueurActRegisterMapper, TpmLiqueurActRegisterEntity>
implements ITpmLiqueurActRegisterService {
    private static final Logger log = LoggerFactory.getLogger(TpmLiqueurActRegisterServiceImpl.class);
    @Autowired
    private TaActBaseFeign activityFeign;
    @Resource
    private TpmLiqueurActRegisterMapper tpmLiqueurActRegisterMapper;
    @Autowired
    private TpmLiqueurActRegisterServiceHelper helper;

    @Override
    public PageResult<TpmLiqueurActRegisterRespVo> findList(TpmLiqueurActRegisterReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<TpmLiqueurActRegisterRespVo> list = this.tpmLiqueurActRegisterMapper.findList((Page<TpmLiqueurActRegisterRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmLiqueurActRegisterRespVo query(String id) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TpmLiqueurActRegisterReqVo reqVo) {
        ActRegisterBuilder builder = new ActRegisterBuilder(this.helper, reqVo);
        TpmLiqueurActRegisterEntity entity = builder.init().check().convert().save();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TpmLiqueurActRegisterReqVo reqVo) {
        this.helper.updateCheck(reqVo);
        ActRegisterBuilder builder = new ActRegisterBuilder(this.helper, reqVo);
        TpmLiqueurActRegisterEntity entity = builder.init().check().convert().update();
        this.sendToActivity(entity, reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        this.helper.deleteCheck(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
    }

    @Transactional(rollbackFor={Exception.class})
    public void sendToActivity(TpmLiqueurActRegisterEntity entity, TpmLiqueurActRegisterReqVo reqVo) {
        if (StringUtils.equals((CharSequence)ActApproveStatusEnum.APPROVING.getCode(), (CharSequence)entity.getApproveStatus())) {
            StartProcessReqVo processReqVo = this.helper.buildStartProcessData(entity, reqVo);
            Result processCommonVoResult = this.activityFeign.startProcess(processReqVo);
            if (!Objects.equals(CommonConstant.SC_OK_200, processCommonVoResult.getCode())) {
                throw new BusinessException(processCommonVoResult.getMessage());
            }
            entity.setProcessCode(((ProcessCommonVo)processCommonVoResult.getResult()).getProcessNo());
            this.saveOrUpdate((Object)entity);
        }
    }
}

