/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.liqueuract.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.act.service.impl.ActServiceHelper;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.budgetsubjects.mapper.TpmBudgetSubjectsMapper;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesFineMapper;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesMapper;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesEntity;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesFineEntity;
import com.biz.crm.costtypefine.mapper.TpmCostTypeFineMapper;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActSaveTypeEnum;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.ActException;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetControlMapper;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetMapper;
import com.biz.crm.feebudget.model.OperateBudgetControlReqVo;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.feebudget.service.ITpmFeeBudgetService;
import com.biz.crm.feebudget.service.impl.FeeBudgetServiceHelper;
import com.biz.crm.feebudget.service.impl.TpmFeeBudgetControlServiceImpl;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActBudgetMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActFileMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActMapper;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActFileEntity;
import com.biz.crm.liqueuract.service.TpmLiqueurActBudgetService;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.act.req.TaActFileReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.tpm.feebudget.req.FeeBudgetControlOperateTypeEnum;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetControlReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActBudgetRespVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActFileRespVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TpmLiqueurServiceHelper
extends BaseServiceHelper {
    @Resource
    private MdmOrgFeign orgFeign;
    @Resource
    private MdmCustomerMsgFeign customerMsgFeign;
    @Resource
    private TpmCostTypeCategoriesMapper tpmCostTypeCategoriesMapper;
    @Resource
    private ActServiceHelper actServiceHelper;
    @Resource
    private TpmCostTypeCategoriesFineMapper categoriesFineMapper;
    @Autowired
    private TpmFeeBudgetControlServiceImpl feeBudgetControlService;
    @Resource
    private TpmCostTypeFineMapper tpmCostTypeFineMapper;
    @Autowired
    private ITpmFeeBudgetService feeBudgetService;
    @Resource
    private TpmFeeBudgetMapper feeBudgetMapper;
    @Resource
    private TpmBudgetSubjectsMapper subjectsMapper;
    @Resource
    private TpmLiqueurActBudgetMapper liqueurActBudgetMapper;
    @Resource
    private TpmFeeBudgetControlMapper feeBudgetControlMapper;
    @Autowired
    private TpmLiqueurActBudgetService liqueurActBudgetService;
    @Autowired
    private FeeBudgetServiceHelper budgetServiceHelper;
    @Resource
    private TpmLiqueurActFileMapper liqueurActFileMapper;
    @Resource
    TpmLiqueurActMapper liqueurActMapper;

    public Map<String, Map<String, String>> getDictMaps() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("act_approve_status");
        dictCodes.add("enable_status");
        dictCodes.add("yesOrNo");
        dictCodes.add("owned_sales_company");
        return DictUtil.getDictValueMapsByCodes((List)dictCodes);
    }

    public void setRespVoData(TpmLiqueurActRespVo respVo) {
        List<DictItemVo> dictItemVos;
        Map<String, Map<String, String>> dataMaps = this.getDictMaps();
        if (StringUtils.isNotEmpty((CharSequence)respVo.getApproveStatus())) {
            respVo.setApproveStatusName(Optional.ofNullable(dataMaps.get("act_approve_status")).orElse(Maps.newHashMap()).get(respVo.getApproveStatus()));
        }
        if (StringUtils.isNotEmpty((CharSequence)respVo.getEnableStatus())) {
            respVo.setEnableStatusName(Optional.ofNullable(dataMaps.get("enable_status")).orElse(Maps.newHashMap()).get(respVo.getEnableStatus()));
        }
        if (StringUtils.isNotEmpty((CharSequence)respVo.getIsCrossOrg())) {
            respVo.setIsCrossOrgDesc(Optional.ofNullable(dataMaps.get("yesOrNo")).orElse(Maps.newHashMap()).get(respVo.getIsCrossOrg()));
        }
        if (StringUtils.isNotEmpty((CharSequence)respVo.getIsAllAudit())) {
            respVo.setIsAllAuditDesc(Optional.ofNullable(dataMaps.get("yesOrNo")).orElse(Maps.newHashMap()).get(respVo.getIsAllAudit()));
        }
        if (StringUtils.isNotEmpty((CharSequence)respVo.getIsAudit())) {
            respVo.setIsAuditDesc(Optional.ofNullable(dataMaps.get("yesOrNo")).orElse(Maps.newHashMap()).get(respVo.getIsAudit()));
        }
        if (StringUtils.isNotEmpty((CharSequence)respVo.getOrgCode())) {
            List mdmOrgRespVos = (List)ApiResultUtil.objResult((Result)this.orgFeign.findOrgList(new MdmOrgReqVo()), (boolean)true);
            Map<String, String> orgMap = mdmOrgRespVos.stream().collect(Collectors.toMap(MdmOrgRespVo::getOrgCode, MdmOrgRespVo::getOrgName));
            dictItemVos = super.convertDictList(orgMap, respVo.getOrgCode());
            respVo.setOrgNameList(dictItemVos);
        }
        if (StringUtils.isNotEmpty((CharSequence)respVo.getCustomerCode())) {
            List cusList = (List)ApiResultUtil.objResult((Result)this.customerMsgFeign.findCustomerSelectList(new MdmCustomerMsgReqVo()), (boolean)true);
            Map<String, String> cusMap = cusList.stream().collect(Collectors.toMap(MdmCustomerMsgSelectRespVo::getCustomerCode, MdmCustomerMsgSelectRespVo::getCustomerName));
            dictItemVos = super.convertDictList(cusMap, respVo.getCustomerCode());
            respVo.setCusNameList(dictItemVos);
        }
        if (StringUtils.isNotEmpty((CharSequence)respVo.getSaleCompany())) {
            respVo.setSaleCompanyDesc(Optional.ofNullable(dataMaps.get("owned_sales_company")).orElse(Maps.newHashMap()).get(respVo.getSaleCompany()));
        }
    }

    public List<TpmBudgetSubjectsEntity> getTpmBudgetSubjectsEntities(TpmFeeBudgetControlRespVo o) {
        return this.subjectsMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmBudgetSubjectsEntity::getBudgetSubjectsCode, (Object)o.getBudgetSubjectsCode()));
    }

    public void saveOrUpdateAct(TpmLiqueurActEntity liqueurActEntity, TpmLiqueurActReqVo reqVo) {
        if (ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())) {
            liqueurActEntity.setApproveStatus(ActApproveStatusEnum.APPROVING.getCode());
        } else if (StringUtils.isEmpty((CharSequence)liqueurActEntity.getApproveStatus())) {
            liqueurActEntity.setApproveStatus(ActApproveStatusEnum.CREATE.getCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)liqueurActEntity.getId())) {
            this.liqueurActMapper.updateById((Object)liqueurActEntity);
        } else {
            this.liqueurActMapper.insert((Object)liqueurActEntity);
        }
    }

    public void saveActBudgets(List<TpmLiqueurActBudgetEntity> actBudgetEntities, TpmLiqueurActReqVo reqVo) {
        if (ActSaveTypeEnum.getUpdateTypes().contains(reqVo.getSaveType())) {
            this.liqueurActBudgetMapper.delete((Wrapper)new LambdaQueryWrapper().eq(TpmLiqueurActBudgetEntity::getActCode, (Object)reqVo.getActCode()));
        }
        actBudgetEntities.forEach(o -> o.setId(null));
        this.liqueurActBudgetService.saveBatch(actBudgetEntities);
    }

    public void saveActFiles(List<TpmLiqueurActFileEntity> liqueurActFileEntities, TpmLiqueurActReqVo reqVo) {
        if (ActSaveTypeEnum.getUpdateTypes().contains(reqVo.getSaveType())) {
            List list = liqueurActFileEntities.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getId())).map(BaseIdEntity::getId).collect(Collectors.toList());
            this.liqueurActFileMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().notIn(CollectionUtils.isNotEmpty(list), BaseIdEntity::getId, list)).eq(TpmLiqueurActFileEntity::getActCode, (Object)reqVo.getActCode()));
        }
        liqueurActFileEntities.forEach(o -> {
            if (StringUtils.isEmpty((CharSequence)o.getId())) {
                this.liqueurActFileMapper.insert(o);
            } else {
                this.liqueurActFileMapper.updateById(o);
            }
        });
    }

    public void saveFeeBudgets(List<TpmFeeBudgetEntity> feeBudgetEntities, TpmLiqueurActReqVo reqVo) {
        if (!ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())) {
            return;
        }
        this.feeBudgetService.updateBatchById(feeBudgetEntities);
    }

    public void saveBudgetController(List<TpmFeeBudgetControlEntity> feeBudgetControlEntities, TpmLiqueurActReqVo reqVo) {
        if (!ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())) {
            return;
        }
        for (TpmFeeBudgetControlEntity o : feeBudgetControlEntities) {
            OperateBudgetControlReqVo controlReqVo = OperateBudgetControlReqVo.builder().controlEntity(o).typeEnum(FeeBudgetControlOperateTypeEnum.USE).build();
            this.budgetServiceHelper.saveFeeBudgetControlData(controlReqVo);
        }
    }

    public StartProcessReqVo buildStartProcessData(TpmLiqueurActEntity entity, TpmLiqueurActReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        StartProcessReqVo startProcessReqVo = new StartProcessReqVo();
        startProcessReqVo.setCallBackFeign("TpmActCallBackFeign");
        startProcessReqVo.setProcessKey(reqVo.getWorkFlowKey());
        startProcessReqVo.setUserCode(user.getUsername());
        startProcessReqVo.setPosCode(user.getPoscode());
        startProcessReqVo.setTitle(reqVo.getTitle());
        startProcessReqVo.setFormNo(entity.getId());
        startProcessReqVo.setRemark(reqVo.getApproveRemarks());
        startProcessReqVo.setSignTicket(System.currentTimeMillis() + "");
        startProcessReqVo.setBusinessCode(entity.getActCode());
        List taActFileReqVos = Optional.ofNullable(reqVo.getActivityFileList()).orElse(Lists.newArrayList()).stream().map(o -> {
            TaActFileReqVo taActFileReqVo = new TaActFileReqVo();
            taActFileReqVo.setObjectName(o.getObjectName());
            taActFileReqVo.setFileAddress(o.getFileAddress());
            return taActFileReqVo;
        }).collect(Collectors.toList());
        startProcessReqVo.setFileList(taActFileReqVos);
        return startProcessReqVo;
    }

    public void setBudgetData(TpmLiqueurActRespVo actRespVo) {
        List liqueurActBudgetEntities = this.liqueurActBudgetMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmLiqueurActBudgetEntity::getActCode, (Object)actRespVo.getActCode()));
        if (CollectionUtils.isNotEmpty((Collection)liqueurActBudgetEntities)) {
            List respVos = CrmBeanUtil.copyList((List)liqueurActBudgetEntities, TpmLiqueurActBudgetRespVo.class);
            actRespVo.setBudgetVos(respVos);
            Map<String, List<TpmLiqueurActBudgetRespVo>> actBudgetGroupMap = respVos.stream().collect(Collectors.groupingBy(TpmLiqueurActBudgetRespVo::getControlId));
            HashMap controllerAndAmount = Maps.newHashMap();
            HashSet idSet = Sets.newHashSet();
            actBudgetGroupMap.keySet().forEach(x -> {
                BigDecimal applyAmount = ((List)actBudgetGroupMap.get(x)).stream().map(TpmLiqueurActBudgetRespVo::getApplyAmount).reduce(BigDecimal::add).get();
                idSet.add(x);
                controllerAndAmount.put(x, applyAmount);
            });
            List controlEntities = this.feeBudgetControlMapper.selectBatchIds(idSet);
            if (CollectionUtils.isNotEmpty((Collection)controlEntities)) {
                ArrayList arrayList = Lists.newArrayList();
            }
        }
    }

    public void setActFileData(TpmLiqueurActRespVo actRespVo) {
        List fileEntities = this.liqueurActFileMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmLiqueurActFileEntity::getActCode, (Object)actRespVo.getActCode()));
        if (CollectionUtils.isNotEmpty((Collection)fileEntities)) {
            List fileRespVos = CrmBeanUtil.copyList((List)fileEntities, TpmLiqueurActFileRespVo.class);
            actRespVo.setFileRespVos(fileRespVos);
        }
    }

    public void checkUpdate(TpmLiqueurActReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        TpmLiqueurActEntity entity = (TpmLiqueurActEntity)((Object)this.liqueurActMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(BaseIdEntity::getId, (Object)reqVo.getId())));
        AssertUtils.isNotNull((Object)((Object)entity), (CrmExceptionType)ActException.DATA_NOT_EXIST, (String[])new String[0]);
        if (!ActApproveStatusEnum.getCanUpdateStatus().contains(entity.getApproveStatus())) {
            throw new BusinessException("\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u4e0d\u5141\u8bb8\u4fee\u6539\u64cd\u4f5c");
        }
    }

    public TpmLiqueurActEntity saveCheckActStatus(TpmLiqueurActRegisterReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getActCode(), (String)"\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        TpmLiqueurActEntity actEntity = (TpmLiqueurActEntity)((Object)this.liqueurActMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(TpmLiqueurActEntity::getActCode, (Object)reqVo.getActCode())));
        if (actEntity == null) {
            throw new BusinessException("\u6ca1\u6709\u6d3b\u52a8\u7533\u8bf7\u4fe1\u606f");
        }
        if (!actEntity.getApproveStatus().equals(ActApproveStatusEnum.APPROVED.getCode())) {
            throw new BusinessException("\u53ea\u6709\u5ba1\u6279\u901a\u8fc7\u7684\u6d3b\u52a8\u624d\u53ef\u4ee5\u65b0\u589e\u6d3b\u52a8\u660e\u7ec6");
        }
        return actEntity;
    }

    public void checkOrgAndCus(TpmLiqueurActReqVo reqVo) {
        UserRedis userRedis = UserUtils.getUser();
        if (StringUtils.isNotEmpty((CharSequence)userRedis.getOrgcode()) && CollectionUtils.isNotEmpty((Collection)reqVo.getOrgCodeList())) {
            MdmOrgRespVo orgRespVo = (MdmOrgRespVo)ApiResultUtil.objResult((Result)this.orgFeign.detail(userRedis.getOrgcode()));
            MdmOrgReqVo mdmOrgReqVo = new MdmOrgReqVo();
            if (StringUtils.equals((CharSequence)reqVo.getIsCrossOrg(), (CharSequence)GlobalWhetherEnum.YES.getCode()) && StringUtils.isNotEmpty((CharSequence)orgRespVo.getParentCode())) {
                mdmOrgReqVo.setParentCode(orgRespVo.getParentCode());
                List orgRespVos = (List)ApiResultUtil.objResult((Result)this.orgFeign.findOrgList(mdmOrgReqVo), (boolean)true);
                List orgCodes = orgRespVos.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
                MdmOrgReqVo mdmOrgReqVoByReq = new MdmOrgReqVo();
                mdmOrgReqVoByReq.setOrgCodeList(orgCodes);
                List respVos = (List)ApiResultUtil.objResult((Result)this.orgFeign.listCondition(mdmOrgReqVoByReq), (boolean)true);
                List orgCodeList = respVos.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
                orgCodeList.retainAll(reqVo.getOrgCodeList());
                if (orgCodeList.size() != reqVo.getOrgCodeList().size()) {
                    reqVo.getOrgCodeList().removeAll(orgCodeList);
                    throw new BusinessException(reqVo.getOrgCodeList() + "\u8be5\u7ec4\u7ec7\u4e0d\u5728\u6743\u9650\u8303\u56f4");
                }
            } else {
                mdmOrgReqVo.setOrgCodeList((Collection)reqVo.getOrgCodeList());
                List respVos = (List)ApiResultUtil.objResult((Result)this.orgFeign.listCondition(mdmOrgReqVo), (boolean)true);
                Map orgRespVoMap = respVos.stream().collect(Collectors.toMap(MdmOrgRespVo::getOrgCode, Function.identity(), (k1, k2) -> k1));
                orgRespVoMap.keySet().forEach(o -> {
                    if (!StringUtils.startsWith((CharSequence)((MdmOrgRespVo)orgRespVoMap.get(o)).getRuleCode(), (CharSequence)orgRespVo.getRuleCode())) {
                        throw new BusinessException(((MdmOrgRespVo)orgRespVoMap.get(o)).getOrgCode() + "\u8be5\u7ec4\u7ec7\u4e0d\u5728\u6743\u9650\u8303\u56f4");
                    }
                });
            }
            reqVo.setOrgCode(reqVo.getOrgCodeList().toString());
            if (CollectionUtils.isNotEmpty((Collection)reqVo.getCustomerCodeList())) {
                MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo = new MdmCustomerOrgSearchReqVo();
                mdmCustomerOrgSearchReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                mdmCustomerOrgSearchReqVo.setLockState(CrmEnableStatusEnum.ENABLE.getCode());
                mdmCustomerOrgSearchReqVo.setOrgCodeList(reqVo.getOrgCodeList());
                List customerMsgRespVos = (List)ApiResultUtil.objResult((Result)this.customerMsgFeign.findCurrentAndSubCustomerList(mdmCustomerOrgSearchReqVo), (boolean)true);
                List codeList = customerMsgRespVos.stream().map(MdmCustomerMsgRespVo::getCustomerCode).collect(Collectors.toList());
                codeList.removeAll(reqVo.getCustomerCodeList());
                if (codeList.size() != reqVo.getCustomerCodeList().size()) {
                    reqVo.getCustomerCodeList().removeAll(codeList);
                    throw new BusinessException(reqVo.getCustomerCodeList() + "\u8be5\u5ba2\u6237\u4e0d\u5728\u53ef\u9009\u8303\u56f4\u5185");
                }
                reqVo.setCustomerCode(reqVo.getCustomerCodeList().toString());
            }
        }
    }

    public void checkBudgetData(TpmLiqueurActReqVo reqVo) {
        Set<String> controllerIds = reqVo.getBudgetControlVos().stream().map(UuidVo::getId).collect(Collectors.toSet());
        List<TpmFeeBudgetControlEntity> controlEntities = this.actServiceHelper.findFeeBudgetControls(controllerIds);
        if (reqVo.getBudgetControlVos().size() != controlEntities.size()) {
            throw new BusinessException("\u9884\u7b97\u6570\u636e\u5f02\u5e38");
        }
    }

    public void checkBudgets(TpmLiqueurActReqVo reqVo) {
        List fineEntities = this.tpmCostTypeFineMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmCostTypeFineEntity::getFineCode, (Object)reqVo.getFineCode()));
        if (CollectionUtils.size((Object)fineEntities) != 1) {
            throw new BusinessException("\u6d3b\u52a8\u7c7b\u578b\u5f02\u5e38");
        }
        reqVo.setFineName(((TpmCostTypeFineEntity)((Object)fineEntities.get(0))).getFineName());
        List categoriesFineEntities = this.categoriesFineMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmCostTypeCategoriesFineEntity::getFineCode, (Object)reqVo.getFineCode()));
        if (CollectionUtils.isEmpty((Collection)categoriesFineEntities)) {
            throw new BusinessException(reqVo.getFineCode() + "\u6d3b\u52a8\u7c7b\u578b\u6ca1\u6709\u5173\u8054\u6295\u5165\u7c7b\u578b\uff0c\u65e0\u6cd5\u9009\u62e9\u9884\u7b97");
        }
        Set<Object> categoriesSets = Sets.newHashSet();
        categoriesSets = categoriesFineEntities.stream().map(TpmCostTypeCategoriesFineEntity::getCategoriesCode).collect(Collectors.toSet());
        List categoriesEntities = this.tpmCostTypeCategoriesMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(TpmCostTypeCategoriesEntity::getCategoriesCode, (Collection)categoriesSets));
        if (CollectionUtils.isEmpty((Collection)categoriesEntities)) {
            throw new BusinessException("\u5173\u8054\u6295\u5165\u7c7b\u578b\u4e0d\u5b58\u5728,\u65e0\u6cd5\u83b7\u53d6\u9884\u7b97");
        }
        Set budgetSubjectSetByCate = categoriesEntities.stream().map(TpmCostTypeCategoriesEntity::getBudgetSubjectsCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(budgetSubjectSetByCate)) {
            throw new BusinessException("\u6295\u5165\u7c7b\u578b\u6570\u636e\u5f02\u5e38");
        }
        AssertUtils.isNotEmpty((Collection)reqVo.getBudgetControlVos(), (String)"\u8bf7\u9009\u62e9\u9884\u7b97");
        TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo = new TpmFeeBudgetControlReqVo();
        tpmFeeBudgetControlReqVo.setActBeginDate(reqVo.getBeginDate());
        tpmFeeBudgetControlReqVo.setActEndDate(reqVo.getEndDate());
        List feeBudgetControlRespVoList = this.feeBudgetControlService.findList(tpmFeeBudgetControlReqVo).getData();
        if (CollectionUtils.isEmpty((Collection)feeBudgetControlRespVoList)) {
            throw new BusinessException("\u5f53\u524d\u65f6\u95f4\u6bb5\u6ca1\u6709\u53ef\u7528\u9884\u7b97");
        }
        Set budgetSubjectSets = feeBudgetControlRespVoList.stream().map(TpmFeeBudgetControlRespVo::getBudgetSubjectsCode).collect(Collectors.toSet());
        if (budgetSubjectSetByCate.containsAll(budgetSubjectSets)) {
            throw new BusinessException("\u9884\u7b97\u4e0d\u652f\u6301\u5f53\u524d\u6d3b\u52a8\u7c7b\u578b");
        }
    }

    public List<TpmFeeBudgetControlEntity> findControlByIds(Set<String> ids) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(BaseIdEntity::getId, ids);
        List tpmFeeBudgetControlEntities = this.feeBudgetControlMapper.selectList((Wrapper)queryWrapper);
        return CollectionUtils.isEmpty((Collection)tpmFeeBudgetControlEntities) ? Lists.newArrayList() : tpmFeeBudgetControlEntities;
    }

    public List<TpmFeeBudgetEntity> findFeeBudgetByControlIds(Set<String> ids) {
        List feeBudgetEntities = this.feeBudgetMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TpmFeeBudgetEntity::getControlId, ids)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode()));
        return CollectionUtils.isEmpty((Collection)feeBudgetEntities) ? Lists.newArrayList() : feeBudgetEntities;
    }
}

