/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.income.mapper.TpmIncomeBudgetMapper;
import com.biz.crm.income.model.TpmIncomeBudgetEntity;
import com.biz.crm.income.service.ITpmIncomeBudgetService;
import com.biz.crm.income.service.impl.InComeServiceHelp;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.mdm.productlevel.MdmProductLevelFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelSelectReqVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelSelectRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmCustomerTerminalVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.tpm.income.req.TpmIncomeBudgetReqVo;
import com.biz.crm.nebular.tpm.income.resp.TpmIncomeBudgetRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmIncomeBudgetServiceExpandImpl"})
public class TpmIncomeBudgetServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmIncomeBudgetMapper, TpmIncomeBudgetEntity>
implements ITpmIncomeBudgetService {
    private static final Logger log = LoggerFactory.getLogger(TpmIncomeBudgetServiceImpl.class);
    @Resource
    private TpmIncomeBudgetMapper tpmIncomeBudgetMapper;
    @Autowired
    private InComeServiceHelp inComeHelpService;
    @Autowired
    private MdmOrgFeign mdmOrgFeign;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Autowired
    private MdmTerminalFeign terminalFeign;
    @Autowired
    private MdmProductFeign mdmProductFeign;
    @Autowired
    private MdmProductLevelFeign mdmProductLevelFeign;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;

    @Override
    public PageResult<TpmIncomeBudgetRespVo> findList(TpmIncomeBudgetReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<TpmIncomeBudgetRespVo> list = this.tpmIncomeBudgetMapper.findList((Page<TpmIncomeBudgetRespVo>)page, reqVo);
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(o -> this.inComeHelpService.setRespVoData((TpmIncomeBudgetRespVo)o));
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmIncomeBudgetRespVo query(String id) {
        AssertUtils.isNotEmpty((String)id, (CrmExceptionType)CommonException.IDS_NULL);
        List entities = this.tpmIncomeBudgetMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(BaseIdEntity::getId, (Object)id));
        if (entities.size() > 1) {
            throw new BusinessException("\u6570\u636e\u5f02\u5e38");
        }
        if (entities.size() < 1) {
            throw new BusinessException("\u4e0d\u5b58\u5728\u8be5\u6570\u636e");
        }
        TpmIncomeBudgetRespVo tpmIncomeBudgetRespVo = (TpmIncomeBudgetRespVo)CrmBeanUtil.copy(entities.get(0), TpmIncomeBudgetRespVo.class);
        this.inComeHelpService.setRespVoData(tpmIncomeBudgetRespVo);
        return tpmIncomeBudgetRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TpmIncomeBudgetReqVo reqVo) {
        this.inComeHelpService.checkData(reqVo);
        TpmIncomeBudgetEntity entity = (TpmIncomeBudgetEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmIncomeBudgetEntity.class));
        this.save((Object)entity);
        TpmIncomeBudgetRespVo newData = (TpmIncomeBudgetRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmIncomeBudgetRespVo.class);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        this.crmLogSendUtil.sendForAdd(menuCodeObj.toString(), newData.getId(), newData.getIncomeCode(), (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TpmIncomeBudgetReqVo reqVo) {
        this.inComeHelpService.updateCheck(reqVo);
        this.inComeHelpService.checkData(reqVo);
        TpmIncomeBudgetEntity entity = (TpmIncomeBudgetEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmIncomeBudgetEntity.class));
        TpmIncomeBudgetRespVo oldData = this.query(reqVo.getId());
        this.updateById((Object)entity);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        TpmIncomeBudgetRespVo newData = (TpmIncomeBudgetRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmIncomeBudgetRespVo.class);
        this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), newData.getId(), newData.getIncomeCode(), (Object)oldData, (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List tpmIncomeBudgetEntities = this.tpmIncomeBudgetMapper.selectBatchIds(ids);
        List oldDataList = CrmBeanUtil.copyList((List)tpmIncomeBudgetEntities, TpmIncomeBudgetRespVo.class);
        if (CollectionUtils.isNotEmpty((Collection)tpmIncomeBudgetEntities)) {
            tpmIncomeBudgetEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmIncomeBudgetEntities);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        List newDataList = CrmBeanUtil.copyList((List)tpmIncomeBudgetEntities, TpmIncomeBudgetRespVo.class);
        for (int i = 0; i < newDataList.size(); ++i) {
            this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), ((TpmIncomeBudgetRespVo)newDataList.get(i)).getId(), ((TpmIncomeBudgetRespVo)newDataList.get(i)).getIncomeCode(), oldDataList.get(i), newDataList.get(i));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List tpmIncomeBudgetEntities = this.tpmIncomeBudgetMapper.selectBatchIds(ids);
        List oldDataList = CrmBeanUtil.copyList((List)tpmIncomeBudgetEntities, TpmIncomeBudgetRespVo.class);
        if (CollectionUtils.isNotEmpty((Collection)tpmIncomeBudgetEntities)) {
            tpmIncomeBudgetEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmIncomeBudgetEntities);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        List newDataList = CrmBeanUtil.copyList((List)tpmIncomeBudgetEntities, TpmIncomeBudgetRespVo.class);
        for (int i = 0; i < newDataList.size(); ++i) {
            this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), ((TpmIncomeBudgetRespVo)newDataList.get(i)).getId(), ((TpmIncomeBudgetRespVo)newDataList.get(i)).getIncomeCode(), oldDataList.get(i), newDataList.get(i));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchDelete(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List entities = this.tpmIncomeBudgetMapper.selectBatchIds(ids);
        ArrayList removeIds = Lists.newArrayList();
        List oldDataList = CrmBeanUtil.copyList((List)entities, TpmIncomeBudgetRespVo.class);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            entities.forEach(o -> removeIds.add(o.getId()));
            this.removeByIds(removeIds);
        }
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        for (TpmIncomeBudgetRespVo oldData : oldDataList) {
            this.crmLogSendUtil.sendForDel(menuCodeObj.toString(), oldData.getId(), oldData.getIncomeCode(), (Object)oldData);
        }
    }

    @Override
    public List<MdmOrgRespVo> findAllOrgCodes(MdmOrgReqVo mdmOrgReqVo) {
        Result orgRespVos;
        mdmOrgReqVo.setOrgCode(UserUtils.getUser().getOrgcode());
        try {
            orgRespVos = this.mdmOrgFeign.findAllChildrenOrgList(mdmOrgReqVo);
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
            throw new BusinessException("\u6536\u5165\u9884\u7b97\u65b0\u589e\u83b7\u53d6\u6240\u6709\u7ec4\u7ec7,\u8c03\u7528mdm\u63a5\u53e3\u5931\u8d25");
        }
        return (List)ApiResultUtil.objResult((Result)orgRespVos, (boolean)true);
    }

    @Override
    public List<MdmCustomerMsgRespVo> findCustomerByOrgCode(List<String> codes) {
        Result customerOrgRespVos;
        MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo = new MdmCustomerOrgSearchReqVo();
        mdmCustomerOrgSearchReqVo.setOrgCodeList(codes);
        try {
            customerOrgRespVos = this.mdmCustomerMsgFeign.findCurrentAndSubCustomerList(mdmCustomerOrgSearchReqVo);
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
            throw new BusinessException("\u6536\u5165\u9884\u7b97\u65b0\u589e\u83b7\u53d6\u5bf9\u5e94\u5ba2\u6237,\u8c03\u7528mdm\u63a5\u53e3\u5931\u8d25");
        }
        return (List)ApiResultUtil.objResult((Result)customerOrgRespVos, (boolean)true);
    }

    @Override
    public List<MdmTerminalVo> findTerminalByOrgCode(List<String> codes) {
        Result terminalRespVos;
        try {
            MdmCustomerTerminalVo mdmCustomerTerminalVo = new MdmCustomerTerminalVo();
            mdmCustomerTerminalVo.setCustomerCodeList(codes);
            terminalRespVos = this.terminalFeign.customerTerminalList(mdmCustomerTerminalVo);
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
            throw new BusinessException("\u6536\u5165\u9884\u7b97\u65b0\u589e\u83b7\u53d6\u5bf9\u5e94\u95e8\u5e97,\u8c03\u7528mdm\u63a5\u53e3\u5931\u8d25");
        }
        return (List)ApiResultUtil.objResult((Result)terminalRespVos, (boolean)true);
    }

    @Override
    public List<MdmProductRespVo> findAllProduct(MdmProductReqVo mdmProductReqVo) {
        Result productRespVos;
        try {
            mdmProductReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            productRespVos = this.mdmProductFeign.listCondition(mdmProductReqVo);
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
            throw new BusinessException("\u6536\u5165\u9884\u7b97\u83b7\u53d6\u5546\u54c1\uff0c\u8c03\u7528mdm\u63a5\u53e3\u5931\u8d25");
        }
        return (List)ApiResultUtil.objResult((Result)productRespVos, (boolean)true);
    }

    @Override
    public List<MdmProductRespVo> findAllProductByLevelCode(List<String> levelCode) {
        Result productRespVos;
        try {
            productRespVos = this.mdmProductFeign.queryBatchByProductLevelCodeList(levelCode);
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
            throw new BusinessException("\u6536\u5165\u9884\u7b97\u901a\u8fc7\u5c42\u7ea7\u53ca\u4e0b\u7ea7\u83b7\u53d6\u5546\u54c1\uff0c\u8c03\u7528mdm\u63a5\u53e3\u5931\u8d25");
        }
        return (List)ApiResultUtil.objResult((Result)productRespVos, (boolean)true);
    }

    @Override
    public List<MdmProductLevelSelectRespVo> findAllProductLevel(MdmProductLevelSelectReqVo mdmProductLevelSelectReqVo) {
        Result productLevelRespVos;
        try {
            productLevelRespVos = this.mdmProductLevelFeign.productLevelSelectList(mdmProductLevelSelectReqVo);
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
            throw new BusinessException("\u6536\u5165\u9884\u7b97\u83b7\u53d6\u5c42\u7ea7\u53ca\u4e0b\u7ea7\uff0c\u8c03\u7528mdm\u63a5\u53e3\u5931\u8d25");
        }
        return (List)ApiResultUtil.objResult((Result)productLevelRespVos, (boolean)true);
    }
}

