/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.liqueuract.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesFineMapper;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesMapper;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesEntity;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesFineEntity;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActSaveTypeEnum;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.ActException;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActBudgetMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActRegisterDetailAttachMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActRegisterDetailBudgetMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActRegisterDetailMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActRegisterMapper;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetTransactionEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterDetailAttachEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterDetailBudgetEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterDetailEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterEntity;
import com.biz.crm.liqueuract.service.ITpmLiqueurActBudgetTransactionService;
import com.biz.crm.liqueuract.service.ITpmLiqueurActRegisterDetailAttachService;
import com.biz.crm.liqueuract.service.ITpmLiqueurActRegisterDetailBudgetService;
import com.biz.crm.liqueuract.service.ITpmLiqueurActRegisterDetailService;
import com.biz.crm.liqueuract.service.TpmLiqueurActBudgetService;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.act.req.TaActFileReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class TpmLiqueurActRegisterServiceHelper
extends BaseServiceHelper {
    @Resource
    private TpmLiqueurActBudgetMapper actBudgetMapper;
    @Resource
    private TpmLiqueurActRegisterMapper registerMapper;
    @Resource
    private TpmLiqueurActMapper actMapper;
    @Resource
    private TpmCostTypeCategoriesFineMapper costTypeCategoriesFineMapper;
    @Resource
    private TpmCostTypeCategoriesMapper costTypeCategoriesMapper;
    @Resource
    private TpmLiqueurActRegisterDetailMapper detailMapper;
    @Resource
    private TpmLiqueurActRegisterDetailBudgetMapper detailBudgetMapper;
    @Resource
    private TpmLiqueurActRegisterDetailAttachMapper detailAttachMapper;
    @Autowired
    private ITpmLiqueurActRegisterDetailAttachService detailAttachService;
    @Autowired
    private ITpmLiqueurActRegisterDetailService detailService;
    @Autowired
    private ITpmLiqueurActRegisterDetailBudgetService detailBudgetService;
    @Autowired
    private ITpmLiqueurActBudgetTransactionService actBudgetTransactionService;
    @Autowired
    private TpmLiqueurActBudgetService actBudgetService;

    public Map<String, Map<String, String>> getDicts() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("enable_status");
        dictCodes.add("act_approve_status");
        return DictUtil.getDictValueMapsByCodes((List)dictCodes);
    }

    public void convertListDate(List<TpmLiqueurActRegisterRespVo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Map<String, Map<String, String>> map = this.getDicts();
            list.forEach(o -> {
                if (StringUtils.isNotEmpty((CharSequence)o.getEnableStatus())) {
                    o.setEnableStatusName((String)((Map)Optional.ofNullable(map.get("enable_status")).orElse(Maps.newHashMap())).get(o.getEnableStatus()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getApproveStatus())) {
                    o.setApproveStatusName((String)((Map)Optional.ofNullable(map.get("act_approve_status")).orElse(Maps.newHashMap())).get(o.getApproveStatus()));
                }
            });
        }
    }

    public TpmLiqueurActEntity findActEntityByCode(String actCode) {
        AssertUtils.isNotEmpty((String)actCode, (String)"\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TpmLiqueurActEntity::getActCode, (Object)actCode);
        return (TpmLiqueurActEntity)((Object)this.actMapper.selectOne((Wrapper)wrapper));
    }

    public List<TpmLiqueurActBudgetEntity> findActBudgetByActCode(String actCode) {
        AssertUtils.isNotEmpty((String)actCode, (String)"\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TpmLiqueurActBudgetEntity::getActCode, (Object)actCode);
        return this.actBudgetMapper.selectList((Wrapper)wrapper);
    }

    public Map<String, TpmCostTypeCategoriesEntity> findCategoriesMapByFineCode(String fineCode) {
        AssertUtils.isNotEmpty((String)fineCode, (String)"\u6d3b\u52a8\u7c7b\u578b(\u6d3b\u52a8\u7ec6\u7c7b)\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper costTypeCategoriesFineWrapper = new LambdaQueryWrapper();
        costTypeCategoriesFineWrapper.eq(TpmCostTypeCategoriesFineEntity::getFineCode, (Object)fineCode);
        List tpmCostTypeCategoriesFineEntities = this.costTypeCategoriesFineMapper.selectList((Wrapper)costTypeCategoriesFineWrapper);
        ArrayList categoriesCodes = Lists.newArrayList();
        tpmCostTypeCategoriesFineEntities.stream().forEach(o -> categoriesCodes.add(o.getCategoriesCode()));
        LambdaQueryWrapper costTypeCategoriesWrapper = new LambdaQueryWrapper();
        costTypeCategoriesWrapper.in(TpmCostTypeCategoriesEntity::getCategoriesCode, (Collection)categoriesCodes);
        List tpmCostTypeCategoriesEntities = this.costTypeCategoriesMapper.selectList((Wrapper)costTypeCategoriesWrapper);
        Map<String, TpmCostTypeCategoriesEntity> map = tpmCostTypeCategoriesEntities.stream().collect(Collectors.toMap(TpmCostTypeCategoriesEntity::getCategoriesCode, Function.identity(), (k1, k2) -> k1));
        return map;
    }

    public void deleteCheck(List<String> ids) {
        List entities = this.registerMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmLiqueurActRegisterEntity.class).in(BaseIdEntity::getId, ids));
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append("\u6d3b\u52a8\u767b\u8bb0\u7f16\u7801:[");
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            StringBuffer msg = new StringBuffer();
            entities.forEach(o -> {
                if (!StringUtils.equals((CharSequence)ActApproveStatusEnum.CREATE.getCode(), (CharSequence)o.getApproveStatus())) {
                    msg.append(o.getActCode()).append(",");
                }
            });
            if (StringUtils.isNotEmpty((CharSequence)msg.toString())) {
                throw new BusinessException(errorMsg.append(msg.toString()).append("],\u7684\u6d3b\u52a8\u72b6\u6001\u4e0d\u4e3a\u5f85\u63d0\u4ea4,\u4e0d\u80fd\u5220\u9664").toString());
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public TpmLiqueurActRegisterEntity saveOrUpdateActRegister(TpmLiqueurActRegisterEntity actRegisterEntity, TpmLiqueurActRegisterReqVo reqVo) {
        if (ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())) {
            actRegisterEntity.setApproveStatus(ActApproveStatusEnum.APPROVING.getCode());
        } else if (StringUtils.isEmpty((CharSequence)actRegisterEntity.getApproveStatus())) {
            actRegisterEntity.setApproveStatus(ActApproveStatusEnum.CREATE.getCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)actRegisterEntity.getId())) {
            this.registerMapper.updateById((Object)actRegisterEntity);
        } else {
            this.registerMapper.insert((Object)actRegisterEntity);
        }
        return actRegisterEntity;
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveActRegisterBudgets(List<TpmLiqueurActRegisterDetailBudgetEntity> actRegisterDetailBudgetEntities, TpmLiqueurActRegisterReqVo reqVo) {
        if (ActSaveTypeEnum.getUpdateTypes().contains(reqVo.getSaveType())) {
            List ids = actRegisterDetailBudgetEntities.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getId())).map(BaseIdEntity::getId).collect(Collectors.toList());
            this.detailBudgetMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmLiqueurActRegisterDetailBudgetEntity::getActRegisterCode, (Object)reqVo.getActRegisterCode())).notIn(CollectionUtils.isNotEmpty(ids), BaseIdEntity::getId, ids));
        }
        this.detailBudgetService.saveOrUpdateBatch(actRegisterDetailBudgetEntities);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveActRegisterDetails(List<TpmLiqueurActRegisterDetailEntity> actDetailEntities, TpmLiqueurActRegisterReqVo reqVo) {
        if (ActSaveTypeEnum.getUpdateTypes().contains(reqVo.getSaveType())) {
            List list = actDetailEntities.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getId())).map(BaseIdEntity::getId).collect(Collectors.toList());
            this.detailMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().notIn(CollectionUtils.isNotEmpty(list), BaseIdEntity::getId, list)).eq(TpmLiqueurActRegisterDetailEntity::getActRegisterCode, (Object)reqVo.getActRegisterCode()));
        }
        this.detailService.saveOrUpdateBatch(actDetailEntities);
    }

    public void saveActRegisterAttaches(List<TpmLiqueurActRegisterDetailAttachEntity> attachEntities, TpmLiqueurActRegisterReqVo reqVo) {
        if (CollectionUtils.isNotEmpty(attachEntities)) {
            if (ActSaveTypeEnum.getUpdateTypes().contains(reqVo.getSaveType())) {
                List list = attachEntities.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getId())).map(BaseIdEntity::getId).collect(Collectors.toList());
                this.detailAttachMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().notIn(CollectionUtils.isNotEmpty(list), BaseIdEntity::getId, list)).eq(TpmLiqueurActRegisterDetailAttachEntity::getActRegisterCode, (Object)reqVo.getActRegisterCode()));
            }
            this.detailAttachService.saveOrUpdateBatch(attachEntities);
        } else if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            this.detailAttachMapper.delete((Wrapper)Wrappers.lambdaQuery(TpmLiqueurActRegisterDetailAttachEntity.class).eq(TpmLiqueurActRegisterDetailAttachEntity::getActRegisterCode, (Object)reqVo.getActRegisterCode()));
        }
    }

    public void saveActBudgetTransactions(List<TpmLiqueurActBudgetTransactionEntity> transactionEntities, TpmLiqueurActRegisterReqVo reqVo) {
        if (!ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())) {
            return;
        }
        this.actBudgetTransactionService.saveBatch(transactionEntities);
    }

    public void saveActFeeBudgets(List<TpmLiqueurActBudgetEntity> actBudgetEntities, TpmLiqueurActRegisterReqVo reqVo) {
        if (!ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())) {
            return;
        }
        this.actBudgetService.updateBatchById(actBudgetEntities);
    }

    public void updateCheck(TpmLiqueurActRegisterReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        TpmLiqueurActRegisterEntity entity = (TpmLiqueurActRegisterEntity)((Object)this.registerMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(BaseIdEntity::getId, (Object)reqVo.getId())));
        AssertUtils.isNotNull((Object)((Object)entity), (CrmExceptionType)ActException.DATA_NOT_EXIST, (String[])new String[0]);
        if (!ActApproveStatusEnum.getCanUpdateStatus().contains(entity.getApproveStatus())) {
            throw new BusinessException("\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u4e0d\u5141\u8bb8\u4fee\u6539\u64cd\u4f5c");
        }
    }

    public TpmLiqueurActRegisterEntity approvedCheck(TpmLiqueurActRegisterReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        TpmLiqueurActRegisterEntity entity = (TpmLiqueurActRegisterEntity)((Object)this.registerMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(BaseIdEntity::getId, (Object)reqVo.getId())));
        AssertUtils.isNotNull((Object)((Object)entity), (String)"\u5f53\u524d\u6d3b\u52a8\u6570\u636e\u4e0d\u5b58\u5728");
        if (!StringUtils.equals((CharSequence)ActApproveStatusEnum.APPROVING.getCode(), (CharSequence)entity.getApproveStatus())) {
            return null;
        }
        return entity;
    }

    public TpmLiqueurActRegisterEntity rejectAndInterruptCheck(TpmLiqueurActRegisterReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        TpmLiqueurActRegisterEntity entity = (TpmLiqueurActRegisterEntity)((Object)this.registerMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(BaseIdEntity::getId, (Object)reqVo.getId())));
        if (!StringUtils.equals((CharSequence)ActApproveStatusEnum.APPROVING.getCode(), (CharSequence)entity.getApproveStatus())) {
            return null;
        }
        entity.setApproveStatus(reqVo.getApproveStatus());
        return entity;
    }

    public StartProcessReqVo buildStartProcessData(TpmLiqueurActRegisterEntity entity, TpmLiqueurActRegisterReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        StartProcessReqVo startProcessReqVo = new StartProcessReqVo();
        startProcessReqVo.setCallBackFeign("TpmActRegisterCallBackFeign");
        startProcessReqVo.setProcessKey(reqVo.getWorkFlowKey());
        startProcessReqVo.setUserCode(user.getUsername());
        startProcessReqVo.setPosCode(user.getPoscode());
        startProcessReqVo.setTitle(reqVo.getTitle());
        startProcessReqVo.setFormNo(entity.getId());
        startProcessReqVo.setRemark(reqVo.getApproveRemarks());
        startProcessReqVo.setSignTicket(System.currentTimeMillis() + "");
        startProcessReqVo.setBusinessCode(entity.getActCode());
        List taActFileReqVos = Optional.ofNullable(reqVo.getActivityFileList()).orElse(Lists.newArrayList()).stream().map(o -> {
            TaActFileReqVo taActFileReqVo = new TaActFileReqVo();
            taActFileReqVo.setObjectName(o.getObjectName());
            taActFileReqVo.setFileAddress(o.getFileAddress());
            return taActFileReqVo;
        }).collect(Collectors.toList());
        startProcessReqVo.setFileList(taActFileReqVos);
        return startProcessReqVo;
    }
}

