/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.liqueuract.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActSendMessageTypeEnum;
import com.biz.crm.eunm.tpm.TpmProjectNameEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActRegisterDetailAttachMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActRegisterDetailBudgetMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActRegisterDetailMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActRegisterMapper;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterDetailAttachEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterDetailBudgetEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterDetailEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterEntity;
import com.biz.crm.liqueuract.service.ITpmLiqueurActRegisterService;
import com.biz.crm.liqueuract.service.impl.TpmLiqueurActRegisterServiceHelper;
import com.biz.crm.liqueuract.service.impl.actbuilder.ActRegisterBuilder;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.common.ProcessCommonVo;
import com.biz.crm.nebular.tpm.act.req.TpmActSendMessageVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterDetailAttachRespVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterDetailBudgetRespVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterDetailRespVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmLiqueurDetailServiceExpandImpl"})
public class TpmLiqueurActRegisterServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmLiqueurActRegisterMapper, TpmLiqueurActRegisterEntity>
implements ITpmLiqueurActRegisterService {
    private static final Logger log = LoggerFactory.getLogger(TpmLiqueurActRegisterServiceImpl.class);
    @Autowired
    private TaActBaseFeign activityFeign;
    @Resource
    private TpmLiqueurActRegisterMapper tpmLiqueurActRegisterMapper;
    @Resource
    private TpmLiqueurActRegisterDetailBudgetMapper budgetMapper;
    @Resource
    private TpmLiqueurActRegisterDetailAttachMapper attachMapper;
    @Resource
    private TpmLiqueurActRegisterDetailMapper detailMapper;
    @Autowired
    private TpmLiqueurActRegisterServiceHelper helper;
    @Autowired
    private RocketMQProducer rocketMQProducer;
    @Value(value="${rocketmq.topic}${rocketmq.environment-variable}")
    private String topic;

    @Override
    public PageResult<TpmLiqueurActRegisterRespVo> findList(TpmLiqueurActRegisterReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<TpmLiqueurActRegisterRespVo> list = this.tpmLiqueurActRegisterMapper.findList((Page<TpmLiqueurActRegisterRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmLiqueurActRegisterRespVo query(String id) {
        AssertUtils.isNotEmpty((String)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        TpmLiqueurActRegisterReqVo tpmLiqueurActRegisterReqVo = new TpmLiqueurActRegisterReqVo();
        tpmLiqueurActRegisterReqVo.setId(id);
        List list = this.findList(tpmLiqueurActRegisterReqVo).getData();
        AssertUtils.isNotEmpty((Collection)list, (String)"\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e0d\u5b58\u5728");
        TpmLiqueurActRegisterRespVo respVo = (TpmLiqueurActRegisterRespVo)list.get(0);
        AssertUtils.isNotEmpty((String)respVo.getActRegisterCode(), (String)"\u8be5\u6570\u636e\u6d3b\u52a8\u767b\u8bb0\u5355\u53f7\u4e3a\u7a7a");
        LambdaQueryWrapper budgetWrapper = new LambdaQueryWrapper();
        budgetWrapper.eq(TpmLiqueurActRegisterDetailBudgetEntity::getActRegisterCode, (Object)respVo.getActRegisterCode());
        List tpmLiqueurActRegisterDetailBudgetEntities = this.budgetMapper.selectList((Wrapper)budgetWrapper);
        List budgetRespVos = CrmBeanUtil.copyList((List)tpmLiqueurActRegisterDetailBudgetEntities, TpmLiqueurActRegisterDetailBudgetRespVo.class);
        respVo.setBudgetRespVoList(budgetRespVos);
        List detailEntities = this.detailMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(TpmLiqueurActRegisterDetailEntity::getActRegisterCode, (Object)respVo.getActRegisterCode()));
        List detailRespVos = CrmBeanUtil.copyList((List)detailEntities, TpmLiqueurActRegisterDetailRespVo.class);
        respVo.setDetailRespVoList(detailRespVos);
        LambdaQueryWrapper attachWrapper = new LambdaQueryWrapper();
        attachWrapper.eq(TpmLiqueurActRegisterDetailAttachEntity::getActRegisterCode, (Object)respVo.getActRegisterCode());
        List tpmLiqueurActRegisterDetailAttachEntities = this.attachMapper.selectList((Wrapper)attachWrapper);
        List attachRespVos = CrmBeanUtil.copyList((List)tpmLiqueurActRegisterDetailAttachEntities, TpmLiqueurActRegisterDetailAttachRespVo.class);
        respVo.setAttachRespVoList(attachRespVos);
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TpmLiqueurActRegisterReqVo reqVo) {
        ActRegisterBuilder builder = new ActRegisterBuilder(this.helper, reqVo);
        TpmLiqueurActRegisterEntity entity = builder.init().check().convert().save();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TpmLiqueurActRegisterReqVo reqVo) {
        this.helper.updateCheck(reqVo);
        ActRegisterBuilder builder = new ActRegisterBuilder(this.helper, reqVo);
        TpmLiqueurActRegisterEntity entity = builder.init().check().convert().update();
        this.sendToActivity(entity, reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        this.helper.deleteCheck(ids);
        this.tpmLiqueurActRegisterMapper.deleteByParams(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        List tpmLiqueurActRegisterEntities = this.tpmLiqueurActRegisterMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)tpmLiqueurActRegisterEntities)) {
            tpmLiqueurActRegisterEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmLiqueurActRegisterEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        List tpmLiqueurActRegisterEntities = this.tpmLiqueurActRegisterMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)tpmLiqueurActRegisterEntities)) {
            tpmLiqueurActRegisterEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmLiqueurActRegisterEntities);
    }

    @Transactional(rollbackFor={Exception.class})
    public void sendToActivity(TpmLiqueurActRegisterEntity entity, TpmLiqueurActRegisterReqVo reqVo) {
        if (StringUtils.equals((CharSequence)ActApproveStatusEnum.APPROVING.getCode(), (CharSequence)entity.getApproveStatus())) {
            StartProcessReqVo processReqVo = this.helper.buildStartProcessData(entity, reqVo);
            Result processCommonVoResult = this.activityFeign.startProcess(processReqVo);
            if (!Objects.equals(CommonConstant.SC_OK_200, processCommonVoResult.getCode())) {
                throw new BusinessException(processCommonVoResult.getMessage());
            }
            entity.setProcessCode(((ProcessCommonVo)processCommonVoResult.getResult()).getProcessNo());
            this.saveOrUpdate((Object)entity);
        }
    }

    @Override
    public void approve(TpmLiqueurActRegisterReqVo reqVo) {
        this.helper.approveCheck(reqVo);
        this.update(reqVo);
    }

    @Override
    public void activityCallBack(ActivitiCallBackVo activitiCallBackVo) {
        TpmLiqueurActRegisterReqVo reqVo = new TpmLiqueurActRegisterReqVo();
        reqVo.setId(activitiCallBackVo.getFormNo());
        TpmActSendMessageVo actSendMessageVo = TpmActSendMessageVo.builder().actId(reqVo.getId()).actSystemType(TpmProjectNameEnum.LIQUEUR_TPM.getCode()).build();
        RocketMQMessageBody rocketMQMessageBody = RocketMQMessageBody.builder().topic(this.topic).tag("TPM_ACT_APPROVED_AND_CLOSED").bizKey("tpm").msgBody(JSON.toJSONString((Object)actSendMessageVo)).build();
        if (Indicator.CON_BPM_DOING.getCode() == activitiCallBackVo.getProcessState().intValue()) {
            this.approved(reqVo);
            actSendMessageVo.setType(ActSendMessageTypeEnum.APPROVED.getCode());
            log.info("\u6d3b\u52a8\u5ba1\u6279\u901a\u8fc7,\u53d1\u9001MQ\u6d88\u606f,messageBody={}", (Object)rocketMQMessageBody.getMsgBody());
            this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
        }
        if (Indicator.CON_BPM_PASS.getCode() == activitiCallBackVo.getProcessState().intValue()) {
            reqVo.setApproveStatus(ActApproveStatusEnum.REJECTED.getCode());
            this.rejectAndInterrupt(reqVo);
        }
        if (Indicator.CON_BPM_REJECT.getCode() == activitiCallBackVo.getProcessState().intValue()) {
            reqVo.setApproveStatus(ActApproveStatusEnum.INTERRUPT.getCode());
            this.rejectAndInterrupt(reqVo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void approved(TpmLiqueurActRegisterReqVo reqVo) {
        this.helper.approved(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void rejectAndInterrupt(TpmLiqueurActRegisterReqVo reqVo) {
        this.helper.rejectAndInterrupt(reqVo);
    }
}

