/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.liqueraudit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.budgetsubjects.mapper.TpmBudgetSubjectsMapper;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.ActSaveTypeEnum;
import com.biz.crm.eunm.tpm.BudgetSubjectsControlTypeEnum;
import com.biz.crm.eunm.tpm.FeeBudgetDetailTypeEnum;
import com.biz.crm.eunm.tpm.FeeBudgetRemarkEnum;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetControlMapper;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.liqueraudit.mapper.TpmLiqueurAuditMapper;
import com.biz.crm.liqueraudit.model.TpmLiqueurAuditDetailsEntity;
import com.biz.crm.liqueraudit.model.TpmLiqueurAuditEntity;
import com.biz.crm.liqueraudit.model.TpmLiqueurAuditFileEntity;
import com.biz.crm.liqueraudit.service.ITpmLiqueurAuditDetailsService;
import com.biz.crm.liqueraudit.service.ITpmLiqueurAuditFileService;
import com.biz.crm.liqueraudit.service.ITpmLiqueurAuditService;
import com.biz.crm.liqueraudit.service.LiquerAuditServiceHelper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActBudgetMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActBudgetTransactionMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActRegisterDetailMapper;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetTransactionEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterDetailEntity;
import com.biz.crm.liqueuract.service.LiqueurActOperateFeeBudgetVo;
import com.biz.crm.nebular.tpm.feebudget.req.FeeBudgetControlOperateTypeEnum;
import com.biz.crm.nebular.tpm.liqueuraudit.req.TpmLiqueurAuditReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditDetailsRespVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmLiqueurAuditServiceExpandImpl"})
public class TpmLiqueurAuditServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmLiqueurAuditMapper, TpmLiqueurAuditEntity>
implements ITpmLiqueurAuditService {
    private static final Logger log = LoggerFactory.getLogger(TpmLiqueurAuditServiceImpl.class);
    @Resource
    private TpmLiqueurAuditMapper tpmLiqueurAuditMapper;
    @Autowired
    private LiquerAuditServiceHelper helper;
    @Autowired
    private ITpmLiqueurAuditDetailsService tpmLiqueurAuditDetailsService;
    @Autowired
    private ITpmLiqueurAuditFileService tpmLiqueurAuditFileService;
    @Resource
    private TpmLiqueurActRegisterDetailMapper actRegisterDetailMapper;
    @Resource
    private TpmLiqueurActBudgetTransactionMapper liqueurActBudgetTransactionMapper;
    @Resource
    private TpmFeeBudgetControlMapper feeBudgetControlMapper;
    @Resource
    private TpmLiqueurActBudgetMapper liqueurActBudgetMapper;
    @Resource
    private TpmBudgetSubjectsMapper budgetSubjectsMapper;

    @Override
    public PageResult<TpmLiqueurAuditRespVo> findList(TpmLiqueurAuditReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<TpmLiqueurAuditRespVo> list = this.tpmLiqueurAuditMapper.findList((Page<TpmLiqueurAuditRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmLiqueurAuditRespVo query(TpmLiqueurAuditReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TpmLiqueurAuditReqVo reqVo) {
        this.helper.saveCheck(reqVo);
        AssertUtils.isTrue((boolean)ActSaveTypeEnum.getCreateTypes().contains(reqVo.getSaveType()), (String)"\u4fdd\u5b58\u7c7b\u578b\u503c\u9519\u8bef");
        TpmLiqueurAuditEntity entity = (TpmLiqueurAuditEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmLiqueurAuditEntity.class));
        entity.setAuditCode(CodeUtil.createOneCode((String)"tpm_audit"));
        this.save((Object)entity);
        this.saveAuditDetailInfo(reqVo, entity);
        this.saveAuditFileInfo(reqVo, entity);
        if (StringUtils.equals((CharSequence)ActSaveTypeEnum.ADD_AND_APPROVE.getCode(), (CharSequence)reqVo.getSaveType()) && reqVo.getOccupyFeeBudgetFlag().booleanValue()) {
            this.occupyTheBudget(reqVo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TpmLiqueurAuditReqVo reqVo) {
        TpmLiqueurAuditEntity entity = (TpmLiqueurAuditEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(TpmLiqueurAuditReqVo reqVo) {
        List tpmLiqueurAuditEntities = this.tpmLiqueurAuditMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmLiqueurAuditEntities)) {
            tpmLiqueurAuditEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(tpmLiqueurAuditEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(TpmLiqueurAuditReqVo reqVo) {
        List tpmLiqueurAuditEntities = this.tpmLiqueurAuditMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmLiqueurAuditEntities)) {
            tpmLiqueurAuditEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmLiqueurAuditEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(TpmLiqueurAuditReqVo reqVo) {
        List tpmLiqueurAuditEntities = this.tpmLiqueurAuditMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmLiqueurAuditEntities)) {
            tpmLiqueurAuditEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmLiqueurAuditEntities);
    }

    public void saveAuditDetailInfo(TpmLiqueurAuditReqVo reqVo, TpmLiqueurAuditEntity entity) {
        List detailVos = reqVo.getDetailsRespVos();
        detailVos.forEach(o -> {
            AssertUtils.isNotNull((Object)o.getActDetailCode(), (String)"\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801\u4e0d\u5b58\u5728");
            o.setAuditCode(entity.getAuditCode());
            if (Objects.isNull(o.getFeeUsed())) {
                o.setFeeUsed(BigDecimal.ZERO);
            }
            if (StringUtils.isBlank((CharSequence)o.getIsAllFeeUsed())) {
                o.setIsAllFeeUsed(GlobalWhetherEnum.NO.getCode());
            }
        });
        List tpmAuditDetailEntities = CrmBeanUtil.copyList((List)detailVos, TpmLiqueurAuditDetailsEntity.class);
        this.tpmLiqueurAuditDetailsService.saveBatch(tpmAuditDetailEntities);
    }

    private void saveAuditFileInfo(TpmLiqueurAuditReqVo reqVo, TpmLiqueurAuditEntity entity) {
        List typeFineRespVos = reqVo.getAuditFileRespVos();
        if (CollectionUtil.listNotEmpty((List)typeFineRespVos)) {
            List tpmAuditFileEntities = CrmBeanUtil.copyList((List)typeFineRespVos, TpmLiqueurAuditFileEntity.class);
            tpmAuditFileEntities.forEach(tpmAuditFileEntity -> {
                AssertUtils.isNotNull((Object)tpmAuditFileEntity.getAuditFileType(), (String)"\u6838\u9500\u8d44\u6599\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                tpmAuditFileEntity.setAuditCode(entity.getAuditCode());
            });
            this.tpmLiqueurAuditFileService.saveBatch(tpmAuditFileEntities);
        }
    }

    private void occupyBudget() {
    }

    private void occupyTheBudget(TpmLiqueurAuditReqVo reqVo) {
        List occupyFeeBudgetDetails = reqVo.getOccupyFeeBudgetDetails();
        if (CollectionUtils.isEmpty((Collection)occupyFeeBudgetDetails)) {
            return;
        }
        List detailEntities = this.actRegisterDetailMapper.selectList((Wrapper)new LambdaQueryWrapper().in(TpmLiqueurActRegisterDetailEntity::getActDetailCode, (Collection)occupyFeeBudgetDetails.stream().map(TpmLiqueurAuditDetailsRespVo::getActDetailCode).collect(Collectors.toSet())));
        LiqueurActOperateFeeBudgetVo operateFeeBudgetVo = this.setOperateFeeBudgetVo(detailEntities);
        ArrayList saveFeeBudgetDetails = Lists.newArrayList();
        HashSet saveFeeBudgetCodes = Sets.newHashSet();
        HashSet saveFeeBudgetControlIds = Sets.newHashSet();
        for (TpmLiqueurAuditDetailsRespVo p : occupyFeeBudgetDetails) {
            List tpmFeeBudgetDetailsEntities = operateFeeBudgetVo.getBudgetDetailsMap().get(p.getActCode() + p.getActDetailCode()).stream().sorted(Comparator.comparing(TpmLiqueurActBudgetTransactionEntity::getReduceOrder)).collect(Collectors.toList());
            AtomicReference<BigDecimal> occupyMoney = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            if (Optional.ofNullable(p.getAuditAmount()).orElse(BigDecimal.ZERO).compareTo(p.getApplyAmount()) == 1) {
                occupyMoney.set(p.getAmount());
            } else {
                occupyMoney.set(p.getAmount().add(Optional.ofNullable(p.getAuditAmount()).orElse(BigDecimal.ZERO)).subtract(p.getApplyAmount()));
            }
            for (int i = 0; i < tpmFeeBudgetDetailsEntities.size(); ++i) {
                TpmLiqueurActBudgetTransactionEntity actBudgetTransactionEntity = (TpmLiqueurActBudgetTransactionEntity)((Object)tpmFeeBudgetDetailsEntities.get(i));
                TpmLiqueurActBudgetEntity actBudgetEntity = operateFeeBudgetVo.getFeeBudgetMap().get(actBudgetTransactionEntity.getFeeBudgetCode());
                TpmFeeBudgetControlEntity budgetControlEntity = operateFeeBudgetVo.getControlEntityMap().get(actBudgetEntity.getControlId());
                TpmBudgetSubjectsEntity subjectsEntity = operateFeeBudgetVo.getSubjectsEntityMap().get(actBudgetEntity.getActBudgetCode());
                AssertUtils.isNotNull((Object)((Object)subjectsEntity), (String)("\u8d39\u7528\u9884\u7b97:" + actBudgetEntity.getFeeBudgetCode() + "\u5bf9\u5e94\u7684\u9884\u7b97\u79d1\u76ee:" + subjectsEntity.getBudgetSubjectsCode() + "\u4e0d\u5b58\u5728"));
                if (!StringUtils.equals((CharSequence)BudgetSubjectsControlTypeEnum.NON.getCode(), (CharSequence)subjectsEntity.getControlType()) && actBudgetEntity.getCanUseAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal canOccupyMoney = BigDecimal.ZERO;
                BigDecimal maxCanOccupy = BigDecimal.ZERO;
                if (occupyMoney.get().compareTo(BigDecimal.ZERO) == 0) break;
                if (!StringUtils.equals((CharSequence)BudgetSubjectsControlTypeEnum.NON.getCode(), (CharSequence)subjectsEntity.getControlType())) {
                    canOccupyMoney = occupyMoney.get();
                    occupyMoney.set(BigDecimal.ZERO);
                    actBudgetEntity.setCanUseAmount(actBudgetEntity.getCanUseAmount().subtract(canOccupyMoney));
                    budgetControlEntity.setCanUseAmount(budgetControlEntity.getCanUseAmount().subtract(canOccupyMoney));
                } else {
                    maxCanOccupy = actBudgetEntity.getCanUseAmount();
                    if (occupyMoney.get().compareTo(maxCanOccupy) == 1) {
                        canOccupyMoney = maxCanOccupy;
                        occupyMoney.set(occupyMoney.get().subtract(maxCanOccupy));
                        actBudgetEntity.setCanUseAmount(BigDecimal.ZERO);
                        budgetControlEntity.setCanUseAmount(budgetControlEntity.getCanUseAmount().subtract(canOccupyMoney));
                    } else {
                        canOccupyMoney = occupyMoney.get();
                        occupyMoney.set(BigDecimal.ZERO);
                        actBudgetEntity.setCanUseAmount(actBudgetEntity.getCanUseAmount().subtract(canOccupyMoney));
                        budgetControlEntity.setCanUseAmount(budgetControlEntity.getCanUseAmount().subtract(canOccupyMoney));
                    }
                }
                saveFeeBudgetCodes.add(actBudgetEntity.getFeeBudgetCode());
                saveFeeBudgetControlIds.add(budgetControlEntity.getId());
                TpmLiqueurActBudgetTransactionEntity newBudgetDetailsEntity = new TpmLiqueurActBudgetTransactionEntity();
                CrmBeanUtil.copyProperties((Object)((Object)actBudgetTransactionEntity), (Object)((Object)newBudgetDetailsEntity));
                newBudgetDetailsEntity.setTransactionType(FeeBudgetDetailTypeEnum.USE.getCode());
                newBudgetDetailsEntity.setCreateDate(actBudgetEntity.getCreateDate());
                newBudgetDetailsEntity.setTransactionTypeName(FeeBudgetDetailTypeEnum.USE.getDes());
                newBudgetDetailsEntity.setFeeAmount(BigDecimal.ZERO.subtract(canOccupyMoney));
                newBudgetDetailsEntity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                newBudgetDetailsEntity.setBusinessCode(p.getAuditCode());
                newBudgetDetailsEntity.setBusinessLineCode(p.getActDetailCode());
                newBudgetDetailsEntity.setBusinessRemarks(FeeBudgetRemarkEnum.WRITE_OFF_THE_OCCUPIED_BUDGET.getDes());
                saveFeeBudgetDetails.add(newBudgetDetailsEntity);
            }
            if (occupyMoney.get().compareTo(BigDecimal.ZERO) != 1) continue;
            throw new BusinessException("\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801:" + p.getActDetailCode() + "\u8d85\u989d\u6838\u9500\u5360\u7528\u8d39\u7528\u65f6,\u9884\u7b97\u4e0d\u8db3");
        }
        operateFeeBudgetVo.setSaveFeeBudgetDetails(saveFeeBudgetDetails);
        operateFeeBudgetVo.setSaveFeeBudgetCodes(saveFeeBudgetCodes);
        operateFeeBudgetVo.setSaveFeeBudgetControlIds(saveFeeBudgetControlIds);
        operateFeeBudgetVo.setTypeEnum(FeeBudgetControlOperateTypeEnum.USE);
    }

    public LiqueurActOperateFeeBudgetVo setOperateFeeBudgetVo(List<TpmLiqueurActRegisterDetailEntity> detailEntities) {
        ArrayList actDetailCodes = Lists.newArrayList();
        HashSet actCodes = Sets.newHashSet();
        detailEntities.stream().forEach(o -> {
            actDetailCodes.add(o.getActDetailCode());
            actCodes.add(o.getActCode());
        });
        List budgetDetailsEntities = this.liqueurActBudgetTransactionMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TpmLiqueurActBudgetTransactionEntity::getBusinessCode, (Collection)actCodes)).in(TpmLiqueurActBudgetTransactionEntity::getBusinessLineCode, (Collection)actDetailCodes)).eq(TpmLiqueurActBudgetTransactionEntity::getTransactionType, (Object)FeeBudgetDetailTypeEnum.USE.getCode())).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
        HashMap budgetDetailsMap = Maps.newHashMap();
        Set feeBudgetCodes = budgetDetailsEntities.stream().map(TpmLiqueurActBudgetTransactionEntity::getFeeBudgetCode).collect(Collectors.toSet());
        for (TpmLiqueurActBudgetTransactionEntity o2 : budgetDetailsEntities) {
            List list1 = (List)budgetDetailsMap.get(o2.getBusinessCode() + o2.getBusinessLineCode());
            if (CollectionUtils.isEmpty((Collection)list1)) {
                list1 = Lists.newArrayList();
            }
            list1.add(o2);
            budgetDetailsMap.put(o2.getBusinessCode() + o2.getBusinessLineCode(), list1);
        }
        List feeBudgetEntities = this.liqueurActBudgetMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TpmLiqueurActBudgetEntity.class).in(TpmLiqueurActBudgetEntity::getFeeBudgetCode, feeBudgetCodes)).in(TpmLiqueurActBudgetEntity::getActCode, (Collection)actCodes)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode()));
        HashSet controlIds = Sets.newHashSet();
        HashMap feeBudgetMap = Maps.newHashMap();
        HashSet subjectsCodes = Sets.newHashSet();
        for (TpmLiqueurActBudgetEntity o3 : feeBudgetEntities) {
            controlIds.add(o3.getControlId());
            subjectsCodes.add(o3.getActBudgetCode());
            feeBudgetMap.put(o3.getFeeBudgetCode(), o3);
        }
        List<TpmFeeBudgetControlEntity> feeBudgetControls = this.findFeeBudgetControls(controlIds);
        Map<String, TpmFeeBudgetControlEntity> controlEntityMap = feeBudgetControls.stream().collect(Collectors.toMap(BaseIdEntity::getId, Function.identity()));
        Map<String, TpmBudgetSubjectsEntity> subjectsEntityMap = this.findBudgetSubjectsByCodes(subjectsCodes);
        return LiqueurActOperateFeeBudgetVo.builder().budgetDetailsMap(budgetDetailsMap).controlEntityMap(controlEntityMap).feeBudgetControls(feeBudgetControls).feeBudgetEntities(feeBudgetEntities).isRatio(false).feeBudgetMap(feeBudgetMap).saveFeeBudgetCodes(Sets.newHashSet()).saveFeeBudgetControlIds(Sets.newHashSet()).saveFeeBudgetDetails(Lists.newArrayList()).subjectsEntityMap(subjectsEntityMap).build();
    }

    public List<TpmFeeBudgetControlEntity> findFeeBudgetControls(Set<String> controlIds) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(BaseIdEntity::getId, controlIds);
        List tpmFeeBudgetControlEntities = this.feeBudgetControlMapper.selectList((Wrapper)queryWrapper);
        return CollectionUtils.isEmpty((Collection)tpmFeeBudgetControlEntities) ? Lists.newArrayList() : tpmFeeBudgetControlEntities;
    }

    public Map<String, TpmBudgetSubjectsEntity> findBudgetSubjectsByCodes(Collection<String> subjectsCodes) {
        List subjectsEntities;
        HashMap map = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(subjectsCodes) && CollectionUtils.isNotEmpty((Collection)(subjectsEntities = this.budgetSubjectsMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmBudgetSubjectsEntity.class).in(TpmBudgetSubjectsEntity::getBudgetSubjectsCode, subjectsCodes))))) {
            subjectsEntities.forEach(o -> map.put(o.getBudgetSubjectsCode(), o));
        }
        return map;
    }
}

