/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.feebudget.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.tpm.FeeBudgetDetailTypeEnum;
import com.biz.crm.eunm.tpm.FeeBudgetTypeEnum;
import com.biz.crm.feebudget.service.ITpmFeeBudgetService;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tpmFeeBudgetController"})
@Api(tags={"\u8d39\u7528\u9884\u7b97 "})
public class TpmFeeBudgetController {
    private static final Logger log = LoggerFactory.getLogger(TpmFeeBudgetController.class);
    @Autowired
    private ITpmFeeBudgetService tpmFeeBudgetService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<TpmFeeBudgetRespVo>> list(@RequestBody TpmFeeBudgetReqVo tpmFeeBudgetReqVo) {
        PageResult<TpmFeeBudgetRespVo> result = this.tpmFeeBudgetService.findList(tpmFeeBudgetReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @GetMapping(value={"/query"})
    @CrmLog
    public Result<TpmFeeBudgetRespVo> query(@RequestParam(value="id", required=false) String id) {
        TpmFeeBudgetRespVo respVo = this.tpmFeeBudgetService.query(id);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody TpmFeeBudgetReqVo tpmFeeBudgetReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmFeeBudgetReqVo.setUsername(user.getUsername());
        tpmFeeBudgetReqVo.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.INIT.getCode());
        this.tpmFeeBudgetService.save(tpmFeeBudgetReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody TpmFeeBudgetReqVo tpmFeeBudgetReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmFeeBudgetReqVo.setUsername(user.getUsername());
        tpmFeeBudgetReqVo.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.INIT.getCode());
        this.tpmFeeBudgetService.update(tpmFeeBudgetReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.tpmFeeBudgetService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        this.tpmFeeBudgetService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        this.tpmFeeBudgetService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u53d8\u66f4")
    @PostMapping(value={"/change"})
    @CrmLog
    public Result change(@RequestBody TpmFeeBudgetReqVo tpmFeeBudgetReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmFeeBudgetReqVo.setUsername(user.getUsername());
        this.tpmFeeBudgetService.change(tpmFeeBudgetReqVo);
        return Result.ok((String)"\u53d8\u66f4\u6210\u529f");
    }

    @ApiOperation(value="\u8c03\u6574")
    @PostMapping(value={"/adjust"})
    @CrmLog
    public Result adjust(@RequestBody TpmFeeBudgetReqVo tpmFeeBudgetReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmFeeBudgetReqVo.setUsername(user.getUsername());
        this.tpmFeeBudgetService.adjust(tpmFeeBudgetReqVo);
        return Result.ok((String)"\u8c03\u6574\u6210\u529f");
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u6240\u5c5e\u7ec4\u7ec7\u7684\u8d39\u7528\u9884\u7b97")
    @PostMapping(value={"/feeBudgetInfoByUser"})
    @CrmLog
    public Result<PageResult<TpmFeeBudgetRespVo>> feeBudgetInfoByUser(@RequestBody TpmFeeBudgetReqVo tpmFeeBudgetReqVo) {
        UserRedis user = UserUtils.getUser();
        if (StringUtils.isNotEmpty((String)user.getOrgcode())) {
            tpmFeeBudgetReqVo.setOrgCode(user.getOrgcode());
            tpmFeeBudgetReqVo.setFeeBudgetType(FeeBudgetTypeEnum.FIXED.getCode());
        }
        PageResult<TpmFeeBudgetRespVo> result = this.tpmFeeBudgetService.findList(tpmFeeBudgetReqVo);
        return Result.ok(result);
    }
}

