/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.liqueraudit.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.annotation.Klock;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.budgetsubjects.mapper.TpmBudgetSubjectsMapper;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.costtypefine.service.ITpmCostTypeFineService;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActSaveTypeEnum;
import com.biz.crm.eunm.tpm.BudgetSubjectsControlTypeEnum;
import com.biz.crm.eunm.tpm.FeeBudgetDetailTypeEnum;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetControlMapper;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetDetailsEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.feebudget.service.ITpmFeeBudgetControlService;
import com.biz.crm.feebudget.service.ITpmFeeBudgetDetailsService;
import com.biz.crm.feebudget.service.ITpmFeeBudgetService;
import com.biz.crm.liqueraudit.mapper.TpmLiqueurAuditMapper;
import com.biz.crm.liqueraudit.model.TpmLiqueurAuditDetailsEntity;
import com.biz.crm.liqueraudit.model.TpmLiqueurAuditEntity;
import com.biz.crm.liqueraudit.model.TpmLiqueurAuditFileEntity;
import com.biz.crm.liqueraudit.service.ITpmLiqueurAuditDetailsService;
import com.biz.crm.liqueraudit.service.ITpmLiqueurAuditFileService;
import com.biz.crm.liqueraudit.service.ITpmLiqueurAuditService;
import com.biz.crm.liqueraudit.service.LiquerAuditServiceHelper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActBudgetMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActBudgetTransactionMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActRegisterDetailMapper;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetTransactionEntity;
import com.biz.crm.liqueuract.service.ITpmLiqueurActBudgetTransactionService;
import com.biz.crm.liqueuract.service.TpmLiqueurActBudgetService;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.common.ProcessCommonVo;
import com.biz.crm.nebular.tpm.liqueuraudit.req.TpmLiqueurAuditDetailsReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.req.TpmLiqueurAuditReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmLiqueurAuditServiceExpandImpl"})
public class TpmLiqueurAuditServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmLiqueurAuditMapper, TpmLiqueurAuditEntity>
implements ITpmLiqueurAuditService {
    private static final Logger log = LoggerFactory.getLogger(TpmLiqueurAuditServiceImpl.class);
    @Resource
    private TpmLiqueurAuditMapper tpmLiqueurAuditMapper;
    @Autowired
    private LiquerAuditServiceHelper helper;
    @Autowired
    private ITpmLiqueurAuditDetailsService tpmLiqueurAuditDetailsService;
    @Autowired
    private ITpmLiqueurAuditFileService tpmLiqueurAuditFileService;
    @Resource
    private TpmLiqueurActRegisterDetailMapper actRegisterDetailMapper;
    @Resource
    private TpmLiqueurActBudgetTransactionMapper liqueurActBudgetTransactionMapper;
    @Resource
    private ITpmLiqueurActBudgetTransactionService liqueurActBudgetTransactionService;
    @Resource
    private TpmFeeBudgetControlMapper feeBudgetControlMapper;
    @Resource
    private TpmLiqueurActBudgetMapper liqueurActBudgetMapper;
    @Resource
    private TpmBudgetSubjectsMapper budgetSubjectsMapper;
    @Resource
    private ITpmCostTypeFineService tpmCostTypeFineService;
    @Resource
    private TpmLiqueurActBudgetService tpmLiqueurActBudgetService;
    @Resource
    private ITpmFeeBudgetDetailsService tpmFeeBudgetDetailsService;
    @Resource
    private ITpmFeeBudgetService tpmFeeBudgetService;
    @Autowired
    private TaActBaseFeign activityFeign;
    @Resource
    private ITpmFeeBudgetControlService tpmFeeBudgetControlService;

    @Override
    public PageResult<TpmLiqueurAuditRespVo> findList(TpmLiqueurAuditReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<TpmLiqueurAuditRespVo> list = this.tpmLiqueurAuditMapper.findList((Page<TpmLiqueurAuditRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmLiqueurAuditRespVo query(TpmLiqueurAuditReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock(keys={"liqueurAudit", "#reqVo.username"}, leaseTime=5L)
    public void save(TpmLiqueurAuditReqVo reqVo) {
        this.helper.saveCheck(reqVo);
        AssertUtils.isTrue((boolean)ActSaveTypeEnum.getCreateTypes().contains(reqVo.getSaveType()), (String)"\u4fdd\u5b58\u7c7b\u578b\u503c\u9519\u8bef");
        TpmLiqueurAuditEntity entity = (TpmLiqueurAuditEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmLiqueurAuditEntity.class));
        entity.setAuditCode(CodeUtil.createOneCode((String)"tpm_audit"));
        this.save((Object)entity);
        this.saveAuditDetailInfo(reqVo, entity);
        this.saveAuditFileInfo(reqVo, entity);
        if (StringUtils.equals((CharSequence)ActSaveTypeEnum.ADD_AND_APPROVE.getCode(), (CharSequence)reqVo.getSaveType())) {
            if (reqVo.getOccupyFeeBudgetFlag().booleanValue()) {
                this.occupyTheBudget(reqVo);
            }
            this.sendToActivity(entity, reqVo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock(keys={"liqueurAudit", "#reqVo.username"}, leaseTime=5L)
    public void update(TpmLiqueurAuditReqVo reqVo) {
        TpmLiqueurAuditEntity entity = (TpmLiqueurAuditEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(TpmLiqueurAuditReqVo reqVo) {
        List tpmLiqueurAuditEntities = this.tpmLiqueurAuditMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmLiqueurAuditEntities)) {
            tpmLiqueurAuditEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(tpmLiqueurAuditEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(TpmLiqueurAuditReqVo reqVo) {
        List tpmLiqueurAuditEntities = this.tpmLiqueurAuditMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmLiqueurAuditEntities)) {
            tpmLiqueurAuditEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmLiqueurAuditEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(TpmLiqueurAuditReqVo reqVo) {
        List tpmLiqueurAuditEntities = this.tpmLiqueurAuditMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)tpmLiqueurAuditEntities)) {
            tpmLiqueurAuditEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmLiqueurAuditEntities);
    }

    public void saveAuditDetailInfo(TpmLiqueurAuditReqVo reqVo, TpmLiqueurAuditEntity entity) {
        List detailVos = reqVo.getDetailsReqVos();
        detailVos.forEach(o -> {
            AssertUtils.isNotNull((Object)o.getActDetailCode(), (String)"\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801\u4e0d\u5b58\u5728");
            o.setAuditCode(entity.getAuditCode());
            if (Objects.isNull(o.getFeeUsed())) {
                o.setFeeUsed(BigDecimal.ZERO);
            }
            if (StringUtils.isBlank((CharSequence)o.getIsAllFeeUsed())) {
                o.setIsAllFeeUsed(GlobalWhetherEnum.NO.getCode());
            }
        });
        List tpmAuditDetailEntities = CrmBeanUtil.copyList((List)detailVos, TpmLiqueurAuditDetailsEntity.class);
        this.tpmLiqueurAuditDetailsService.saveBatch(tpmAuditDetailEntities);
    }

    private void saveAuditFileInfo(TpmLiqueurAuditReqVo reqVo, TpmLiqueurAuditEntity entity) {
        List typeFineRespVos = reqVo.getAuditFileReqVos();
        if (CollectionUtil.listNotEmpty((List)typeFineRespVos)) {
            List tpmAuditFileEntities = CrmBeanUtil.copyList((List)typeFineRespVos, TpmLiqueurAuditFileEntity.class);
            tpmAuditFileEntities.forEach(tpmAuditFileEntity -> {
                AssertUtils.isNotNull((Object)tpmAuditFileEntity.getAuditFileType(), (String)"\u6838\u9500\u8d44\u6599\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                tpmAuditFileEntity.setAuditCode(entity.getAuditCode());
            });
            this.tpmLiqueurAuditFileService.saveBatch(tpmAuditFileEntities);
        }
    }

    private void occupyTheBudget(TpmLiqueurAuditReqVo reqVo) {
        List occupyFeeBudgetDetails = reqVo.getOccupyFeeBudgetDetails();
        if (CollectionUtils.isEmpty((Collection)occupyFeeBudgetDetails)) {
            return;
        }
        TpmCostTypeFineEntity tpmCostTypeFineEntity = (TpmCostTypeFineEntity)((Object)this.tpmCostTypeFineService.getOne((Wrapper)new LambdaQueryWrapper().eq(TpmCostTypeFineEntity::getFineCode, (Object)reqVo.getFineCode())));
        this.checkAuditDetail(reqVo, tpmCostTypeFineEntity.getIsAllowRepeatAudit());
        this.checkActAudit(reqVo);
        this.checkFeeBudget(reqVo);
    }

    public List<TpmFeeBudgetControlEntity> findFeeBudgetControls(Set<String> controlIds) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(BaseIdEntity::getId, controlIds);
        List tpmFeeBudgetControlEntities = this.feeBudgetControlMapper.selectList((Wrapper)queryWrapper);
        return CollectionUtils.isEmpty((Collection)tpmFeeBudgetControlEntities) ? Lists.newArrayList() : tpmFeeBudgetControlEntities;
    }

    public Map<String, TpmBudgetSubjectsEntity> findBudgetSubjectsByCodes(Collection<String> subjectsCodes) {
        List subjectsEntities;
        HashMap map = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(subjectsCodes) && CollectionUtils.isNotEmpty((Collection)(subjectsEntities = this.budgetSubjectsMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmBudgetSubjectsEntity.class).in(TpmBudgetSubjectsEntity::getBudgetSubjectsCode, subjectsCodes))))) {
            subjectsEntities.forEach(o -> map.put(o.getBudgetSubjectsCode(), o));
        }
        return map;
    }

    public void checkAuditDetail(TpmLiqueurAuditReqVo reqVo, String isAllowRepeatAudit) {
        List occupyFeeBudgetDetails = reqVo.getOccupyFeeBudgetDetails();
        ArrayList tpmLiqueurAuditDetailsRespVos = Lists.newArrayList();
        for (TpmLiqueurAuditDetailsReqVo p : occupyFeeBudgetDetails) {
            p.setIsAllAudit(GlobalWhetherEnum.NO.getCode().equals(isAllowRepeatAudit) ? GlobalWhetherEnum.YES.getCode() : GlobalWhetherEnum.NO.getCode());
            if (Optional.ofNullable(p.getAuditAmount()).orElse(BigDecimal.ZERO).compareTo(p.getApplyAmount()) > 0) {
                p.setAuditAmount(p.getAuditAmount().add(p.getAmount()));
                tpmLiqueurAuditDetailsRespVos.add(p);
                continue;
            }
            if (Optional.ofNullable(p.getAuditAmount()).orElse(BigDecimal.ZERO).add(p.getAmount()).compareTo(p.getApplyAmount()) > 0) {
                BigDecimal waitAudit = p.getAmount().add(p.getAuditAmount()).subtract(p.getApplyAmount());
                p.setAuditAmount(p.getAmount().add(p.getAuditAmount()));
                TpmLiqueurAuditDetailsReqVo newReq = (TpmLiqueurAuditDetailsReqVo)CrmBeanUtil.copy((Object)p, TpmLiqueurAuditDetailsReqVo.class);
                newReq.setAmount(waitAudit);
                tpmLiqueurAuditDetailsRespVos.add(newReq);
                continue;
            }
            p.setAuditAmount(p.getAuditAmount().add(p.getAmount()));
        }
        this.tpmLiqueurAuditDetailsService.saveBatch(CrmBeanUtil.copyList((List)occupyFeeBudgetDetails, TpmLiqueurAuditDetailsEntity.class));
        reqVo.setOccupyFeeBudgetDetails((List)tpmLiqueurAuditDetailsRespVos);
    }

    public void checkActAudit(TpmLiqueurAuditReqVo reqVo) {
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getOccupyFeeBudgetDetails())) {
            return;
        }
        List occupyFeeBudgetDetails = reqVo.getOccupyFeeBudgetDetails();
        ArrayList waitAuditList = Lists.newArrayList();
        ArrayList addTransaction = Lists.newArrayList();
        Set actDetailCode = reqVo.getOccupyFeeBudgetDetails().stream().map(TpmLiqueurAuditDetailsReqVo::getActDetailCode).collect(Collectors.toSet());
        List budgetDetailsEntities = this.liqueurActBudgetTransactionMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TpmLiqueurActBudgetTransactionEntity::getBusinessLineCode, actDetailCode)).eq(TpmLiqueurActBudgetTransactionEntity::getTransactionType, (Object)FeeBudgetDetailTypeEnum.USE.getCode())).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
        HashMap budgetDetailEntityMap = Maps.newHashMap();
        budgetDetailsEntities.forEach(budgetDetailsEntity -> {
            List list = Lists.newArrayList();
            if (budgetDetailEntityMap.containsKey(budgetDetailsEntity.getBusinessLineCode())) {
                list = (List)budgetDetailEntityMap.get(budgetDetailsEntity.getBusinessLineCode());
            }
            list.add(budgetDetailsEntity);
            budgetDetailEntityMap.put(budgetDetailsEntity.getBusinessLineCode(), list);
        });
        List tpmLiqueurActBudgetEntities = this.liqueurActBudgetMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TpmLiqueurActBudgetEntity::getActBudgetCode, (Collection)budgetDetailsEntities.stream().map(TpmLiqueurActBudgetTransactionEntity::getActBudgetCode).collect(Collectors.toList()))).in(TpmLiqueurActBudgetEntity::getFeeBudgetCode, (Collection)budgetDetailsEntities.stream().map(TpmLiqueurActBudgetTransactionEntity::getFeeBudgetCode).collect(Collectors.toList()))).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
        Map map = tpmLiqueurActBudgetEntities.stream().collect(Collectors.toMap(TpmLiqueurActBudgetEntity::getFeeBudgetCode, Function.identity()));
        for (TpmLiqueurAuditDetailsReqVo p : occupyFeeBudgetDetails) {
            AssertUtils.isTrue((boolean)budgetDetailEntityMap.containsKey(p.getActDetailCode()), (String)("\u6d3b\u52a8\u8be6\u7ec6\u7f16\u7801\uff1a" + p.getActDetailCode() + "\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8d39\u7528\u660e\u7ec6\u4fe1\u606f"));
            List transactions = (List)budgetDetailEntityMap.get(p.getActDetailCode());
            BigDecimal waitAudit = p.getAmount();
            for (TpmLiqueurActBudgetTransactionEntity transaction : transactions) {
                if (waitAudit.compareTo(BigDecimal.ZERO) == 0) break;
                AssertUtils.isTrue((boolean)map.containsKey(transaction.getFeeBudgetCode()), (String)(transaction.getFeeBudgetCode() + "\u5bf9\u5e94\u7684\u6d3b\u52a8\u9884\u7b97\u4e0d\u5b58\u5728"));
                TpmLiqueurActBudgetEntity actBudgetEntity = (TpmLiqueurActBudgetEntity)((Object)map.get(transaction.getFeeBudgetCode()));
                if (actBudgetEntity.getCanUseAmount().compareTo(waitAudit) > 0) {
                    actBudgetEntity.setCanUseAmount(actBudgetEntity.getCanUseAmount().subtract(waitAudit));
                    addTransaction.add(transaction.setFeeAmount(waitAudit));
                    continue;
                }
                if (actBudgetEntity.getCanUseAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                waitAudit = waitAudit.subtract(actBudgetEntity.getCanUseAmount());
                actBudgetEntity.setCanUseAmount(BigDecimal.ZERO);
                addTransaction.add(transaction.setFeeAmount(actBudgetEntity.getCanUseAmount()));
            }
            if (waitAudit.compareTo(BigDecimal.ZERO) <= 0) continue;
            p.setAmount(waitAudit);
            p.setFeeBudgetCodes(transactions.stream().map(TpmLiqueurActBudgetTransactionEntity::getFeeBudgetCode).collect(Collectors.toList()));
            waitAuditList.add(p);
        }
        this.tpmLiqueurActBudgetService.saveOrUpdateBatch(map.values());
        this.liqueurActBudgetTransactionService.saveBatch(this.addParams(addTransaction));
        reqVo.setOccupyFeeBudgetDetails((List)waitAuditList);
    }

    public void checkFeeBudget(TpmLiqueurAuditReqVo reqVo) {
        List occupyFeeBudgetDetails = reqVo.getOccupyFeeBudgetDetails();
        List transactionEntities = this.liqueurActBudgetTransactionMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TpmLiqueurActBudgetTransactionEntity::getBusinessLineCode, (Collection)occupyFeeBudgetDetails.stream().map(TpmLiqueurAuditDetailsReqVo::getActDetailCode).collect(Collectors.toSet()))).eq(TpmLiqueurActBudgetTransactionEntity::getTransactionType, (Object)FeeBudgetDetailTypeEnum.USE.getCode())).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
        List budgetDetailsEntities = this.tpmFeeBudgetDetailsService.getBaseMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmFeeBudgetDetailsEntity::getBusinessCode, (Object)reqVo.getActCode())).eq(TpmFeeBudgetDetailsEntity::getFeeBudgetDetailType, (Object)FeeBudgetDetailTypeEnum.USE.getCode())).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
        ArrayList addDetailsList = Lists.newArrayList();
        ArrayList addTransaction = Lists.newArrayList();
        List budgetEntities = this.tpmFeeBudgetService.getBaseMapper().selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TpmFeeBudgetEntity::getFeeBudgetCode, (Collection)occupyFeeBudgetDetails.stream().map(TpmLiqueurAuditDetailsReqVo::getFeeBudgetCodes).collect(Collectors.toList()))).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
        List controlEntities = this.tpmFeeBudgetControlService.getBaseMapper().selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(BaseIdEntity::getId, (Collection)budgetEntities.stream().map(TpmFeeBudgetEntity::getControlId).collect(Collectors.toList()))).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
        Map controlEntityMap = controlEntities.stream().collect(Collectors.toMap(BaseIdEntity::getId, Function.identity()));
        Map feeBudgetEntityMap = budgetEntities.stream().collect(Collectors.toMap(TpmFeeBudgetEntity::getFeeBudgetCode, Function.identity()));
        Map<String, TpmBudgetSubjectsEntity> subjectsEntityMap = this.findBudgetSubjectsByCodes(budgetDetailsEntities.stream().map(TpmFeeBudgetDetailsEntity::getBudgetSubjectsCode).collect(Collectors.toList()));
        Map feeBudgetDetailsEntityMap = budgetDetailsEntities.stream().collect(Collectors.toMap(TpmFeeBudgetDetailsEntity::getFeeBudgetCode, Function.identity()));
        for (TpmLiqueurAuditDetailsReqVo p : occupyFeeBudgetDetails) {
            BigDecimal waitAudit = p.getAmount();
            for (String feeBudgetCode : p.getFeeBudgetCodes()) {
                if (waitAudit.compareTo(BigDecimal.ZERO) == 0) break;
                AssertUtils.isTrue((boolean)feeBudgetEntityMap.containsKey(feeBudgetCode), (String)("\u8d39\u7528\u9884\u7b97\u7f16\u7801" + feeBudgetCode + "\u5bf9\u5e94\u7684\u9884\u7b97\u4e0d\u5b58\u5728"));
                TpmFeeBudgetEntity budget = (TpmFeeBudgetEntity)((Object)feeBudgetEntityMap.get(feeBudgetCode));
                TpmFeeBudgetControlEntity control = (TpmFeeBudgetControlEntity)((Object)controlEntityMap.get(budget.getControlId()));
                TpmFeeBudgetDetailsEntity detailsEntity = (TpmFeeBudgetDetailsEntity)((Object)feeBudgetDetailsEntityMap.get(feeBudgetCode));
                detailsEntity.setId(null);
                if (StringUtils.equals((CharSequence)BudgetSubjectsControlTypeEnum.NON.getCode(), (CharSequence)subjectsEntityMap.get(budget.getBudgetSubjectsCode()).getControlType())) {
                    waitAudit = this.getBigDecimal(transactionEntities, addDetailsList, addTransaction, waitAudit, feeBudgetCode, budget, detailsEntity, waitAudit);
                    control.setCanUseAmount(control.getCanUseAmount().subtract(waitAudit));
                    continue;
                }
                if (budget.getCanUseAmount().compareTo(waitAudit) > 0) {
                    waitAudit = this.getBigDecimal(transactionEntities, addDetailsList, addTransaction, waitAudit, feeBudgetCode, budget, detailsEntity, budget.getUsedAmount());
                    control.setCanUseAmount(control.getCanUseAmount().subtract(waitAudit));
                    continue;
                }
                if (budget.getCanUseAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                addDetailsList.add(detailsEntity.setFeeAmount(budget.getCanUseAmount()).setBeforAmount(budget.getCanUseAmount()).setAfterAmount(BigDecimal.ZERO));
                budget.setUsedAmount(budget.getCanUseAmount().add(budget.getCanUseAmount()));
                budget.setCanUseAmount(BigDecimal.ZERO);
                waitAudit = waitAudit.subtract(budget.getCanUseAmount());
                addTransaction.add(((TpmLiqueurActBudgetTransactionEntity)((Object)transactionEntities.get(0))).setFeeBudgetCode(feeBudgetCode).setFeeAmount(budget.getCanUseAmount()));
                control.setCanUseAmount(budget.getCanUseAmount());
            }
            if (waitAudit.compareTo(BigDecimal.ZERO) <= 0) continue;
            throw new BusinessException("\u6d3b\u52a8\u660e\u7ec6\uff1a" + p.getActDetailName() + "\u6838\u9500\u8d39\u7528\u8d85\u51fa\u8d39\u7528\u9884\u7b97");
        }
        this.tpmFeeBudgetService.saveOrUpdateBatch(feeBudgetEntityMap.values());
        this.tpmFeeBudgetControlService.saveOrUpdateBatch(controlEntityMap.values());
        addDetailsList.forEach(detail -> {
            detail.setCreateDate(DateUtil.formatDate());
            detail.setCreateDateSecond(DateUtil.dateNowStrHms());
            detail.setCreateCode(UserUtils.getUser().getCustname());
            detail.setCreatePosCode(UserUtils.getUser().getPoscode());
            detail.setCreateName(UserUtils.getUser().getRealname());
            detail.setCreatePosName(UserUtils.getUser().getPosname());
            detail.setCreateOrgCode(UserUtils.getUser().getOrgcode());
            detail.setCreateOrgName(UserUtils.getUser().getOrgname());
        });
        this.liqueurActBudgetTransactionService.saveBatch(this.addParams(addTransaction));
    }

    private BigDecimal getBigDecimal(List<TpmLiqueurActBudgetTransactionEntity> transactionEntities, List<TpmFeeBudgetDetailsEntity> addDetailsList, List<TpmLiqueurActBudgetTransactionEntity> addTransaction, BigDecimal waitAudit, String feeBudgetCode, TpmFeeBudgetEntity budget, TpmFeeBudgetDetailsEntity detailsEntity, BigDecimal usedAmount) {
        addDetailsList.add(detailsEntity.setFeeAmount(waitAudit).setBeforAmount(budget.getCanUseAmount()).setAfterAmount(budget.getCanUseAmount().subtract(waitAudit)));
        budget.setUsedAmount(usedAmount.add(budget.getCanUseAmount()));
        budget.setCanUseAmount(budget.getCanUseAmount().subtract(waitAudit));
        waitAudit = BigDecimal.ZERO;
        addTransaction.add(transactionEntities.get(0).setFeeBudgetCode(feeBudgetCode).setFeeAmount(waitAudit));
        return waitAudit;
    }

    private List<TpmLiqueurActBudgetTransactionEntity> addParams(List<TpmLiqueurActBudgetTransactionEntity> list) {
        list.forEach(transaction -> {
            transaction.setCreateDate(DateUtil.formatDate());
            transaction.setCreateDateSecond(DateUtil.dateNowStrHms());
            transaction.setCreateCode(UserUtils.getUser().getCustname());
            transaction.setCreatePosCode(UserUtils.getUser().getPoscode());
            transaction.setCreateName(UserUtils.getUser().getRealname());
            transaction.setCreatePosName(UserUtils.getUser().getPosname());
            transaction.setCreateOrgCode(UserUtils.getUser().getOrgcode());
            transaction.setCreateOrgName(UserUtils.getUser().getOrgname());
            transaction.setId(null);
        });
        return list;
    }

    @Transactional(rollbackFor={Exception.class})
    public void sendToActivity(TpmLiqueurAuditEntity entity, TpmLiqueurAuditReqVo reqVo) {
        if (StringUtils.equals((CharSequence)ActApproveStatusEnum.APPROVING.getCode(), (CharSequence)entity.getApproveStatus())) {
            StartProcessReqVo processReqVo = this.helper.buildStartProcessData(entity, reqVo);
            Result processCommonVoResult = this.activityFeign.startProcess(processReqVo);
            log.info("\u6838\u9500\u63d0\u4ea4\u5ba1\u6279,\u5de5\u4f5c\u6d41\u8fd4\u56de\u53c2\u6570={}", (Object)JSON.toJSONString((Object)processCommonVoResult));
            if (!Objects.equals(CommonConstant.SC_OK_200, processCommonVoResult.getCode())) {
                throw new BusinessException(processCommonVoResult.getMessage());
            }
            entity.setProcessCode(((ProcessCommonVo)processCommonVoResult.getResult()).getProcessNo());
            this.saveOrUpdate((Object)entity);
        }
    }
}

