/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.account.controller;

import com.biz.crm.account.service.ITpmAccountDetailService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.audit.service.ITpmAuditDetailService;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.costtypefine.service.ITpmCostTypeFineService;
import com.biz.crm.nebular.tpm.account.req.TpmAccountDetailMainReqVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountDetailReqVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountInvoiceReqVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountUpdatePayTypeReqVo;
import com.biz.crm.nebular.tpm.account.req.TpmPayTypeByTypeAndFineVo;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountDetailMainRespVo;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountDetailRespVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditDetailReqVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditDetailRespVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tpmAccountDetailController"})
@Api(tags={"\u8d39\u7528\u4e0a\u8d26\u8868;"})
public class TpmAccountDetailController {
    private static final Logger log = LoggerFactory.getLogger(TpmAccountDetailController.class);
    @Autowired
    private ITpmAccountDetailService tpmAccountDetailService;
    @Autowired
    private ITpmAuditDetailService tpmAuditDetailService;
    @Autowired
    private ITpmCostTypeFineService tpmCostTypeFineService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<TpmAccountDetailRespVo>> list(@RequestBody TpmAccountDetailReqVo tpmAccountDetailReqVo) {
        PageResult<TpmAccountDetailRespVo> result = this.tpmAccountDetailService.findList(tpmAccountDetailReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u770b")
    @GetMapping(value={"/queryView"})
    @CrmLog
    public Result<TpmAccountDetailMainRespVo> queryView(@RequestParam(value="id", required=false) String id) {
        TpmAccountDetailMainRespVo respVo = this.tpmAccountDetailService.queryView(id);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody TpmAccountDetailMainReqVo accountDetailMainReqVo) {
        UserRedis user = UserUtils.getUser();
        accountDetailMainReqVo.setLockUserName(user.getUsername());
        this.tpmAccountDetailService.save(accountDetailMainReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody TpmAccountDetailMainReqVo accountDetailMainReqVo) {
        UserRedis user = UserUtils.getUser();
        accountDetailMainReqVo.setLockUserName(user.getUsername());
        this.tpmAccountDetailService.update(accountDetailMainReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.tpmAccountDetailService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        this.tpmAccountDetailService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        this.tpmAccountDetailService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u652f\u4ed8\u65b9\u5f0f")
    @PostMapping(value={"/batchUpdatePayType"})
    @CrmLog
    public Result batchUpdatePayType(@RequestBody TpmAccountUpdatePayTypeReqVo updatePayTypeReqVo) {
        this.tpmAccountDetailService.batchUpdatePayType(updatePayTypeReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u6839\u636e\u652f\u4ed8\u65b9\u5f0f\u7c7b\u578b\u548c\u6d3b\u52a8\u7ec6\u7c7b\u96c6\u5408\u67e5\u8be2\u652f\u4ed8\u65b9\u5f0f")
    @PostMapping(value={"/payTypeByTypeAndFine"})
    @CrmLog
    public Result<List<DictItemVo>> payTypeByTypeAndFine(@RequestBody TpmPayTypeByTypeAndFineVo typeAndFineVo) {
        List<DictItemVo> respVo = this.tpmAccountDetailService.payTypeByTypeAndFine(typeAndFineVo);
        return Result.ok(respVo);
    }

    @ApiOperation(value="\u4e0a\u8d26\u6838\u9500\u660e\u7ec6\u67e5\u8be2")
    @PostMapping(value={"/findAccountAuditDetail"})
    @CrmLog
    public Result<PageResult<TpmAuditDetailRespVo>> findAccountAuditDetail(@RequestBody TpmAuditDetailReqVo tpmAuditDetailReqVo) {
        PageResult<TpmAuditDetailRespVo> result = this.tpmAuditDetailService.findAccountAuditDetail(tpmAuditDetailReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u8d39\u7528\u4e0a\u8d26\u6839\u636e\u7ec6\u7c7b\u7f16\u7801\u96c6\u5408\u6216\u8005\u4e0a\u8d26\u5355\u53f7\u96c6\u5408\u67e5\u8be2\u4e0a\u8d26\u79d1\u76ee\u96c6\u5408")
    @PostMapping(value={"/financeSubjectsErpCodeByFindCode"})
    @CrmLog
    public Result<List<TpmCostTypeFineRespVo>> financeSubjectsErpCodeByFindCode(@RequestBody TpmAccountInvoiceReqVo reqVo) {
        return Result.ok(this.tpmCostTypeFineService.financeSubjectsErpCodeByFindCode(reqVo));
    }
}

