/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.feebudget.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.annotation.Klock;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.tpm.BudgetSubjectsControlTypeEnum;
import com.biz.crm.eunm.tpm.FeeBudgetDetailTypeEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.FeeBudgetException;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetControlMapper;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetDetailsMapper;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetMapper;
import com.biz.crm.feebudget.model.OperateBudgetControlReqVo;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.feebudget.service.ITpmFeeBudgetControlService;
import com.biz.crm.feebudget.service.ITpmFeeBudgetService;
import com.biz.crm.feebudget.service.impl.FeeBudgetServiceHelper;
import com.biz.crm.nebular.tpm.feebudget.req.FeeBudgetControlOperateTypeEnum;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmFeeBudgetServiceExpandImpl"})
public class TpmFeeBudgetServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmFeeBudgetMapper, TpmFeeBudgetEntity>
implements ITpmFeeBudgetService {
    private static final Logger log = LoggerFactory.getLogger(TpmFeeBudgetServiceImpl.class);
    @Resource
    private TpmFeeBudgetMapper tpmFeeBudgetMapper;
    @Autowired
    private FeeBudgetServiceHelper serviceHelper;
    @Resource
    private TpmFeeBudgetDetailsMapper detailsMapper;
    @Resource
    private TpmFeeBudgetControlMapper controlMapper;
    @Autowired
    private ITpmFeeBudgetControlService controlService;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;

    @Override
    public PageResult<TpmFeeBudgetRespVo> findList(TpmFeeBudgetReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<TpmFeeBudgetRespVo> list = this.tpmFeeBudgetMapper.findList((Page<TpmFeeBudgetRespVo>)page, reqVo);
        this.serviceHelper.convertListDate(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmFeeBudgetRespVo query(String id) {
        TpmFeeBudgetReqVo reqVo = new TpmFeeBudgetReqVo();
        reqVo.setId(id);
        List list = this.findList(reqVo).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new TpmFeeBudgetRespVo();
        }
        return (TpmFeeBudgetRespVo)list.get(0);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock(keys={"fee", "#reqVo.username"}, waitTime=0L, leaseTime=5L)
    public void save(TpmFeeBudgetReqVo reqVo) {
        this.serviceHelper.saveCheck(reqVo);
        TpmFeeBudgetEntity entity = (TpmFeeBudgetEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmFeeBudgetEntity.class));
        entity.setCanUseAmount(entity.getInitAmount());
        entity.setUsedAmount(BigDecimal.ZERO);
        entity.setAfterAdjustAmount(entity.getInitAmount());
        entity.setAdjustTotalAmount(BigDecimal.ZERO);
        this.serviceHelper.createOrUpdateSaveDetail(entity, reqVo);
        OperateBudgetControlReqVo controlReqVo = OperateBudgetControlReqVo.builder().entity(entity).reqVo(reqVo).typeEnum(FeeBudgetControlOperateTypeEnum.NEW).build();
        this.serviceHelper.saveFeeBudgetControlData(controlReqVo);
        this.save((Object)entity);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        TpmFeeBudgetRespVo newData = (TpmFeeBudgetRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmFeeBudgetRespVo.class);
        this.crmLogSendUtil.sendForAdd(menuCodeObj.toString(), newData.getId(), newData.getFeeBudgetCode(), (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock(keys={"fee", "#reqVo.username"}, waitTime=0L, leaseTime=5L)
    public void update(TpmFeeBudgetReqVo reqVo) {
        if (StringUtils.isEmpty((CharSequence)reqVo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TpmFeeBudgetEntity entity = (TpmFeeBudgetEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        TpmFeeBudgetRespVo oldData = (TpmFeeBudgetRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmFeeBudgetRespVo.class);
        AssertUtils.isNotNull((Object)((Object)entity), (CrmExceptionType)FeeBudgetException.DATA_NOT_EXIST, (String[])new String[0]);
        reqVo.setFeeBudgetCode(entity.getFeeBudgetCode());
        reqVo.setControlId(entity.getControlId());
        reqVo.setRemarks(entity.getRemarks());
        reqVo.setFeeBudgetCode(entity.getFeeBudgetCode());
        reqVo.setCanUseAmount(entity.getCanUseAmount());
        Integer count = this.detailsMapper.getDetailCountByFeeBudgetCode(entity.getFeeBudgetCode());
        AssertUtils.isTrue((count <= 1 ? 1 : 0) != 0, (CrmExceptionType)FeeBudgetException.NOT_ALLOW_EDIT, (String[])new String[0]);
        this.serviceHelper.saveCheck(reqVo);
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)((Object)entity));
        entity.setCanUseAmount(entity.getInitAmount());
        entity.setUsedAmount(BigDecimal.ZERO);
        entity.setAfterAdjustAmount(entity.getInitAmount());
        entity.setAdjustTotalAmount(BigDecimal.ZERO);
        this.serviceHelper.createOrUpdateSaveDetail(entity, reqVo);
        OperateBudgetControlReqVo controlReqVo = OperateBudgetControlReqVo.builder().entity(entity).reqVo(reqVo).typeEnum(FeeBudgetControlOperateTypeEnum.UPDATE).build();
        this.serviceHelper.saveFeeBudgetControlData(controlReqVo);
        this.updateById((Object)entity);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        TpmFeeBudgetRespVo newData = (TpmFeeBudgetRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmFeeBudgetRespVo.class);
        this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), newData.getId(), newData.getFeeBudgetCode(), (Object)oldData, (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List<TpmFeeBudgetRespVo> list = this.tpmFeeBudgetMapper.countDetailsNum(ids);
        AssertUtils.isNotEmpty(list, (String)"\u60a8\u9009\u62e9\u7684\u8d39\u7528\u9884\u7b97\u5df2\u88ab\u5220\u9664");
        HashMap map = Maps.newHashMap();
        HashMap controlAndFeeBudgetCodeMap = Maps.newHashMap();
        list.forEach(o -> {
            AssertUtils.isTrue((o.getNum() <= 1 ? 1 : 0) != 0, (String)("\u8d39\u7528\u9884\u7b97:" + o.getFeeBudgetCode() + ",\u5df2\u4ea7\u751f\u660e\u7ec6\u6570\u636e,\u4e0d\u80fd\u88ab\u5220\u9664"));
            AssertUtils.isNotEmpty((String)o.getControlId(), (String)("\u8d39\u7528\u9884\u7b97:" + o.getFeeBudgetCode() + ",\u6570\u636e\u5f02\u5e38,\u672a\u5173\u8054\u63a7\u5236\u7ef4\u5ea6"));
            BigDecimal bigDecimal = (BigDecimal)map.get(o.getControlId());
            if (Objects.isNull(bigDecimal)) {
                controlAndFeeBudgetCodeMap.put(o.getControlId(), Lists.newArrayList((Object[])new String[]{o.getFeeBudgetCode()}));
                map.put(o.getControlId(), Optional.ofNullable(o.getCanUseAmount()).orElse(BigDecimal.ZERO));
            } else {
                List strings = (List)controlAndFeeBudgetCodeMap.get(o.getControlId());
                strings.add(o.getFeeBudgetCode());
                controlAndFeeBudgetCodeMap.put(o.getControlId(), strings);
                map.put(o.getControlId(), bigDecimal.add(Optional.ofNullable(o.getCanUseAmount()).orElse(BigDecimal.ZERO)));
            }
        });
        List controlEntities = this.controlMapper.selectList((Wrapper)new LambdaQueryWrapper().in(BaseIdEntity::getId, map.keySet()));
        if (CollectionUtils.isNotEmpty((Collection)controlEntities)) {
            controlEntities.forEach(o -> {
                BigDecimal bigDecimal = (BigDecimal)map.get(o.getId());
                List feeBudgetCodes = (List)controlAndFeeBudgetCodeMap.get(o.getId());
                feeBudgetCodes.forEach(p -> {
                    String s = this.serviceHelper.replaceFeeBudgetCodes(o.getFeeBudgetCodes(), (String)p);
                    o.setFeeBudgetCodes(s);
                });
                OperateBudgetControlReqVo controlReqVo = OperateBudgetControlReqVo.builder().controlEntity((TpmFeeBudgetControlEntity)((Object)o)).typeEnum(FeeBudgetControlOperateTypeEnum.DELETE).controlUpdateAmount(bigDecimal).build();
                this.serviceHelper.saveFeeBudgetControlData(controlReqVo);
            });
        }
        PageResult<TpmFeeBudgetRespVo> oldDataList = this.findList(new TpmFeeBudgetReqVo().setIds(ids));
        this.tpmFeeBudgetMapper.deleteByParams(new TpmFeeBudgetReqVo().setIds(ids));
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        for (TpmFeeBudgetRespVo oldData : oldDataList.getData()) {
            this.crmLogSendUtil.sendForDel(menuCodeObj.toString(), oldData.getId(), oldData.getFeeBudgetCode(), (Object)oldData);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List entities = this.tpmFeeBudgetMapper.selectBatchIds(ids);
        List oldDataList = CrmBeanUtil.copyList((List)entities, TpmFeeBudgetRespVo.class);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            entities.forEach(o -> {
                if (!StringUtils.equals((CharSequence)CrmEnableStatusEnum.ENABLE.getCode(), (CharSequence)o.getEnableStatus())) {
                    OperateBudgetControlReqVo controlReqVo = OperateBudgetControlReqVo.builder().entity((TpmFeeBudgetEntity)((Object)o)).typeEnum(FeeBudgetControlOperateTypeEnum.ENABLE).build();
                    this.serviceHelper.saveFeeBudgetControlData(controlReqVo);
                }
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(entities);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        List newDataList = CrmBeanUtil.copyList((List)entities, TpmFeeBudgetRespVo.class);
        for (int i = 0; i < newDataList.size(); ++i) {
            this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), ((TpmFeeBudgetRespVo)newDataList.get(i)).getId(), ((TpmFeeBudgetRespVo)newDataList.get(i)).getBudgetSubjectsCode(), oldDataList.get(i), newDataList.get(i));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        List entities = this.tpmFeeBudgetMapper.selectBatchIds(ids);
        List oldDataList = CrmBeanUtil.copyList((List)entities, TpmFeeBudgetRespVo.class);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            entities.forEach(o -> {
                if (!StringUtils.equals((CharSequence)CrmEnableStatusEnum.DISABLE.getCode(), (CharSequence)o.getEnableStatus())) {
                    OperateBudgetControlReqVo controlReqVo = OperateBudgetControlReqVo.builder().entity((TpmFeeBudgetEntity)((Object)o)).typeEnum(FeeBudgetControlOperateTypeEnum.DISABLE).build();
                    this.serviceHelper.saveFeeBudgetControlData(controlReqVo);
                }
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(entities);
        List newDataList = CrmBeanUtil.copyList((List)entities, TpmFeeBudgetRespVo.class);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        for (int i = 0; i < newDataList.size(); ++i) {
            this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), ((TpmFeeBudgetRespVo)newDataList.get(i)).getId(), ((TpmFeeBudgetRespVo)newDataList.get(i)).getBudgetSubjectsCode(), oldDataList.get(i), newDataList.get(i));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock(keys={"fee", "#reqVo.username"}, waitTime=0L, leaseTime=5L)
    public void change(TpmFeeBudgetReqVo reqVo) {
        TpmFeeBudgetEntity budgetEntity = (TpmFeeBudgetEntity)((Object)this.tpmFeeBudgetMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(BaseIdEntity::getId, (Object)reqVo.getId())));
        AssertUtils.isNotNull((Object)((Object)budgetEntity), (String)"\u9884\u7b97\u6570\u636e\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u91cd\u8bd5");
        reqVo.setBudgetSubjectsCode(budgetEntity.getBudgetSubjectsCode());
        this.serviceHelper.changeCheck(reqVo);
        TpmFeeBudgetRespVo oldData = (TpmFeeBudgetRespVo)CrmBeanUtil.copy((Object)((Object)budgetEntity), TpmFeeBudgetRespVo.class);
        BigDecimal decimal = BigDecimal.ZERO;
        if (StringUtils.equals((CharSequence)FeeBudgetDetailTypeEnum.CUT_OUT.getCode(), (CharSequence)reqVo.getFeeBudgetDetailType())) {
            decimal = budgetEntity.getCanUseAmount().subtract(reqVo.getChangeAmount());
            if (decimal.compareTo(BigDecimal.ZERO) < 1 && !StringUtils.equals((CharSequence)BudgetSubjectsControlTypeEnum.NON.getCode(), (CharSequence)reqVo.getBudgetSubjectsControlType())) {
                throw new BusinessException((CrmExceptionType)FeeBudgetException.AMOUNT_LT_ZERO);
            }
        } else {
            decimal = budgetEntity.getCanUseAmount().add(reqVo.getChangeAmount());
        }
        OperateBudgetControlReqVo controlReqVo = OperateBudgetControlReqVo.builder().entity(budgetEntity).typeEnum(FeeBudgetControlOperateTypeEnum.CHANGE).afterChangeCanUseAmount(decimal.subtract(budgetEntity.getCanUseAmount())).build();
        this.serviceHelper.saveFeeBudgetControlData(controlReqVo);
        budgetEntity.setCanUseAmount(decimal);
        this.serviceHelper.changeOrAdjustSaveDetail(budgetEntity, reqVo);
        this.serviceHelper.computeAmount(budgetEntity, reqVo);
        this.updateById((Object)budgetEntity);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        TpmFeeBudgetRespVo newData = (TpmFeeBudgetRespVo)CrmBeanUtil.copy((Object)((Object)budgetEntity), TpmFeeBudgetRespVo.class);
        this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), newData.getId(), newData.getFeeBudgetCode(), (Object)oldData, (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock(keys={"fee", "#reqVo.username"}, waitTime=0L, leaseTime=5L)
    public void adjust(TpmFeeBudgetReqVo reqVo) {
        this.serviceHelper.adjustCheck(reqVo);
        TpmFeeBudgetEntity adjustOutEntity = (TpmFeeBudgetEntity)((Object)this.tpmFeeBudgetMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(BaseIdEntity::getId, (Object)reqVo.getId())));
        AssertUtils.isNotNull((Object)((Object)adjustOutEntity), (String)"\u8c03\u51fa\u65b9\u6570\u636e\u4e0d\u5b58\u5728");
        TpmFeeBudgetEntity adjustInEntity = (TpmFeeBudgetEntity)((Object)this.tpmFeeBudgetMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(BaseIdEntity::getId, (Object)reqVo.getAdjustInFeeBudgetId())));
        AssertUtils.isNotNull((Object)((Object)adjustInEntity), (String)"\u8c03\u5165\u65b9\u6570\u636e\u4e0d\u5b58\u5728");
        TpmFeeBudgetRespVo oldAdjustOut = (TpmFeeBudgetRespVo)CrmBeanUtil.copy((Object)((Object)adjustOutEntity), TpmFeeBudgetRespVo.class);
        TpmFeeBudgetRespVo oldAdjustIn = (TpmFeeBudgetRespVo)CrmBeanUtil.copy((Object)((Object)adjustInEntity), TpmFeeBudgetRespVo.class);
        BigDecimal outDecimal = adjustOutEntity.getCanUseAmount().subtract(reqVo.getChangeAmount());
        if (outDecimal.compareTo(BigDecimal.ZERO) < 1 && !StringUtils.equals((CharSequence)BudgetSubjectsControlTypeEnum.NON.getCode(), (CharSequence)reqVo.getBudgetSubjectsControlType())) {
            throw new BusinessException((CrmExceptionType)FeeBudgetException.AMOUNT_LT_ZERO);
        }
        OperateBudgetControlReqVo controlReqVo = OperateBudgetControlReqVo.builder().entity(adjustOutEntity).typeEnum(FeeBudgetControlOperateTypeEnum.ADJUST_OUT).afterChangeCanUseAmount(BigDecimal.ZERO.subtract(reqVo.getChangeAmount())).build();
        this.serviceHelper.saveFeeBudgetControlData(controlReqVo);
        adjustOutEntity.setCanUseAmount(outDecimal);
        reqVo.setAdjustInFeeBudgetCode(adjustInEntity.getFeeBudgetCode());
        reqVo.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.ADJUST_OUT.getCode());
        this.serviceHelper.changeOrAdjustSaveDetail(adjustOutEntity, reqVo);
        this.serviceHelper.computeAmount(adjustOutEntity, reqVo);
        this.updateById((Object)adjustOutEntity);
        BigDecimal inDecimal = adjustInEntity.getCanUseAmount().add(reqVo.getChangeAmount());
        OperateBudgetControlReqVo controlReqVo1 = OperateBudgetControlReqVo.builder().entity(adjustInEntity).typeEnum(FeeBudgetControlOperateTypeEnum.ADJUST_IN).afterChangeCanUseAmount(reqVo.getChangeAmount()).build();
        this.serviceHelper.saveFeeBudgetControlData(controlReqVo1);
        adjustInEntity.setCanUseAmount(inDecimal);
        reqVo.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.ADJUST_IN.getCode());
        this.serviceHelper.changeOrAdjustSaveDetail(adjustInEntity, reqVo);
        this.serviceHelper.computeAmount(adjustInEntity, reqVo);
        this.updateById((Object)adjustInEntity);
        TpmFeeBudgetRespVo newAdjustIn = (TpmFeeBudgetRespVo)CrmBeanUtil.copy((Object)((Object)adjustInEntity), TpmFeeBudgetRespVo.class);
        TpmFeeBudgetRespVo newAdjustOut = (TpmFeeBudgetRespVo)CrmBeanUtil.copy((Object)((Object)adjustOutEntity), TpmFeeBudgetRespVo.class);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), newAdjustIn.getId(), newAdjustIn.getFeeBudgetCode(), (Object)oldAdjustIn, (Object)newAdjustIn);
        this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), newAdjustOut.getId(), newAdjustOut.getFeeBudgetCode(), (Object)oldAdjustOut, (Object)newAdjustOut);
    }
}

