/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.liqueuract.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.annotation.Klock;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.budgetsubjects.mapper.TpmBudgetSubjectsMapper;
import com.biz.crm.common.PageResult;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesMapper;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesEntity;
import com.biz.crm.costtypecategories.service.impl.CostTypeCategoriesServiceHelper;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActSendMessageTypeEnum;
import com.biz.crm.eunm.tpm.BudgetSubjectsControlTypeEnum;
import com.biz.crm.eunm.tpm.TpmProjectNameEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetControlMapper;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActBudgetMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActRegisterDetailAttachMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActRegisterDetailBudgetMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActRegisterDetailMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActRegisterMapper;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterDetailAttachEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterDetailBudgetEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterDetailEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterEntity;
import com.biz.crm.liqueuract.service.ITpmLiqueurActRegisterService;
import com.biz.crm.liqueuract.service.impl.TpmLiqueurActRegisterServiceHelper;
import com.biz.crm.liqueuract.service.impl.actbuilder.ActRegisterBuilder;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.common.ProcessCommonVo;
import com.biz.crm.nebular.tpm.act.req.TpmActSendMessageVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRespVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActBudgetRespVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterDetailAttachRespVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterDetailBudgetRespVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterDetailRespVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmLiqueurDetailServiceExpandImpl"})
public class TpmLiqueurActRegisterServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmLiqueurActRegisterMapper, TpmLiqueurActRegisterEntity>
implements ITpmLiqueurActRegisterService {
    private static final Logger log = LoggerFactory.getLogger(TpmLiqueurActRegisterServiceImpl.class);
    @Autowired
    private TaActBaseFeign activityFeign;
    @Resource
    private TpmLiqueurActRegisterMapper tpmLiqueurActRegisterMapper;
    @Resource
    private TpmLiqueurActBudgetMapper budgetMapper;
    @Resource
    private TpmFeeBudgetControlMapper budgetControlMapper;
    @Resource
    private TpmBudgetSubjectsMapper budgetSubjectsMapper;
    @Resource
    private TpmCostTypeCategoriesMapper costTypeCategoriesMapper;
    @Autowired
    private CostTypeCategoriesServiceHelper categoriesServiceHelper;
    @Resource
    private TpmLiqueurActRegisterDetailBudgetMapper detailBudgetMapper;
    @Resource
    private TpmLiqueurActRegisterDetailAttachMapper attachMapper;
    @Resource
    private TpmLiqueurActRegisterDetailMapper detailMapper;
    @Autowired
    private TpmLiqueurActRegisterServiceHelper helper;
    @Autowired
    private RocketMQProducer rocketMQProducer;
    @Value(value="${rocketmq.topic}${rocketmq.environment-variable}")
    private String topic;

    @Override
    public PageResult<TpmLiqueurActRegisterRespVo> findList(TpmLiqueurActRegisterReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<TpmLiqueurActRegisterRespVo> list = this.tpmLiqueurActRegisterMapper.findList((Page<TpmLiqueurActRegisterRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmLiqueurActRegisterRespVo query(String id) {
        AssertUtils.isNotEmpty((String)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        TpmLiqueurActRegisterReqVo tpmLiqueurActRegisterReqVo = new TpmLiqueurActRegisterReqVo();
        tpmLiqueurActRegisterReqVo.setId(id);
        List list = this.findList(tpmLiqueurActRegisterReqVo).getData();
        AssertUtils.isNotEmpty((Collection)list, (String)"\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e0d\u5b58\u5728");
        TpmLiqueurActRegisterRespVo respVo = (TpmLiqueurActRegisterRespVo)list.get(0);
        AssertUtils.isNotEmpty((String)respVo.getActRegisterCode(), (String)"\u8be5\u6570\u636e\u6d3b\u52a8\u767b\u8bb0\u5355\u53f7\u4e3a\u7a7a");
        List budgetEntities = this.budgetMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(TpmLiqueurActBudgetEntity::getActCode, (Object)respVo.getActCode()));
        if (CollectionUtils.isNotEmpty((Collection)budgetEntities)) {
            HashSet controlIds = Sets.newHashSet();
            HashMap controlIdMap = Maps.newHashMap();
            HashMap amountMap = Maps.newHashMap();
            budgetEntities.stream().forEach(actBudgetEntity -> {
                if (controlIdMap.containsKey(actBudgetEntity.getControlId())) {
                    ((List)controlIdMap.get(actBudgetEntity.getControlId())).add(actBudgetEntity);
                    ((BigDecimal)((List)amountMap.get(actBudgetEntity.getControlId())).get(0)).add(actBudgetEntity.getApplyAmount());
                    ((BigDecimal)((List)amountMap.get(actBudgetEntity.getControlId())).get(1)).add(actBudgetEntity.getCanUseAmount());
                } else {
                    ArrayList liqueurActBudgetEntitiesByControlId = Lists.newArrayList();
                    liqueurActBudgetEntitiesByControlId.add(actBudgetEntity);
                    controlIdMap.put(actBudgetEntity.getControlId(), liqueurActBudgetEntitiesByControlId);
                    ArrayList amountList = Lists.newArrayList();
                    amountList.add(0, actBudgetEntity.getApplyAmount());
                    amountList.add(1, actBudgetEntity.getCanUseAmount());
                    amountMap.put(actBudgetEntity.getControlId(), amountList);
                }
                controlIds.add(actBudgetEntity.getControlId());
            });
            List budgetControlRespVos = CrmBeanUtil.copyList((List)this.budgetControlMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmFeeBudgetControlEntity.class).in(BaseIdEntity::getId, (Collection)controlIds)), TpmFeeBudgetControlRespVo.class);
            if (CollectionUtils.isNotEmpty((Collection)budgetControlRespVos)) {
                budgetControlRespVos.stream().forEach(budgetControl -> {
                    budgetControl.setApplyAmount((BigDecimal)((List)amountMap.get(budgetControl.getId())).get(0));
                    budgetControl.setCanUseAmount((BigDecimal)((List)amountMap.get(budgetControl.getId())).get(1));
                    budgetControl.setLiqueurBudgetVos(CrmBeanUtil.copyList((List)((List)controlIdMap.get(budgetControl.getId())), TpmLiqueurActBudgetRespVo.class));
                });
            }
            respVo.setBudgetControlRespVos(budgetControlRespVos);
        }
        List detailEntities = this.detailMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(TpmLiqueurActRegisterDetailEntity::getActRegisterCode, (Object)respVo.getActRegisterCode()));
        List detailRespVos = CrmBeanUtil.copyList((List)detailEntities, TpmLiqueurActRegisterDetailRespVo.class);
        List detailBudgetEntities = this.detailBudgetMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmLiqueurActRegisterDetailBudgetEntity.class).eq(TpmLiqueurActRegisterDetailBudgetEntity::getActRegisterCode, (Object)respVo.getActRegisterCode()));
        List detailAttachEntities = this.attachMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmLiqueurActRegisterDetailAttachEntity.class).eq(TpmLiqueurActRegisterDetailAttachEntity::getActRegisterCode, (Object)respVo.getActRegisterCode()));
        Map<String, List<TpmLiqueurActRegisterDetailBudgetEntity>> detailBudgetMap = detailBudgetEntities.stream().collect(Collectors.groupingBy(TpmLiqueurActRegisterDetailBudgetEntity::getActDetailCode));
        Map<String, List<TpmLiqueurActRegisterDetailAttachEntity>> detailAttachMap = detailAttachEntities.stream().collect(Collectors.groupingBy(TpmLiqueurActRegisterDetailAttachEntity::getActDetailCode));
        if (CollectionUtils.isNotEmpty((Collection)detailRespVos)) {
            detailRespVos.stream().forEach(detailRespVo -> {
                detailRespVo.setDetailBudgetRespVos(CrmBeanUtil.copyList((List)((List)detailBudgetMap.get(detailRespVo.getActDetailCode())), TpmLiqueurActRegisterDetailBudgetRespVo.class));
                detailRespVo.setAttachRespVos(CrmBeanUtil.copyList((List)((List)detailAttachMap.get(detailRespVo.getActDetailCode())), TpmLiqueurActRegisterDetailAttachRespVo.class));
            });
        }
        respVo.setDetailRespVos(detailRespVos);
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock(keys={"liqueurActRegister", "#reqVo.username"}, waitTime=0L, leaseTime=5L)
    public void save(TpmLiqueurActRegisterReqVo reqVo) {
        ActRegisterBuilder builder = new ActRegisterBuilder(this.helper, reqVo);
        TpmLiqueurActRegisterEntity entity = builder.init().check().convert().save();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock(keys={"liqueurActRegister", "#reqVo.username"}, waitTime=0L, leaseTime=5L)
    public void update(TpmLiqueurActRegisterReqVo reqVo) {
        this.helper.updateCheck(reqVo);
        ActRegisterBuilder builder = new ActRegisterBuilder(this.helper, reqVo);
        TpmLiqueurActRegisterEntity entity = builder.init().check().convert().update();
        this.sendToActivity(entity, reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, (CrmExceptionType)CommonException.IDS_NULL);
        this.helper.deleteCheck(ids);
        this.tpmLiqueurActRegisterMapper.deleteByParams(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        List tpmLiqueurActRegisterEntities = this.tpmLiqueurActRegisterMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)tpmLiqueurActRegisterEntities)) {
            tpmLiqueurActRegisterEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmLiqueurActRegisterEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        List tpmLiqueurActRegisterEntities = this.tpmLiqueurActRegisterMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)tpmLiqueurActRegisterEntities)) {
            tpmLiqueurActRegisterEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmLiqueurActRegisterEntities);
    }

    @Transactional(rollbackFor={Exception.class})
    public void sendToActivity(TpmLiqueurActRegisterEntity entity, TpmLiqueurActRegisterReqVo reqVo) {
        if (StringUtils.equals((CharSequence)ActApproveStatusEnum.APPROVING.getCode(), (CharSequence)entity.getApproveStatus())) {
            StartProcessReqVo processReqVo = this.helper.buildStartProcessData(entity, reqVo);
            Result processCommonVoResult = this.activityFeign.startProcess(processReqVo);
            if (!Objects.equals(CommonConstant.SC_OK_200, processCommonVoResult.getCode())) {
                throw new BusinessException(processCommonVoResult.getMessage());
            }
            entity.setProcessCode(((ProcessCommonVo)processCommonVoResult.getResult()).getProcessNo());
            this.saveOrUpdate((Object)entity);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock(keys={"liqueurActRegister", "#reqVo.username"}, waitTime=0L, leaseTime=5L)
    public void approve(TpmLiqueurActRegisterReqVo reqVo) {
        this.helper.approveCheck(reqVo);
        this.update(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void activityCallBack(ActivitiCallBackVo activitiCallBackVo) {
        TpmLiqueurActRegisterReqVo reqVo = new TpmLiqueurActRegisterReqVo();
        reqVo.setId(activitiCallBackVo.getFormNo());
        TpmActSendMessageVo actSendMessageVo = TpmActSendMessageVo.builder().actId(reqVo.getId()).actSystemType(TpmProjectNameEnum.LIQUEUR_TPM.getCode()).build();
        RocketMQMessageBody rocketMQMessageBody = RocketMQMessageBody.builder().topic(this.topic).tag("TPM_ACT_APPROVED_AND_CLOSED").bizKey("tpm").msgBody(JSON.toJSONString((Object)actSendMessageVo)).build();
        if (Indicator.CON_BPM_DOING.getCode() == activitiCallBackVo.getProcessState().intValue()) {
            this.approved(reqVo);
            actSendMessageVo.setType(ActSendMessageTypeEnum.APPROVED.getCode());
            log.info("\u6d3b\u52a8\u5ba1\u6279\u901a\u8fc7,\u53d1\u9001MQ\u6d88\u606f,messageBody={}", (Object)rocketMQMessageBody.getMsgBody());
            this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
        }
        if (Indicator.CON_BPM_PASS.getCode() == activitiCallBackVo.getProcessState().intValue()) {
            reqVo.setApproveStatus(ActApproveStatusEnum.REJECTED.getCode());
            this.rejectAndInterrupt(reqVo);
        }
        if (Indicator.CON_BPM_REJECT.getCode() == activitiCallBackVo.getProcessState().intValue()) {
            reqVo.setApproveStatus(ActApproveStatusEnum.INTERRUPT.getCode());
            this.rejectAndInterrupt(reqVo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void approved(TpmLiqueurActRegisterReqVo reqVo) {
        this.helper.approved(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void rejectAndInterrupt(TpmLiqueurActRegisterReqVo reqVo) {
        this.helper.rejectAndInterrupt(reqVo);
    }

    @Override
    public List<TpmFeeBudgetControlRespVo> findBudgetByActCode(String actCode) {
        AssertUtils.isNotEmpty((String)actCode, (String)"\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List budgetEntities = this.budgetMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmLiqueurActBudgetEntity.class).eq(TpmLiqueurActBudgetEntity::getActCode, (Object)actCode));
        AssertUtils.isNotEmpty((Collection)budgetEntities, (String)"\u6570\u636e\u5f02\u5e38\uff0c\u6d3b\u52a8\u9884\u7b97\u4e3a\u7a7a");
        HashMap controlIdMap = Maps.newHashMap();
        HashMap amountMap = Maps.newHashMap();
        HashSet controlIds = Sets.newHashSet();
        budgetEntities.stream().forEach(budgetEntity -> {
            if (controlIdMap.containsKey(budgetEntity.getControlId())) {
                ((List)controlIdMap.get(budgetEntity.getControlId())).add(budgetEntity);
                ((BigDecimal)amountMap.get(budgetEntity.getControlId())).add(budgetEntity.getCanUseAmount());
            } else {
                ArrayList liqueurActBudgetEntitiesByControlId = Lists.newArrayList();
                liqueurActBudgetEntitiesByControlId.add(budgetEntity);
                controlIdMap.put(budgetEntity.getControlId(), liqueurActBudgetEntitiesByControlId);
                BigDecimal canUseAmount = BigDecimal.ZERO.add(budgetEntity.getCanUseAmount());
                amountMap.put(budgetEntity.getControlId(), canUseAmount);
            }
            controlIds.add(budgetEntity.getControlId());
        });
        List<TpmFeeBudgetControlRespVo> budgetControlRespVos = CrmBeanUtil.copyList((List)this.budgetControlMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmFeeBudgetControlEntity.class).in(BaseIdEntity::getId, (Collection)controlIds)), TpmFeeBudgetControlRespVo.class);
        if (CollectionUtils.isNotEmpty((Collection)budgetControlRespVos)) {
            budgetControlRespVos.stream().forEach(budgetControl -> {
                budgetControl.setCanUseAmount((BigDecimal)amountMap.get(budgetControl.getId()));
                budgetControl.setLiqueurBudgetVos(CrmBeanUtil.copyList((List)((List)controlIdMap.get(budgetControl.getId())), TpmLiqueurActBudgetRespVo.class));
            });
        }
        budgetControlRespVos = budgetControlRespVos.stream().filter(budgetControlRespVo -> {
            if (budgetControlRespVo.getControlType().equals(BudgetSubjectsControlTypeEnum.NON)) {
                return true;
            }
            return budgetControlRespVo.getCanUseAmount().compareTo(BigDecimal.ZERO) == 1;
        }).collect(Collectors.toList());
        return budgetControlRespVos;
    }

    @Override
    public PageResult<TpmCostTypeCategoriesRespVo> findCategoriesBySubjectCodes(List<TpmCostTypeCategoriesReqVo> reqVos) {
        AssertUtils.isNotEmpty(reqVos, (String)"\u9884\u7b97\u79d1\u76ee\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList subjectCodes = Lists.newArrayList();
        reqVos.stream().forEach(vo -> subjectCodes.add(vo.getBudgetSubjectsCode()));
        Page page = PageUtil.buildPage((Integer)reqVos.get(0).getPageNum(), (Integer)reqVos.get(0).getPageSize());
        page = (Page)this.costTypeCategoriesMapper.selectPage((IPage)page, (Wrapper)Wrappers.lambdaQuery(TpmCostTypeCategoriesEntity.class).in(TpmCostTypeCategoriesEntity::getBudgetSubjectsCode, (Collection)subjectCodes));
        List respVos = CrmBeanUtil.copyList((List)page.getRecords(), TpmCostTypeCategoriesRespVo.class);
        this.categoriesServiceHelper.convertListDate(respVos);
        return PageResult.builder().data(respVos).count(Long.valueOf(page.getTotal())).build();
    }
}

