/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.liqueraudit.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.liqueraudit.service.ITpmLiqueurAuditService;
import com.biz.crm.nebular.tpm.liqueuraudit.req.TpmLiqueurAuditReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tpmliqueuraudit"})
@Api(tags={"\u9152\u7c7bTPM\u6838\u9500\u7533\u8bf7\u4e3b\u8868;"})
public class TpmLiqueurAuditController {
    private static final Logger log = LoggerFactory.getLogger(TpmLiqueurAuditController.class);
    @Autowired
    private ITpmLiqueurAuditService tpmLiqueurAuditService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<TpmLiqueurAuditRespVo>> list(@RequestBody TpmLiqueurAuditReqVo tpmLiqueurAuditReqVo) {
        PageResult<TpmLiqueurAuditRespVo> result = this.tpmLiqueurAuditService.findList(tpmLiqueurAuditReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @PostMapping(value={"/query"})
    @CrmLog
    public Result<TpmLiqueurAuditRespVo> query(@RequestBody TpmLiqueurAuditReqVo tpmLiqueurAuditReqVo) {
        TpmLiqueurAuditRespVo respVo = this.tpmLiqueurAuditService.query(tpmLiqueurAuditReqVo);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody TpmLiqueurAuditReqVo tpmLiqueurAuditReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmLiqueurAuditReqVo.setLockUserName(user.getUsername());
        this.tpmLiqueurAuditService.save(tpmLiqueurAuditReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody TpmLiqueurAuditReqVo tpmLiqueurAuditReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmLiqueurAuditReqVo.setLockUserName(user.getUsername());
        this.tpmLiqueurAuditService.update(tpmLiqueurAuditReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody TpmLiqueurAuditReqVo tpmLiqueurAuditReqVo) {
        this.tpmLiqueurAuditService.deleteBatch(tpmLiqueurAuditReqVo);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody TpmLiqueurAuditReqVo tpmLiqueurAuditReqVo) {
        this.tpmLiqueurAuditService.enableBatch(tpmLiqueurAuditReqVo);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody TpmLiqueurAuditReqVo tpmLiqueurAuditReqVo) {
        this.tpmLiqueurAuditService.disableBatch(tpmLiqueurAuditReqVo);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }
}

