/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.liqueuract.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.budgetsubjects.mapper.TpmBudgetSubjectsMapper;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesFineMapper;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesMapper;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesEntity;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesFineEntity;
import com.biz.crm.costtypefine.mapper.TpmCostTypeFineMapper;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActSaveTypeEnum;
import com.biz.crm.eunm.tpm.FeeBudgetDetailTypeEnum;
import com.biz.crm.eunm.tpm.LiqueurActBudgetBusinessTypeEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.ActException;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetControlMapper;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetDetailsMapper;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetMapper;
import com.biz.crm.feebudget.model.OperateBudgetControlReqVo;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetDetailsEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.feebudget.service.ITpmFeeBudgetDetailsService;
import com.biz.crm.feebudget.service.ITpmFeeBudgetService;
import com.biz.crm.feebudget.service.impl.FeeBudgetServiceHelper;
import com.biz.crm.feebudget.service.impl.TpmFeeBudgetControlServiceImpl;
import com.biz.crm.liqueraudit.mapper.TpmLiqueurAuditMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActBudgetMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActBudgetTransactionMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActFileMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActRegisterDetailMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActRegisterMapper;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetTransactionEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActFileEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterDetailEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterEntity;
import com.biz.crm.liqueuract.service.ITpmLiqueurActBudgetTransactionService;
import com.biz.crm.liqueuract.service.TpmLiqueurActBudgetService;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.act.req.TaActFileReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.tpm.feebudget.req.FeeBudgetControlOperateTypeEnum;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetControlReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActBudgetRespVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActFileRespVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TpmLiqueurServiceHelper
extends BaseServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(TpmLiqueurServiceHelper.class);
    @Resource
    private MdmOrgFeign orgFeign;
    @Resource
    private MdmCustomerMsgFeign customerMsgFeign;
    @Resource
    private TpmCostTypeCategoriesMapper tpmCostTypeCategoriesMapper;
    @Resource
    private TpmCostTypeCategoriesFineMapper categoriesFineMapper;
    @Autowired
    private TpmFeeBudgetControlServiceImpl feeBudgetControlService;
    @Resource
    private TpmCostTypeFineMapper tpmCostTypeFineMapper;
    @Resource
    private TpmLiqueurAuditMapper auditMapper;
    @Autowired
    private ITpmFeeBudgetService feeBudgetService;
    @Autowired
    private ITpmFeeBudgetDetailsService detailsService;
    @Resource
    private TpmFeeBudgetDetailsMapper detailsMapper;
    @Resource
    private TpmFeeBudgetMapper feeBudgetMapper;
    @Resource
    private TpmBudgetSubjectsMapper subjectsMapper;
    @Resource
    private TpmLiqueurActBudgetMapper liqueurActBudgetMapper;
    @Resource
    private TpmLiqueurActRegisterMapper liqueurActRegisterMapper;
    @Resource
    private TpmLiqueurActRegisterDetailMapper registerDetailMapper;
    @Resource
    private TpmFeeBudgetControlMapper feeBudgetControlMapper;
    @Autowired
    private TpmLiqueurActBudgetService liqueurActBudgetService;
    @Autowired
    private FeeBudgetServiceHelper budgetServiceHelper;
    @Resource
    private TpmLiqueurActFileMapper liqueurActFileMapper;
    @Resource
    private TpmLiqueurActRegisterMapper actRegisterMapper;
    @Resource
    private TpmLiqueurActMapper liqueurActMapper;
    @Autowired
    private ITpmLiqueurActBudgetTransactionService transactionService;
    @Resource
    private TpmLiqueurActBudgetTransactionMapper transactionMapper;

    public Map<String, Map<String, String>> getDictMaps() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("act_approve_status");
        dictCodes.add("enable_status");
        dictCodes.add("yesOrNo");
        dictCodes.add("owned_sales_company");
        dictCodes.add("budget_year");
        dictCodes.add("budget_mouth");
        dictCodes.add("budget_quater");
        dictCodes.add("fee_budget_type");
        return DictUtil.getDictValueMapsByCodes((List)dictCodes);
    }

    public void setRespVoData(TpmLiqueurActRespVo respVo) {
        Map<String, Map<String, String>> dataMaps = this.getDictMaps();
        if (StringUtils.isNotEmpty((CharSequence)respVo.getApproveStatus())) {
            respVo.setApproveStatusName(Optional.ofNullable(dataMaps.get("act_approve_status")).orElse(Maps.newHashMap()).get(respVo.getApproveStatus()));
        }
        if (StringUtils.isNotEmpty((CharSequence)respVo.getEnableStatus())) {
            respVo.setEnableStatusName(Optional.ofNullable(dataMaps.get("enable_status")).orElse(Maps.newHashMap()).get(respVo.getEnableStatus()));
        }
        if (StringUtils.isNotEmpty((CharSequence)respVo.getIsCrossOrg())) {
            respVo.setIsCrossOrgDesc(Optional.ofNullable(dataMaps.get("yesOrNo")).orElse(Maps.newHashMap()).get(respVo.getIsCrossOrg()));
        }
        if (StringUtils.isNotEmpty((CharSequence)respVo.getIsAllAudit())) {
            respVo.setIsAllAuditDesc(Optional.ofNullable(dataMaps.get("yesOrNo")).orElse(Maps.newHashMap()).get(respVo.getIsAllAudit()));
        }
        if (StringUtils.isNotEmpty((CharSequence)respVo.getIsAudit())) {
            respVo.setIsAuditDesc(Optional.ofNullable(dataMaps.get("yesOrNo")).orElse(Maps.newHashMap()).get(respVo.getIsAudit()));
        }
        if (StringUtils.isNotEmpty((CharSequence)respVo.getSaleCompany())) {
            respVo.setSaleCompanyDesc(Optional.ofNullable(dataMaps.get("owned_sales_company")).orElse(Maps.newHashMap()).get(respVo.getSaleCompany()));
        }
        if (StringUtils.isNotEmpty((CharSequence)respVo.getActCode())) {
            List actRegisterEntities = this.actRegisterMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TpmLiqueurActRegisterEntity::getActCode, (Object)respVo.getActCode())).eq(TpmLiqueurActRegisterEntity::getApproveStatus, (Object)ActApproveStatusEnum.APPROVED.getCode()));
            if (CollectionUtils.isNotEmpty((Collection)actRegisterEntities)) {
                respVo.setRegisterTotalAmount(actRegisterEntities.stream().map(TpmLiqueurActRegisterEntity::getTotalAmount).reduce(BigDecimal::add).get());
            } else {
                respVo.setRegisterTotalAmount(BigDecimal.ZERO);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)respVo.getCustomerCode())) {
            respVo.setCustomerCodeList((List)Lists.newArrayList((Object[])new String[]{respVo.getCustomerCode()}));
        }
        if (StringUtils.isNotBlank((CharSequence)respVo.getCustomerName())) {
            respVo.setCustomerNameList((List)Lists.newArrayList((Object[])new String[]{respVo.getCustomerName()}));
        }
        if (StringUtils.isNotBlank((CharSequence)respVo.getOrgCode())) {
            respVo.setOrgCodeList((List)Lists.newArrayList((Object[])new String[]{respVo.getOrgCode()}));
        }
        if (StringUtils.isNotBlank((CharSequence)respVo.getOrgName())) {
            respVo.setOrgNameList((List)Lists.newArrayList((Object[])new String[]{respVo.getOrgName()}));
        }
    }

    public List<TpmBudgetSubjectsEntity> getTpmBudgetSubjectsEntities(TpmFeeBudgetControlRespVo o) {
        return this.subjectsMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmBudgetSubjectsEntity::getBudgetSubjectsCode, (Object)o.getBudgetSubjectsCode()));
    }

    public void saveOrUpdateAct(TpmLiqueurActEntity liqueurActEntity, TpmLiqueurActReqVo reqVo) {
        if (ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())) {
            liqueurActEntity.setApproveStatus(ActApproveStatusEnum.APPROVING.getCode());
        } else if (StringUtils.isEmpty((CharSequence)liqueurActEntity.getApproveStatus())) {
            liqueurActEntity.setApproveStatus(ActApproveStatusEnum.CREATE.getCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)liqueurActEntity.getId())) {
            this.liqueurActMapper.updateById((Object)liqueurActEntity);
        } else {
            this.liqueurActMapper.insert((Object)liqueurActEntity);
        }
    }

    public void saveActBudgets(List<TpmLiqueurActBudgetEntity> actBudgetEntities, TpmLiqueurActReqVo reqVo) {
        List actBudgetEntityList = this.liqueurActBudgetMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmLiqueurActBudgetEntity::getActCode, (Object)reqVo.getActCode()));
        if (CollectionUtils.isEmpty((Collection)actBudgetEntityList)) {
            this.liqueurActBudgetService.saveBatch(actBudgetEntities);
            return;
        }
        ArrayList needSaveEntities = Lists.newArrayList();
        ArrayList needUpdateEntities = Lists.newArrayList();
        actBudgetEntities.forEach(o -> actBudgetEntityList.forEach(x -> {
            if (o.getFeeBudgetCode().equals(x.getFeeBudgetCode())) {
                x.setApplyAmount(o.getApplyAmount());
                needUpdateEntities.add(x);
            } else {
                needSaveEntities.add(o);
            }
        }));
        this.liqueurActBudgetService.saveBatch(needSaveEntities);
        this.liqueurActBudgetService.updateBatchById(needUpdateEntities);
    }

    public void saveActFiles(List<TpmLiqueurActFileEntity> liqueurActFileEntities, TpmLiqueurActReqVo reqVo) {
        if (ActSaveTypeEnum.getUpdateTypes().contains(reqVo.getSaveType())) {
            List list = liqueurActFileEntities.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getId())).map(BaseIdEntity::getId).collect(Collectors.toList());
            this.liqueurActFileMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().notIn(CollectionUtils.isNotEmpty(list), BaseIdEntity::getId, list)).eq(TpmLiqueurActFileEntity::getActCode, (Object)reqVo.getActCode()));
        }
        liqueurActFileEntities.forEach(o -> {
            if (StringUtils.isEmpty((CharSequence)o.getId())) {
                this.liqueurActFileMapper.insert(o);
            } else {
                this.liqueurActFileMapper.updateById(o);
            }
        });
    }

    public void saveFeeBudgets(List<TpmFeeBudgetEntity> feeBudgetEntities, TpmLiqueurActReqVo reqVo) {
        if (!ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())) {
            return;
        }
        this.feeBudgetService.updateBatchById(feeBudgetEntities);
    }

    public void saveBudgetController(List<TpmFeeBudgetControlEntity> feeBudgetControlEntities, TpmLiqueurActReqVo reqVo) {
        if (!ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())) {
            return;
        }
        for (TpmFeeBudgetControlEntity o : feeBudgetControlEntities) {
            OperateBudgetControlReqVo controlReqVo = OperateBudgetControlReqVo.builder().controlEntity(o).typeEnum(FeeBudgetControlOperateTypeEnum.USE).build();
            this.budgetServiceHelper.saveFeeBudgetControlData(controlReqVo);
        }
    }

    public StartProcessReqVo buildStartProcessData(TpmLiqueurActEntity entity, TpmLiqueurActReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        StartProcessReqVo startProcessReqVo = new StartProcessReqVo();
        startProcessReqVo.setCallBackFeign("TpmActCallBackFeign");
        startProcessReqVo.setProcessKey(reqVo.getWorkFlowKey());
        startProcessReqVo.setUserCode(user.getUsername());
        startProcessReqVo.setPosCode(user.getPoscode());
        startProcessReqVo.setTitle(reqVo.getTitle());
        startProcessReqVo.setFormNo(entity.getId());
        startProcessReqVo.setRemark(reqVo.getApproveRemarks());
        startProcessReqVo.setSignTicket(System.currentTimeMillis() + "");
        startProcessReqVo.setBusinessCode(entity.getActCode());
        List taActFileReqVos = Optional.ofNullable(reqVo.getActivityFileList()).orElse(Lists.newArrayList()).stream().map(o -> {
            TaActFileReqVo taActFileReqVo = new TaActFileReqVo();
            taActFileReqVo.setObjectName(o.getObjectName());
            taActFileReqVo.setFileAddress(o.getFileAddress());
            return taActFileReqVo;
        }).collect(Collectors.toList());
        startProcessReqVo.setFileList(taActFileReqVos);
        return startProcessReqVo;
    }

    public void setBudgetData(TpmLiqueurActRespVo actRespVo) {
        List liqueurActBudgetEntities = this.liqueurActBudgetMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmLiqueurActBudgetEntity::getActCode, (Object)actRespVo.getActCode()));
        if (CollectionUtils.isNotEmpty((Collection)liqueurActBudgetEntities)) {
            List respVos = CrmBeanUtil.copyList((List)liqueurActBudgetEntities, TpmLiqueurActBudgetRespVo.class);
            actRespVo.setBudgetVos(respVos);
            Map<String, List<TpmLiqueurActBudgetRespVo>> actBudgetGroupMap = respVos.stream().collect(Collectors.groupingBy(TpmLiqueurActBudgetRespVo::getControlId));
            HashMap controllerAndAmount = Maps.newHashMap();
            HashSet idSet = Sets.newHashSet();
            HashSet budgetCodes = Sets.newHashSet();
            actBudgetGroupMap.keySet().forEach(x -> {
                BigDecimal applyAmount = ((List)actBudgetGroupMap.get(x)).stream().map(TpmLiqueurActBudgetRespVo::getApplyAmount).reduce(BigDecimal::add).get();
                idSet.add(x);
                controllerAndAmount.put(x, applyAmount);
                budgetCodes.add(((TpmLiqueurActBudgetRespVo)((List)actBudgetGroupMap.get(x)).get(0)).getBudgetSubjectsCode());
            });
            AssertUtils.isNotEmpty((Collection)budgetCodes, (String)"\u6d3b\u52a8\u9884\u7b97\uff0c\u9884\u7b97\u4fe1\u606f\u4e0d\u5b58\u5728");
            List subjectsEntities = this.subjectsMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(TpmBudgetSubjectsEntity::getBudgetSubjectsCode, (Collection)budgetCodes));
            Map subjectsEntityMap = subjectsEntities.stream().collect(Collectors.toMap(TpmBudgetSubjectsEntity::getBudgetSubjectsCode, Function.identity()));
            List controlEntities = this.feeBudgetControlMapper.selectBatchIds(idSet);
            Map<String, Map<String, String>> map = this.getDictMaps();
            if (CollectionUtils.isNotEmpty((Collection)controlEntities)) {
                ArrayList controlRespVos = Lists.newArrayList();
                controlEntities.forEach(x -> {
                    TpmFeeBudgetControlRespVo vo = (TpmFeeBudgetControlRespVo)CrmBeanUtil.copy((Object)x, TpmFeeBudgetControlRespVo.class);
                    if (controllerAndAmount.containsKey(vo.getId())) {
                        vo.setApplyAmount((BigDecimal)controllerAndAmount.get(x.getId()));
                    }
                    if (subjectsEntityMap.containsKey(x.getBudgetSubjectsCode())) {
                        vo.setBudgetSubjectsName(((TpmBudgetSubjectsEntity)((Object)((Object)subjectsEntityMap.get(x.getBudgetSubjectsCode())))).getBudgetSubjectsName());
                    }
                    if (StringUtils.isNotBlank((CharSequence)vo.getBudgetYear())) {
                        vo.setBudgetYearName((String)((Map)Optional.ofNullable(map.get("budget_year")).orElse(Maps.newHashMap())).get(vo.getBudgetYear()));
                    }
                    if (StringUtils.isNotBlank((CharSequence)vo.getBudgetMonth())) {
                        vo.setBudgetMonthName((String)((Map)Optional.ofNullable(map.get("budget_mouth")).orElse(Maps.newHashMap())).get(vo.getBudgetMonth()));
                    }
                    if (StringUtils.isNotBlank((CharSequence)vo.getBudgetQuater())) {
                        vo.setBudgetQuaterName((String)((Map)Optional.ofNullable(map.get("budget_quater")).orElse(Maps.newHashMap())).get(vo.getBudgetQuater()));
                    }
                    if (StringUtils.isNotBlank((CharSequence)vo.getFeeBudgetType())) {
                        vo.setFeeBudgetTypeName((String)((Map)Optional.ofNullable(map.get("fee_budget_type")).orElse(Maps.newHashMap())).get(vo.getFeeBudgetType()));
                    }
                    controlRespVos.add(vo);
                });
                actRespVo.setEditBudgetVos((List)controlRespVos);
            }
        }
    }

    public void setActFileData(TpmLiqueurActRespVo actRespVo) {
        List fileEntities = this.liqueurActFileMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmLiqueurActFileEntity::getActCode, (Object)actRespVo.getActCode()));
        if (CollectionUtils.isNotEmpty((Collection)fileEntities)) {
            List fileRespVos = CrmBeanUtil.copyList((List)fileEntities, TpmLiqueurActFileRespVo.class);
            actRespVo.setFileRespVos(fileRespVos);
        }
    }

    public void checkUpdate(TpmLiqueurActReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        TpmLiqueurActEntity entity = (TpmLiqueurActEntity)((Object)this.liqueurActMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(BaseIdEntity::getId, (Object)reqVo.getId())));
        AssertUtils.isNotNull((Object)((Object)entity), (CrmExceptionType)ActException.DATA_NOT_EXIST, (String[])new String[0]);
        if (!ActApproveStatusEnum.getCanUpdateStatus().contains(entity.getApproveStatus())) {
            throw new BusinessException("\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u4e0d\u5141\u8bb8\u4fee\u6539\u64cd\u4f5c");
        }
    }

    public TpmLiqueurActEntity saveCheckActStatus(TpmLiqueurActRegisterReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getActCode(), (String)"\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        TpmLiqueurActEntity actEntity = (TpmLiqueurActEntity)((Object)this.liqueurActMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(TpmLiqueurActEntity::getActCode, (Object)reqVo.getActCode())));
        if (actEntity == null) {
            throw new BusinessException("\u6ca1\u6709\u6d3b\u52a8\u7533\u8bf7\u4fe1\u606f");
        }
        if (!actEntity.getApproveStatus().equals(ActApproveStatusEnum.APPROVED.getCode())) {
            throw new BusinessException("\u53ea\u6709\u5ba1\u6279\u901a\u8fc7\u7684\u6d3b\u52a8\u624d\u53ef\u4ee5\u65b0\u589e\u6d3b\u52a8\u660e\u7ec6");
        }
        return actEntity;
    }

    public void checkOrgAndCus(TpmLiqueurActReqVo reqVo) {
        UserRedis userRedis = UserUtils.getUser();
        if (StringUtils.isNotEmpty((CharSequence)userRedis.getOrgcode()) && CollectionUtils.isNotEmpty((Collection)reqVo.getOrgCodeList())) {
            MdmOrgRespVo orgRespVo = (MdmOrgRespVo)ApiResultUtil.objResult((Result)this.orgFeign.detail(userRedis.getOrgcode()), (boolean)true);
            MdmOrgReqVo mdmOrgReqVo = new MdmOrgReqVo();
            if (StringUtils.equals((CharSequence)reqVo.getIsCrossOrg(), (CharSequence)GlobalWhetherEnum.YES.getCode()) && StringUtils.isNotEmpty((CharSequence)orgRespVo.getParentCode())) {
                mdmOrgReqVo.setParentCode(orgRespVo.getParentCode());
                List orgRespVos = (List)ApiResultUtil.objResult((Result)this.orgFeign.findOrgList(mdmOrgReqVo), (boolean)true);
                List orgCodes = orgRespVos.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
                MdmOrgReqVo mdmOrgReqVoByReq = new MdmOrgReqVo();
                mdmOrgReqVoByReq.setOrgCodeList(orgCodes);
                List respVos = (List)ApiResultUtil.objResult((Result)this.orgFeign.listCondition(mdmOrgReqVoByReq), (boolean)true);
                Map orgCodeMap = respVos.stream().collect(Collectors.toMap(MdmOrgRespVo::getOrgCode, Function.identity(), (k1, k2) -> k1));
                ArrayList orgCodeList = Lists.newArrayList(orgCodeMap.keySet());
                orgCodeList.retainAll(reqVo.getOrgCodeList());
                if (orgCodeList.size() != reqVo.getOrgCodeList().size()) {
                    reqVo.getOrgCodeList().removeAll(orgCodeList);
                    throw new BusinessException(reqVo.getOrgCodeList() + "\u8be5\u7ec4\u7ec7\u4e0d\u5728\u6743\u9650\u8303\u56f4");
                }
                ArrayList orgNameList = Lists.newArrayList();
                orgCodeList.forEach(o -> orgNameList.add(((MdmOrgRespVo)orgCodeMap.get(o)).getOrgName()));
                reqVo.setOrgName(((Object)orgNameList).toString());
            } else {
                mdmOrgReqVo.setOrgCodeList((Collection)reqVo.getOrgCodeList());
                List respVos = (List)ApiResultUtil.objResult((Result)this.orgFeign.listCondition(mdmOrgReqVo), (boolean)true);
                Map orgRespVoMap = respVos.stream().collect(Collectors.toMap(MdmOrgRespVo::getOrgCode, Function.identity(), (k1, k2) -> k1));
                ArrayList orgNameList = Lists.newArrayList();
                orgRespVoMap.keySet().forEach(o -> {
                    if (!StringUtils.startsWith((CharSequence)((MdmOrgRespVo)orgRespVoMap.get(o)).getRuleCode(), (CharSequence)orgRespVo.getRuleCode())) {
                        throw new BusinessException(((MdmOrgRespVo)orgRespVoMap.get(o)).getOrgCode() + "\u8be5\u7ec4\u7ec7\u4e0d\u5728\u6743\u9650\u8303\u56f4");
                    }
                    orgNameList.add(((MdmOrgRespVo)orgRespVoMap.get(o)).getOrgName());
                });
                reqVo.setOrgName(((Object)orgNameList).toString());
            }
            reqVo.setOrgCode(reqVo.getOrgCodeList().toString());
            if (CollectionUtils.isNotEmpty((Collection)reqVo.getCustomerCodeList())) {
                MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo = new MdmCustomerOrgSearchReqVo();
                mdmCustomerOrgSearchReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                mdmCustomerOrgSearchReqVo.setLockState(CrmEnableStatusEnum.ENABLE.getCode());
                mdmCustomerOrgSearchReqVo.setOrgCodeList(reqVo.getOrgCodeList());
                List customerMsgRespVos = (List)ApiResultUtil.objResult((Result)this.customerMsgFeign.findCurrentAndSubCustomerList(mdmCustomerOrgSearchReqVo), (boolean)true);
                Map cusMap = customerMsgRespVos.stream().collect(Collectors.toMap(MdmCustomerMsgRespVo::getCustomerCode, Function.identity(), (k1, k2) -> k1));
                ArrayList codeList = Lists.newArrayList(cusMap.keySet());
                codeList.retainAll(reqVo.getCustomerCodeList());
                if (codeList.size() != reqVo.getCustomerCodeList().size()) {
                    reqVo.getCustomerCodeList().removeAll(codeList);
                    throw new BusinessException(reqVo.getCustomerCodeList() + "\u8be5\u5ba2\u6237\u4e0d\u5728\u53ef\u9009\u8303\u56f4\u5185");
                }
                ArrayList cusNameList = Lists.newArrayList();
                codeList.forEach(o -> cusNameList.add(((MdmCustomerMsgRespVo)cusMap.get(o)).getCustomerName()));
                reqVo.setCustomerName(((Object)cusNameList).toString());
                reqVo.setCustomerCode(reqVo.getCustomerCodeList().toString());
            }
        }
    }

    public void checkBudgetData(TpmLiqueurActReqVo reqVo) {
        Set<String> controllerIds = reqVo.getBudgetControlVos().stream().map(UuidVo::getId).collect(Collectors.toSet());
        List<TpmFeeBudgetControlEntity> controlEntities = this.findControlByIds(controllerIds);
        if (reqVo.getBudgetControlVos().size() != controlEntities.size()) {
            throw new BusinessException("\u9884\u7b97\u6570\u636e\u5f02\u5e38,\u9884\u7b97\u4e0d\u5b58\u5728");
        }
    }

    public void checkBudgets(TpmLiqueurActReqVo reqVo) {
        TpmCostTypeFineEntity fineEntity = this.findFineEntity(reqVo.getFineCode());
        reqVo.setFineName(fineEntity.getFineName());
        List categoriesFineEntities = this.categoriesFineMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmCostTypeCategoriesFineEntity::getFineCode, (Object)reqVo.getFineCode()));
        if (CollectionUtils.isEmpty((Collection)categoriesFineEntities)) {
            throw new BusinessException(reqVo.getFineCode() + "\u6d3b\u52a8\u7c7b\u578b\u6ca1\u6709\u5173\u8054\u6295\u5165\u7c7b\u578b\uff0c\u65e0\u6cd5\u9009\u62e9\u9884\u7b97");
        }
        Set<Object> categoriesSets = Sets.newHashSet();
        categoriesSets = categoriesFineEntities.stream().map(TpmCostTypeCategoriesFineEntity::getCategoriesCode).collect(Collectors.toSet());
        List categoriesEntities = this.tpmCostTypeCategoriesMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(TpmCostTypeCategoriesEntity::getCategoriesCode, (Collection)categoriesSets));
        if (CollectionUtils.isEmpty((Collection)categoriesEntities)) {
            throw new BusinessException("\u5173\u8054\u6295\u5165\u7c7b\u578b\u4e0d\u5b58\u5728,\u65e0\u6cd5\u83b7\u53d6\u9884\u7b97");
        }
        Set budgetSubjectSetByCate = categoriesEntities.stream().map(TpmCostTypeCategoriesEntity::getBudgetSubjectsCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(budgetSubjectSetByCate)) {
            throw new BusinessException("\u6295\u5165\u7c7b\u578b\u6570\u636e\u5f02\u5e38\u6ca1\u6709\u9884\u7b97\u79d1\u76ee");
        }
        AssertUtils.isNotEmpty((Collection)reqVo.getBudgetControlVos(), (String)"\u8bf7\u9009\u62e9\u9884\u7b97");
        TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo = new TpmFeeBudgetControlReqVo();
        tpmFeeBudgetControlReqVo.setActBeginDate(reqVo.getBeginDate());
        tpmFeeBudgetControlReqVo.setActEndDate(reqVo.getEndDate());
        List feeBudgetControlRespVoList = this.feeBudgetControlService.findList(tpmFeeBudgetControlReqVo).getData();
        if (CollectionUtils.isEmpty((Collection)feeBudgetControlRespVoList)) {
            throw new BusinessException("\u5f53\u524d\u65f6\u95f4\u6bb5\u6ca1\u6709\u53ef\u7528\u9884\u7b97");
        }
        Set budgetSubjectSets = reqVo.getBudgetControlVos().stream().map(TpmFeeBudgetControlRespVo::getBudgetSubjectsCode).collect(Collectors.toSet());
        if (!budgetSubjectSetByCate.containsAll(budgetSubjectSets)) {
            throw new BusinessException("\u9884\u7b97\u4e0d\u652f\u6301\u5f53\u524d\u6d3b\u52a8\u7c7b\u578b");
        }
    }

    private TpmCostTypeFineEntity findTpmCostTypeFineEntities(TpmLiqueurActReqVo reqVo) {
        List fineEntities = this.tpmCostTypeFineMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmCostTypeFineEntity::getFineCode, (Object)reqVo.getFineCode()));
        if (CollectionUtils.size((Object)fineEntities) != 1) {
            throw new BusinessException("\u6d3b\u52a8\u7c7b\u578b\u5f02\u5e38\uff0c\u6d3b\u52a8\u7ec6\u7c7b\u4e0d\u5b58\u5728");
        }
        return (TpmCostTypeFineEntity)((Object)fineEntities.get(0));
    }

    public List<TpmFeeBudgetControlEntity> findControlByIds(Set<String> ids) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(BaseIdEntity::getId, ids);
        List tpmFeeBudgetControlEntities = this.feeBudgetControlMapper.selectList((Wrapper)queryWrapper);
        return CollectionUtils.isEmpty((Collection)tpmFeeBudgetControlEntities) ? Lists.newArrayList() : tpmFeeBudgetControlEntities;
    }

    public List<TpmFeeBudgetEntity> findFeeBudgetByControlIds(Set<String> ids) {
        List feeBudgetEntities = this.feeBudgetMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TpmFeeBudgetEntity::getControlId, ids)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode()));
        return CollectionUtils.isEmpty((Collection)feeBudgetEntities) ? Lists.newArrayList() : feeBudgetEntities;
    }

    public void approved(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        TpmLiqueurActEntity entity = this.checkOperatingData(tpmLiqueurActReqVo);
        TpmCostTypeFineEntity fineEntity = (TpmCostTypeFineEntity)((Object)this.tpmCostTypeFineMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(TpmCostTypeFineEntity::getFineCode, (Object)entity.getFineCode())));
        if (fineEntity == null) {
            throw new BusinessException("\u7ec6\u7c7b\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u5efa\u6d3b\u52a8");
        }
        String date = "";
        try {
            date = Objects.nonNull(fineEntity.getAuditValidity()) ? DateUtil.formatAddMonth((String)entity.getEndDate(), (String)"yyyy-MM-dd", (int)fineEntity.getAuditValidity()) : "9999-12-31";
        }
        catch (ParseException e) {
            log.error("{}", (Throwable)e);
            throw new BusinessException("\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        entity.setAllowAuditEndDate(date);
        entity.setAllowAuditEndDateSecond("23:59:59");
        entity.setApproveStatus(ActApproveStatusEnum.APPROVED.getCode());
        entity.setIsAllAudit(GlobalWhetherEnum.YES.getCode());
        entity.setApproveAmount(entity.getApplyTotalAmount());
        entity.setCanUseAmount(entity.getApproveAmount());
        entity.setIsAudit(GlobalWhetherEnum.YES.getCode());
        List liqueurActBudgetEntities = this.liqueurActBudgetMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmLiqueurActBudgetEntity::getActCode, (Object)entity.getActCode()));
        liqueurActBudgetEntities.forEach(o -> {
            o.setApproveAmount(o.getApplyAmount());
            o.setCanUseAmount(o.getApproveAmount());
        });
        ArrayList transactionEntities = Lists.newArrayList();
        liqueurActBudgetEntities.forEach(x -> {
            TpmLiqueurActBudgetTransactionEntity transactionEntity = (TpmLiqueurActBudgetTransactionEntity)((Object)((Object)CrmBeanUtil.copy((Object)x, TpmLiqueurActBudgetTransactionEntity.class)));
            super.setPublicParamsNull((CrmBaseEntity)transactionEntity);
            transactionEntity.setBusinessCode(entity.getActCode());
            transactionEntity.setBusinessName(entity.getActName());
            transactionEntity.setBusinessType(FeeBudgetDetailTypeEnum.INIT.getCode());
            transactionEntity.setFeeAmount(x.getCanUseAmount());
            transactionEntities.add(transactionEntity);
        });
        this.transactionService.updateBatchById(transactionEntities);
        this.liqueurActBudgetService.updateBatchById(liqueurActBudgetEntities);
        this.liqueurActMapper.updateById((Object)entity);
    }

    private TpmLiqueurActEntity checkOperatingData(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        AssertUtils.isNotEmpty((String)tpmLiqueurActReqVo.getId(), (CrmExceptionType)CommonException.IDS_NULL);
        TpmLiqueurActEntity entity = (TpmLiqueurActEntity)((Object)this.liqueurActMapper.selectById((Serializable)((Object)tpmLiqueurActReqVo.getId())));
        if (entity == null) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (!entity.getApproveStatus().equals(ActApproveStatusEnum.APPROVING.getCode())) {
            throw new BusinessException("\u53ea\u6709\u5ba1\u6279\u4e2d\u7684\u6d3b\u52a8\u624d\u53ef\u4ee5\u8fdb\u884c\u64cd\u4f5c");
        }
        return entity;
    }

    public void reject(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        TpmLiqueurActEntity entity = this.checkOperatingData(tpmLiqueurActReqVo);
        entity.setApproveStatus(ActApproveStatusEnum.REJECTED.getCode());
        this.rejectAndInterrupt(entity);
    }

    private void rejectAndInterrupt(TpmLiqueurActEntity entity) {
        List actBudgetEntities = this.liqueurActBudgetMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmLiqueurActBudgetEntity::getActCode, (Object)entity.getActCode()));
        HashSet controlIds = Sets.newHashSet();
        HashMap feeBudgetAmount = Maps.newHashMap();
        actBudgetEntities.forEach(o -> {
            o.setCanUseAmount(BigDecimal.ZERO);
            o.setApproveAmount(BigDecimal.ZERO);
            feeBudgetAmount.put(o.getFeeBudgetCode(), o.getApplyAmount());
            controlIds.add(o.getControlId());
        });
        List<TpmFeeBudgetEntity> feeBudgetEntities = this.findFeeBudgetByControlIds(controlIds);
        List<TpmFeeBudgetControlEntity> feeBudgetControlEntities = this.findControlByIds(controlIds);
        feeBudgetEntities.forEach(x -> {
            if (feeBudgetAmount.containsKey(x.getFeeBudgetCode())) {
                x.setCanUseAmount(x.getCanUseAmount().add((BigDecimal)feeBudgetAmount.get(x.getFeeBudgetCode())));
                x.setUsedAmount(x.getUsedAmount().subtract((BigDecimal)feeBudgetAmount.get(x.getFeeBudgetCode())));
            }
        });
        Map<String, List<TpmFeeBudgetEntity>> feeBudgetGroupByControlId = feeBudgetEntities.stream().collect(Collectors.groupingBy(TpmFeeBudgetEntity::getControlId));
        feeBudgetControlEntities.forEach(y -> {
            if (feeBudgetGroupByControlId.containsKey(y.getId())) {
                BigDecimal bigDecimal = ((List)feeBudgetGroupByControlId.get(y.getId())).stream().map(TpmFeeBudgetEntity::getCanUseAmount).reduce(BigDecimal::add).get();
                y.setCanUseAmount(bigDecimal);
            }
        });
        List detailsEntities = this.detailsMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmFeeBudgetDetailsEntity::getBusinessCode, (Object)entity.getActCode()));
        detailsEntities.forEach(x -> x.setFeeAmount(BigDecimal.ZERO));
        List transactionEntities = this.transactionMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmLiqueurActBudgetTransactionEntity::getBusinessCode, (Object)entity.getActCode()));
        transactionEntities.forEach(x -> x.setFeeAmount(BigDecimal.ZERO));
        this.detailsService.updateBatchById(detailsEntities);
        this.transactionService.updateBatchById(transactionEntities);
        this.liqueurActMapper.updateById((Object)entity);
        this.liqueurActBudgetService.updateBatchById(actBudgetEntities);
        this.feeBudgetService.updateBatchById(feeBudgetEntities);
        this.feeBudgetControlService.updateBatchById(feeBudgetControlEntities);
    }

    public void approve(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        AssertUtils.isNotEmpty((String)tpmLiqueurActReqVo.getId(), (CrmExceptionType)CommonException.IDS_NULL);
        AssertUtils.isNotEmpty((String)tpmLiqueurActReqVo.getWorkFlowKey(), (String)"\u8bf7\u9009\u62e9\u6d41\u7a0b");
        TpmLiqueurActEntity entity = (TpmLiqueurActEntity)((Object)this.liqueurActMapper.selectById((Serializable)((Object)tpmLiqueurActReqVo.getId())));
        if (entity == null) {
            throw new BusinessException("\u64cd\u4f5c\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (!ActApproveStatusEnum.getCanApproveStatus().contains(entity.getApproveStatus())) {
            throw new BusinessException("\u5f53\u524d\u6570\u636e\u72b6\u6001\u4e0d\u53ef\u63d0\u4ea4\u5ba1\u6279");
        }
        tpmLiqueurActReqVo.setSaveType(ActSaveTypeEnum.APPROVE.getCode());
        tpmLiqueurActReqVo.setApproveStatus(ActApproveStatusEnum.APPROVING.getCode());
    }

    public TpmCostTypeFineEntity findFineEntity(String fineCode) {
        return (TpmCostTypeFineEntity)((Object)this.tpmCostTypeFineMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(TpmCostTypeFineEntity::getFineCode, (Object)fineCode)));
    }

    public void interrupt(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        TpmLiqueurActEntity entity = this.checkOperatingData(tpmLiqueurActReqVo);
        entity.setApproveStatus(ActApproveStatusEnum.INTERRUPT.getCode());
        this.rejectAndInterrupt(entity);
    }

    public void closed(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        TpmLiqueurActEntity entity = this.checkCanClosedData(tpmLiqueurActReqVo);
        entity.setApproveStatus(ActApproveStatusEnum.CLOSED.getCode());
        List actBudgetEntities = this.liqueurActBudgetMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(TpmLiqueurActBudgetEntity::getActCode, (Object)entity.getActCode()));
        List liqueurActRegisterEntities = this.actRegisterMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TpmLiqueurActRegisterEntity::getActCode, (Object)entity.getActCode())).eq(TpmLiqueurActRegisterEntity::getApproveStatus, (Object)ActApproveStatusEnum.APPROVED.getCode()));
        List cannotClosedList = this.actRegisterMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TpmLiqueurActRegisterEntity::getActCode, (Object)entity.getActCode())).eq(TpmLiqueurActRegisterEntity::getApproveStatus, (Object)ActApproveStatusEnum.APPROVING.getCode()));
        if (CollectionUtils.isNotEmpty((Collection)cannotClosedList)) {
            List exceptionCodes = cannotClosedList.stream().map(TpmLiqueurActRegisterEntity::getActRegisterCode).collect(Collectors.toList());
            throw new BusinessException("\u6d3b\u52a8\u767b\u8bb0\u4fe1\u606fcode\u4e3a" + exceptionCodes.toString() + "\u7684\u6570\u636e\u4e3a\u5ba1\u6279\u4e2d\uff0c\u65e0\u6cd5\u5173\u95ed");
        }
        HashMap noAllAuditAmount = Maps.newHashMap();
        Map<Object, Object> transactionMap = Maps.newHashMap();
        HashMap transactionEntityMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)liqueurActRegisterEntities)) {
            List actRegisterCodes = liqueurActRegisterEntities.stream().map(TpmLiqueurActRegisterEntity::getActRegisterCode).collect(Collectors.toList());
            List detailEntities = this.registerDetailMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(TpmLiqueurActRegisterDetailEntity::getActRegisterCode, actRegisterCodes));
            List finalDetailEntities = detailEntities.stream().filter(o -> StringUtils.equals((CharSequence)o.getIsAllAudit(), (CharSequence)GlobalWhetherEnum.NO.getCode())).collect(Collectors.toList());
            Map finalDetailMap = finalDetailEntities.stream().collect(Collectors.toMap(TpmLiqueurActRegisterDetailEntity::getActDetailCode, Function.identity()));
            HashSet actDetailCodes = Sets.newHashSet();
            finalDetailMap.keySet().forEach(x -> {
                TpmLiqueurActBudgetTransactionEntity transactionEntity = new TpmLiqueurActBudgetTransactionEntity();
                TpmLiqueurActRegisterDetailEntity detailEntity = (TpmLiqueurActRegisterDetailEntity)((Object)((Object)finalDetailMap.get(x)));
                transactionEntity.setBusinessType(LiqueurActBudgetBusinessTypeEnum.CLOSED.getCode());
                transactionEntity.setTransactionType(FeeBudgetDetailTypeEnum.RETURN_BACK.getCode());
                transactionEntity.setTransactionTypeName(FeeBudgetDetailTypeEnum.RETURN_BACK.getDes());
                transactionEntity.setBusinessCode(detailEntity.getActRegisterCode());
                transactionEntity.setBusinessLineCode(detailEntity.getActDetailCode());
                transactionEntity.setBusinessLineName(detailEntity.getActDetailName());
                actDetailCodes.add(x);
                noAllAuditAmount.put(x, detailEntity.getApplyAmount().subtract(detailEntity.getAuditAmount()));
                transactionEntityMap.put(x, transactionEntity);
            });
            if (CollectionUtils.isNotEmpty((Collection)actDetailCodes)) {
                List transactionEntities = this.transactionMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(TpmLiqueurActBudgetTransactionEntity::getBusinessCode, (Collection)actDetailCodes));
                transactionMap = transactionEntities.stream().collect(Collectors.groupingBy(TpmLiqueurActBudgetTransactionEntity::getBusinessLineCode));
            }
        }
        this.actClosedSaveData(entity, actBudgetEntities, noAllAuditAmount, transactionMap, transactionEntityMap);
        entity.setCanUseAmount(BigDecimal.ZERO);
        this.liqueurActMapper.updateById((Object)entity);
    }

    private void actClosedSaveData(TpmLiqueurActEntity entity, List<TpmLiqueurActBudgetEntity> actBudgetEntities, Map<String, BigDecimal> noAllAuditAmount, Map<String, List<TpmLiqueurActBudgetTransactionEntity>> transactionMap, Map<String, TpmLiqueurActBudgetTransactionEntity> transactionEntityMap) {
        if (CollectionUtils.isNotEmpty(actBudgetEntities)) {
            Map actBudgetEntityMap = actBudgetEntities.stream().collect(Collectors.toMap(TpmLiqueurActBudgetEntity::getActBudgetCode, Function.identity()));
            Map<String, List<TpmLiqueurActBudgetTransactionEntity>> finalTransactionMap = transactionMap;
            ArrayList needSaveTransactionList = Lists.newArrayList();
            transactionMap.keySet().forEach(x -> {
                List<TpmLiqueurActBudgetTransactionEntity> entities = ((List)finalTransactionMap.get(x)).stream().sorted(Comparator.comparing(TpmLiqueurActBudgetTransactionEntity::getReduceOrder).reversed()).collect(Collectors.toList());
                AtomicReference bigDecimal = new AtomicReference(noAllAuditAmount.get(x));
                AtomicReference transactionAmount = new AtomicReference(noAllAuditAmount.get(x));
                entities.forEach(o -> {
                    TpmLiqueurActBudgetTransactionEntity transactionEntity = (TpmLiqueurActBudgetTransactionEntity)((Object)((Object)((Object)transactionEntityMap.get(x))));
                    if (transactionEntityMap.containsKey(x)) {
                        transactionEntity.setActBudgetCode(o.getActBudgetCode());
                        transactionEntity.setControlId(o.getControlId());
                        transactionEntity.setFeeBudgetCode(o.getFeeBudgetCode());
                        transactionEntity.setReduceOrder(o.getReduceOrder());
                    }
                    if (actBudgetEntityMap.containsKey(o.getActBudgetCode())) {
                        TpmLiqueurActBudgetEntity budgetEntity = (TpmLiqueurActBudgetEntity)((Object)((Object)((Object)actBudgetEntityMap.get(o.getActBudgetCode()))));
                        if (noAllAuditAmount.containsKey(o.getBusinessLineCode())) {
                            if (((BigDecimal)bigDecimal.get()).add(budgetEntity.getCanUseAmount()).compareTo(budgetEntity.getApplyAmount()) < 1) {
                                budgetEntity.setCanUseAmount(((BigDecimal)bigDecimal.get()).add(budgetEntity.getCanUseAmount()));
                                bigDecimal.set(BigDecimal.ZERO);
                                if (actBudgetEntityMap.containsKey(transactionEntity.getActBudgetCode())) {
                                    if (((BigDecimal)transactionAmount.get()).compareTo(o.getFeeAmount()) < 1) {
                                        transactionEntity.setFeeAmount((BigDecimal)transactionAmount.get());
                                        transactionAmount.set(BigDecimal.ZERO);
                                    } else {
                                        transactionEntity.setFeeAmount(o.getFeeAmount());
                                        transactionAmount.set(((BigDecimal)transactionAmount.get()).subtract(o.getFeeAmount()));
                                    }
                                }
                            } else {
                                bigDecimal.set(((BigDecimal)bigDecimal.get()).add(budgetEntity.getCanUseAmount().subtract(budgetEntity.getApplyAmount())));
                                budgetEntity.setCanUseAmount(budgetEntity.getApplyAmount());
                            }
                        }
                        needSaveTransactionList.add(transactionEntity);
                    }
                });
            });
            HashMap budgetMap = Maps.newHashMap();
            actBudgetEntities.forEach(x -> {
                if (budgetMap.containsKey(x.getControlId())) {
                    ((Map)budgetMap.get(x.getControlId())).put(x.getFeeBudgetCode(), x.getCanUseAmount());
                    x.setCanUseAmount(BigDecimal.ZERO);
                } else {
                    HashMap map2 = Maps.newHashMap();
                    map2.put(x.getFeeBudgetCode(), x.getCanUseAmount());
                    budgetMap.put(x.getControlId(), map2);
                    x.setCanUseAmount(BigDecimal.ZERO);
                }
            });
            List<TpmFeeBudgetControlEntity> controlEntities = this.findControlByIds(budgetMap.keySet());
            List<TpmFeeBudgetEntity> feeBudgetEntities = this.findFeeBudgetByControlIds(budgetMap.keySet());
            ArrayList detailsEntities = Lists.newArrayList();
            feeBudgetEntities.forEach(y -> {
                Map bigDecimalMap = (Map)budgetMap.get(y.getControlId());
                TpmFeeBudgetDetailsEntity detailsEntity = (TpmFeeBudgetDetailsEntity)((Object)((Object)CrmBeanUtil.copy((Object)y, TpmFeeBudgetDetailsEntity.class)));
                super.setPublicParamsNull((CrmBaseEntity)detailsEntity);
                if (bigDecimalMap.containsKey(y.getFeeBudgetCode())) {
                    detailsEntity.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.RETURN_BACK.getCode());
                    detailsEntity.setFeeBudgetDetailTypeName(FeeBudgetDetailTypeEnum.RETURN_BACK.getDes());
                    detailsEntity.setInitAmount(y.getInitAmount());
                    detailsEntity.setFeeAmount((BigDecimal)bigDecimalMap.get(y.getFeeBudgetCode()));
                    detailsEntity.setBeforAmount(y.getCanUseAmount());
                    detailsEntity.setAfterAmount(y.getCanUseAmount().add((BigDecimal)bigDecimalMap.get(y.getFeeBudgetCode())));
                    detailsEntity.setBusinessCode(entity.getActCode());
                    detailsEntity.setBusinessName(entity.getActName());
                    y.setCanUseAmount(y.getCanUseAmount().add((BigDecimal)bigDecimalMap.get(y.getFeeBudgetCode())));
                    y.setUsedAmount(y.getUsedAmount().subtract((BigDecimal)bigDecimalMap.get(y.getFeeBudgetCode())));
                }
                detailsEntities.add(detailsEntity);
            });
            controlEntities.forEach(y -> {
                if (budgetMap.containsKey(y.getId())) {
                    y.setCanUseAmount(y.getCanUseAmount().add((BigDecimal)((Map)budgetMap.get(y.getId())).values().stream().reduce(BigDecimal::add).get()));
                }
            });
            this.feeBudgetControlService.updateBatchById(controlEntities);
            this.feeBudgetService.updateBatchById(feeBudgetEntities);
            this.liqueurActBudgetService.updateBatchById(actBudgetEntities);
            List transactionEntities = needSaveTransactionList.stream().filter(o -> o.getFeeAmount() != null && o.getFeeAmount().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
            this.transactionService.saveBatch(transactionEntities);
            this.detailsService.saveBatch(detailsEntities);
        }
    }

    private TpmLiqueurActEntity checkCanClosedData(TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        AssertUtils.isNotEmpty((String)tpmLiqueurActReqVo.getId(), (CrmExceptionType)CommonException.IDS_NULL);
        TpmLiqueurActEntity entity = (TpmLiqueurActEntity)((Object)this.liqueurActMapper.selectById((Serializable)((Object)tpmLiqueurActReqVo.getId())));
        if (entity == null) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (!entity.getApproveStatus().equals(ActApproveStatusEnum.APPROVED.getCode())) {
            throw new BusinessException("\u53ea\u6709\u6267\u884c\u4e2d\u7684\u6d3b\u52a8\u624d\u80fd \u8fdb\u884c\u5173\u95ed");
        }
        return entity;
    }

    public void saveFeeBudgetDetails(List<TpmFeeBudgetDetailsEntity> feeBudgetDetailEntities, TpmLiqueurActReqVo reqVo) {
        if (!ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())) {
            return;
        }
        this.detailsService.saveOrUpdateBatch(feeBudgetDetailEntities);
    }

    public void saveTransaction(TpmLiqueurActBudgetTransactionEntity transactionEntity, TpmLiqueurActReqVo reqVo) {
        if (!ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())) {
            return;
        }
        this.transactionService.saveOrUpdate((Object)transactionEntity);
    }
}

