/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.actfieldcollect.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.actfieldcollect.mapper.TpmActCollectFieldMapper;
import com.biz.crm.actfieldcollect.model.TpmActCollectFieldEntity;
import com.biz.crm.actfieldcollect.service.ITpmActCollectFieldService;
import com.biz.crm.actfieldcollect.service.impl.ActFieldCollectServiceHelper;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.costtypefine.mapper.TpmActCollectFieldFineMapper;
import com.biz.crm.costtypefine.model.TpmActCollectFieldFineEntity;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.tpm.actfieldcollect.req.TpmActCollectFieldReqVo;
import com.biz.crm.nebular.tpm.actfieldcollect.resp.TpmActCollectFieldRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"TpmActCollectFieldServiceExpandImpl"})
public class TpmActCollectFieldServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmActCollectFieldMapper, TpmActCollectFieldEntity>
implements ITpmActCollectFieldService {
    private static final Logger log = LoggerFactory.getLogger(TpmActCollectFieldServiceImpl.class);
    @Resource
    private TpmActCollectFieldMapper tpmActCollectFieldMapper;
    @Autowired
    private ActFieldCollectServiceHelper actFieldCollectServiceHelper;
    @Resource
    private TpmActCollectFieldFineMapper fieldFineMapper;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;

    @Override
    public PageResult<TpmActCollectFieldRespVo> findList(TpmActCollectFieldReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<TpmActCollectFieldRespVo> list = this.tpmActCollectFieldMapper.findList((Page<TpmActCollectFieldRespVo>)page, reqVo);
        this.actFieldCollectServiceHelper.convertListDate(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TpmActCollectFieldRespVo query(String id) {
        TpmActCollectFieldEntity tpmActCollectFieldEntity = (TpmActCollectFieldEntity)((Object)this.tpmActCollectFieldMapper.selectById((Serializable)((Object)id)));
        if (ObjectUtils.isEmpty((Object)((Object)tpmActCollectFieldEntity))) {
            return new TpmActCollectFieldRespVo();
        }
        TpmActCollectFieldRespVo respVo = (TpmActCollectFieldRespVo)CrmBeanUtil.copy((Object)((Object)tpmActCollectFieldEntity), TpmActCollectFieldRespVo.class);
        ArrayList<TpmActCollectFieldRespVo> list = new ArrayList<TpmActCollectFieldRespVo>(Arrays.asList(respVo));
        respVo = (TpmActCollectFieldRespVo)list.get(0);
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TpmActCollectFieldReqVo reqVo) {
        this.actFieldCollectServiceHelper.saveCheck(reqVo);
        TpmActCollectFieldEntity entity = (TpmActCollectFieldEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmActCollectFieldEntity.class));
        this.save((Object)entity);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        TpmActCollectFieldRespVo newData = (TpmActCollectFieldRespVo)CrmBeanUtil.copy((Object)((Object)entity), TpmActCollectFieldRespVo.class);
        this.crmLogSendUtil.sendForAdd(menuCodeObj.toString(), newData.getId(), newData.getFieldCode(), (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TpmActCollectFieldReqVo reqVo) {
        this.actFieldCollectServiceHelper.saveCheck(reqVo);
        TpmActCollectFieldEntity tpmAuditEntity = (TpmActCollectFieldEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TpmActCollectFieldEntity.class));
        TpmActCollectFieldRespVo oldData = this.query(reqVo.getId());
        tpmAuditEntity.setFieldCode(oldData.getFieldCode());
        this.updateById((Object)tpmAuditEntity);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        TpmActCollectFieldRespVo newData = (TpmActCollectFieldRespVo)CrmBeanUtil.copy((Object)((Object)tpmAuditEntity), TpmActCollectFieldRespVo.class);
        this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), newData.getId(), newData.getFieldCode(), (Object)oldData, (Object)newData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u8bf7\u6307\u5b9a\u8981\u5220\u9664\u7684\u91c7\u96c6\u5b57\u6bb5\u6570\u636e!");
        List tpmActCollectFieldEntities = this.tpmActCollectFieldMapper.selectBatchIds(ids);
        Assert.notEmpty((Collection)tpmActCollectFieldEntities, (String)"\u6d3b\u52a8\u91c7\u96c6\u5b57\u6bb5\u6570\u636e\u4e0d\u5b58\u5728");
        List oldDataList = CrmBeanUtil.copyList((List)tpmActCollectFieldEntities, TpmActCollectFieldRespVo.class);
        Set idConnect = tpmActCollectFieldEntities.stream().map(BaseIdEntity::getId).collect(Collectors.toSet());
        this.tpmActCollectFieldMapper.deleteBatchIds(idConnect);
        this.fieldFineMapper.delete((Wrapper)new LambdaQueryWrapper().in(TpmActCollectFieldFineEntity::getFieldCode, (Collection)tpmActCollectFieldEntities.stream().map(TpmActCollectFieldEntity::getFieldCode).collect(Collectors.toList())));
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        oldDataList.stream().forEach(o -> this.crmLogSendUtil.sendForDel(menuCodeObj.toString(), o.getId(), o.getFieldCode(), o));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        List tpmActCollectFieldEntities = this.tpmActCollectFieldMapper.selectBatchIds(ids);
        List oldDataList = CrmBeanUtil.copyList((List)tpmActCollectFieldEntities, TpmActCollectFieldRespVo.class);
        if (CollectionUtils.isNotEmpty((Collection)tpmActCollectFieldEntities)) {
            tpmActCollectFieldEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(tpmActCollectFieldEntities);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        List newDataList = CrmBeanUtil.copyList((List)tpmActCollectFieldEntities, TpmActCollectFieldRespVo.class);
        for (int i = 0; i < newDataList.size(); ++i) {
            this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), ((TpmActCollectFieldRespVo)newDataList.get(i)).getId(), ((TpmActCollectFieldRespVo)newDataList.get(i)).getFieldCode(), oldDataList.get(i), newDataList.get(i));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        List tpmActCollectFieldEntities = this.tpmActCollectFieldMapper.selectBatchIds(ids);
        List oldDataList = CrmBeanUtil.copyList((List)tpmActCollectFieldEntities, TpmActCollectFieldRespVo.class);
        if (CollectionUtils.isNotEmpty((Collection)tpmActCollectFieldEntities)) {
            tpmActCollectFieldEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(tpmActCollectFieldEntities);
        List newDataList = CrmBeanUtil.copyList((List)tpmActCollectFieldEntities, TpmActCollectFieldRespVo.class);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        for (int i = 0; i < newDataList.size(); ++i) {
            this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), ((TpmActCollectFieldRespVo)newDataList.get(i)).getId(), ((TpmActCollectFieldRespVo)newDataList.get(i)).getFieldCode(), oldDataList.get(i), newDataList.get(i));
        }
    }
}

