/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.liqueuraccount.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.account.mapper.TpmAccountDetailMapper;
import com.biz.crm.account.mapper.TpmAccountInvoiceMapper;
import com.biz.crm.account.mapper.TpmAccountProductMapper;
import com.biz.crm.account.model.TpmAccountInvoiceEntity;
import com.biz.crm.account.model.TpmAccountProductEntity;
import com.biz.crm.account.service.ITpmAccountInvoiceService;
import com.biz.crm.account.service.ITpmAccountProductService;
import com.biz.crm.annotation.Klock;
import com.biz.crm.audit.service.ITpmAuditService;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.costtypefine.mapper.TpmCostTypeFineMapper;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.AccountStatusEnum;
import com.biz.crm.liqueraudit.mapper.TpmLiqueurAuditDetailsMapper;
import com.biz.crm.liqueraudit.model.TpmLiqueurAuditDetailsEntity;
import com.biz.crm.liqueraudit.service.ITpmLiqueurAuditDetailsService;
import com.biz.crm.liqueuraccount.mapper.TpmLiqueurAccountDetailMapper;
import com.biz.crm.liqueuraccount.model.TpmLiqueurAccountDetailEntity;
import com.biz.crm.liqueuraccount.service.ITpmLiqueurAccountDetailService;
import com.biz.crm.liqueuraccount.service.impl.LiqueurAccountServiceHelper;
import com.biz.crm.nebular.tpm.account.req.TpmAccountInvoiceReqVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountProductReqVo;
import com.biz.crm.nebular.tpm.liqueuraccount.req.TpmLiqueurAccountDetailMainReqVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.UUIDGenerator;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TpmLiqueurAccountDetailServiceImpl"})
public class TpmLiqueurAccountDetailServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TpmLiqueurAccountDetailMapper, TpmLiqueurAccountDetailEntity>
implements ITpmLiqueurAccountDetailService {
    private static final Logger log = LoggerFactory.getLogger(TpmLiqueurAccountDetailServiceImpl.class);
    @Resource
    private TpmAccountDetailMapper tpmAccountDetailMapper;
    @Autowired
    private LiqueurAccountServiceHelper liqueurAccountServiceHelper;
    @Resource
    private TpmAccountProductMapper tpmAccountProductMapper;
    @Resource
    private TpmAccountInvoiceMapper tpmAccountInvoiceMapper;
    @Resource
    private TpmCostTypeFineMapper tpmCostTypeFineMapper;
    @Autowired
    private ITpmAuditService iTpmAuditService;
    @Autowired
    private ITpmAccountProductService accountProductService;
    @Autowired
    private ITpmAccountInvoiceService accountInvoiceService;
    @Resource
    private TpmLiqueurAuditDetailsMapper auditDetailMapper;
    @Autowired
    private ITpmLiqueurAuditDetailsService auditDetailService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock(keys={"accountDetail", "#accountDetailMainReqVo.lockUserName"}, waitTime=0L, leaseTime=5L)
    public void save(TpmLiqueurAccountDetailMainReqVo accountDetailMainReqVo) {
        this.liqueurAccountServiceHelper.saveCheck(accountDetailMainReqVo);
        List accountDetailReqVos = accountDetailMainReqVo.getAccountDetailReqVos();
        String groupId = UUIDGenerator.generate();
        accountDetailReqVos.forEach(tpmAccountDetailReqVo -> {
            List tpmProductInfoReqVos = tpmAccountDetailReqVo.getTpmProductInfoReqVos();
            if (CollectionUtils.isNotEmpty((Collection)tpmProductInfoReqVos)) {
                String productNames = tpmProductInfoReqVos.stream().map(TpmAccountProductReqVo::getProductName).collect(Collectors.joining(","));
                tpmAccountDetailReqVo.setProductNames(productNames);
            }
            tpmAccountDetailReqVo.setGroupId(groupId);
        });
        List accountInvoiceReqVos = accountDetailMainReqVo.getAccountInvoiceReqVos();
        List accountDetailEntities = CrmBeanUtil.copyList((List)accountDetailReqVos, TpmLiqueurAccountDetailEntity.class);
        this.saveProductInfo(accountDetailMainReqVo.getNeedSaveProductList(), groupId);
        this.saveInvoice(accountInvoiceReqVos, groupId);
        this.updateAuditDetails(accountDetailMainReqVo.getSaveType(), accountDetailEntities);
    }

    public void updateAuditDetails(String saveType, List<TpmLiqueurAccountDetailEntity> accountDetailEntities) {
        if (StringUtils.equals((CharSequence)AccountStatusEnum.SUBMIT.getCode(), (CharSequence)saveType)) {
            HashMap map = Maps.newHashMap();
            ArrayList auditDetailCodes = Lists.newArrayList();
            accountDetailEntities.stream().forEach(o -> {
                map.put(o.getAuditDetailCode(), o);
                auditDetailCodes.add(o.getAuditDetailCode());
            });
            List tpmAuditDetailEntities = this.auditDetailMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmLiqueurAuditDetailsEntity.class).in(TpmLiqueurAuditDetailsEntity::getAuditDetailCode, (Collection)auditDetailCodes));
            tpmAuditDetailEntities.forEach(o -> {
                TpmLiqueurAccountDetailEntity tpmAccountDetailEntity = (TpmLiqueurAccountDetailEntity)((Object)((Object)map.get(o.getAuditDetailCode())));
                BigDecimal add = tpmAccountDetailEntity.getAccountAmount().add(Optional.ofNullable(o.getFeeUsed()).orElse(BigDecimal.ZERO));
                if (o.getAmount().compareTo(add) == 1) {
                    o.setIsAllFeeUsed(GlobalWhetherEnum.NO.getCode());
                } else {
                    o.setIsAllFeeUsed(GlobalWhetherEnum.YES.getCode());
                }
                o.setFeeUsed(add);
            });
            this.auditDetailService.updateBatchById(tpmAuditDetailEntities);
        }
    }

    private void saveProductInfo(List<TpmAccountProductReqVo> needSaveProductList, String groupId) {
        if (CollectionUtils.isNotEmpty(needSaveProductList)) {
            List ids = needSaveProductList.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getId())).map(UuidVo::getId).collect(Collectors.toList());
            this.tpmAccountProductMapper.delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TpmAccountProductEntity.class).eq(TpmAccountProductEntity::getGroupId, (Object)groupId)).notIn(CollectionUtils.isNotEmpty(ids), BaseIdEntity::getId, ids));
            List productEntities = needSaveProductList.stream().map(o -> {
                TpmAccountProductEntity productEntity = (TpmAccountProductEntity)((Object)((Object)CrmBeanUtil.copy((Object)o, TpmAccountProductEntity.class)));
                productEntity.setGroupId(groupId);
                return productEntity;
            }).collect(Collectors.toList());
            this.accountProductService.saveOrUpdateBatch(productEntities);
        } else {
            this.tpmAccountProductMapper.delete((Wrapper)Wrappers.lambdaQuery(TpmAccountProductEntity.class).eq(TpmAccountProductEntity::getGroupId, (Object)groupId));
        }
    }

    private void saveInvoice(List<TpmAccountInvoiceReqVo> accountInvoiceReqVos, String groupId) {
        if (CollectionUtils.isNotEmpty(accountInvoiceReqVos)) {
            List ids = accountInvoiceReqVos.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getId())).map(UuidVo::getId).collect(Collectors.toList());
            this.tpmAccountInvoiceMapper.delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TpmAccountInvoiceEntity.class).eq(TpmAccountInvoiceEntity::getGroupId, (Object)groupId)).notIn(CollectionUtils.isNotEmpty(ids), BaseIdEntity::getId, ids));
            List entities = accountInvoiceReqVos.stream().map(o -> {
                TpmAccountInvoiceEntity entity = (TpmAccountInvoiceEntity)((Object)((Object)CrmBeanUtil.copy((Object)o, TpmAccountInvoiceEntity.class)));
                entity.setGroupId(groupId);
                return entity;
            }).collect(Collectors.toList());
            this.accountInvoiceService.saveOrUpdateBatch(entities);
        } else {
            this.tpmAccountInvoiceMapper.delete((Wrapper)Wrappers.lambdaQuery(TpmAccountInvoiceEntity.class).eq(TpmAccountInvoiceEntity::getGroupId, (Object)groupId));
        }
    }
}

