/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.account.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.account.mapper.TpmAccountDetailMapper;
import com.biz.crm.account.model.TpmAccountDetailEntity;
import com.biz.crm.account.model.TpmAccountInvoiceEntity;
import com.biz.crm.audit.mapper.TpmAuditDetailMapper;
import com.biz.crm.audit.mapper.TpmAuditMapper;
import com.biz.crm.audit.model.TpmAuditDetailEntity;
import com.biz.crm.audit.model.TpmAuditEntity;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.AccountStatusEnum;
import com.biz.crm.eunm.tpm.ActAdvancePayApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActPayTypeEnum;
import com.biz.crm.eunm.tpm.ActPayTypeTypeEnum;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.AccountException;
import com.biz.crm.exception.tpm.AuditException;
import com.biz.crm.liqueraudit.mapper.TpmLiqueurAuditAttachMapper;
import com.biz.crm.liqueraudit.mapper.TpmLiqueurAuditDetailsMapper;
import com.biz.crm.liqueraudit.mapper.TpmLiqueurAuditMapper;
import com.biz.crm.liqueraudit.model.TpmLiqueurAuditAttachEntity;
import com.biz.crm.liqueraudit.model.TpmLiqueurAuditEntity;
import com.biz.crm.nebular.tpm.account.req.TpmAccountDetailMainReqVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountDetailReqVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountInvoiceReqVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountUpdatePayTypeReqVo;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountDetailRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.DictUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AccountServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(AccountServiceHelper.class);
    @Resource
    private TpmAuditDetailMapper tpmAuditDetailMapper;
    @Resource
    private TpmAuditMapper tpmAuditMapper;
    @Resource
    private TpmAccountDetailMapper tpmAccountDetailMapper;
    @Resource
    private TpmLiqueurAuditMapper tpmLiqueurAuditMapper;
    @Resource
    private TpmLiqueurAuditDetailsMapper tpmLiqueurAuditDetailsMapper;
    @Resource
    private TpmLiqueurAuditAttachMapper tpmLiqueurAuditAttachMapper;

    public Map<String, Map<String, String>> getDicts() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("account_status");
        dictCodes.add("pay_type_type");
        return DictUtil.getDictValueMapsByCodes((List)dictCodes);
    }

    public void convertListDate(List<TpmAccountDetailRespVo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Map<String, Map<String, String>> map = this.getDicts();
            list.forEach(o -> {
                if (StringUtils.isNotEmpty((CharSequence)o.getApproveStatus())) {
                    o.setApproveStatusName((String)((Map)Optional.ofNullable(map.get("account_status")).orElse(Maps.newHashMap())).get(o.getApproveStatus()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getPayTypeType())) {
                    o.setPayTypeTypeName((String)((Map)Optional.ofNullable(map.get("pay_type_type")).orElse(Maps.newHashMap())).get(o.getPayTypeType()));
                }
            });
        }
    }

    public void saveCheck(TpmAccountDetailMainReqVo accountDetailMainReqVo) {
        AssertUtils.isNotEmpty((String)accountDetailMainReqVo.getSaveType(), (String)"\u4fdd\u5b58\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkAuditInfo(accountDetailMainReqVo);
        this.checkProductInfo(accountDetailMainReqVo);
        this.checkInvoice(accountDetailMainReqVo);
    }

    private void checkAuditInfo(TpmAccountDetailMainReqVo accountDetailMainReqVo) {
        List accountDetailReqVos = accountDetailMainReqVo.getAccountDetailReqVos();
        AssertUtils.isNotEmpty((Collection)accountDetailReqVos, (String)"\u4e0a\u8d26\u660e\u7ec6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isNotEmpty((CharSequence)((TpmAccountDetailReqVo)accountDetailReqVos.get(0)).getAttachCode())) {
            this.liqueurCheckAuditInfo(accountDetailMainReqVo);
        } else {
            HashSet payTypeTypes = Sets.newHashSet();
            HashSet auditCodes = Sets.newHashSet();
            HashSet auditDetailCodes = Sets.newHashSet();
            HashSet accountCodes = Sets.newHashSet();
            if (StringUtils.isNotEmpty((CharSequence)accountDetailMainReqVo.getGroupId())) {
                List accountDetailEntities = this.tpmAccountDetailMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmAccountDetailEntity.class).eq(TpmAccountDetailEntity::getGroupId, (Object)accountDetailMainReqVo.getGroupId()));
                AssertUtils.isNotEmpty((Collection)accountDetailEntities, (String)"\u60a8\u7f16\u8f91\u7684\u6570\u636e\u5df2\u88ab\u5220\u9664");
                AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)AccountStatusEnum.TEMP.getCode(), (CharSequence)((TpmAccountDetailEntity)((Object)accountDetailEntities.get(0))).getApproveStatus()), (String)"\u5f53\u524d\u6570\u636e\u4e0d\u5141\u8bb8\u7f16\u8f91");
            }
            String approveStatus = "";
            if (StringUtils.equals((CharSequence)AccountStatusEnum.TEMP.getCode(), (CharSequence)accountDetailMainReqVo.getSaveType())) {
                approveStatus = AccountStatusEnum.TEMP.getCode();
            }
            if (StringUtils.equals((CharSequence)AccountStatusEnum.SUBMIT.getCode(), (CharSequence)accountDetailMainReqVo.getSaveType())) {
                approveStatus = AccountStatusEnum.SUBMIT.getCode();
            }
            for (TpmAccountDetailReqVo vo : accountDetailReqVos) {
                AssertUtils.isNotEmpty((String)vo.getPayTypeType(), (String)"\u652f\u4ed8\u65b9\u5f0f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                payTypeTypes.add(vo.getPayTypeType());
                AssertUtils.isTrue((!auditDetailCodes.contains(vo.getAuditDetailCode()) ? 1 : 0) != 0, (String)"\u8bf7\u52ff\u9009\u62e9\u91cd\u590d\u7684\u6838\u9500\u660e\u7ec6\u6570\u636e");
                auditDetailCodes.add(vo.getAuditDetailCode());
                auditCodes.add(vo.getAuditCode());
                accountCodes.add(vo.getAccountCode());
                vo.setApproveStatus(approveStatus);
            }
            AssertUtils.isTrue((accountDetailReqVos.size() == accountCodes.size() ? 1 : 0) != 0, (String)"\u8d39\u7528\u4e0a\u8d26\u7f16\u7801\u91cd\u590d");
            AssertUtils.isTrue((payTypeTypes.size() == 1 ? 1 : 0) != 0, (String)"\u53ea\u80fd\u9009\u62e9\u540c\u4e00\u652f\u4ed8\u65b9\u5f0f\u7c7b\u578b\u7684\u6838\u9500\u660e\u7ec6");
            List tpmAuditEntities = this.tpmAuditMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmAuditEntity.class).in(TpmAuditEntity::getAuditCode, (Collection)auditCodes));
            AssertUtils.isTrue((auditCodes.size() == CollectionUtils.size((Object)tpmAuditEntities) ? 1 : 0) != 0, (String)"\u6838\u9500\u4e3b\u8868\u6570\u636e\u5f02\u5e38");
            Map auditEntityMap = tpmAuditEntities.stream().collect(Collectors.toMap(TpmAuditEntity::getAuditCode, Function.identity()));
            List tpmAuditDetailEntities = this.tpmAuditDetailMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmAuditDetailEntity.class).in(TpmAuditDetailEntity::getAuditDetailCode, (Collection)auditDetailCodes));
            AssertUtils.isTrue((auditDetailCodes.size() == CollectionUtils.size((Object)tpmAuditDetailEntities) ? 1 : 0) != 0, (String)"\u6838\u9500\u660e\u7ec6\u6570\u636e\u5f02\u5e38");
            Map auditDetailEntityMap = tpmAuditDetailEntities.stream().collect(Collectors.toMap(TpmAuditDetailEntity::getAuditDetailCode, Function.identity()));
            accountDetailReqVos.forEach(tpmAccountDetailReqVo -> {
                TpmAuditEntity tpmAuditEntity = (TpmAuditEntity)((Object)((Object)auditEntityMap.get(tpmAccountDetailReqVo.getAuditCode())));
                AssertUtils.isNotNull((Object)((Object)tpmAuditEntity), (CrmExceptionType)AuditException.DATA_NOT_EXIST, (String[])new String[0]);
                AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)ActAdvancePayApproveStatusEnum.APPROVED.getCode(), (CharSequence)tpmAuditEntity.getApproveStatus()), (String)"\u5ba1\u6279\u901a\u8fc7\u6838\u9500\u624d\u80fd\u4e0a\u8d26");
                TpmAuditDetailEntity auditDetailEntity = (TpmAuditDetailEntity)((Object)((Object)auditDetailEntityMap.get(tpmAccountDetailReqVo.getAuditDetailCode())));
                AssertUtils.isNotNull((Object)((Object)auditDetailEntity), (CrmExceptionType)AuditException.DATA_NOT_EXIST, (String[])new String[0]);
                AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)GlobalWhetherEnum.NO.getCode(), (CharSequence)auditDetailEntity.getIsAllFeeUsed()), (String)"\u5b8c\u5168\u4e0a\u8d26\u7684\u6838\u9500\u4e0d\u80fd\u4e0a\u8d26");
                AssertUtils.isNotNull((Object)tpmAccountDetailReqVo.getAccountAmount(), (String)"\u672c\u6b21\u4e0a\u8d26\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isTrue((tpmAccountDetailReqVo.getAccountAmount().compareTo(auditDetailEntity.getAuditApplyAmount().subtract(Optional.ofNullable(auditDetailEntity.getFeeUsed()).orElse(BigDecimal.ZERO))) < 1 ? 1 : 0) != 0, (String)"\u672c\u6b21\u4e0a\u8d26\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u53ef\u4e0a\u8d26\u91d1\u989d");
                tpmAccountDetailReqVo.setCurrentAllowAmount(auditDetailEntity.getAuditApplyAmount().subtract(Optional.ofNullable(auditDetailEntity.getFeeUsed()).orElse(BigDecimal.ZERO)));
            });
        }
    }

    private void liqueurCheckAuditInfo(TpmAccountDetailMainReqVo accountDetailMainReqVo) {
        List accountDetailReqVos = accountDetailMainReqVo.getAccountDetailReqVos();
        AssertUtils.isNotEmpty((Collection)accountDetailReqVos, (String)"\u4e0a\u8d26\u660e\u7ec6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        HashSet payTypeTypes = Sets.newHashSet();
        HashSet auditCodes = Sets.newHashSet();
        HashSet accountCodes = Sets.newHashSet();
        HashSet attachCodes = Sets.newHashSet();
        if (StringUtils.isNotEmpty((CharSequence)accountDetailMainReqVo.getGroupId())) {
            List accountDetailEntities = this.tpmAccountDetailMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmAccountDetailEntity.class).eq(TpmAccountDetailEntity::getGroupId, (Object)accountDetailMainReqVo.getGroupId()));
            AssertUtils.isNotEmpty((Collection)accountDetailEntities, (String)"\u60a8\u7f16\u8f91\u7684\u6570\u636e\u5df2\u88ab\u5220\u9664");
            AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)AccountStatusEnum.TEMP.getCode(), (CharSequence)((TpmAccountDetailEntity)((Object)accountDetailEntities.get(0))).getApproveStatus()), (String)"\u5f53\u524d\u6570\u636e\u4e0d\u5141\u8bb8\u7f16\u8f91");
        }
        String approveStatus = "";
        if (StringUtils.equals((CharSequence)AccountStatusEnum.TEMP.getCode(), (CharSequence)accountDetailMainReqVo.getSaveType())) {
            approveStatus = AccountStatusEnum.TEMP.getCode();
        }
        if (StringUtils.equals((CharSequence)AccountStatusEnum.SUBMIT.getCode(), (CharSequence)accountDetailMainReqVo.getSaveType())) {
            approveStatus = AccountStatusEnum.SUBMIT.getCode();
        }
        for (TpmAccountDetailReqVo vo : accountDetailReqVos) {
            AssertUtils.isNotEmpty((String)vo.getPayTypeType(), (String)"\u652f\u4ed8\u65b9\u5f0f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            payTypeTypes.add(vo.getPayTypeType());
            AssertUtils.isTrue((!attachCodes.contains(vo.getAttachCode()) ? 1 : 0) != 0, (String)"\u8bf7\u52ff\u9009\u62e9\u91cd\u590d\u7684\u6838\u9500\u9644\u52a0\u4fe1\u606f\u6570\u636e");
            attachCodes.add(vo.getAttachCode());
            auditCodes.add(vo.getAuditCode());
            accountCodes.add(vo.getAccountCode());
            vo.setApproveStatus(approveStatus);
        }
        AssertUtils.isTrue((accountDetailReqVos.size() == accountCodes.size() ? 1 : 0) != 0, (String)"\u8d39\u7528\u4e0a\u8d26\u7f16\u7801\u91cd\u590d");
        AssertUtils.isTrue((payTypeTypes.size() == 1 ? 1 : 0) != 0, (String)"\u53ea\u80fd\u9009\u62e9\u540c\u4e00\u652f\u4ed8\u65b9\u5f0f\u7c7b\u578b\u7684\u6838\u9500\u660e\u7ec6");
        List tpmLiqueurAuditEntities = this.tpmLiqueurAuditMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmLiqueurAuditEntity.class).in(TpmLiqueurAuditEntity::getAuditCode, (Collection)auditCodes));
        AssertUtils.isTrue((auditCodes.size() == CollectionUtils.size((Object)tpmLiqueurAuditEntities) ? 1 : 0) != 0, (String)"\u6838\u9500\u4e3b\u8868\u6570\u636e\u5f02\u5e38");
        Map auditEntityMap = tpmLiqueurAuditEntities.stream().collect(Collectors.toMap(TpmLiqueurAuditEntity::getAuditCode, Function.identity()));
        List tpmLiqueurAuditAttachEntities = this.tpmLiqueurAuditAttachMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmLiqueurAuditAttachEntity.class).in(TpmLiqueurAuditAttachEntity::getAttachCode, (Collection)attachCodes));
        AssertUtils.isTrue((attachCodes.size() == CollectionUtils.size((Object)tpmLiqueurAuditAttachEntities) ? 1 : 0) != 0, (String)"\u6838\u9500\u9644\u52a0\u4fe1\u606f\u6570\u636e\u5f02\u5e38");
        Map auditAttachMap = tpmLiqueurAuditAttachEntities.stream().collect(Collectors.toMap(TpmLiqueurAuditAttachEntity::getAttachCode, Function.identity()));
        accountDetailReqVos.forEach(tpmAccountDetailReqVo -> {
            TpmLiqueurAuditEntity tpmLiqueurAuditEntity = (TpmLiqueurAuditEntity)((Object)((Object)auditEntityMap.get(tpmAccountDetailReqVo.getAuditCode())));
            AssertUtils.isNotNull((Object)((Object)tpmLiqueurAuditEntity), (CrmExceptionType)AuditException.DATA_NOT_EXIST, (String[])new String[0]);
            AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)ActAdvancePayApproveStatusEnum.APPROVED.getCode(), (CharSequence)tpmLiqueurAuditEntity.getApproveStatus()), (String)"\u5ba1\u6279\u901a\u8fc7\u6838\u9500\u624d\u80fd\u4e0a\u8d26");
            TpmLiqueurAuditAttachEntity auditAttachEntity = (TpmLiqueurAuditAttachEntity)((Object)((Object)auditAttachMap.get(tpmAccountDetailReqVo.getAttachCode())));
            AssertUtils.isNotNull((Object)((Object)auditAttachEntity), (CrmExceptionType)AuditException.DATA_NOT_EXIST, (String[])new String[0]);
            AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)GlobalWhetherEnum.NO.getCode(), (CharSequence)auditAttachEntity.getIsAllFeeUsed()), (String)"\u5b8c\u5168\u4e0a\u8d26\u7684\u6838\u9500\u4e0d\u80fd\u4e0a\u8d26");
            AssertUtils.isNotNull((Object)tpmAccountDetailReqVo.getAccountAmount(), (String)"\u672c\u6b21\u4e0a\u8d26\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isTrue((tpmAccountDetailReqVo.getAccountAmount().compareTo(auditAttachEntity.getAmount().subtract(Optional.ofNullable(auditAttachEntity.getFeeUsed()).orElse(BigDecimal.ZERO))) < 1 ? 1 : 0) != 0, (String)"\u672c\u6b21\u4e0a\u8d26\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u53ef\u4e0a\u8d26\u91d1\u989d");
            tpmAccountDetailReqVo.setCurrentAllowAmount(auditAttachEntity.getAmount().subtract(Optional.ofNullable(auditAttachEntity.getFeeUsed()).orElse(BigDecimal.ZERO)));
        });
    }

    private void checkProductInfo(TpmAccountDetailMainReqVo accountDetailMainReqVo) {
        ArrayList needSaveProductList = Lists.newArrayList();
        accountDetailMainReqVo.getAccountDetailReqVos().forEach(tpmAccountDetailReqVo -> {
            if (StringUtils.equals((CharSequence)ActPayTypeTypeEnum.DEFAULT_FEE_POOL.getCode(), (CharSequence)tpmAccountDetailReqVo.getPayTypeType())) {
                List productInfoReqVos = tpmAccountDetailReqVo.getTpmProductInfoReqVos();
                if (CollectionUtils.isNotEmpty((Collection)productInfoReqVos)) {
                    AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)ActPayTypeEnum.REPLENISHMENT.getCode(), (CharSequence)tpmAccountDetailReqVo.getPayType()), (String)("\u5f53\u524d\u4e0a\u8d26\u660e\u7ec6:" + tpmAccountDetailReqVo.getAccountCode() + "\u7684\u652f\u4ed8\u65b9\u5f0f\u7c7b\u578b\u548c\u652f\u4ed8\u65b9\u5f0f\u4e0d\u5141\u8bb8\u9009\u62e9\u8d27\u8865\u4ea7\u54c1"));
                    HashSet collect = Sets.newHashSet();
                    HashSet productLevelCodes = Sets.newHashSet();
                    productInfoReqVos.forEach(o -> {
                        AssertUtils.isNotEmpty((String)o.getProductCode(), (String)("\u4e0a\u8d26\u660e\u7ec6\u7f16\u7801:" + tpmAccountDetailReqVo.getAccountCode() + "\u8d27\u8865\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                        AssertUtils.isNotEmpty((String)o.getProductCode(), (String)("\u4e0a\u8d26\u660e\u7ec6\u7f16\u7801:" + tpmAccountDetailReqVo.getAccountCode() + "\u8d27\u8865\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
                        AssertUtils.isNotEmpty((String)o.getProductLevelCode(), (String)("\u4e0a\u8d26\u660e\u7ec6\u7f16\u7801:" + tpmAccountDetailReqVo.getAccountCode() + "\u8d27\u8865\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                        productLevelCodes.add(o.getProductLevelCode());
                        o.setAccountCode(tpmAccountDetailReqVo.getAccountCode());
                        AssertUtils.isTrue((!collect.contains(o.getProductCode()) ? 1 : 0) != 0, (String)("\u4e0a\u8d26\u660e\u7ec6\u7f16\u7801:" + tpmAccountDetailReqVo.getAccountCode() + "\u8d27\u8865\u4ea7\u54c1\u91cd\u590d"));
                        collect.add(o.getProductCode());
                    });
                    if (StringUtils.isNotEmpty((CharSequence)tpmAccountDetailReqVo.getProductLevelCode())) {
                        AssertUtils.isTrue((productLevelCodes.size() == 1 ? 1 : 0) != 0, (String)("\u4e0a\u8d26\u660e\u7ec6\u7f16\u7801:" + tpmAccountDetailReqVo.getAccountCode() + "\u8d27\u8865\u4ea7\u54c1\u4e0d\u5b8c\u5168\u5c5e\u4e8e\u9009\u5b9a\u7684\u4ea7\u54c1\u5c42\u7ea7"));
                        AssertUtils.isTrue((boolean)productLevelCodes.contains(tpmAccountDetailReqVo.getProductLevelCode()), (String)("\u4e0a\u8d26\u660e\u7ec6\u7f16\u7801:" + tpmAccountDetailReqVo.getAccountCode() + "\u8d27\u8865\u4ea7\u54c1\u4e0d\u5c5e\u4e8e\u9009\u5b9a\u7684\u4ea7\u54c1\u5c42\u7ea7"));
                    }
                    needSaveProductList.addAll(productInfoReqVos);
                }
            } else if (StringUtils.isNotEmpty((CharSequence)tpmAccountDetailReqVo.getProductLevelCode())) {
                throw new BusinessException("\u4e0a\u8d26\u660e\u7ec6\u7f16\u7801:" + tpmAccountDetailReqVo.getAccountCode() + "\u4e0d\u80fd\u9009\u62e9\u8d27\u8865\u4ea7\u54c1\u5c42\u7ea7");
            }
        });
        accountDetailMainReqVo.setNeedSaveProductList((List)needSaveProductList);
    }

    private void checkInvoice(TpmAccountDetailMainReqVo accountDetailMainReqVo) {
        List accountDetailReqVos = accountDetailMainReqVo.getAccountDetailReqVos();
        List accountInvoiceReqVos = accountDetailMainReqVo.getAccountInvoiceReqVos();
        TpmAccountDetailReqVo detailReqVo = (TpmAccountDetailReqVo)accountDetailReqVos.get(0);
        if (StringUtils.equals((CharSequence)ActPayTypeTypeEnum.NEED_INVOICE.getCode(), (CharSequence)detailReqVo.getPayTypeType()) && CollectionUtils.isNotEmpty((Collection)accountInvoiceReqVos)) {
            Map detailMap = accountDetailReqVos.stream().collect(Collectors.toMap(TpmAccountDetailReqVo::getAccountCode, Function.identity()));
            for (TpmAccountInvoiceReqVo invoiceReqVo : accountInvoiceReqVos) {
                AssertUtils.isNotEmpty((String)invoiceReqVo.getInvoiceCode(), (String)"\u53d1\u7968\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isNotNull((Object)invoiceReqVo.getInvoiceAmount(), (String)"\u53d1\u7968\u91d1\u989d(\u4e0d\u542b\u7a0e)\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isNotEmpty((Collection)invoiceReqVo.getAccountCodeList(), (String)"\u53d1\u7968\u5bf9\u5e94\u7684\u4e0a\u8d26\u5355\u53f7\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
                HashSet accountCodes = Sets.newHashSet((Iterable)invoiceReqVo.getAccountCodeList());
                AssertUtils.isTrue((accountCodes.size() == invoiceReqVo.getAccountCodeList().size() ? 1 : 0) != 0, (String)"\u53d1\u7968\u5173\u8054\u7684\u4e0a\u8d26\u5355\u91cd\u590d");
                HashSet customerCodes = Sets.newHashSet();
                accountCodes.forEach(o -> {
                    TpmAccountDetailReqVo tpmAccountDetailReqVo = (TpmAccountDetailReqVo)detailMap.get(o);
                    AssertUtils.isNotNull((Object)tpmAccountDetailReqVo, (String)"\u53d1\u7968\u5173\u8054\u7684\u4e0a\u8d26\u5355\u4e0d\u5b58\u5728");
                    customerCodes.add(Optional.ofNullable(tpmAccountDetailReqVo.getCustomerCode()).orElse(""));
                });
                AssertUtils.isTrue((CollectionUtils.size((Object)customerCodes) == 1 ? 1 : 0) != 0, (String)"\u540c\u4e00\u5f20\u53d1\u7968\u5173\u8054\u7684\u4e0a\u8d26\u5355\u7684\u5ba2\u6237\u5fc5\u987b\u4e00\u81f4");
                invoiceReqVo.setAccountCodes(JSON.toJSONString((Object)accountCodes));
            }
        } else {
            AssertUtils.isTrue((boolean)CollectionUtils.isEmpty((Collection)accountInvoiceReqVos), (String)"\u5f53\u524d\u4e0a\u8d26\u5355\u4e0d\u5141\u8bb8\u586b\u5199\u53d1\u7968\u6570\u636e");
        }
    }

    private void checkDataExist(TpmAccountDetailMainReqVo accountDetailMainReqVo) {
        List accountDetailReqVos = accountDetailMainReqVo.getAccountDetailReqVos();
        for (TpmAccountDetailReqVo accountDetailReqVo : accountDetailReqVos) {
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmAccountDetailEntity::getAuditCode, (Object)accountDetailReqVo.getAccountCode());
            if (StringUtils.isNotEmpty((CharSequence)accountDetailReqVo.getId())) {
                wrapper.ne(BaseIdEntity::getId, (Object)accountDetailReqVo.getId());
            }
            TpmAccountDetailEntity entity = (TpmAccountDetailEntity)((Object)this.tpmAccountDetailMapper.selectOne((Wrapper)wrapper));
            AssertUtils.isTrue((boolean)Objects.isNull((Object)entity), (CrmExceptionType)AccountException.DATA_CODE_DUPLICATE, (String[])new String[0]);
        }
    }

    public void batchUpdatePayTypeCheck(TpmAccountUpdatePayTypeReqVo accountDetailMainReqVo) {
        AssertUtils.isNotEmpty((Collection)accountDetailMainReqVo.getIds(), (String)"\u7f16\u7801\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)accountDetailMainReqVo.getPayType(), (String)"\u652f\u4ed8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public Boolean judgeInvoiceContain(TpmAccountInvoiceEntity entity, List<String> AccountCodes) {
        return Boolean.FALSE;
    }
}

