/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.income.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.income.service.ITpmIncomeBudgetService;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductQueryRespVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelSelectReqVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelSelectRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.tpm.income.req.TpmIncomeBudgetReqVo;
import com.biz.crm.nebular.tpm.income.resp.TpmIncomeBudgetRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tpmincomebudget"})
@Api(tags={"\u6536\u5165\u9884\u7b97;"})
public class TpmIncomeBudgetController {
    private static final Logger log = LoggerFactory.getLogger(TpmIncomeBudgetController.class);
    @Autowired
    private ITpmIncomeBudgetService tpmIncomeBudgetService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<TpmIncomeBudgetRespVo>> list(@RequestBody TpmIncomeBudgetReqVo tpmIncomeBudgetReqVo) {
        PageResult<TpmIncomeBudgetRespVo> result = this.tpmIncomeBudgetService.findList(tpmIncomeBudgetReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @PostMapping(value={"/query"})
    @CrmLog
    public Result<TpmIncomeBudgetRespVo> query(@RequestBody String id) {
        TpmIncomeBudgetRespVo respVo = this.tpmIncomeBudgetService.query(id);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody TpmIncomeBudgetReqVo tpmIncomeBudgetReqVo) {
        this.tpmIncomeBudgetService.save(tpmIncomeBudgetReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody TpmIncomeBudgetReqVo tpmIncomeBudgetReqVo) {
        this.tpmIncomeBudgetService.update(tpmIncomeBudgetReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/batchDelete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.tpmIncomeBudgetService.batchDelete(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        this.tpmIncomeBudgetService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        this.tpmIncomeBudgetService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u767b\u9646\u4eba\u7ec4\u7ec7\u4ee5\u53ca\u4e0b\u7ea7\u7ec4\u7ec7")
    @PostMapping(value={"/findAllOrgCodes"})
    @CrmLog
    public Result<List<MdmOrgRespVo>> findAllOrgCodes(@RequestBody MdmOrgReqVo mdmOrgReqVo) {
        List<MdmOrgRespVo> orgCodesList = this.tpmIncomeBudgetService.findAllOrgCodes(mdmOrgReqVo);
        return Result.ok(orgCodesList);
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u67e5\u8be2\u5ba2\u6237")
    @PostMapping(value={"/findCustomerByOrgCode"})
    @CrmLog
    public Result<List<MdmCustomerMsgRespVo>> findCustomerByOrgCode(@RequestBody MdmOrgReqVo mdmOrgReqVo) {
        List<MdmCustomerMsgRespVo> customerMsgRespVos = this.tpmIncomeBudgetService.findCustomerByOrgCode(mdmOrgReqVo);
        return Result.ok(customerMsgRespVos);
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u67e5\u8be2\u95e8\u5e97")
    @PostMapping(value={"/findTerminalByOrgCode"})
    @CrmLog
    public Result<List<MdmTerminalVo>> findTerminalByOrgCode(@RequestBody MdmOrgReqVo mdmOrgReqVo) {
        List<MdmTerminalVo> terminalVos = this.tpmIncomeBudgetService.findTerminalByOrgCode(mdmOrgReqVo);
        return Result.ok(terminalVos);
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u4ea7\u54c1\u5c42\u7ea7")
    @PostMapping(value={"/findAllProductLevel"})
    @CrmLog
    public Result<List<MdmProductLevelSelectRespVo>> findAllProductLevel(@RequestBody MdmProductLevelSelectReqVo mdmProductLevelSelectReqVo) {
        List<MdmProductLevelSelectRespVo> productLevelSelectRespVos = this.tpmIncomeBudgetService.findAllProductLevel(mdmProductLevelSelectReqVo);
        return Result.ok(productLevelSelectRespVos);
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u4ea7\u54c1")
    @PostMapping(value={"/findAllProductByLevelCode"})
    @CrmLog
    public Result<List<MdmProductQueryRespVo>> findAllProductByLevelCode(@RequestBody MdmProductLevelSelectReqVo mdmProductLevelSelectReqVo) {
        List<MdmProductQueryRespVo> productRespVos = this.tpmIncomeBudgetService.findAllProductByLevelCode(mdmProductLevelSelectReqVo);
        return Result.ok(productRespVos);
    }
}

