/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.liqueuract.service.impl.actbuilder;

import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.ActSaveTypeEnum;
import com.biz.crm.eunm.tpm.BudgetSubjectsControlTypeEnum;
import com.biz.crm.eunm.tpm.FeeBudgetDetailTypeEnum;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetDetailsEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetTransactionEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActFileEntity;
import com.biz.crm.liqueuract.service.impl.TpmLiqueurServiceHelper;
import com.biz.crm.liqueuract.service.impl.actbuilder.ActBaseBuilder;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetRespVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActBudgetReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActReqVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class LiqueurActBuilder
extends BaseServiceHelper
implements ActBaseBuilder {
    private TpmLiqueurServiceHelper helper;
    private TpmLiqueurActReqVo reqVo;
    private TpmCostTypeFineEntity fineEntity;
    private List<TpmLiqueurActBudgetReqVo> liqueurActBudgetReqVos;
    private List<TpmFeeBudgetControlEntity> controlEntities = Lists.newArrayList();
    private TpmLiqueurActEntity liqueurActEntity;
    private List<TpmLiqueurActBudgetEntity> liqueurActBudgetEntities = Lists.newArrayList();
    private TpmLiqueurActBudgetTransactionEntity transactionEntity = new TpmLiqueurActBudgetTransactionEntity();
    private List<TpmLiqueurActFileEntity> liqueurActFileEntities = Lists.newArrayList();
    private List<TpmFeeBudgetEntity> feeBudgetEntities = Lists.newArrayList();
    private List<TpmFeeBudgetDetailsEntity> feeBudgetDetailEntities = Lists.newArrayList();

    public LiqueurActBuilder(TpmLiqueurServiceHelper helper, TpmLiqueurActReqVo reqVo) {
        this.helper = helper;
        this.reqVo = reqVo;
    }

    public static LiqueurActBuilder builder(TpmLiqueurServiceHelper helper, TpmLiqueurActReqVo reqVo) {
        return new LiqueurActBuilder(helper, reqVo);
    }

    @Override
    public ActBaseBuilder init() {
        if (!CollectionUtils.isNotEmpty((Collection)this.reqVo.getBudgetControlVos())) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u6d3b\u52a8\u9884\u7b97");
        }
        this.initLiqueurData();
        return this;
    }

    public void initLiqueurData() {
        AssertUtils.isNotEmpty((String)this.reqVo.getFineCode(), (String)"\u6d3b\u52a8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList liqueurActBudgetReqVos = Lists.newArrayList();
        HashSet applyAmountSet = Sets.newHashSet();
        HashSet ids = Sets.newHashSet();
        this.reqVo.getBudgetControlVos().forEach(o -> {
            if (StringUtils.isBlank((CharSequence)o.getId())) {
                throw new BusinessException(o.getFeeBudgetCodes() + "\u8d39\u7528\u9884\u7b97Id\u4e0d\u5b58\u5728");
            }
            if (ids.contains(o.getId())) {
                throw new BusinessException("\u8bf7\u52ff\u9009\u62e9\u76f8\u540c\u7684\u9884\u7b97");
            }
            ids.add(o.getId());
            AtomicInteger count = new AtomicInteger(1);
            if (o.getApplyAmount() != null) {
                List<TpmBudgetSubjectsEntity> subjectsRespVoList;
                if (o.getApplyAmount().compareTo(BigDecimal.ZERO) > 0) {
                    applyAmountSet.add(o.getApplyAmount());
                }
                if ((subjectsRespVoList = this.helper.getTpmBudgetSubjectsEntities((TpmFeeBudgetControlRespVo)o)).size() != 1) {
                    throw new BusinessException("\u9884\u7b97\u79d1\u76ee\u5f02\u5e38");
                }
                if (StringUtils.equals((CharSequence)subjectsRespVoList.get(0).getControlType(), (CharSequence)BudgetSubjectsControlTypeEnum.NON.getCode())) {
                    List<TpmFeeBudgetRespVo> feeBudgetRespVos = o.getFeeBudgetVos().stream().sorted(Comparator.comparing(CrmBaseVo::getCreateDate)).collect(Collectors.toList());
                    AtomicReference<BigDecimal> bigDecimal = new AtomicReference<BigDecimal>(o.getApplyAmount());
                    feeBudgetRespVos.forEach(x -> {
                        if (((BigDecimal)bigDecimal.get()).compareTo(BigDecimal.ZERO) > 0) {
                            TpmLiqueurActBudgetReqVo liqueurActBudgetReqVo = this.setTpmLiqueurActBudgetReqVo((TpmFeeBudgetRespVo)x);
                            liqueurActBudgetReqVo.setApplyAmount((BigDecimal)bigDecimal.get());
                            liqueurActBudgetReqVo.setReduceOrder(Integer.valueOf(count.get()));
                            liqueurActBudgetReqVos.add(liqueurActBudgetReqVo);
                            count.getAndIncrement();
                            bigDecimal.set(BigDecimal.ZERO);
                        } else {
                            TpmLiqueurActBudgetReqVo liqueurActBudgetReqVo = this.setTpmLiqueurActBudgetReqVo((TpmFeeBudgetRespVo)x);
                            liqueurActBudgetReqVo.setApplyAmount(BigDecimal.ZERO);
                            liqueurActBudgetReqVo.setReduceOrder(Integer.valueOf(count.get()));
                            liqueurActBudgetReqVos.add(liqueurActBudgetReqVo);
                            count.getAndIncrement();
                        }
                    });
                } else {
                    if (Optional.ofNullable(o.getApplyAmount()).orElse(BigDecimal.ZERO).compareTo(o.getCanUseAmount()) > 0) {
                        throw new BusinessException("\u7533\u8bf7\u91d1\u989d\u4e0d\u53ef\u5927\u4e8e\u53ef\u7528\u91d1\u989d");
                    }
                    List<TpmFeeBudgetRespVo> feeBudgetRespVos = o.getFeeBudgetVos().stream().sorted(Comparator.comparing(TpmFeeBudgetRespVo::getBudgetMonth)).collect(Collectors.toList());
                    AtomicReference<BigDecimal> bigDecimal = new AtomicReference<BigDecimal>(o.getApplyAmount());
                    feeBudgetRespVos.forEach(x -> {
                        if (((BigDecimal)bigDecimal.get()).compareTo(BigDecimal.ZERO) > 0) {
                            TpmLiqueurActBudgetReqVo liqueurActBudgetReqVo = this.setTpmLiqueurActBudgetReqVo((TpmFeeBudgetRespVo)x);
                            if (((BigDecimal)bigDecimal.get()).compareTo(x.getCanUseAmount()) > 0) {
                                liqueurActBudgetReqVo.setApplyAmount(x.getCanUseAmount());
                                bigDecimal.set(((BigDecimal)bigDecimal.get()).subtract(x.getCanUseAmount()));
                            } else {
                                liqueurActBudgetReqVo.setApplyAmount((BigDecimal)bigDecimal.get());
                                bigDecimal.set(BigDecimal.ZERO);
                            }
                            liqueurActBudgetReqVo.setReduceOrder(Integer.valueOf(count.get()));
                            liqueurActBudgetReqVos.add(liqueurActBudgetReqVo);
                            count.incrementAndGet();
                        } else {
                            TpmLiqueurActBudgetReqVo liqueurActBudgetReqVo = this.setTpmLiqueurActBudgetReqVo((TpmFeeBudgetRespVo)x);
                            liqueurActBudgetReqVo.setApplyAmount(BigDecimal.ZERO);
                            liqueurActBudgetReqVo.setReduceOrder(Integer.valueOf(count.get()));
                            liqueurActBudgetReqVos.add(liqueurActBudgetReqVo);
                            count.getAndIncrement();
                            liqueurActBudgetReqVos.add(liqueurActBudgetReqVo);
                        }
                    });
                }
            } else {
                List feeBudgetRespVos = o.getFeeBudgetVos();
                feeBudgetRespVos.forEach(x -> {
                    TpmLiqueurActBudgetReqVo liqueurActBudgetReqVo = this.setTpmLiqueurActBudgetReqVo((TpmFeeBudgetRespVo)x);
                    liqueurActBudgetReqVo.setApplyAmount(BigDecimal.ZERO);
                    liqueurActBudgetReqVo.setReduceOrder(Integer.valueOf(count.get()));
                    count.getAndIncrement();
                    liqueurActBudgetReqVos.add(liqueurActBudgetReqVo);
                });
            }
        });
        AssertUtils.isTrue((applyAmountSet.size() > 0 ? 1 : 0) != 0, (String)"\u81f3\u5c11\u4e00\u6761\u9884\u7b97\u7533\u8bf7\u4e86\u91d1\u989d(\u5927\u4e8e0)");
        this.reqVo.setLiqueurActBudgetReqVos((List)liqueurActBudgetReqVos);
        this.liqueurActBudgetReqVos = this.reqVo.getLiqueurActBudgetReqVos();
        this.controlEntities = this.helper.findControlByIds(ids);
        this.feeBudgetEntities = this.helper.findFeeBudgetByControlIds(ids);
        this.fineEntity = this.helper.findFineEntity(this.reqVo.getFineCode());
    }

    private TpmLiqueurActBudgetReqVo setTpmLiqueurActBudgetReqVo(TpmFeeBudgetRespVo x) {
        TpmLiqueurActBudgetReqVo liqueurActBudgetReqVo = new TpmLiqueurActBudgetReqVo();
        liqueurActBudgetReqVo.setControlId(x.getControlId());
        liqueurActBudgetReqVo.setFeeBudgetCode(x.getFeeBudgetCode());
        liqueurActBudgetReqVo.setFeeBudgetType(x.getFeeBudgetType());
        liqueurActBudgetReqVo.setOrgType(x.getOrgType());
        liqueurActBudgetReqVo.setBudgetMonth(x.getBudgetMonth());
        liqueurActBudgetReqVo.setBudgetYear(x.getBudgetYear());
        liqueurActBudgetReqVo.setBudgetQuater(x.getBudgetQuater());
        liqueurActBudgetReqVo.setBudgetSubjectsCode(x.getBudgetSubjectsCode());
        return liqueurActBudgetReqVo;
    }

    @Override
    public ActBaseBuilder check() {
        this.checkActData();
        this.helper.checkOrgAndCus(this.reqVo);
        this.helper.checkBudgets(this.reqVo);
        this.helper.checkBudgetData(this.reqVo);
        this.checkAmount();
        return this;
    }

    private void checkAmount() {
        if (!ActSaveTypeEnum.getCheckBudgetTypes().contains(this.reqVo.getSaveType())) {
            return;
        }
        Map<String, List<TpmFeeBudgetEntity>> feeBudgetMap = this.feeBudgetEntities.stream().collect(Collectors.groupingBy(TpmFeeBudgetEntity::getControlId));
        Map actBudgetReqVoMap = this.liqueurActBudgetReqVos.stream().collect(Collectors.toMap(TpmLiqueurActBudgetReqVo::getFeeBudgetCode, Function.identity()));
        HashSet feeBudgetIds = Sets.newHashSet();
        ArrayList feeBudgetDetailEntities = Lists.newArrayList();
        this.controlEntities.forEach(o -> {
            AtomicReference<BigDecimal> bigDecimal = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            ((List)feeBudgetMap.get(o.getId())).forEach(x -> {
                Set actBudgetCodes = actBudgetReqVoMap.keySet();
                TpmLiqueurActBudgetReqVo actBudgetReqVo = (TpmLiqueurActBudgetReqVo)actBudgetReqVoMap.get(x.getFeeBudgetCode());
                if (actBudgetCodes.contains(x.getFeeBudgetCode())) {
                    if (x.getCanUseAmount().compareTo(actBudgetReqVo.getApplyAmount()) < 1) {
                        throw new BusinessException("\u9884\u7b97\u53ef\u7528\u4f59\u989d\u4e0d\u8db3");
                    }
                    x.setCanUseAmount(x.getCanUseAmount().subtract(actBudgetReqVo.getApplyAmount()));
                    x.setUsedAmount(x.getUsedAmount().add(actBudgetReqVo.getApplyAmount()));
                }
                feeBudgetIds.add(x.getId());
                bigDecimal.set(((BigDecimal)bigDecimal.get()).add(x.getCanUseAmount()));
                TpmFeeBudgetDetailsEntity detailsEntity = (TpmFeeBudgetDetailsEntity)((Object)((Object)((Object)CrmBeanUtil.copy((Object)x, TpmFeeBudgetDetailsEntity.class))));
                super.setPublicParamsNull((CrmBaseEntity)detailsEntity);
                detailsEntity.setInitAmount(x.getInitAmount());
                detailsEntity.setBeforAmount(x.getCanUseAmount().add(actBudgetReqVo.getApplyAmount()));
                detailsEntity.setFeeAmount(BigDecimal.ZERO.subtract(actBudgetReqVo.getApplyAmount()));
                detailsEntity.setAfterAmount(detailsEntity.getBeforAmount().add(detailsEntity.getFeeAmount()));
                feeBudgetDetailEntities.add(detailsEntity);
            });
            o.setCanUseAmount(bigDecimal.get());
        });
        AssertUtils.isTrue((feeBudgetIds.size() == this.liqueurActBudgetReqVos.size() ? 1 : 0) != 0, (String)"\u9884\u7b97\u6570\u636e\u5f02\u5e38");
        this.feeBudgetDetailEntities = feeBudgetDetailEntities;
    }

    private void checkActData() {
        AssertUtils.isNotEmpty((String)this.reqVo.getActName(), (String)"\u8bf7\u8f93\u5165\u6d3b\u52a8\u540d\u79f0");
        AssertUtils.isNotEmpty((String)this.reqVo.getBeginDate(), (String)"\u8bf7\u9009\u62e9\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4");
        if (StringUtils.isEmpty((CharSequence)this.reqVo.getBeginDateSecond())) {
            this.reqVo.setBeginDateSecond("00:00:00");
        }
        AssertUtils.isNotEmpty((String)this.reqVo.getEndDate(), (String)"\u8bf7\u9009\u62e9\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4");
        if (StringUtils.isEmpty((CharSequence)this.reqVo.getEndDateSecond())) {
            this.reqVo.setEndDateSecond("23:59:59");
        }
        AssertUtils.isTrue((StringUtils.compare((String)(this.reqVo.getBeginDate() + this.reqVo.getBeginDateSecond()), (String)(this.reqVo.getEndDate() + this.reqVo.getEndDateSecond())) < 0 ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4");
        AssertUtils.isNotEmpty((String)this.reqVo.getFineCode(), (String)"\u8bf7\u9009\u62e9\u6d3b\u52a8\u7c7b\u578b");
        if (StringUtils.isBlank((CharSequence)this.reqVo.getIsCrossOrg())) {
            this.reqVo.setIsCrossOrg(GlobalWhetherEnum.NO.getCode());
        }
        AssertUtils.isNotEmpty((String)this.reqVo.getSaveType(), (String)"\u6d3b\u52a8\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        this.reqVo.setIsCrossOrg(this.fineEntity.getIsSpanOrgBudget());
    }

    @Override
    public ActBaseBuilder convert() {
        this.liqueurActEntity = (TpmLiqueurActEntity)((Object)CrmBeanUtil.copy((Object)this.reqVo, TpmLiqueurActEntity.class));
        if (StringUtils.isBlank((CharSequence)this.liqueurActEntity.getActCode())) {
            this.liqueurActEntity.setActCode(CodeUtil.createOneCode((String)"liqueur_act"));
        }
        this.liqueurActEntity.setCanUseAmount(BigDecimal.ZERO);
        this.liqueurActEntity.setRegisterTotalAmount(BigDecimal.ZERO);
        this.liqueurActEntity.setApproveAmount(BigDecimal.ZERO);
        this.liqueurActEntity.setAuditTotalAmount(BigDecimal.ZERO);
        this.liqueurActEntity.setIsAllAudit(GlobalWhetherEnum.NO.getCode());
        this.liqueurActEntity.setIsAudit(GlobalWhetherEnum.NO.getCode());
        this.liqueurActEntity.setAuditFormCode(this.fineEntity.getAuditFormCode());
        this.liqueurActEntity.setCostFormCode(this.fineEntity.getCostFormCode());
        BigDecimal amount = this.liqueurActBudgetReqVos.stream().map(TpmLiqueurActBudgetReqVo::getApplyAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.liqueurActEntity.setApplyTotalAmount(amount);
        this.liqueurActBudgetEntities = CrmBeanUtil.copyList(this.liqueurActBudgetReqVos, TpmLiqueurActBudgetEntity.class);
        this.liqueurActBudgetEntities.forEach(x -> {
            x.setActCode(this.liqueurActEntity.getActCode());
            x.setActBudgetCode(CodeUtil.createOneCode((String)"liqueur_act_budget"));
            x.setApproveAmount(BigDecimal.ZERO);
            x.setAuditAmount(BigDecimal.ZERO);
            x.setApproveAmount(BigDecimal.ZERO);
            x.setCanUseAmount(BigDecimal.ZERO);
            super.setPublicParamsNull((CrmBaseEntity)x);
        });
        if (CollectionUtils.isNotEmpty(this.feeBudgetDetailEntities)) {
            this.feeBudgetDetailEntities.forEach(x -> {
                x.setBusinessCode(this.liqueurActEntity.getActCode());
                x.setBusinessName(this.liqueurActEntity.getActName());
                x.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.USE.getCode());
                x.setFeeBudgetDetailTypeName(FeeBudgetDetailTypeEnum.USE.getDes());
                this.liqueurActBudgetReqVos.forEach(o -> {
                    if (x.getFeeBudgetCode().equals(o.getFeeBudgetCode())) {
                        x.setReduceOrder(o.getReduceOrder());
                        x.setYear(o.getBudgetYear());
                        x.setMonth(o.getBudgetMonth());
                    }
                });
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)this.reqVo.getFileVos())) {
            this.reqVo.getFileVos().forEach(x -> {
                x.setActCode(this.liqueurActEntity.getActCode());
                TpmLiqueurActFileEntity entity = (TpmLiqueurActFileEntity)((Object)((Object)CrmBeanUtil.copy((Object)x, TpmLiqueurActFileEntity.class)));
                this.liqueurActFileEntities.add(entity);
            });
        }
        return this;
    }

    @Override
    public TpmLiqueurActEntity save() {
        this.helper.saveOrUpdateAct(this.liqueurActEntity, this.reqVo);
        this.helper.saveActBudgets(this.liqueurActBudgetEntities, this.reqVo);
        this.helper.saveActFiles(this.liqueurActFileEntities, this.reqVo);
        this.helper.saveFeeBudgets(this.feeBudgetEntities, this.reqVo);
        this.helper.saveBudgetController(this.controlEntities, this.reqVo);
        this.helper.saveFeeBudgetDetails(this.feeBudgetDetailEntities, this.reqVo);
        return this.liqueurActEntity;
    }

    @Override
    public TpmLiqueurActEntity update() {
        this.helper.saveOrUpdateAct(this.liqueurActEntity, this.reqVo);
        this.helper.saveActBudgets(this.liqueurActBudgetEntities, this.reqVo);
        this.helper.saveActFiles(this.liqueurActFileEntities, this.reqVo);
        this.helper.saveFeeBudgets(this.feeBudgetEntities, this.reqVo);
        this.helper.saveBudgetController(this.controlEntities, this.reqVo);
        this.helper.saveFeeBudgetDetails(this.feeBudgetDetailEntities, this.reqVo);
        return this.liqueurActEntity;
    }
}

