/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.liqueuract.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesFineMapper;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesMapper;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesEntity;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesFineEntity;
import com.biz.crm.costtypefine.mapper.TpmCostTypeFineMapper;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActSaveTypeEnum;
import com.biz.crm.eunm.tpm.FeeBudgetDetailTypeEnum;
import com.biz.crm.eunm.tpm.LiqueurActBudgetBusinessTypeEnum;
import com.biz.crm.eunm.tpm.LiqueurActBudgetRemarkEnum;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.tpm.ActException;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActBudgetMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActBudgetTransactionMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActRegisterDetailAttachMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActRegisterDetailBudgetMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActRegisterDetailMapper;
import com.biz.crm.liqueuract.mapper.TpmLiqueurActRegisterMapper;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActBudgetTransactionEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterDetailAttachEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterDetailBudgetEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterDetailEntity;
import com.biz.crm.liqueuract.model.TpmLiqueurActRegisterEntity;
import com.biz.crm.liqueuract.service.ITpmLiqueurActBudgetTransactionService;
import com.biz.crm.liqueuract.service.ITpmLiqueurActRegisterDetailAttachService;
import com.biz.crm.liqueuract.service.ITpmLiqueurActRegisterDetailBudgetService;
import com.biz.crm.liqueuract.service.ITpmLiqueurActRegisterDetailService;
import com.biz.crm.liqueuract.service.TpmLiqueurActBudgetService;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.act.req.TaActFileReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class TpmLiqueurActRegisterServiceHelper
extends BaseServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(TpmLiqueurActRegisterServiceHelper.class);
    @Resource
    private TpmLiqueurActBudgetMapper actBudgetMapper;
    @Resource
    private TpmLiqueurActRegisterMapper registerMapper;
    @Resource
    private TpmLiqueurActMapper actMapper;
    @Resource
    private TpmCostTypeCategoriesFineMapper costTypeCategoriesFineMapper;
    @Resource
    private TpmCostTypeCategoriesMapper costTypeCategoriesMapper;
    @Resource
    private TpmLiqueurActRegisterDetailMapper detailMapper;
    @Resource
    private TpmLiqueurActRegisterDetailBudgetMapper detailBudgetMapper;
    @Resource
    private TpmLiqueurActRegisterDetailAttachMapper detailAttachMapper;
    @Autowired
    private ITpmLiqueurActRegisterDetailAttachService detailAttachService;
    @Autowired
    private ITpmLiqueurActRegisterDetailService detailService;
    @Autowired
    private ITpmLiqueurActRegisterDetailBudgetService detailBudgetService;
    @Autowired
    private ITpmLiqueurActBudgetTransactionService actBudgetTransactionService;
    @Resource
    private TpmLiqueurActBudgetTransactionMapper actBudgetTransactionMapper;
    @Autowired
    private TpmLiqueurActBudgetService actBudgetService;
    @Resource
    private TpmCostTypeFineMapper fineMapper;

    public Map<String, Map<String, String>> getDicts() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("enable_status");
        dictCodes.add("act_approve_status");
        return DictUtil.getDictValueMapsByCodes((List)dictCodes);
    }

    public void convertListDate(List<TpmLiqueurActRegisterRespVo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Map<String, Map<String, String>> map = this.getDicts();
            list.forEach(o -> {
                if (StringUtils.isNotEmpty((CharSequence)o.getEnableStatus())) {
                    o.setEnableStatusName((String)((Map)Optional.ofNullable(map.get("enable_status")).orElse(Maps.newHashMap())).get(o.getEnableStatus()));
                }
                if (StringUtils.isNotEmpty((CharSequence)o.getApproveStatus())) {
                    o.setApproveStatusName((String)((Map)Optional.ofNullable(map.get("act_approve_status")).orElse(Maps.newHashMap())).get(o.getApproveStatus()));
                }
            });
        }
    }

    public TpmLiqueurActEntity findActEntityByCode(String actCode) {
        AssertUtils.isNotEmpty((String)actCode, (String)"\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TpmLiqueurActEntity::getActCode, (Object)actCode);
        return (TpmLiqueurActEntity)((Object)this.actMapper.selectOne((Wrapper)wrapper));
    }

    public List<TpmLiqueurActBudgetEntity> findActBudgetByActCode(String actCode) {
        AssertUtils.isNotEmpty((String)actCode, (String)"\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TpmLiqueurActBudgetEntity::getActCode, (Object)actCode);
        return this.actBudgetMapper.selectList((Wrapper)wrapper);
    }

    public Map<String, TpmCostTypeCategoriesEntity> findCategoriesMapByFineCode(String fineCode) {
        AssertUtils.isNotEmpty((String)fineCode, (String)"\u6d3b\u52a8\u7c7b\u578b(\u6d3b\u52a8\u7ec6\u7c7b)\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper costTypeCategoriesFineWrapper = new LambdaQueryWrapper();
        costTypeCategoriesFineWrapper.eq(TpmCostTypeCategoriesFineEntity::getFineCode, (Object)fineCode);
        List tpmCostTypeCategoriesFineEntities = this.costTypeCategoriesFineMapper.selectList((Wrapper)costTypeCategoriesFineWrapper);
        ArrayList categoriesCodes = Lists.newArrayList();
        tpmCostTypeCategoriesFineEntities.stream().forEach(o -> categoriesCodes.add(o.getCategoriesCode()));
        LambdaQueryWrapper costTypeCategoriesWrapper = new LambdaQueryWrapper();
        costTypeCategoriesWrapper.in(TpmCostTypeCategoriesEntity::getCategoriesCode, (Collection)categoriesCodes);
        List tpmCostTypeCategoriesEntities = this.costTypeCategoriesMapper.selectList((Wrapper)costTypeCategoriesWrapper);
        Map<String, TpmCostTypeCategoriesEntity> map = tpmCostTypeCategoriesEntities.stream().collect(Collectors.toMap(TpmCostTypeCategoriesEntity::getCategoriesCode, Function.identity(), (k1, k2) -> k1));
        return map;
    }

    public void deleteCheck(List<String> ids) {
        List entities = this.registerMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmLiqueurActRegisterEntity.class).in(BaseIdEntity::getId, ids));
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append("\u6d3b\u52a8\u767b\u8bb0\u7f16\u7801:[");
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            StringBuffer msg = new StringBuffer();
            entities.forEach(o -> {
                if (!StringUtils.equals((CharSequence)ActApproveStatusEnum.CREATE.getCode(), (CharSequence)o.getApproveStatus())) {
                    msg.append(o.getActCode()).append(",");
                }
            });
            if (StringUtils.isNotEmpty((CharSequence)msg.toString())) {
                throw new BusinessException(errorMsg.append(msg.toString()).append("],\u7684\u6d3b\u52a8\u72b6\u6001\u4e0d\u4e3a\u5f85\u63d0\u4ea4,\u4e0d\u80fd\u5220\u9664").toString());
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public TpmLiqueurActRegisterEntity saveOrUpdateActRegister(TpmLiqueurActRegisterEntity actRegisterEntity, TpmLiqueurActRegisterReqVo reqVo) {
        if (ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())) {
            actRegisterEntity.setApproveStatus(ActApproveStatusEnum.APPROVING.getCode());
        } else if (StringUtils.isEmpty((CharSequence)actRegisterEntity.getApproveStatus())) {
            actRegisterEntity.setApproveStatus(ActApproveStatusEnum.CREATE.getCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)actRegisterEntity.getId())) {
            this.registerMapper.updateById((Object)actRegisterEntity);
        } else {
            this.registerMapper.insert((Object)actRegisterEntity);
        }
        return actRegisterEntity;
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveActRegisterBudgets(List<TpmLiqueurActRegisterDetailBudgetEntity> actRegisterDetailBudgetEntities, TpmLiqueurActRegisterReqVo reqVo) {
        if (ActSaveTypeEnum.getUpdateTypes().contains(reqVo.getSaveType())) {
            List ids = actRegisterDetailBudgetEntities.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getId())).map(BaseIdEntity::getId).collect(Collectors.toList());
            this.detailBudgetMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TpmLiqueurActRegisterDetailBudgetEntity::getActRegisterCode, (Object)reqVo.getActRegisterCode())).notIn(CollectionUtils.isNotEmpty(ids), BaseIdEntity::getId, ids));
        }
        this.detailBudgetService.saveOrUpdateBatch(actRegisterDetailBudgetEntities);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveActRegisterDetails(List<TpmLiqueurActRegisterDetailEntity> actDetailEntities, TpmLiqueurActRegisterReqVo reqVo) {
        if (ActSaveTypeEnum.getUpdateTypes().contains(reqVo.getSaveType())) {
            List list = actDetailEntities.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getId())).map(BaseIdEntity::getId).collect(Collectors.toList());
            this.detailMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().notIn(CollectionUtils.isNotEmpty(list), BaseIdEntity::getId, list)).eq(TpmLiqueurActRegisterDetailEntity::getActRegisterCode, (Object)reqVo.getActRegisterCode()));
        }
        this.detailService.saveOrUpdateBatch(actDetailEntities);
    }

    public void saveActRegisterAttaches(List<TpmLiqueurActRegisterDetailAttachEntity> attachEntities, TpmLiqueurActRegisterReqVo reqVo) {
        if (CollectionUtils.isNotEmpty(attachEntities)) {
            if (ActSaveTypeEnum.getUpdateTypes().contains(reqVo.getSaveType())) {
                List list = attachEntities.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getId())).map(BaseIdEntity::getId).collect(Collectors.toList());
                this.detailAttachMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().notIn(CollectionUtils.isNotEmpty(list), BaseIdEntity::getId, list)).eq(TpmLiqueurActRegisterDetailAttachEntity::getActRegisterCode, (Object)reqVo.getActRegisterCode()));
            }
            this.detailAttachService.saveOrUpdateBatch(attachEntities);
        } else if (StringUtils.isNotEmpty((CharSequence)reqVo.getId())) {
            this.detailAttachMapper.delete((Wrapper)Wrappers.lambdaQuery(TpmLiqueurActRegisterDetailAttachEntity.class).eq(TpmLiqueurActRegisterDetailAttachEntity::getActRegisterCode, (Object)reqVo.getActRegisterCode()));
        }
    }

    public void saveActBudgetTransactions(List<TpmLiqueurActBudgetTransactionEntity> transactionEntities, TpmLiqueurActRegisterReqVo reqVo) {
        if (!ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())) {
            return;
        }
        this.actBudgetTransactionService.saveBatch(transactionEntities);
    }

    public void saveActFeeBudgets(List<TpmLiqueurActBudgetEntity> actBudgetEntities, TpmLiqueurActRegisterReqVo reqVo) {
        if (!ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())) {
            return;
        }
        this.actBudgetService.updateBatchById(actBudgetEntities);
    }

    public void updateCheck(TpmLiqueurActRegisterReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        TpmLiqueurActRegisterEntity entity = (TpmLiqueurActRegisterEntity)((Object)this.registerMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(BaseIdEntity::getId, (Object)reqVo.getId())));
        AssertUtils.isNotNull((Object)((Object)entity), (CrmExceptionType)ActException.DATA_NOT_EXIST, (String[])new String[0]);
        if (!ActApproveStatusEnum.getCanUpdateStatus().contains(entity.getApproveStatus())) {
            throw new BusinessException("\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u4e0d\u5141\u8bb8\u4fee\u6539\u64cd\u4f5c");
        }
    }

    public TpmLiqueurActRegisterEntity approveCheck(TpmLiqueurActRegisterReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getWorkFlowKey(), (String)"\u8bf7\u9009\u62e9\u6d41\u7a0b");
        TpmLiqueurActRegisterEntity entity = (TpmLiqueurActRegisterEntity)((Object)this.registerMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(BaseIdEntity::getId, (Object)reqVo.getId())));
        AssertUtils.isNotNull((Object)((Object)entity), (String)"\u5f53\u524d\u6d3b\u52a8\u6570\u636e\u4e0d\u5b58\u5728");
        Set canApproveStatus = ActApproveStatusEnum.getCanApproveStatus();
        AssertUtils.isTrue((boolean)canApproveStatus.contains(entity.getApproveStatus()), (String)"\u4ec5\u72b6\u6001\u4e3a\u201c\u5f85\u63d0\u4ea4\u3001\u5ba1\u6279\u9a73\u56de\u3001\u6d41\u7a0b\u8ffd\u56de\u201d\u7684\u5355\u636e\u53ef\u63d0\u4ea4\u5ba1\u6279");
        reqVo.setSaveType(ActSaveTypeEnum.APPROVE.getCode());
        return entity;
    }

    public TpmLiqueurActRegisterEntity rejectAndInterruptCheck(TpmLiqueurActRegisterReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        TpmLiqueurActRegisterEntity entity = (TpmLiqueurActRegisterEntity)((Object)this.registerMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(BaseIdEntity::getId, (Object)reqVo.getId())));
        if (!StringUtils.equals((CharSequence)ActApproveStatusEnum.APPROVING.getCode(), (CharSequence)entity.getApproveStatus())) {
            return null;
        }
        entity.setApproveStatus(reqVo.getApproveStatus());
        return entity;
    }

    public TpmLiqueurActRegisterEntity approvedCheck(TpmLiqueurActRegisterReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        TpmLiqueurActRegisterEntity entity = (TpmLiqueurActRegisterEntity)((Object)this.registerMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(BaseIdEntity::getId, (Object)reqVo.getId())));
        AssertUtils.isNotNull((Object)((Object)entity), (String)"\u5f53\u524d\u6d3b\u52a8\u6570\u636e\u4e0d\u5b58\u5728");
        if (!StringUtils.equals((CharSequence)ActApproveStatusEnum.APPROVING.getCode(), (CharSequence)entity.getApproveStatus())) {
            return null;
        }
        return entity;
    }

    public StartProcessReqVo buildStartProcessData(TpmLiqueurActRegisterEntity entity, TpmLiqueurActRegisterReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        StartProcessReqVo startProcessReqVo = new StartProcessReqVo();
        startProcessReqVo.setCallBackFeign("TpmLiqueurActRegisterCallBackFeign");
        startProcessReqVo.setProcessKey(reqVo.getWorkFlowKey());
        startProcessReqVo.setUserCode(user.getUsername());
        startProcessReqVo.setPosCode(user.getPoscode());
        startProcessReqVo.setTitle(reqVo.getTitle());
        startProcessReqVo.setFormNo(entity.getId());
        startProcessReqVo.setRemark(reqVo.getApproveRemarks());
        startProcessReqVo.setSignTicket(System.currentTimeMillis() + "");
        startProcessReqVo.setBusinessCode(entity.getActCode());
        List taActFileReqVos = Optional.ofNullable(reqVo.getActivityFileList()).orElse(Lists.newArrayList()).stream().map(o -> {
            TaActFileReqVo taActFileReqVo = new TaActFileReqVo();
            taActFileReqVo.setObjectName(o.getObjectName());
            taActFileReqVo.setFileAddress(o.getFileAddress());
            return taActFileReqVo;
        }).collect(Collectors.toList());
        startProcessReqVo.setFileList(taActFileReqVos);
        return startProcessReqVo;
    }

    public void approved(TpmLiqueurActRegisterReqVo reqVo) {
        TpmLiqueurActRegisterEntity registerEntity = this.approvedCheck(reqVo);
        if (Objects.isNull((Object)registerEntity)) {
            return;
        }
        registerEntity.setApproveStatus(ActApproveStatusEnum.APPROVED.getCode());
        TpmLiqueurActEntity actEntity = (TpmLiqueurActEntity)((Object)this.actMapper.selectOne((Wrapper)Wrappers.lambdaQuery(TpmLiqueurActEntity.class).eq(TpmLiqueurActEntity::getActCode, (Object)registerEntity.getActCode())));
        if (!StringUtils.equals((CharSequence)actEntity.getApproveStatus(), (CharSequence)ActApproveStatusEnum.APPROVED.getCode())) {
            throw new BusinessException("\u6d3b\u52a8\u7533\u8bf7\u72b6\u6001\u4e0d\u4e3a\u5ba1\u6279\u901a\u8fc7,\u6d3b\u52a8\u767b\u8bb0\u5ba1\u6279\u901a\u8fc7\u5931\u8d25");
        }
        TpmCostTypeFineEntity fineEntity = (TpmCostTypeFineEntity)((Object)this.fineMapper.selectOne((Wrapper)Wrappers.lambdaQuery(TpmCostTypeFineEntity.class).eq(TpmCostTypeFineEntity::getFineCode, (Object)actEntity.getFineCode())));
        AssertUtils.isNotNull((Object)((Object)fineEntity), (String)("\u6d3b\u52a8\u7c7b\u578b:" + actEntity.getFineCode() + ",\u6570\u636e\u4e0d\u5b58\u5728"));
        String date = "";
        try {
            date = Objects.nonNull(fineEntity.getAuditValidity()) ? DateUtil.formatAddMonth((String)actEntity.getEndDate(), (String)"yyyy-MM-dd", (int)fineEntity.getAuditValidity()) : "9999-12-31";
        }
        catch (ParseException e) {
            log.error("{}", (Throwable)e);
            throw new BusinessException("\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        List detailEntities = this.detailMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmLiqueurActRegisterDetailEntity.class).eq(TpmLiqueurActRegisterDetailEntity::getActRegisterCode, (Object)registerEntity.getActRegisterCode()));
        for (TpmLiqueurActRegisterDetailEntity o : detailEntities) {
            o.setAllowAuditEndDate(date);
            o.setAllowAuditEndDateSecond("23:59:59");
            o.setIsAllAudit(GlobalWhetherEnum.NO.getCode());
            o.setIsAudit(GlobalWhetherEnum.YES.getCode());
        }
        this.detailService.saveOrUpdateBatch(detailEntities);
        this.registerMapper.updateById((Object)registerEntity);
    }

    public void rejectAndInterrupt(TpmLiqueurActRegisterReqVo reqVo) {
        TpmLiqueurActRegisterEntity registerEntity = this.rejectAndInterruptCheck(reqVo);
        if (Objects.isNull((Object)registerEntity)) {
            return;
        }
        TpmLiqueurActEntity actEntity = (TpmLiqueurActEntity)((Object)this.actMapper.selectOne((Wrapper)Wrappers.lambdaQuery(TpmLiqueurActEntity.class).eq(TpmLiqueurActEntity::getActCode, (Object)registerEntity.getActCode())));
        actEntity.setCanUseAmount(actEntity.getCanUseAmount().add(registerEntity.getTotalAmount()));
        actEntity.setRegisterTotalAmount(actEntity.getRegisterTotalAmount().subtract(registerEntity.getTotalAmount()));
        List budgetTransactionEntities = this.actBudgetTransactionMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TpmLiqueurActBudgetTransactionEntity.class).eq(TpmLiqueurActBudgetTransactionEntity::getBusinessCode, (Object)registerEntity.getActRegisterCode())).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode()));
        if (CollectionUtils.isNotEmpty((Collection)budgetTransactionEntities)) {
            Set actBudgetCodes = budgetTransactionEntities.stream().map(TpmLiqueurActBudgetTransactionEntity::getActBudgetCode).collect(Collectors.toSet());
            List actBudgetEntities = this.actBudgetMapper.selectList((Wrapper)Wrappers.lambdaQuery(TpmLiqueurActBudgetEntity.class).in(TpmLiqueurActBudgetEntity::getActBudgetCode, actBudgetCodes));
            AssertUtils.isTrue((CollectionUtils.size((Object)actBudgetEntities) == CollectionUtils.size(actBudgetCodes) ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u9884\u7b97\u6570\u636e\u5f02\u5e38[\u6d3b\u52a8\u9884\u7b97\u6570\u636e\u4e22\u5931]");
            Map actBudgetEntityMap = actBudgetEntities.stream().collect(Collectors.toMap(TpmLiqueurActBudgetEntity::getActBudgetCode, Function.identity()));
            ArrayList newTransactions = Lists.newArrayList();
            for (TpmLiqueurActBudgetTransactionEntity transactionEntity : budgetTransactionEntities) {
                if (transactionEntity.getFeeAmount().compareTo(BigDecimal.ZERO) == 0) continue;
                TpmLiqueurActBudgetEntity actBudgetEntity = (TpmLiqueurActBudgetEntity)((Object)actBudgetEntityMap.get(transactionEntity.getActBudgetCode()));
                TpmLiqueurActBudgetTransactionEntity newTransaction = (TpmLiqueurActBudgetTransactionEntity)((Object)CrmBeanUtil.copy((Object)((Object)transactionEntity), TpmLiqueurActBudgetTransactionEntity.class));
                super.setPublicParamsNull((CrmBaseEntity)newTransaction);
                newTransaction.setTransactionType(FeeBudgetDetailTypeEnum.RETURN_BACK.getCode());
                newTransaction.setTransactionTypeName(FeeBudgetDetailTypeEnum.RETURN_BACK.getDes());
                newTransaction.setBusinessType(LiqueurActBudgetBusinessTypeEnum.ACT_REGISTER.getCode());
                newTransaction.setBusinessRemarks(LiqueurActBudgetRemarkEnum.ACT_RETURN_BUDGET.getDes());
                newTransaction.setFeeAmount(newTransaction.getFeeAmount().abs());
                newTransaction.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
                actBudgetEntity.setCanUseAmount(actBudgetEntity.getCanUseAmount().add(transactionEntity.getFeeAmount().abs()));
                newTransactions.add(newTransaction);
            }
            this.actBudgetTransactionService.saveBatch(newTransactions);
            this.actBudgetService.updateBatchById(actBudgetEntities);
        }
        this.registerMapper.updateById((Object)registerEntity);
        this.actMapper.updateById((Object)actEntity);
    }

    public void updateActEntity(TpmLiqueurActEntity actEntity, TpmLiqueurActRegisterReqVo reqVo) {
        if (!ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())) {
            return;
        }
        actEntity.setCanUseAmount(Optional.ofNullable(actEntity.getCanUseAmount()).orElse(BigDecimal.ZERO).subtract(reqVo.getTotalAmount()));
        actEntity.setRegisterTotalAmount(Optional.ofNullable(actEntity.getRegisterTotalAmount()).orElse(BigDecimal.ZERO).add(reqVo.getTotalAmount()));
        this.actMapper.updateById((Object)actEntity);
    }
}

