/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.liqueraudit.controller;

import com.alibaba.fastjson.JSON;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.liqueraudit.service.ITpmLiqueurAuditService;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterDetailAttachReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActRegisterDetailReqVo;
import com.biz.crm.nebular.tpm.liqueuract.req.TpmLiqueurActReqVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterDetailAttachRespVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRegisterDetailRespVo;
import com.biz.crm.nebular.tpm.liqueuract.resp.TpmLiqueurActRespVo;
import com.biz.crm.nebular.tpm.liqueuraudit.req.TpmLiqueurAuditReqVo;
import com.biz.crm.nebular.tpm.liqueuraudit.resp.TpmLiqueurAuditRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tpmliqueuraudit"})
@Api(tags={"\u9152\u7c7bTPM\u6838\u9500\u7533\u8bf7\u4e3b\u8868;"})
public class TpmLiqueurAuditController {
    private static final Logger log = LoggerFactory.getLogger(TpmLiqueurAuditController.class);
    @Autowired
    private ITpmLiqueurAuditService tpmLiqueurAuditService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<TpmLiqueurAuditRespVo>> list(@RequestBody TpmLiqueurAuditReqVo tpmLiqueurAuditReqVo) {
        PageResult<TpmLiqueurAuditRespVo> result = this.tpmLiqueurAuditService.findList(tpmLiqueurAuditReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @GetMapping(value={"/query"})
    @CrmLog
    public Result<TpmLiqueurAuditRespVo> query(@RequestParam(value="id", required=false) String id) {
        TpmLiqueurAuditRespVo respVo = this.tpmLiqueurAuditService.query(id);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody TpmLiqueurAuditReqVo tpmLiqueurAuditReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmLiqueurAuditReqVo.setLockUserName(user.getUsername());
        this.tpmLiqueurAuditService.save(tpmLiqueurAuditReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody TpmLiqueurAuditReqVo tpmLiqueurAuditReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmLiqueurAuditReqVo.setLockUserName(user.getUsername());
        this.tpmLiqueurAuditService.update(tpmLiqueurAuditReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.tpmLiqueurAuditService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody TpmLiqueurAuditReqVo tpmLiqueurAuditReqVo) {
        this.tpmLiqueurAuditService.enableBatch(tpmLiqueurAuditReqVo);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody TpmLiqueurAuditReqVo tpmLiqueurAuditReqVo) {
        this.tpmLiqueurAuditService.disableBatch(tpmLiqueurAuditReqVo);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u67e5\u8be2\u53ef\u6838\u9500\u6d3b\u52a8\u5217\u8868")
    @PostMapping(value={"/getActList"})
    @CrmLog
    public Result<PageResult<TpmLiqueurActRespVo>> getActList(@RequestBody TpmLiqueurActReqVo tpmLiqueurActReqVo) {
        PageResult<TpmLiqueurActRespVo> result = this.tpmLiqueurAuditService.getActList(tpmLiqueurActReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2\u53ef\u6838\u9500\u6d3b\u52a8\u660e\u7ec6\u5217\u8868")
    @PostMapping(value={"/getActDetailList"})
    @CrmLog
    public Result<PageResult<TpmLiqueurActRegisterDetailRespVo>> getActDetailList(@RequestBody TpmLiqueurActRegisterDetailReqVo reqVo) {
        PageResult<TpmLiqueurActRegisterDetailRespVo> result = this.tpmLiqueurAuditService.getActDetailList(reqVo);
        return Result.ok(result);
    }

    @ApiModelProperty(value="\u6839\u636e\u6d3b\u52a8\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u9644\u52a0\u4fe1\u606f\u5217\u8868")
    @PostMapping(value={"/getAttachList"})
    @CrmLog
    public Result<PageResult<TpmLiqueurActRegisterDetailAttachRespVo>> getAttachList(@RequestBody TpmLiqueurActRegisterDetailAttachReqVo reqVo) {
        PageResult<TpmLiqueurActRegisterDetailAttachRespVo> result = this.tpmLiqueurAuditService.getAttachList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u5de5\u4f5c\u6d41\u56de\u8c03\u63a5\u53e3")
    @PostMapping(value={"/liqueurAuditCallBack"})
    @CrmLog
    public Result callback(@RequestBody ActivitiCallBackVo activitiCallBackVo) {
        log.info("\u9152\u7c7b\u6838\u9500\u6536\u5230\u5de5\u4f5c\u6d41\u56de\u8c03\u8bf7\u6c42,\u8bf7\u6c42\u53c2\u6570={}", (Object)JSON.toJSONString((Object)activitiCallBackVo));
        this.tpmLiqueurAuditService.auditCallBack(activitiCallBackVo);
        return Result.ok((String)"\u6838\u9500\u5ba1\u6279\u56de\u8c03\u6210\u529f");
    }

    @ApiOperation(value="\u63d0\u4ea4\u5ba1\u6279")
    @PostMapping(value={"/approve"})
    @CrmLog
    public Result approve(@RequestBody TpmLiqueurAuditReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        reqVo.setLockUserName(user.getUsername());
        this.tpmLiqueurAuditService.approve(reqVo);
        return Result.ok((String)"\u63d0\u4ea4\u5ba1\u6279\u6210\u529f");
    }
}

