/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.controller;

import com.biz.crm.act.service.ITpmActService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.costtypecategories.service.ITpmCostTypeCategoriesService;
import com.biz.crm.eunm.tpm.ActSaveTypeEnum;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialPriceRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.tpm.act.req.ActDetailFeeShareVo;
import com.biz.crm.nebular.tpm.act.req.ActGetCategoriesByBudgetReqVo;
import com.biz.crm.nebular.tpm.act.req.ActGetCustomerCodeByOrgCodeReqVo;
import com.biz.crm.nebular.tpm.act.req.ActGetOrgInfoReqVo;
import com.biz.crm.nebular.tpm.act.req.ActGetTerminalByCustomerCodeReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActReqVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActRespVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRespVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tpmActController"})
@Api(tags={"\u6d3b\u52a8\u4fe1\u606f\u4e3b\u8868;"})
public class TpmActController {
    private static final Logger log = LoggerFactory.getLogger(TpmActController.class);
    @Autowired
    private ITpmActService tpmActService;
    @Autowired
    private ITpmCostTypeCategoriesService categoriesService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<TpmActRespVo>> list(@RequestBody TpmActReqVo tpmActReqVo) {
        PageResult<TpmActRespVo> result = this.tpmActService.findList(tpmActReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @GetMapping(value={"/query"})
    @CrmLog
    public Result<TpmActRespVo> query(@RequestParam(value="id", required=true) String id) {
        TpmActRespVo respVo = this.tpmActService.query(id);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody TpmActReqVo tpmActReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmActReqVo.setLockUserName(user.getUsername());
        this.tpmActService.save(tpmActReqVo);
        return Result.ok((String)"\u65b0\u589e\u6210\u529f");
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody TpmActReqVo tpmActReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmActReqVo.setLockUserName(user.getUsername());
        this.tpmActService.update(tpmActReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.tpmActService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        this.tpmActService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        this.tpmActService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u6d3b\u52a8\u5173\u95ed")
    @PostMapping(value={"/closed"})
    @CrmLog
    public Result closed(@RequestBody TpmActReqVo tpmActReqVo) {
        this.tpmActService.closed(tpmActReqVo);
        return Result.ok((String)"\u6d3b\u52a8\u5173\u95ed\u6210\u529f");
    }

    @ApiOperation(value="\u63d0\u4ea4\u5ba1\u6279")
    @PostMapping(value={"/approve"})
    @CrmLog
    public Result approve(@RequestBody TpmActReqVo tpmActReqVo) {
        String username = UserUtils.getUser().getUsername();
        tpmActReqVo.setLockUserName(username);
        this.tpmActService.approve(tpmActReqVo);
        return Result.ok((String)"\u63d0\u4ea4\u5ba1\u6279\u6210\u529f");
    }

    @ApiOperation(value="\u5ba1\u6279\u901a\u8fc7")
    @PostMapping(value={"/approved"})
    @CrmLog
    public Result approved(@RequestBody TpmActReqVo tpmActReqVo) {
        this.tpmActService.approved(tpmActReqVo);
        return Result.ok((String)"\u5ba1\u6279\u901a\u8fc7\u64cd\u4f5c\u6210\u529f");
    }

    @ApiOperation(value="\u5ba1\u6279\u9a73\u56de")
    @PostMapping(value={"/reject"})
    @CrmLog
    public Result reject(@RequestBody TpmActReqVo tpmActReqVo) {
        tpmActReqVo.setSaveType(ActSaveTypeEnum.REJECT.getCode());
        this.tpmActService.rejectAndInterrupt(tpmActReqVo);
        return Result.ok((String)"\u5ba1\u6279\u9a73\u56de\u64cd\u4f5c\u6210\u529f");
    }

    @ApiOperation(value="\u6d41\u7a0b\u8ffd\u56de")
    @PostMapping(value={"/interrupt"})
    @CrmLog
    public Result interrupt(@RequestBody TpmActReqVo tpmActReqVo) {
        tpmActReqVo.setSaveType(ActSaveTypeEnum.INTERRUPT.getCode());
        this.tpmActService.rejectAndInterrupt(tpmActReqVo);
        return Result.ok((String)"\u6d41\u7a0b\u8ffd\u56de\u64cd\u4f5c\u6210\u529f");
    }

    @ApiOperation(value="\u6d3b\u52a8\u65b0\u589e\u6839\u636e\u9009\u5b9a\u7684\u8d39\u7528\u9884\u7b97\u7ef4\u5ea6\u67e5\u8be2\u6d3b\u52a8\u5927\u7c7b")
    @PostMapping(value={"/getCategoriesByBudget"})
    @CrmLog
    public Result<List<TpmCostTypeCategoriesRespVo>> getCategoriesByBudget(@RequestBody ActGetCategoriesByBudgetReqVo reqVo) {
        List<TpmCostTypeCategoriesRespVo> list = this.categoriesService.getCategoriesByBudget(reqVo);
        return Result.ok(list);
    }

    @ApiOperation(value="\u6d3b\u52a8\u65b0\u589e;\u8ddf\u636e\u6d3b\u52a8\u5927\u7c7b\u67e5\u51fa\u6d3b\u52a8\u7ec6\u7c7b\u96c6\u5408")
    @PostMapping(value={"/getCategoryFinesByCategoryCode"})
    @CrmLog
    public Result<List<TpmCostTypeFineRespVo>> getCategoryFinesByCategoryCode(@RequestBody TpmActDetailReqVo tpmActDetailReqVo) {
        List<TpmCostTypeFineRespVo> respVos = this.tpmActService.getCategoryFinesByCategoryCode(tpmActDetailReqVo);
        return Result.ok(respVos);
    }

    @ApiOperation(value="\u6d3b\u52a8\u65b0\u589e\u6839\u636e\u8d39\u7528\u9884\u7b97\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u7ec4\u7ec7")
    @PostMapping(value={"/getOrgInfoByControlIds"})
    @CrmLog
    public Result<List<MdmOrgRespVo>> getOrgInfoByControlIds(@RequestBody ActGetOrgInfoReqVo tpmActReqVo) {
        List<MdmOrgRespVo> engineOrgRespVos = this.tpmActService.getOrgInfoByControlIds(tpmActReqVo);
        return Result.ok(engineOrgRespVos);
    }

    @ApiOperation(value="\u6d3b\u52a8\u65b0\u589e\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u67e5\u8be2\u5ba2\u6237")
    @PostMapping(value={"/getCustomerMsgByOrgCodes"})
    @CrmLog
    public Result<List<MdmCustomerMsgRespVo>> getCustomerMsgByOrgCodes(@RequestBody ActGetCustomerCodeByOrgCodeReqVo tpmActReqVo) {
        List<MdmCustomerMsgRespVo> customerMsgs = this.tpmActService.getCustomerMsgByOrgCodes(tpmActReqVo);
        return Result.ok(customerMsgs);
    }

    @ApiOperation(value="\u9886\u7528\u6d3b\u52a8\u65b0\u589e\u9875\u9762\u67e5\u8be2\u7269\u6599")
    @PostMapping(value={"/getMaterialList"})
    @CrmLog
    public Result<List<MdmMaterialPriceRespVo>> getMaterialList(@RequestBody ActGetTerminalByCustomerCodeReqVo tpmActReqVo) {
        List<MdmMaterialPriceRespVo> materialMags = this.tpmActService.getMaterialList(tpmActReqVo);
        return Result.ok(materialMags);
    }

    @ApiOperation(value="\u6d3b\u52a8\u660e\u7ec6\u8d39\u7528\u5206\u644a\u63a5\u53e3")
    @PostMapping(value={"/actDetailFeeShare"})
    @CrmLog
    public Result<List<ActDetailFeeShareVo>> actDetailFeeShare(@RequestBody ActDetailFeeShareVo reqVo) {
        List<ActDetailFeeShareVo> vos = this.tpmActService.actDetailFeeShare(reqVo);
        return Result.ok(vos);
    }

    @ApiOperation(value="\u6279\u91cf\u751f\u6210\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801")
    @GetMapping(value={"/generateActDetailCodes"})
    @CrmLog
    public Result generateAccountCode(@RequestParam(value="num") Integer num) {
        List codeList = CodeUtil.createCodeList((String)"tpm_act_detail", (int)num);
        return Result.ok((Object)codeList);
    }

    @ApiOperation(value="\u5de5\u4f5c\u6d41\u56de\u8c03\u63a5\u53e3")
    @PostMapping(value={"/activityCallBack"})
    @CrmLog
    public Result callback(@RequestBody ActivitiCallBackVo activitiCallBackVo) {
        this.tpmActService.activityCallBack(activitiCallBackVo);
        return Result.ok((String)"\u6d3b\u52a8\u5ba1\u6279\u56de\u8c03\u6210\u529f");
    }
}

